/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaElementInfoPage
extends PropertyPage {
    protected Control createContents(Composite parent) {
        Composite composite;
        block21: {
            this.noDefaultAndApplyButton();
            IJavaElement element = (IJavaElement)this.getElement();
            IResource resource = element.getResource();
            composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(272));
            Label nameLabel = new Label(composite, 0);
            nameLabel.setText(PreferencesMessages.getString("JavaElementInfoPage.nameLabel"));
            Label nameValueLabel = new Label(composite, 0);
            nameValueLabel.setText(element.getElementName());
            if (resource != null) {
                Label pathLabel = new Label(composite, 0);
                pathLabel.setText(PreferencesMessages.getString("JavaElementInfoPage.resource_path"));
                Label pathValueLabel = new Label(composite, 0);
                pathValueLabel.setText(resource.getFullPath().toString());
            }
            if (element instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)element;
                Label packageLabel = new Label(composite, 0);
                packageLabel.setText(PreferencesMessages.getString("JavaElementInfoPage.package"));
                Label packageName = new Label(composite, 0);
                packageName.setText(unit.getParent().getElementName());
            } else if (element instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)element;
                Label packageContents = new Label(composite, 0);
                packageContents.setText(PreferencesMessages.getString("JavaElementInfoPage.package_contents"));
                Label packageContentsType = new Label(composite, 0);
                try {
                    if (packageFragment.getKind() == 1) {
                        packageContentsType.setText(PreferencesMessages.getString("JavaElementInfoPage.source"));
                        break block21;
                    }
                    packageContentsType.setText(PreferencesMessages.getString("JavaElementInfoPage.binary"));
                }
                catch (JavaModelException javaModelException) {
                    packageContentsType.setText(PreferencesMessages.getString("JavaElementInfoPage.not_present"));
                }
            } else if (element instanceof IPackageFragmentRoot) {
                Label rootContents = new Label(composite, 0);
                rootContents.setText(PreferencesMessages.getString("JavaElementInfoPage.classpath_entry_kind"));
                Label rootContentsType = new Label(composite, 0);
                try {
                    IClasspathEntry entry = ((IPackageFragmentRoot)element).getRawClasspathEntry();
                    if (entry != null) {
                        switch (entry.getEntryKind()) {
                            case 3: {
                                rootContentsType.setText(PreferencesMessages.getString("JavaElementInfoPage.source"));
                                break;
                            }
                            case 2: {
                                rootContentsType.setText(PreferencesMessages.getString("JavaElementInfoPage.project"));
                                break;
                            }
                            case 1: {
                                rootContentsType.setText(PreferencesMessages.getString("JavaElementInfoPage.library"));
                                break;
                            }
                            case 4: {
                                rootContentsType.setText(PreferencesMessages.getString("JavaElementInfoPage.variable"));
                                Label varPath = new Label(composite, 0);
                                varPath.setText(PreferencesMessages.getString("JavaElementInfoPage.variable_path"));
                                Label varPathVar = new Label(composite, 0);
                                varPathVar.setText(entry.getPath().makeRelative().toString());
                            }
                        }
                        break block21;
                    }
                    rootContentsType.setText(PreferencesMessages.getString("JavaElementInfoPage.not_present"));
                }
                catch (JavaModelException javaModelException) {
                    rootContentsType.setText(PreferencesMessages.getString("JavaElementInfoPage.not_present"));
                }
            } else if (element instanceof IJavaProject) {
                Label packageLabel = new Label(composite, 0);
                packageLabel.setText(PreferencesMessages.getString("JavaElementInfoPage.location"));
                IPath location = ((IJavaProject)element).getProject().getLocation();
                if (location != null) {
                    Label packageName = new Label(composite, 0);
                    packageName.setText(location.toOSString());
                }
            }
        }
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.java_element_info_page_context");
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected boolean doOk() {
        return true;
    }
}

