/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.JavaEditorPreferencePage;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

class JavaEditorHoverConfigurationBlock {
    private static final String DELIMITER = PreferencesMessages.getString("JavaEditorHoverConfigurationBlock.delimiter");
    private IPreferenceStore fStore;
    private HoverConfig[] fHoverConfigs;
    private Text fModifierEditor;
    private Button fEnableField;
    private List fHoverList;
    private Text fDescription;
    private JavaEditorPreferencePage fMainPreferencePage;
    private StatusInfo fStatus;

    public JavaEditorHoverConfigurationBlock(JavaEditorPreferencePage mainPreferencePage, IPreferenceStore store) {
        Assert.isNotNull((Object)((Object)mainPreferencePage));
        Assert.isNotNull((Object)store);
        this.fMainPreferencePage = mainPreferencePage;
        this.fStore = store;
    }

    public Control createControl(Composite parent) {
        Composite hoverComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        hoverComposite.setLayout((Layout)layout);
        GridData gd = new GridData(528);
        hoverComposite.setLayoutData((Object)gd);
        Label label = new Label(hoverComposite, 0);
        label.setText(PreferencesMessages.getString("JavaEditorHoverConfigurationBlock.hoverPreferences"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        gd = new GridData(528);
        this.fHoverList = new List(hoverComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels((Control)parent, 10);
        this.fHoverList.setLayoutData((Object)gd);
        this.fHoverList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JavaEditorHoverConfigurationBlock.this.handleHoverListSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite stylesComposite = new Composite(hoverComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.heightHint = this.convertHeightInCharsToPixels((Control)parent, 10) + 2 * this.fHoverList.getBorderWidth();
        stylesComposite.setLayoutData((Object)gd);
        this.fEnableField = new Button(stylesComposite, 32);
        this.fEnableField.setText(PreferencesMessages.getString("JavaEditorHoverConfigurationBlock.enabled"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fEnableField.setLayoutData((Object)gd);
        this.fEnableField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = JavaEditorHoverConfigurationBlock.this.fHoverList.getSelectionIndex();
                boolean state = JavaEditorHoverConfigurationBlock.this.fEnableField.getSelection();
                JavaEditorHoverConfigurationBlock.this.fModifierEditor.setEnabled(state);
                JavaEditorHoverConfigurationBlock.this.fHoverConfigs[i].fIsEnabled = state;
                JavaEditorHoverConfigurationBlock.this.handleModifierModified();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label(stylesComposite, 16384);
        label.setText(PreferencesMessages.getString("JavaEditorHoverConfigurationBlock.keyModifier"));
        this.fModifierEditor = new Text(stylesComposite, 2048);
        gd = new GridData(256);
        this.fModifierEditor.setLayoutData((Object)gd);
        this.fModifierEditor.addKeyListener(new KeyListener(){
            private boolean isModifierCandidate;

            public void keyPressed(KeyEvent e) {
                this.isModifierCandidate = e.keyCode > 0 && e.character == '\u0000' && e.stateMask == 0;
            }

            public void keyReleased(KeyEvent e) {
                if (this.isModifierCandidate && e.stateMask > 0 && e.stateMask == e.stateMask && e.character == '\u0000') {
                    boolean needsPostfixDelimiter;
                    String text = JavaEditorHoverConfigurationBlock.this.fModifierEditor.getText();
                    Point selection = JavaEditorHoverConfigurationBlock.this.fModifierEditor.getSelection();
                    int i = selection.x - 1;
                    while (i > -1 && Character.isWhitespace(text.charAt(i))) {
                        --i;
                    }
                    boolean needsPrefixDelimiter = i > -1 && !String.valueOf(text.charAt(i)).equals(DELIMITER);
                    i = selection.y;
                    while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
                        ++i;
                    }
                    boolean bl = needsPostfixDelimiter = i < text.length() && !String.valueOf(text.charAt(i)).equals(DELIMITER);
                    String insertString = needsPrefixDelimiter && needsPostfixDelimiter ? PreferencesMessages.getFormattedString("JavaEditorHoverConfigurationBlock.insertDelimiterAndModifierAndDelimiter", new String[]{Action.findModifierString((int)e.stateMask)}) : (needsPrefixDelimiter ? PreferencesMessages.getFormattedString("JavaEditorHoverConfigurationBlock.insertDelimiterAndModifier", new String[]{Action.findModifierString((int)e.stateMask)}) : (needsPostfixDelimiter ? PreferencesMessages.getFormattedString("JavaEditorHoverConfigurationBlock.insertModifierAndDelimiter", new String[]{Action.findModifierString((int)e.stateMask)}) : Action.findModifierString((int)e.stateMask)));
                    JavaEditorHoverConfigurationBlock.this.fModifierEditor.insert(insertString);
                }
            }
        });
        this.fModifierEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaEditorHoverConfigurationBlock.this.handleModifierModified();
            }
        });
        Label descriptionLabel = new Label(stylesComposite, 16384);
        descriptionLabel.setText(PreferencesMessages.getString("JavaEditorHoverConfigurationBlock.description"));
        gd = new GridData(2);
        gd.horizontalSpan = 2;
        descriptionLabel.setLayoutData((Object)gd);
        this.fDescription = new Text(stylesComposite, 18506);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.fDescription.setLayoutData((Object)gd);
        this.initialize();
        Dialog.applyDialogFont((Control)hoverComposite);
        return hoverComposite;
    }

    private JavaEditorTextHoverDescriptor[] getContributedHovers() {
        return JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
    }

    void initialize() {
        JavaEditorTextHoverDescriptor[] hoverDescs = this.getContributedHovers();
        this.fHoverConfigs = new HoverConfig[hoverDescs.length];
        int i = 0;
        while (i < hoverDescs.length) {
            this.fHoverConfigs[i] = new HoverConfig(hoverDescs[i].getModifierString(), hoverDescs[i].getStateMask(), hoverDescs[i].isEnabled());
            this.fHoverList.add(hoverDescs[i].getLabel());
            ++i;
        }
        this.initializeFields();
    }

    void initializeFields() {
        this.fHoverList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (JavaEditorHoverConfigurationBlock.this.fHoverList != null && !JavaEditorHoverConfigurationBlock.this.fHoverList.isDisposed()) {
                    JavaEditorHoverConfigurationBlock.this.fHoverList.select(0);
                    JavaEditorHoverConfigurationBlock.this.handleHoverListSelection();
                }
            }
        });
    }

    void performOk() {
        StringBuffer buf = new StringBuffer();
        StringBuffer maskBuf = new StringBuffer();
        int i = 0;
        while (i < this.fHoverConfigs.length) {
            String modifier;
            buf.append(this.getContributedHovers()[i].getId());
            buf.append(";");
            if (!this.fHoverConfigs[i].fIsEnabled) {
                buf.append("!");
            }
            if ((modifier = this.fHoverConfigs[i].fModifierString) == null || modifier.length() == 0) {
                modifier = "0";
            }
            buf.append(modifier);
            buf.append(";");
            maskBuf.append(this.getContributedHovers()[i].getId());
            maskBuf.append(";");
            maskBuf.append(this.fHoverConfigs[i].fStateMask);
            maskBuf.append(";");
            ++i;
        }
        this.fStore.setValue("hoverModifiers", buf.toString());
        this.fStore.setValue("hoverModifierMasks", maskBuf.toString());
        JavaPlugin.getDefault().resetJavaEditorTextHoverDescriptors();
    }

    void performDefaults() {
        this.restoreFromPreferences();
        this.initializeFields();
    }

    private void restoreFromPreferences() {
        String compiledTextHoverModifiers = this.fStore.getString("hoverModifiers");
        StringTokenizer tokenizer = new StringTokenizer(compiledTextHoverModifiers, ";");
        HashMap<String, String> idToModifier = new HashMap<String, String>(tokenizer.countTokens() / 2);
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            idToModifier.put(id, tokenizer.nextToken());
        }
        String compiledTextHoverModifierMasks = JavaPlugin.getDefault().getPreferenceStore().getString("hoverModifierMasks");
        tokenizer = new StringTokenizer(compiledTextHoverModifierMasks, ";");
        HashMap<String, String> idToModifierMask = new HashMap<String, String>(tokenizer.countTokens() / 2);
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            idToModifierMask.put(id, tokenizer.nextToken());
        }
        int i = 0;
        while (i < this.fHoverConfigs.length) {
            String modifierString = (String)idToModifier.get(this.getContributedHovers()[i].getId());
            boolean enabled = true;
            if (modifierString == null) {
                modifierString = "!";
            }
            if (modifierString.startsWith("!")) {
                enabled = false;
                modifierString = modifierString.substring(1);
            }
            if (modifierString.equals("0")) {
                modifierString = "";
            }
            this.fHoverConfigs[i].fModifierString = modifierString;
            this.fHoverConfigs[i].fIsEnabled = enabled;
            this.fHoverConfigs[i].fStateMask = JavaEditorTextHoverDescriptor.computeStateMask(modifierString);
            if (this.fHoverConfigs[i].fStateMask == -1) {
                try {
                    this.fHoverConfigs[i].fStateMask = Integer.parseInt((String)idToModifierMask.get(this.getContributedHovers()[i].getId()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.fHoverConfigs[i].fStateMask = -1;
                }
            }
            ++i;
        }
    }

    private void handleModifierModified() {
        int i = this.fHoverList.getSelectionIndex();
        String modifiers = this.fModifierEditor.getText();
        this.fHoverConfigs[i].fModifierString = modifiers;
        this.fHoverConfigs[i].fStateMask = JavaEditorTextHoverDescriptor.computeStateMask(modifiers);
        this.fStatus = this.fHoverConfigs[i].fIsEnabled && this.fHoverConfigs[i].fStateMask == -1 ? new StatusInfo(4, PreferencesMessages.getFormattedString("JavaEditorHoverConfigurationBlock.modifierIsNotValid", this.fHoverConfigs[i].fModifierString)) : new StatusInfo();
        this.updateStatus();
    }

    private void handleHoverListSelection() {
        int i = this.fHoverList.getSelectionIndex();
        boolean enabled = this.fHoverConfigs[i].fIsEnabled;
        this.fEnableField.setSelection(enabled);
        this.fModifierEditor.setEnabled(enabled);
        this.fModifierEditor.setText(this.fHoverConfigs[i].fModifierString);
        String description = this.getContributedHovers()[i].getDescription();
        if (description == null) {
            description = "";
        }
        this.fDescription.setText(description);
    }

    private int convertHeightInCharsToPixels(Control control, int chars) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        if (fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
    }

    IStatus getStatus() {
        if (this.fStatus == null) {
            this.fStatus = new StatusInfo();
        }
        return this.fStatus;
    }

    private void updateStatus() {
        int i = 0;
        HashMap<Integer, String> stateMasks = new HashMap<Integer, String>(this.fHoverConfigs.length);
        while (this.fStatus.isOK() && i < this.fHoverConfigs.length) {
            if (this.fHoverConfigs[i].fIsEnabled) {
                String label = this.getContributedHovers()[i].getLabel();
                Integer stateMask = new Integer(this.fHoverConfigs[i].fStateMask);
                if (this.fHoverConfigs[i].fStateMask == -1) {
                    this.fStatus = new StatusInfo(4, PreferencesMessages.getFormattedString("JavaEditorHoverConfigurationBlock.modifierIsNotValidForHover", new String[]{this.fHoverConfigs[i].fModifierString, label}));
                } else if (stateMasks.containsKey(stateMask)) {
                    this.fStatus = new StatusInfo(4, PreferencesMessages.getFormattedString("JavaEditorHoverConfigurationBlock.duplicateModifier", new String[]{label, (String)stateMasks.get(stateMask)}));
                } else {
                    stateMasks.put(stateMask, label);
                }
            }
            ++i;
        }
        if (this.fStatus.isOK()) {
            this.fMainPreferencePage.updateStatus(this.fStatus);
        } else {
            this.fMainPreferencePage.setValid(false);
            StatusUtil.applyToStatusLine((DialogPage)this.fMainPreferencePage, this.fStatus);
        }
    }

    private static class HoverConfig {
        private String fModifierString;
        private boolean fIsEnabled;
        private int fStateMask;

        HoverConfig(String modifier, int stateMask, boolean enabled) {
            this.fModifierString = modifier;
            this.fIsEnabled = enabled;
            this.fStateMask = stateMask;
        }
    }
}

