/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.ImportOrganizeInputDialog;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ImportOrganizePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREF_IMPORTORDER = "org.eclipse.jdt.ui.importorder";
    private static final String PREF_ONDEMANDTHRESHOLD = "org.eclipse.jdt.ui.ondemandthreshold";
    private static final String PREF_IGNORELOWERCASE = "org.eclipse.jdt.ui.ignorelowercasenames";
    private static final String PREF_LASTLOADPATH = "org.eclipse.jdt.ui.importorder.loadpath";
    private static final String PREF_LASTSAVEPATH = "org.eclipse.jdt.ui.importorder.savepath";
    private ListDialogField fOrderListField;
    private StringDialogField fThresholdField;
    private SelectionButtonDialogField fIgnoreLowerCaseTypesField;

    public static String[] getImportOrderPreference() {
        IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
        String str = prefs.getString(PREF_IMPORTORDER);
        if (str != null) {
            return ImportOrganizePreferencePage.unpackOrderList(str);
        }
        return new String[0];
    }

    private static String[] unpackOrderList(String str) {
        StringTokenizer tok = new StringTokenizer(str, ";");
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < nTokens) {
            res[i] = tok.nextToken();
            ++i;
        }
        return res;
    }

    private static String packOrderList(List orderList) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < orderList.size()) {
            buf.append((String)orderList.get(i));
            buf.append(';');
            ++i;
        }
        return buf.toString();
    }

    public static int getImportNumberThreshold() {
        IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
        int threshold = prefs.getInt(PREF_ONDEMANDTHRESHOLD);
        if (threshold < 0) {
            threshold = Integer.MAX_VALUE;
        }
        return threshold;
    }

    public static boolean doIgnoreLowerCaseNames() {
        IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
        return prefs.getBoolean(PREF_IGNORELOWERCASE);
    }

    public ImportOrganizePreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.getString("ImportOrganizePreferencePage.description"));
        String[] stringArray = new String[10];
        stringArray[0] = PreferencesMessages.getString("ImportOrganizePreferencePage.order.add.button");
        stringArray[1] = PreferencesMessages.getString("ImportOrganizePreferencePage.order.edit.button");
        stringArray[3] = PreferencesMessages.getString("ImportOrganizePreferencePage.order.up.button");
        stringArray[4] = PreferencesMessages.getString("ImportOrganizePreferencePage.order.down.button");
        stringArray[6] = PreferencesMessages.getString("ImportOrganizePreferencePage.order.remove.button");
        stringArray[8] = PreferencesMessages.getString("ImportOrganizePreferencePage.order.load.button");
        stringArray[9] = PreferencesMessages.getString("ImportOrganizePreferencePage.order.save.button");
        String[] buttonLabels = stringArray;
        ImportOrganizeAdapter adapter = new ImportOrganizeAdapter();
        this.fOrderListField = new ListDialogField(adapter, buttonLabels, (ILabelProvider)new ImportOrganizeLabelProvider());
        this.fOrderListField.setDialogFieldListener(adapter);
        this.fOrderListField.setLabelText(PreferencesMessages.getString("ImportOrganizePreferencePage.order.label"));
        this.fOrderListField.setUpButtonIndex(3);
        this.fOrderListField.setDownButtonIndex(4);
        this.fOrderListField.setRemoveButtonIndex(6);
        this.fOrderListField.enableButton(1, false);
        this.fThresholdField = new StringDialogField();
        this.fThresholdField.setDialogFieldListener(adapter);
        this.fThresholdField.setLabelText(PreferencesMessages.getString("ImportOrganizePreferencePage.threshold.label"));
        this.fIgnoreLowerCaseTypesField = new SelectionButtonDialogField(32);
        this.fIgnoreLowerCaseTypesField.setLabelText(PreferencesMessages.getString("ImportOrganizePreferencePage.ignoreLowerCase.label"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.organizeimports_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.initialize(ImportOrganizePreferencePage.getImportOrderPreference(), ImportOrganizePreferencePage.getImportNumberThreshold(), ImportOrganizePreferencePage.doIgnoreLowerCaseNames());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fOrderListField.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fOrderListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fOrderListField.getLabelControl(null), this.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fOrderListField.getListControl(null));
        this.fThresholdField.doFillIntoGrid(composite, 2);
        ((GridData)this.fThresholdField.getTextControl(null).getLayoutData()).grabExcessHorizontalSpace = false;
        this.fIgnoreLowerCaseTypesField.doFillIntoGrid(composite, 2);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void initialize(String[] importOrder, int threshold, boolean ignoreLowerCase) {
        this.fOrderListField.removeAllElements();
        int i = 0;
        while (i < importOrder.length) {
            this.fOrderListField.addElement(importOrder[i]);
            ++i;
        }
        this.fThresholdField.setText(String.valueOf(threshold));
        this.fIgnoreLowerCaseTypesField.setSelection(ignoreLowerCase);
    }

    private void doThresholdChanged() {
        StatusInfo status = new StatusInfo();
        String thresholdString = this.fThresholdField.getText();
        try {
            int threshold = Integer.parseInt(thresholdString);
            if (threshold < 0) {
                status.setError(PreferencesMessages.getString("ImportOrganizePreferencePage.error.invalidthreshold"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            status.setError(PreferencesMessages.getString("ImportOrganizePreferencePage.error.invalidthreshold"));
        }
        this.updateStatus(status);
    }

    private void doButtonPressed(int index) {
        if (index == 0) {
            List existing = this.fOrderListField.getElements();
            ImportOrganizeInputDialog dialog = new ImportOrganizeInputDialog(this.getShell(), existing);
            if (dialog.open() == 0) {
                this.fOrderListField.addElement(dialog.getResult());
            }
        } else if (index == 1) {
            List selected = this.fOrderListField.getSelectedElements();
            if (selected.isEmpty()) {
                return;
            }
            String editedEntry = (String)selected.get(0);
            List existing = this.fOrderListField.getElements();
            existing.remove(editedEntry);
            ImportOrganizeInputDialog dialog = new ImportOrganizeInputDialog(this.getShell(), existing);
            dialog.setInitialString(editedEntry);
            if (dialog.open() == 0) {
                this.fOrderListField.replaceElement(editedEntry, dialog.getResult());
            }
        } else if (index == 8) {
            List order = this.loadImportOrder();
            if (order != null) {
                this.fOrderListField.setElements(order);
            }
        } else if (index == 9) {
            this.saveImportOrder(this.fOrderListField.getElements());
        }
    }

    private List loadFromProperties(Properties properties) {
        ArrayList<String> res = new ArrayList<String>();
        int nEntries = ((Hashtable)properties).size();
        int i = 0;
        while (i < nEntries) {
            String curr = properties.getProperty(String.valueOf(i));
            if (curr != null) {
                if (!JavaConventions.validatePackageName((String)curr).isOK()) {
                    return null;
                }
            } else {
                return res;
            }
            res.add(curr);
            ++i;
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List loadImportOrder() {
        FileInputStream fis;
        block10: {
            List list;
            String fileName;
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            dialog.setText(PreferencesMessages.getString("ImportOrganizePreferencePage.loadDialog.title"));
            dialog.setFilterExtensions(new String[]{"*.importorder", "*.*"});
            String lastPath = this.getPreferenceStore().getString(PREF_LASTLOADPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((fileName = dialog.open()) == null) return null;
            this.getPreferenceStore().putValue(PREF_LASTLOADPATH, dialog.getFilterPath());
            Properties properties = new Properties();
            fis = null;
            try {
                try {
                    fis = new FileInputStream(fileName);
                    properties.load(fis);
                    List res = this.loadFromProperties(properties);
                    if (res == null) break block10;
                    list = res;
                    Object var7_9 = null;
                    if (fis == null) return list;
                }
                catch (IOException e) {
                    JavaPlugin.log(e);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            fis.close();
            return list;
        }
        Object var7_11 = null;
        if (fis != null) {
            try {}
            catch (IOException iOException) {}
            fis.close();
        }
        String title = PreferencesMessages.getString("ImportOrganizePreferencePage.loadDialog.error.title");
        String message = PreferencesMessages.getString("ImportOrganizePreferencePage.loadDialog.error.message");
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        return null;
    }

    private void saveImportOrder(List elements) {
        block12: {
            String fileName;
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setText(PreferencesMessages.getString("ImportOrganizePreferencePage.saveDialog.title"));
            dialog.setFilterExtensions(new String[]{"*.importorder", "*.*"});
            dialog.setFileName("example.importorder");
            String lastPath = this.getPreferenceStore().getString(PREF_LASTSAVEPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((fileName = dialog.open()) == null) break block12;
            this.getPreferenceStore().putValue(PREF_LASTSAVEPATH, dialog.getFilterPath());
            Properties properties = new Properties();
            int i = 0;
            while (i < elements.size()) {
                properties.setProperty(String.valueOf(i), (String)elements.get(i));
                ++i;
            }
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(fileName);
                    properties.store(fos, "Organize Import Order");
                }
                catch (IOException e) {
                    JavaPlugin.log(e);
                    String title = PreferencesMessages.getString("ImportOrganizePreferencePage.saveDialog.error.title");
                    String message = PreferencesMessages.getString("ImportOrganizePreferencePage.saveDialog.error.message");
                    MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var10_13 = null;
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    protected void performDefaults() {
        IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
        String str = prefs.getDefaultString(PREF_IMPORTORDER);
        String[] order = str != null ? ImportOrganizePreferencePage.unpackOrderList(str) : new String[]{};
        int threshold = prefs.getDefaultInt(PREF_ONDEMANDTHRESHOLD);
        if (threshold < 0) {
            threshold = Integer.MAX_VALUE;
        }
        boolean ignoreLowerCase = prefs.getDefaultBoolean(PREF_IGNORELOWERCASE);
        this.initialize(order, threshold, ignoreLowerCase);
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
        prefs.setValue(PREF_IMPORTORDER, ImportOrganizePreferencePage.packOrderList(this.fOrderListField.getElements()));
        prefs.setValue(PREF_ONDEMANDTHRESHOLD, this.fThresholdField.getText());
        prefs.setValue(PREF_IGNORELOWERCASE, this.fIgnoreLowerCaseTypesField.isSelected());
        JavaPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private static class ImportOrganizeLabelProvider
    extends LabelProvider {
        private static final Image PCK_ICON = JavaPluginImages.get("org.eclipse.jdt.ui.package_obj.gif");

        ImportOrganizeLabelProvider() {
        }

        public Image getImage(Object element) {
            return PCK_ICON;
        }
    }

    private class ImportOrganizeAdapter
    implements IListAdapter,
    IDialogFieldListener {
        ImportOrganizeAdapter() {
        }

        private boolean canEdit(ListDialogField field) {
            return field.getSelectedElements().size() == 1;
        }

        public void customButtonPressed(ListDialogField field, int index) {
            ImportOrganizePreferencePage.this.doButtonPressed(index);
        }

        public void selectionChanged(ListDialogField field) {
            ImportOrganizePreferencePage.this.fOrderListField.enableButton(1, this.canEdit(field));
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == ImportOrganizePreferencePage.this.fThresholdField) {
                ImportOrganizePreferencePage.this.doThresholdChanged();
            }
        }

        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field)) {
                ImportOrganizePreferencePage.this.doButtonPressed(1);
            }
        }
    }
}

