/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.TemplateMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.text.template.TemplateVariableProcessor;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class EditTemplateDialog
extends StatusDialog {
    private final Template fTemplate;
    private Text fNameText;
    private Text fDescriptionText;
    private Combo fContextCombo;
    private SourceViewer fPatternEditor;
    private Button fInsertVariableButton;
    private boolean fIsNameModifiable;
    private StatusInfo fValidationStatus;
    private boolean fSuppressError = true;
    private Map fGlobalActions = new HashMap(10);
    private List fSelectionActions = new ArrayList(3);
    private String[] fContextTypes;
    private final TemplateVariableProcessor fProcessor = new TemplateVariableProcessor();

    public EditTemplateDialog(Shell parent, Template template, boolean edit, boolean isNameModifiable, String[] contextTypes) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String title = edit ? TemplateMessages.getString("EditTemplateDialog.title.edit") : TemplateMessages.getString("EditTemplateDialog.title.new");
        this.setTitle(title);
        this.fTemplate = template;
        this.fIsNameModifiable = isNameModifiable;
        this.fContextTypes = contextTypes;
        this.fValidationStatus = new StatusInfo();
        ContextType type = ContextTypeRegistry.getInstance().getContextType(template.getContextTypeName());
        this.fProcessor.setContextType(type);
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditTemplateDialog.this.doTextWidgetChanged(e.widget);
            }
        };
        if (this.fIsNameModifiable) {
            EditTemplateDialog.createLabel(parent, TemplateMessages.getString("EditTemplateDialog.name"));
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            this.fNameText = EditTemplateDialog.createText(composite);
            this.fNameText.addModifyListener(listener);
            EditTemplateDialog.createLabel(composite, TemplateMessages.getString("EditTemplateDialog.context"));
            this.fContextCombo = new Combo(composite, 8);
            int i = 0;
            while (i < this.fContextTypes.length) {
                this.fContextCombo.add(this.fContextTypes[i]);
                ++i;
            }
            this.fContextCombo.addModifyListener(listener);
        }
        EditTemplateDialog.createLabel(parent, TemplateMessages.getString("EditTemplateDialog.description"));
        int descFlags = this.fIsNameModifiable ? 2048 : 2056;
        this.fDescriptionText = new Text(parent, descFlags);
        this.fDescriptionText.setLayoutData((Object)new GridData(768));
        this.fDescriptionText.addModifyListener(listener);
        Label patternLabel = EditTemplateDialog.createLabel(parent, TemplateMessages.getString("EditTemplateDialog.pattern"));
        patternLabel.setLayoutData((Object)new GridData(2));
        this.fPatternEditor = this.createEditor(parent);
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData());
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        this.fInsertVariableButton = new Button(composite, 0);
        this.fInsertVariableButton.setLayoutData((Object)EditTemplateDialog.getButtonGridData(this.fInsertVariableButton));
        this.fInsertVariableButton.setText(TemplateMessages.getString("EditTemplateDialog.insert.variable"));
        this.fInsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.fPatternEditor.getTextWidget().setFocus();
                EditTemplateDialog.this.fPatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fDescriptionText.setText(this.fTemplate.getDescription());
        if (this.fIsNameModifiable) {
            this.fNameText.setText(this.fTemplate.getName());
            this.fContextCombo.select(this.getIndex(this.fTemplate.getContextTypeName()));
        } else {
            this.fPatternEditor.getControl().setFocus();
        }
        this.initializeActions();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void doTextWidgetChanged(Widget w) {
        if (w == this.fNameText) {
            String name = this.fNameText.getText();
            if (this.fSuppressError && name.trim().length() != 0) {
                this.fSuppressError = false;
            }
            this.fTemplate.setName(name);
            this.updateButtons();
        } else if (w == this.fContextCombo) {
            String name = this.fContextCombo.getText();
            this.fTemplate.setContext(name);
            this.fProcessor.setContextType(ContextTypeRegistry.getInstance().getContextType(name));
        } else if (w == this.fDescriptionText) {
            String desc = this.fDescriptionText.getText();
            this.fTemplate.setDescription(desc);
        }
    }

    protected void doSourceChanged(IDocument document) {
        String text = document.get();
        this.fTemplate.setPattern(text);
        this.fValidationStatus.setOK();
        ContextType contextType = ContextTypeRegistry.getInstance().getContextType(this.fTemplate.getContextTypeName());
        if (contextType != null) {
            try {
                String errorMessage = contextType.validate(text);
                if (errorMessage != null) {
                    this.fValidationStatus.setError(errorMessage);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        this.updateUndoAction();
        this.updateButtons();
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        data.heightHint = SWTUtil.getButtonHeigthHint(button);
        return data;
    }

    private static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private SourceViewer createEditor(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, 2816);
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        Document document = new Document(this.fTemplate.getPattern());
        IDocumentPartitioner partitioner = tools.createDocumentPartitioner();
        document.setDocumentPartitioner(partitioner);
        partitioner.connect((IDocument)document);
        viewer.configure((SourceViewerConfiguration)new SimpleJavaSourceViewerConfiguration(tools, null, this.fProcessor));
        viewer.setEditable(true);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        viewer.getTextWidget().setFont(font);
        int nLines = document.getNumberOfLines();
        if (nLines < 5) {
            nLines = 5;
        } else if (nLines > 12) {
            nLines = 12;
        }
        Control control = viewer.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(nLines);
        control.setLayoutData((Object)data);
        viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                EditTemplateDialog.this.doSourceChanged(event.getDocumentEvent().getDocument());
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditTemplateDialog.this.updateSelectionDependentActions();
            }
        });
        if (viewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)viewer).prependVerifyKeyListener(new VerifyKeyListener(){

                public void verifyKey(VerifyEvent event) {
                    EditTemplateDialog.this.handleVerifyKeyPressed(event);
                }
            });
        } else {
            viewer.getTextWidget().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    EditTemplateDialog.this.handleKeyPressed(e);
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        }
        return viewer;
    }

    private void handleKeyPressed(KeyEvent event) {
        if (event.stateMask != SWT.MOD1) {
            return;
        }
        switch (event.character) {
            case ' ': {
                this.fPatternEditor.doOperation(13);
                break;
            }
            case '\u001a': {
                this.fPatternEditor.doOperation(1);
            }
        }
    }

    private void handleVerifyKeyPressed(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.stateMask != SWT.MOD1) {
            return;
        }
        switch (event.character) {
            case ' ': {
                this.fPatternEditor.doOperation(13);
                event.doit = false;
                break;
            }
            case '\u001a': {
                this.fPatternEditor.doOperation(1);
                event.doit = false;
            }
        }
    }

    private void initializeActions() {
        TextViewerAction action = new TextViewerAction((ITextViewer)this.fPatternEditor, 1);
        action.setText(TemplateMessages.getString("EditTemplateDialog.undo"));
        this.fGlobalActions.put("undo", action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 3);
        action.setText(TemplateMessages.getString("EditTemplateDialog.cut"));
        this.fGlobalActions.put("cut", action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 4);
        action.setText(TemplateMessages.getString("EditTemplateDialog.copy"));
        this.fGlobalActions.put("copy", action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 5);
        action.setText(TemplateMessages.getString("EditTemplateDialog.paste"));
        this.fGlobalActions.put("paste", action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 7);
        action.setText(TemplateMessages.getString("EditTemplateDialog.select.all"));
        this.fGlobalActions.put("selectAll", action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 13);
        action.setText(TemplateMessages.getString("EditTemplateDialog.content.assist"));
        this.fGlobalActions.put("ContentAssistProposal", action);
        this.fSelectionActions.add("cut");
        this.fSelectionActions.add("copy");
        this.fSelectionActions.add("paste");
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EditTemplateDialog.this.fillContextMenu(mgr);
            }
        });
        StyledText text = this.fPatternEditor.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", (IAction)this.fGlobalActions.get("undo"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get("cut"));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get("copy"));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get("paste"));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get("selectAll"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.appendToGroup("group.generate", (IAction)this.fGlobalActions.get("ContentAssistProposal"));
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateUndoAction() {
        IAction action = (IAction)this.fGlobalActions.get("undo");
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private int getIndex(String context) {
        ContextTypeRegistry registry = ContextTypeRegistry.getInstance();
        registry.getContextType(context);
        if (context == null) {
            return -1;
        }
        int i = 0;
        while (i < this.fContextTypes.length) {
            if (context.equals(this.fContextTypes[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void okPressed() {
        super.okPressed();
    }

    private void updateButtons() {
        StatusInfo status;
        boolean valid;
        boolean bl = valid = this.fNameText == null || this.fNameText.getText().trim().length() != 0;
        if (!valid) {
            status = new StatusInfo();
            if (!this.fSuppressError) {
                status.setError(TemplateMessages.getString("EditTemplateDialog.error.noname"));
            }
        } else {
            status = this.fValidationStatus;
        }
        this.updateStatus(status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.edit_template_dialog_context");
    }

    private static class SimpleJavaSourceViewerConfiguration
    extends JavaSourceViewerConfiguration {
        private final IContentAssistProcessor fProcessor;

        SimpleJavaSourceViewerConfiguration(JavaTextTools tools, ITextEditor editor, IContentAssistProcessor processor) {
            super(tools, editor);
            this.fProcessor = processor;
        }

        public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
            IColorManager manager = textTools.getColorManager();
            ContentAssistant assistant = new ContentAssistant();
            assistant.setContentAssistProcessor(this.fProcessor, "__dftl_partition_content_type");
            assistant.setContentAssistProcessor(this.fProcessor, "__java_string");
            assistant.setContentAssistProcessor(this.fProcessor, "__java_character");
            assistant.setContentAssistProcessor(this.fProcessor, "__java_singleline_comment");
            assistant.setContentAssistProcessor(this.fProcessor, "__java_multiline_comment");
            assistant.setContentAssistProcessor(this.fProcessor, "__java_javadoc");
            assistant.enableAutoInsert(store.getBoolean("content_assist_autoinsert"));
            assistant.enableAutoActivation(store.getBoolean("content_assist_autoactivation"));
            assistant.setAutoActivationDelay(store.getInt("content_assist_autoactivation_delay"));
            assistant.setProposalPopupOrientation(10);
            assistant.setContextInformationPopupOrientation(20);
            assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            Color background = this.getColor(store, "content_assist_proposals_background", manager);
            assistant.setContextInformationPopupBackground(background);
            assistant.setContextSelectorBackground(background);
            assistant.setProposalSelectorBackground(background);
            Color foreground = this.getColor(store, "content_assist_proposals_foreground", manager);
            assistant.setContextInformationPopupForeground(foreground);
            assistant.setContextSelectorForeground(foreground);
            assistant.setProposalSelectorForeground(foreground);
            return assistant;
        }

        private Color getColor(IPreferenceStore store, String key, IColorManager manager) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
            return manager.getColor(rgb);
        }
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this.fOperationCode = operationCode;
            this.fOperationTarget = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

