/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class CompilerConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String PREF_LOCAL_VARIABLE_ATTR = "org.eclipse.jdt.core.compiler.debug.localVariable";
    private static final String PREF_LINE_NUMBER_ATTR = "org.eclipse.jdt.core.compiler.debug.lineNumber";
    private static final String PREF_SOURCE_FILE_ATTR = "org.eclipse.jdt.core.compiler.debug.sourceFile";
    private static final String PREF_CODEGEN_UNUSED_LOCAL = "org.eclipse.jdt.core.compiler.codegen.unusedLocal";
    private static final String PREF_CODEGEN_TARGET_PLATFORM = "org.eclipse.jdt.core.compiler.codegen.targetPlatform";
    private static final String PREF_PB_UNREACHABLE_CODE = "org.eclipse.jdt.core.compiler.problem.unreachableCode";
    private static final String PREF_PB_INVALID_IMPORT = "org.eclipse.jdt.core.compiler.problem.invalidImport";
    private static final String PREF_PB_OVERRIDING_PACKAGE_DEFAULT_METHOD = "org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod";
    private static final String PREF_PB_METHOD_WITH_CONSTRUCTOR_NAME = "org.eclipse.jdt.core.compiler.problem.methodWithConstructorName";
    private static final String PREF_PB_DEPRECATION = "org.eclipse.jdt.core.compiler.problem.deprecation";
    private static final String PREF_PB_HIDDEN_CATCH_BLOCK = "org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock";
    private static final String PREF_PB_UNUSED_LOCAL = "org.eclipse.jdt.core.compiler.problem.unusedLocal";
    private static final String PREF_PB_UNUSED_PARAMETER = "org.eclipse.jdt.core.compiler.problem.unusedParameter";
    private static final String PREF_PB_SYNTHETIC_ACCESS_EMULATION = "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation";
    private static final String PREF_PB_NON_EXTERNALIZED_STRINGS = "org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral";
    private static final String PREF_PB_ASSERT_AS_IDENTIFIER = "org.eclipse.jdt.core.compiler.problem.assertIdentifier";
    private static final String PREF_PB_MAX_PER_UNIT = "org.eclipse.jdt.core.compiler.maxProblemPerUnit";
    private static final String PREF_PB_UNUSED_IMPORT = "org.eclipse.jdt.core.compiler.problem.unusedImport";
    private static final String PREF_PB_UNUSED_PRIVATE = "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember";
    private static final String PREF_PB_STATIC_ACCESS_RECEIVER = "org.eclipse.jdt.core.compiler.problem.staticAccessReceiver";
    private static final String PREF_PB_NO_EFFECT_ASSIGNMENT = "org.eclipse.jdt.core.compiler.problem.noEffectAssignment";
    private static final String PREF_PB_CHAR_ARRAY_IN_CONCAT = "org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion";
    private static final String PREF_SOURCE_COMPATIBILITY = "org.eclipse.jdt.core.compiler.source";
    private static final String PREF_COMPLIANCE = "org.eclipse.jdt.core.compiler.compliance";
    private static final String PREF_RESOURCE_FILTER = "org.eclipse.jdt.core.builder.resourceCopyExclusionFilter";
    private static final String PREF_BUILD_INVALID_CLASSPATH = "org.eclipse.jdt.core.builder.invalidClasspath";
    private static final String PREF_BUILD_CLEAN_OUTPUT_FOLDER = "org.eclipse.jdt.core.builder.cleanOutputFolder";
    private static final String PREF_ENABLE_EXCLUSION_PATTERNS = "org.eclipse.jdt.core.classpath.exclusionPatterns";
    private static final String PREF_ENABLE_MULTIPLE_OUTPUT_LOCATIONS = "org.eclipse.jdt.core.classpath.multipleOutputLocations";
    private static final String PREF_PB_INCOMPLETE_BUILDPATH = "org.eclipse.jdt.core.incompleteClasspath";
    private static final String PREF_PB_CIRCULAR_BUILDPATH = "org.eclipse.jdt.core.circularClasspath";
    private static final String PREF_COMPILER_PB_DEPRECATION_IN_DEPRECATED_CODE = "org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode";
    private static final String PREF_PB_DUPLICATE_RESOURCE = "org.eclipse.jdt.core.builder.duplicateResourceTask";
    private static final String PREF_PB_INCOMPATIBLE_INTERFACE_METHOD = "org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod";
    private static final String INTR_DEFAULT_COMPLIANCE = "internal.default.compliance";
    private static final String GENERATE = "generate";
    private static final String DO_NOT_GENERATE = "do not generate";
    private static final String PRESERVE = "preserve";
    private static final String OPTIMIZE_OUT = "optimize out";
    private static final String VERSION_1_1 = "1.1";
    private static final String VERSION_1_2 = "1.2";
    private static final String VERSION_1_3 = "1.3";
    private static final String VERSION_1_4 = "1.4";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ABORT = "abort";
    private static final String CLEAN = "clean";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final String DEFAULT = "default";
    private static final String USER = "user";
    private ArrayList fComplianceControls;
    private PixelConverter fPixelConverter;
    private IStatus fComplianceStatus;
    private IStatus fMaxNumberProblemsStatus;
    private IStatus fResourceFilterStatus;
    private final String[] KEYS = new String[]{"org.eclipse.jdt.core.compiler.debug.localVariable", "org.eclipse.jdt.core.compiler.debug.lineNumber", "org.eclipse.jdt.core.compiler.debug.sourceFile", "org.eclipse.jdt.core.compiler.codegen.unusedLocal", "org.eclipse.jdt.core.compiler.codegen.targetPlatform", "org.eclipse.jdt.core.compiler.problem.unreachableCode", "org.eclipse.jdt.core.compiler.problem.invalidImport", "org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", "org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", "org.eclipse.jdt.core.compiler.problem.deprecation", "org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", "org.eclipse.jdt.core.compiler.problem.unusedLocal", "org.eclipse.jdt.core.compiler.problem.unusedParameter", "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", "org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "org.eclipse.jdt.core.compiler.problem.assertIdentifier", "org.eclipse.jdt.core.compiler.problem.unusedImport", "org.eclipse.jdt.core.compiler.maxProblemPerUnit", "org.eclipse.jdt.core.compiler.source", "org.eclipse.jdt.core.compiler.compliance", "org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", "org.eclipse.jdt.core.builder.invalidClasspath", "org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", "org.eclipse.jdt.core.incompleteClasspath", "org.eclipse.jdt.core.circularClasspath", "org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "org.eclipse.jdt.core.builder.cleanOutputFolder", "org.eclipse.jdt.core.builder.duplicateResourceTask", "org.eclipse.jdt.core.compiler.problem.noEffectAssignment", "org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", "org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", "org.eclipse.jdt.core.classpath.exclusionPatterns", "org.eclipse.jdt.core.classpath.multipleOutputLocations"};

    public CompilerConfigurationBlock(IStatusChangeListener context, IJavaProject project) {
        super(context, project);
        this.fComplianceControls = new ArrayList();
        this.fComplianceStatus = new StatusInfo();
        this.fMaxNumberProblemsStatus = new StatusInfo();
        this.fResourceFilterStatus = new StatusInfo();
    }

    protected String[] getAllKeys() {
        return this.KEYS;
    }

    protected final Map getOptions(boolean inheritJavaCoreOptions) {
        Map map = super.getOptions(inheritJavaCoreOptions);
        map.put(INTR_DEFAULT_COMPLIANCE, CompilerConfigurationBlock.getCurrentCompliance(map));
        return map;
    }

    protected final Map getDefaultOptions() {
        Map map = super.getDefaultOptions();
        map.put(INTR_DEFAULT_COMPLIANCE, CompilerConfigurationBlock.getCurrentCompliance(map));
        return map;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        Composite problemsComposite = this.createProblemsTabContent((Composite)folder);
        Composite styleComposite = this.createStyleTabContent(folder);
        Composite complianceComposite = this.createComplianceTabContent((Composite)folder);
        Composite othersComposite = this.createOthersTabContent(folder);
        TabItem item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.problems.tabtitle"));
        item.setControl((Control)problemsComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.style.tabtitle"));
        item.setControl((Control)styleComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.compliance.tabtitle"));
        item.setControl((Control)complianceComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.others.tabtitle"));
        item.setControl((Control)othersComposite);
        this.validateSettings(null, null);
        return folder;
    }

    private Composite createStyleTabContent(TabFolder folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning"), PreferencesMessages.getString("CompilerConfigurationBlock.ignore")};
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        Composite styleComposite = new Composite((Composite)folder, 0);
        styleComposite.setLayout((Layout)layout);
        Label description = new Label(styleComposite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.style.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(50);
        description.setLayoutData((Object)gd);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_overriding_pkg_dflt.label");
        this.addComboBox(styleComposite, label, PREF_PB_OVERRIDING_PACKAGE_DEFAULT_METHOD, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_method_naming.label");
        this.addComboBox(styleComposite, label, PREF_PB_METHOD_WITH_CONSTRUCTOR_NAME, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_incompatible_interface_method.label");
        this.addComboBox(styleComposite, label, PREF_PB_INCOMPATIBLE_INTERFACE_METHOD, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_hidden_catchblock.label");
        this.addComboBox(styleComposite, label, PREF_PB_HIDDEN_CATCH_BLOCK, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_static_access_receiver.label");
        this.addComboBox(styleComposite, label, PREF_PB_STATIC_ACCESS_RECEIVER, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_synth_access_emul.label");
        this.addComboBox(styleComposite, label, PREF_PB_SYNTHETIC_ACCESS_EMULATION, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_no_effect_assignment.label");
        this.addComboBox(styleComposite, label, PREF_PB_NO_EFFECT_ASSIGNMENT, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_char_array_in_concat.label");
        this.addComboBox(styleComposite, label, PREF_PB_CHAR_ARRAY_IN_CONCAT, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        return styleComposite;
    }

    private Composite createOthersTabContent(TabFolder folder) {
        String[] abortIgnoreValues = new String[]{ABORT, IGNORE};
        String[] cleanIgnoreValues = new String[]{CLEAN, IGNORE};
        String[] enableDisableValues = new String[]{ENABLED, DISABLED};
        String[] errorWarning = new String[]{ERROR, WARNING};
        String[] errorWarningLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning")};
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        Composite othersComposite = new Composite((Composite)folder, 0);
        othersComposite.setLayout((Layout)layout);
        Label description = new Label(othersComposite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.build_warnings.description"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        description.setLayoutData((Object)gd);
        Composite combos = new Composite(othersComposite, 0);
        gd = new GridData(516);
        gd.horizontalSpan = 2;
        combos.setLayoutData((Object)gd);
        GridLayout cl = new GridLayout();
        cl.numColumns = 2;
        cl.marginWidth = 0;
        cl.marginHeight = 0;
        combos.setLayout((Layout)cl);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_incomplete_build_path.label");
        this.addComboBox(combos, label, PREF_PB_INCOMPLETE_BUILDPATH, errorWarning, errorWarningLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_build_path_cycles.label");
        this.addComboBox(combos, label, PREF_PB_CIRCULAR_BUILDPATH, errorWarning, errorWarningLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_duplicate_resources.label");
        this.addComboBox(combos, label, PREF_PB_DUPLICATE_RESOURCE, errorWarning, errorWarningLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.build_invalid_classpath.label");
        this.addCheckBox(othersComposite, label, PREF_BUILD_INVALID_CLASSPATH, abortIgnoreValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.build_clean_outputfolder.label");
        this.addCheckBox(othersComposite, label, PREF_BUILD_CLEAN_OUTPUT_FOLDER, cleanIgnoreValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.enable_exclusion_patterns.label");
        this.addCheckBox(othersComposite, label, PREF_ENABLE_EXCLUSION_PATTERNS, enableDisableValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.enable_multiple_outputlocations.label");
        this.addCheckBox(othersComposite, label, PREF_ENABLE_MULTIPLE_OUTPUT_LOCATIONS, enableDisableValues, 0);
        description = new Label(othersComposite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.resource_filter.description"));
        gd = new GridData(4);
        gd.horizontalSpan = 2;
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(60);
        description.setLayoutData((Object)gd);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.resource_filter.label");
        Text text = this.addTextField(othersComposite, label, PREF_RESOURCE_FILTER, 0, 0);
        gd = (GridData)text.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(10);
        return othersComposite;
    }

    private Composite createProblemsTabContent(Composite folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning"), PreferencesMessages.getString("CompilerConfigurationBlock.ignore")};
        String[] enabledDisabled = new String[]{ENABLED, DISABLED};
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        Composite problemsComposite = new Composite(folder, 0);
        problemsComposite.setLayout((Layout)layout);
        Label description = new Label(problemsComposite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.problems.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(50);
        description.setLayoutData((Object)gd);
        Composite combos = new Composite(problemsComposite, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        combos.setLayoutData((Object)gd);
        GridLayout cl = new GridLayout();
        cl.numColumns = 2;
        cl.marginWidth = 0;
        cl.marginHeight = 0;
        combos.setLayout((Layout)cl);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unreachable_code.label");
        this.addComboBox(combos, label, PREF_PB_UNREACHABLE_CODE, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_invalid_import.label");
        this.addComboBox(combos, label, PREF_PB_INVALID_IMPORT, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unused_local.label");
        this.addComboBox(combos, label, PREF_PB_UNUSED_LOCAL, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unused_parameter.label");
        this.addComboBox(combos, label, PREF_PB_UNUSED_PARAMETER, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unused_imports.label");
        this.addComboBox(combos, label, PREF_PB_UNUSED_IMPORT, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unused_private.label");
        this.addComboBox(combos, label, PREF_PB_UNUSED_PRIVATE, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_non_externalized_strings.label");
        this.addComboBox(combos, label, PREF_PB_NON_EXTERNALIZED_STRINGS, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_deprecation.label");
        this.addComboBox(combos, label, PREF_PB_DEPRECATION, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_deprecation_in_deprecation.label");
        this.addCheckBox(problemsComposite, label, PREF_COMPILER_PB_DEPRECATION_IN_DEPRECATED_CODE, enabledDisabled, 0);
        Composite textField = new Composite(problemsComposite, 0);
        gd = new GridData(516);
        gd.horizontalSpan = 2;
        textField.setLayoutData((Object)gd);
        cl = new GridLayout();
        cl.numColumns = 2;
        cl.marginWidth = 0;
        cl.marginHeight = 0;
        textField.setLayout((Layout)cl);
        gd = new GridData();
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(6);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_max_per_unit.label");
        Text text = this.addTextField(textField, label, PREF_PB_MAX_PER_UNIT, 0, 0);
        text.setTextLimit(6);
        text.setLayoutData((Object)gd);
        return problemsComposite;
    }

    private Composite createComplianceTabContent(Composite folder) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        String[] values34 = new String[]{VERSION_1_3, VERSION_1_4};
        String[] values34Labels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.version13"), PreferencesMessages.getString("CompilerConfigurationBlock.version14")};
        Composite compComposite = new Composite(folder, 0);
        compComposite.setLayout((Layout)layout);
        layout = new GridLayout();
        layout.numColumns = 2;
        Group group = new Group(compComposite, 0);
        group.setText(PreferencesMessages.getString("CompilerConfigurationBlock.compliance.group.label"));
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)layout);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.compiler_compliance.label");
        this.addComboBox((Composite)group, label, PREF_COMPLIANCE, values34, values34Labels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.default_settings.label");
        this.addCheckBox((Composite)group, label, INTR_DEFAULT_COMPLIANCE, new String[]{DEFAULT, USER}, 0);
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(2);
        Control[] otherChildren = group.getChildren();
        String[] values14 = new String[]{VERSION_1_1, VERSION_1_2, VERSION_1_3, VERSION_1_4};
        String[] values14Labels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.version11"), PreferencesMessages.getString("CompilerConfigurationBlock.version12"), PreferencesMessages.getString("CompilerConfigurationBlock.version13"), PreferencesMessages.getString("CompilerConfigurationBlock.version14")};
        label = PreferencesMessages.getString("CompilerConfigurationBlock.codegen_targetplatform.label");
        this.addComboBox((Composite)group, label, PREF_CODEGEN_TARGET_PLATFORM, values14, values14Labels, indent);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.source_compatibility.label");
        this.addComboBox((Composite)group, label, PREF_SOURCE_COMPATIBILITY, values34, values34Labels, indent);
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning"), PreferencesMessages.getString("CompilerConfigurationBlock.ignore")};
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_assert_as_identifier.label");
        this.addComboBox((Composite)group, label, PREF_PB_ASSERT_AS_IDENTIFIER, errorWarningIgnore, errorWarningIgnoreLabels, indent);
        Control[] allChildren = group.getChildren();
        this.fComplianceControls.addAll(Arrays.asList(allChildren));
        ((AbstractCollection)this.fComplianceControls).removeAll(Arrays.asList(otherChildren));
        layout = new GridLayout();
        layout.numColumns = 2;
        group = new Group(compComposite, 0);
        group.setText(PreferencesMessages.getString("CompilerConfigurationBlock.classfiles.group.label"));
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)layout);
        String[] generateValues = new String[]{GENERATE, DO_NOT_GENERATE};
        label = PreferencesMessages.getString("CompilerConfigurationBlock.variable_attr.label");
        this.addCheckBox((Composite)group, label, PREF_LOCAL_VARIABLE_ATTR, generateValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.line_number_attr.label");
        this.addCheckBox((Composite)group, label, PREF_LINE_NUMBER_ATTR, generateValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.source_file_attr.label");
        this.addCheckBox((Composite)group, label, PREF_SOURCE_FILE_ATTR, generateValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.codegen_unused_local.label");
        this.addCheckBox((Composite)group, label, PREF_CODEGEN_UNUSED_LOCAL, new String[]{PRESERVE, OPTIMIZE_OUT}, 0);
        return compComposite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(String changedKey, String newValue) {
        if (changedKey != null) {
            if (INTR_DEFAULT_COMPLIANCE.equals(changedKey)) {
                this.updateComplianceEnableState();
                if (DEFAULT.equals(newValue)) {
                    this.updateComplianceDefaultSettings();
                }
            } else if (PREF_COMPLIANCE.equals(changedKey)) {
                if (this.checkValue(INTR_DEFAULT_COMPLIANCE, DEFAULT)) {
                    this.updateComplianceDefaultSettings();
                }
                this.fComplianceStatus = this.validateCompliance();
            } else if (PREF_SOURCE_COMPATIBILITY.equals(changedKey) || PREF_CODEGEN_TARGET_PLATFORM.equals(changedKey) || PREF_PB_ASSERT_AS_IDENTIFIER.equals(changedKey)) {
                this.fComplianceStatus = this.validateCompliance();
            } else if (PREF_PB_MAX_PER_UNIT.equals(changedKey)) {
                this.fMaxNumberProblemsStatus = this.validateMaxNumberProblems();
            } else {
                if (!PREF_RESOURCE_FILTER.equals(changedKey)) return;
                this.fResourceFilterStatus = this.validateResourceFilters();
            }
        } else {
            this.updateComplianceEnableState();
            this.fComplianceStatus = this.validateCompliance();
            this.fMaxNumberProblemsStatus = this.validateMaxNumberProblems();
            this.fResourceFilterStatus = this.validateResourceFilters();
        }
        IStatus status = StatusUtil.getMostSevere(new IStatus[]{this.fComplianceStatus, this.fMaxNumberProblemsStatus, this.fResourceFilterStatus});
        this.fContext.statusChanged(status);
    }

    private IStatus validateCompliance() {
        StatusInfo status = new StatusInfo();
        if (this.checkValue(PREF_COMPLIANCE, VERSION_1_3)) {
            if (this.checkValue(PREF_SOURCE_COMPATIBILITY, VERSION_1_4)) {
                status.setError(PreferencesMessages.getString("CompilerConfigurationBlock.cpl13src14.error"));
                return status;
            }
            if (this.checkValue(PREF_CODEGEN_TARGET_PLATFORM, VERSION_1_4)) {
                status.setError(PreferencesMessages.getString("CompilerConfigurationBlock.cpl13trg14.error"));
                return status;
            }
        }
        if (this.checkValue(PREF_SOURCE_COMPATIBILITY, VERSION_1_4) && !this.checkValue(PREF_PB_ASSERT_AS_IDENTIFIER, ERROR)) {
            status.setError(PreferencesMessages.getString("CompilerConfigurationBlock.src14asrterr.error"));
            return status;
        }
        if (this.checkValue(PREF_SOURCE_COMPATIBILITY, VERSION_1_4) && !this.checkValue(PREF_CODEGEN_TARGET_PLATFORM, VERSION_1_4)) {
            status.setError(PreferencesMessages.getString("CompilerConfigurationBlock.src14tgt14.error"));
            return status;
        }
        return status;
    }

    private IStatus validateMaxNumberProblems() {
        String number = (String)this.fWorkingValues.get(PREF_PB_MAX_PER_UNIT);
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.getString("CompilerConfigurationBlock.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value <= 0) {
                    status.setError(PreferencesMessages.getFormattedString("CompilerConfigurationBlock.invalid_input", number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(PreferencesMessages.getFormattedString("CompilerConfigurationBlock.invalid_input", number));
            }
        }
        return status;
    }

    private IStatus validateResourceFilters() {
        String text = (String)this.fWorkingValues.get(PREF_RESOURCE_FILTER);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String[] filters = this.getTokens(text, ",");
        int i = 0;
        while (i < filters.length) {
            IStatus status;
            String fileName = filters[i].replace('*', 'x');
            int resourceType = 1;
            int lastCharacter = fileName.length() - 1;
            if (lastCharacter >= 0 && fileName.charAt(lastCharacter) == '/') {
                fileName = fileName.substring(0, lastCharacter);
                resourceType = 2;
            }
            if ((status = workspace.validateName(fileName, resourceType)).matches(4)) {
                String message = PreferencesMessages.getFormattedString("CompilerConfigurationBlock.filter.invalidsegment.error", status.getMessage());
                return new StatusInfo(4, message);
            }
            ++i;
        }
        return new StatusInfo();
    }

    private void updateComplianceEnableState() {
        boolean enabled = this.checkValue(INTR_DEFAULT_COMPLIANCE, USER);
        int i = this.fComplianceControls.size() - 1;
        while (i >= 0) {
            Control curr = (Control)this.fComplianceControls.get(i);
            curr.setEnabled(enabled);
            --i;
        }
    }

    private void updateComplianceDefaultSettings() {
        Object complianceLevel = this.fWorkingValues.get(PREF_COMPLIANCE);
        if (VERSION_1_3.equals(complianceLevel)) {
            this.fWorkingValues.put(PREF_PB_ASSERT_AS_IDENTIFIER, IGNORE);
            this.fWorkingValues.put(PREF_SOURCE_COMPATIBILITY, VERSION_1_3);
            this.fWorkingValues.put(PREF_CODEGEN_TARGET_PLATFORM, VERSION_1_1);
        } else if (VERSION_1_4.equals(complianceLevel)) {
            this.fWorkingValues.put(PREF_PB_ASSERT_AS_IDENTIFIER, ERROR);
            this.fWorkingValues.put(PREF_SOURCE_COMPATIBILITY, VERSION_1_4);
            this.fWorkingValues.put(PREF_CODEGEN_TARGET_PLATFORM, VERSION_1_4);
        }
        this.updateControls();
    }

    private static String getCurrentCompliance(Map map) {
        Object complianceLevel = map.get(PREF_COMPLIANCE);
        if (VERSION_1_3.equals(complianceLevel) && IGNORE.equals(map.get(PREF_PB_ASSERT_AS_IDENTIFIER)) && VERSION_1_3.equals(map.get(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_1.equals(map.get(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_4.equals(complianceLevel) && ERROR.equals(map.get(PREF_PB_ASSERT_AS_IDENTIFIER)) && VERSION_1_4.equals(map.get(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_4.equals(map.get(PREF_CODEGEN_TARGET_PLATFORM))) {
            return DEFAULT;
        }
        return USER;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.getString("CompilerConfigurationBlock.needsbuild.title");
        String message = workspaceSettings ? PreferencesMessages.getString("CompilerConfigurationBlock.needsfullbuild.message") : PreferencesMessages.getString("CompilerConfigurationBlock.needsprojectbuild.message");
        return new String[]{title, message};
    }
}

