/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class CodeFormatterConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String PREF_NEWLINE_OPENING_BRACES = "org.eclipse.jdt.core.formatter.newline.openingBrace";
    private static final String PREF_NEWLINE_CONTROL_STATEMENT = "org.eclipse.jdt.core.formatter.newline.controlStatement";
    private static final String PREF_NEWLINE_CLEAR_ALL = "org.eclipse.jdt.core.formatter.newline.clearAll";
    private static final String PREF_NEWLINE_ELSE_IF = "org.eclipse.jdt.core.formatter.newline.elseIf";
    private static final String PREF_NEWLINE_EMPTY_BLOCK = "org.eclipse.jdt.core.formatter.newline.emptyBlock";
    private static final String PREF_LINE_SPLIT = "org.eclipse.jdt.core.formatter.lineSplit";
    private static final String PREF_STYLE_COMPACT_ASSIGNEMENT = "org.eclipse.jdt.core.formatter.style.assignment";
    private static final String PREF_TAB_CHAR = "org.eclipse.jdt.core.formatter.tabulation.char";
    private static final String PREF_TAB_SIZE = "org.eclipse.jdt.core.formatter.tabulation.size";
    private static final String PREF_SPACE_CASTEXPRESSION = "org.eclipse.jdt.core.formatter.space.castexpression";
    private static final String INSERT = "insert";
    private static final String DO_NOT_INSERT = "do not insert";
    private static final String COMPACT = "compact";
    private static final String NORMAL = "normal";
    private static final String TAB = "tab";
    private static final String SPACE = "space";
    private static final String CLEAR_ALL = "clear all";
    private static final String PRESERVE_ONE = "preserve one";
    private String fPreviewText;
    private IDocument fPreviewDocument = new Document();
    private Text fTabSizeTextBox;
    private SourceViewer fSourceViewer;
    private PixelConverter fPixelConverter;
    private IStatus fLineLengthStatus;
    private IStatus fTabSizeStatus;

    public CodeFormatterConfigurationBlock(IStatusChangeListener context, IJavaProject project) {
        super(context, project);
        this.fPreviewText = this.loadPreviewFile("CodeFormatterPreviewCode.txt");
        this.fLineLengthStatus = new StatusInfo();
        this.fTabSizeStatus = new StatusInfo();
    }

    protected String[] getAllKeys() {
        return new String[]{PREF_NEWLINE_OPENING_BRACES, PREF_NEWLINE_CONTROL_STATEMENT, PREF_NEWLINE_CLEAR_ALL, PREF_NEWLINE_ELSE_IF, PREF_NEWLINE_EMPTY_BLOCK, PREF_LINE_SPLIT, PREF_STYLE_COMPACT_ASSIGNEMENT, PREF_TAB_CHAR, PREF_TAB_SIZE, PREF_SPACE_CASTEXPRESSION};
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        int textWidth = this.fPixelConverter.convertWidthInCharsToPixels(6);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        String[] insertNotInsert = new String[]{INSERT, DO_NOT_INSERT};
        layout = new GridLayout();
        layout.numColumns = 2;
        Composite newlineComposite = new Composite((Composite)folder, 0);
        newlineComposite.setLayout((Layout)layout);
        String label = PreferencesMessages.getString("CodeFormatterPreferencePage.newline_opening_braces.label");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_OPENING_BRACES, insertNotInsert, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.newline_control_statement.label");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_CONTROL_STATEMENT, insertNotInsert, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.newline_clear_lines");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_CLEAR_ALL, new String[]{CLEAR_ALL, PRESERVE_ONE}, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.newline_else_if.label");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_ELSE_IF, insertNotInsert, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.newline_empty_block.label");
        this.addCheckBox(newlineComposite, label, PREF_NEWLINE_EMPTY_BLOCK, insertNotInsert, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        Composite lineSplittingComposite = new Composite((Composite)folder, 0);
        lineSplittingComposite.setLayout((Layout)layout);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.split_line.label");
        this.addTextField(lineSplittingComposite, label, PREF_LINE_SPLIT, 0, textWidth);
        layout = new GridLayout();
        layout.numColumns = 2;
        Composite styleComposite = new Composite((Composite)folder, 0);
        styleComposite.setLayout((Layout)layout);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.style_compact_assignement.label");
        this.addCheckBox(styleComposite, label, PREF_STYLE_COMPACT_ASSIGNEMENT, new String[]{COMPACT, NORMAL}, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.style_space_castexpression.label");
        this.addCheckBox(styleComposite, label, PREF_SPACE_CASTEXPRESSION, insertNotInsert, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.tab_char.label");
        this.addCheckBox(styleComposite, label, PREF_TAB_CHAR, new String[]{TAB, SPACE}, 0);
        label = PreferencesMessages.getString("CodeFormatterPreferencePage.tab_size.label");
        this.fTabSizeTextBox = this.addTextField(styleComposite, label, PREF_TAB_SIZE, 0, textWidth);
        this.fTabSizeTextBox.setTextLimit(3);
        TabItem item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CodeFormatterPreferencePage.tab.newline.tabtitle"));
        item.setControl((Control)newlineComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CodeFormatterPreferencePage.tab.linesplit.tabtitle"));
        item.setControl((Control)lineSplittingComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CodeFormatterPreferencePage.tab.style.tabtitle"));
        item.setControl((Control)styleComposite);
        this.fSourceViewer = this.createPreview(parent);
        this.updatePreview();
        return composite;
    }

    private SourceViewer createPreview(Composite parent) {
        SourceViewer previewViewer = new SourceViewer(parent, null, 2816);
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        previewViewer.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(tools, null));
        previewViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
        previewViewer.getTextWidget().setTabs(CodeFormatterConfigurationBlock.getPositiveIntValue((String)this.fWorkingValues.get(PREF_TAB_SIZE), 0));
        previewViewer.setEditable(false);
        previewViewer.setDocument(this.fPreviewDocument);
        Control control = previewViewer.getControl();
        GridData gdata = new GridData(1808);
        gdata.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(30);
        gdata.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(12);
        control.setLayoutData((Object)gdata);
        return previewViewer;
    }

    protected void validateSettings(String changedKey, String newValue) {
        if (changedKey == null || PREF_LINE_SPLIT.equals(changedKey)) {
            this.fLineLengthStatus = this.validatePositiveNumber(newValue);
        }
        if (changedKey == null || PREF_TAB_SIZE.equals(changedKey)) {
            this.fTabSizeStatus = this.validatePositiveNumber(newValue);
            int oldTabSize = this.fSourceViewer.getTextWidget().getTabs();
            if (this.fTabSizeStatus.matches(4)) {
                this.fWorkingValues.put(PREF_TAB_SIZE, String.valueOf(oldTabSize));
            } else {
                this.fSourceViewer.getTextWidget().setTabs(CodeFormatterConfigurationBlock.getPositiveIntValue(newValue, 0));
            }
        }
        this.updatePreview();
        this.fContext.statusChanged(StatusUtil.getMoreSevere(this.fLineLengthStatus, this.fTabSizeStatus));
    }

    private String loadPreviewFile(String filename) {
        StringBuffer btxt;
        block12: {
            String separator = System.getProperty("line.separator");
            btxt = new StringBuffer(512);
            BufferedReader rin = null;
            try {
                try {
                    String line;
                    rin = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
                    while ((line = rin.readLine()) != null) {
                        if (btxt.length() > 0) {
                            btxt.append(separator);
                        }
                        btxt.append(line);
                    }
                }
                catch (IOException io) {
                    JavaPlugin.log(io);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (rin != null) {
                    try {
                        rin.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var6_9 = null;
            if (rin == null) break block12;
            try {
                rin.close();
            }
            catch (IOException iOException) {}
        }
        return btxt.toString();
    }

    private void updatePreview() {
        ICodeFormatter formatter = ToolFactory.createDefaultCodeFormatter((Map)this.fWorkingValues);
        this.fPreviewDocument.set(formatter.format(this.fPreviewText, 0, null, "\n"));
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.getString("CodeFormatterPreferencePage.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(PreferencesMessages.getFormattedString("CodeFormatterPreferencePage.invalid_input", number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(PreferencesMessages.getFormattedString("CodeFormatterPreferencePage.invalid_input", number));
            }
        }
        return status;
    }

    private static int getPositiveIntValue(String string, int dflt) {
        try {
            int i = Integer.parseInt(string);
            if (i >= 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return dflt;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }
}

