/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.reorg.CopyRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.AddMethodStubAction;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDropAdapter;
import org.eclipse.jdt.internal.ui.dnd.LocalSelectionTransfer;
import org.eclipse.jdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.QualifiedNameComponent;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.reorg.DeleteSourceReferencesAction;
import org.eclipse.jdt.internal.ui.reorg.JdtCopyAction;
import org.eclipse.jdt.internal.ui.reorg.JdtMoveAction;
import org.eclipse.jdt.internal.ui.reorg.MockWorkbenchSite;
import org.eclipse.jdt.internal.ui.reorg.ReorgActionFactory;
import org.eclipse.jdt.internal.ui.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.reorg.SimpleSelectionProvider;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SelectionTransferDropAdapter
extends JdtViewerDropAdapter
implements TransferDropTargetListener {
    private List fElements;
    private MoveRefactoring fMoveRefactoring;
    private int fCanMoveElements;
    private CopyRefactoring fCopyRefactoring;
    private int fCanCopyElements;
    private ISelection fSelection;
    private AddMethodStubAction fAddMethodStubAction = new AddMethodStubAction();
    private static final int DROP_TIME_DIFF_TRESHOLD = 150;

    public SelectionTransferDropAdapter(StructuredViewer viewer) {
        super(viewer, 24);
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public void dragEnter(DropTargetEvent event) {
        this.clear();
        super.dragEnter(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.clear();
        super.dragLeave(event);
    }

    private void clear() {
        this.fElements = null;
        this.fSelection = null;
        this.fMoveRefactoring = null;
        this.fCanMoveElements = 0;
        this.fCopyRefactoring = null;
        this.fCanCopyElements = 0;
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        if (this.tooFast(event)) {
            return;
        }
        this.initializeSelection();
        try {
            if (operation == 16) {
                event.detail = this.handleValidateDefault(target, event);
            } else if (operation == 1) {
                event.detail = this.handleValidateCopy(target, event);
            } else if (operation == 2) {
                event.detail = this.handleValidateMove(target, event);
            } else if (operation == 4) {
                event.detail = this.handleValidateLink(target, event);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), PackagesMessages.getString("SelectionTransferDropAdapter.error.title"), PackagesMessages.getString("SelectionTransferDropAdapter.error.message"));
            event.detail = 0;
        }
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        this.fSelection = s;
        this.fElements = ((IStructuredSelection)s).toList();
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    private boolean tooFast(DropTargetEvent event) {
        return Math.abs(LocalSelectionTransfer.getInstance().getSelectionSetTime() - event.time) < 150;
    }

    public void drop(Object target, DropTargetEvent event) {
        try {
            try {
                if (event.detail == 2) {
                    this.handleDropMove(target, event);
                    if (!this.canPasteSourceReferences(target)) {
                        Object var4_3 = null;
                        event.detail = 0;
                        return;
                    }
                    DeleteSourceReferencesAction delete = ReorgActionFactory.createDeleteSourceReferencesAction(this.getDragableSourceReferences());
                    delete.setAskForDeleteConfirmation(true);
                    delete.setCanDeleteGetterSetter(false);
                    delete.update(delete.getSelection());
                    if (delete.isEnabled()) {
                        delete.run();
                    }
                } else if (event.detail == 1) {
                    this.handleDropCopy(target, event);
                } else if (event.detail == 4) {
                    this.handleDropLink(target, event);
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), PackagesMessages.getString("SelectionTransferDropAdapter.error.title"), PackagesMessages.getString("SelectionTransferDropAdapter.error.message"));
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            event.detail = 0;
            throw throwable;
        }
        Object var4_5 = null;
        event.detail = 0;
    }

    private int handleValidateDefault(Object target, DropTargetEvent event) throws JavaModelException {
        if (target == null) {
            return 0;
        }
        if (this.canPasteSourceReferences(target)) {
            return this.handleValidateCopy(target, event);
        }
        return this.handleValidateMove(target, event);
    }

    private int handleValidateMove(Object target, DropTargetEvent event) throws JavaModelException {
        if (target == null) {
            return 0;
        }
        if (this.canPasteSourceReferences(target)) {
            if (this.canMoveSelectedSourceReferences(target)) {
                return 2;
            }
            return 0;
        }
        if (this.fMoveRefactoring == null) {
            IPackageFragmentRootManipulationQuery query = JdtMoveAction.createUpdateClasspathQuery(this.getViewer().getControl().getShell());
            this.fMoveRefactoring = new MoveRefactoring(this.fElements, JavaPreferencesSettings.getCodeGenerationSettings(), query);
        }
        if (!this.canMoveElements()) {
            return 0;
        }
        if (this.fMoveRefactoring.isValidDestination(target)) {
            return 2;
        }
        return 0;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
            if (!this.canActivate(this.fMoveRefactoring)) {
                this.fCanMoveElements = 1;
            }
        }
        return this.fCanMoveElements == 2;
    }

    private boolean canActivate(ReorgRefactoring ref) {
        try {
            return ref.checkActivation((IProgressMonitor)new NullProgressMonitor()).isOK();
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), PackagesMessages.getString("SelectionTransferDropAdapter.error.title"), PackagesMessages.getString("SelectionTransferDropAdapter.error.message"));
            return false;
        }
    }

    private void handleDropLink(Object target, DropTargetEvent event) {
        if (this.fAddMethodStubAction.init((IType)target, this.getSelection())) {
            this.fAddMethodStubAction.run();
        }
    }

    private int handleValidateLink(Object target, DropTargetEvent event) {
        if (target instanceof IType && AddMethodStubAction.canActionBeAdded((IType)target, this.getSelection())) {
            return 4;
        }
        return 0;
    }

    private void handleDropMove(Object target, DropTargetEvent event) throws JavaModelException {
        if (this.canPasteSourceReferences(target)) {
            this.pasteSourceReferences(target, event);
            return;
        }
        new DragNDropMoveAction(new SimpleSelectionProvider(this.fElements), target).run();
    }

    private void pasteSourceReferences(Object target, DropTargetEvent event) {
        SelectionDispatchAction pasteAction = ReorgActionFactory.createPasteAction(this.getDragableSourceReferences(), target);
        pasteAction.update(pasteAction.getSelection());
        if (!pasteAction.isEnabled()) {
            event.detail = 0;
            return;
        }
        pasteAction.run();
    }

    private int handleValidateCopy(Object target, DropTargetEvent event) throws JavaModelException {
        if (this.canPasteSourceReferences(target)) {
            return 1;
        }
        if (this.fCopyRefactoring == null) {
            IPackageFragmentRootManipulationQuery query = JdtCopyAction.createUpdateClasspathQuery(this.getViewer().getControl().getShell());
            this.fCopyRefactoring = new CopyRefactoring(this.fElements, new ReorgQueries(), query);
        }
        if (!this.canCopyElements()) {
            return 0;
        }
        if (this.fCopyRefactoring.isValidDestination(target)) {
            return 1;
        }
        return 0;
    }

    private boolean canMoveSelectedSourceReferences(Object target) throws JavaModelException {
        ICompilationUnit targetCu = SelectionTransferDropAdapter.getCompilationUnit(target);
        if (targetCu == null) {
            return false;
        }
        ISourceReference[] elements = this.getDragableSourceReferences();
        int i = 0;
        while (i < elements.length) {
            if (targetCu.equals(SourceReferenceUtil.getCompilationUnit(elements[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static ICompilationUnit getCompilationUnit(Object target) {
        if (target instanceof ISourceReference) {
            return SourceReferenceUtil.getCompilationUnit((ISourceReference)target);
        }
        return null;
    }

    private boolean canPasteSourceReferences(Object target) throws JavaModelException {
        ISourceReference[] elements = this.getDragableSourceReferences();
        if (elements.length != this.fElements.size()) {
            return false;
        }
        SelectionDispatchAction pasteAction = ReorgActionFactory.createPasteAction(elements, target);
        pasteAction.update(pasteAction.getSelection());
        return pasteAction.isEnabled();
    }

    private ISourceReference[] getDragableSourceReferences() {
        ArrayList result = new ArrayList(this.fElements.size());
        Iterator iter = this.fElements.iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!SelectionTransferDropAdapter.isDragableSourceReferences(each)) continue;
            result.add(each);
        }
        return result.toArray(new ISourceReference[result.size()]);
    }

    private static boolean isDragableSourceReferences(Object element) {
        if (!(element instanceof ISourceReference)) {
            return false;
        }
        if (!(element instanceof IJavaElement)) {
            return false;
        }
        return !(element instanceof ICompilationUnit);
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
            if (!this.canActivate(this.fCopyRefactoring)) {
                this.fCanCopyElements = 1;
            }
        }
        return this.fCanCopyElements == 2;
    }

    private void handleDropCopy(Object target, DropTargetEvent event) throws JavaModelException {
        if (this.canPasteSourceReferences(target)) {
            this.pasteSourceReferences(target, event);
            return;
        }
        JdtCopyAction action = ReorgActionFactory.createDnDCopyAction(this.fElements, ResourceUtil.getResource(target));
        action.run();
    }

    private static class DragNDropMoveAction
    extends JdtMoveAction {
        private Object fTarget;
        private static final int PREVIEW_ID = 1025;

        public DragNDropMoveAction(ISelectionProvider provider, Object target) {
            super(new MockWorkbenchSite(provider));
            Assert.isNotNull(target);
            this.fTarget = target;
        }

        protected Object selectDestination(ReorgRefactoring ref) {
            return this.fTarget;
        }

        protected boolean isOkToProceed(ReorgRefactoring refactoring) throws JavaModelException {
            if (!super.isOkToProceed(refactoring)) {
                return false;
            }
            return this.askIfUpdateReferences((MoveRefactoring)refactoring);
        }

        private boolean askIfUpdateReferences(MoveRefactoring ref) throws JavaModelException {
            if (!ref.canUpdateReferences() && !ref.canUpdateQualifiedNames()) {
                this.setShowPreview(false);
                return true;
            }
            switch (DragNDropMoveAction.showMoveDialog(ref)) {
                case 1: {
                    this.setShowPreview(false);
                    return false;
                }
                case 0: {
                    this.setShowPreview(false);
                    return true;
                }
                case 1025: {
                    this.setShowPreview(true);
                    return true;
                }
            }
            Assert.isTrue(false);
            return false;
        }

        private static int showMoveDialog(MoveRefactoring ref) {
            Shell shell = JavaPlugin.getActiveWorkbenchShell().getShell();
            UpdateDialog dialog = new UpdateDialog(shell, ref);
            shell.getDisplay().syncExec(new Runnable(dialog){
                private final /* synthetic */ UpdateDialog val$dialog;
                {
                    this.val$dialog = updateDialog;
                }

                public void run() {
                    this.val$dialog.open();
                }
            });
            return dialog.getReturnCode();
        }

        private static class UpdateDialog
        extends Dialog {
            private Button fPreview;
            private MoveRefactoring fRefactoring;
            private Button fReferenceCheckbox;
            private Button fQualifiedNameCheckbox;
            private QualifiedNameComponent fQualifiedNameComponent;

            public UpdateDialog(Shell parentShell, MoveRefactoring refactoring) {
                super(parentShell);
                this.fRefactoring = refactoring;
            }

            protected void configureShell(Shell shell) {
                shell.setText(PackagesMessages.getString("SelectionTransferDropAdapter.dialog.title"));
                super.configureShell(shell);
            }

            protected void createButtonsForButtonBar(Composite parent) {
                this.fPreview = this.createButton(parent, 1025, ReorgMessages.getString("JdtMoveAction.preview"), false);
                super.createButtonsForButtonBar(parent);
            }

            protected void buttonPressed(int buttonId) {
                if (buttonId == 1025) {
                    this.setReturnCode(1025);
                    this.close();
                } else {
                    super.buttonPressed(buttonId);
                }
            }

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                this.addUpdateReferenceComponent(result);
                this.addUpdateQualifiedNameComponent(result, ((GridLayout)result.getLayout()).marginWidth);
                Dialog.applyDialogFont((Control)result);
                return result;
            }

            private void updateButtons() {
                boolean preview;
                Button okButton = this.getButton(0);
                boolean okEnabled = true;
                okButton.setEnabled(okEnabled);
                this.fReferenceCheckbox.setEnabled(okEnabled && this.canUpdateReferences());
                this.fRefactoring.setUpdateReferences(this.fReferenceCheckbox.getEnabled() && this.fReferenceCheckbox.getSelection());
                if (this.fQualifiedNameCheckbox != null) {
                    boolean enabled = okEnabled && this.fRefactoring.canEnableQualifiedNameUpdating();
                    this.fQualifiedNameCheckbox.setEnabled(enabled);
                    if (enabled) {
                        this.fQualifiedNameComponent.setEnabled(this.fRefactoring.getUpdateQualifiedNames());
                        if (this.fRefactoring.getUpdateQualifiedNames()) {
                            okButton.setEnabled(false);
                        }
                    } else {
                        this.fQualifiedNameComponent.setEnabled(false);
                    }
                    this.fRefactoring.setUpdateQualifiedNames(this.fQualifiedNameCheckbox.getEnabled() && this.fQualifiedNameCheckbox.getSelection());
                }
                if (preview = okEnabled) {
                    preview = this.fRefactoring.getUpdateQualifiedNames() && this.fRefactoring.canEnableQualifiedNameUpdating() || this.fReferenceCheckbox.getSelection() && this.canUpdateReferences();
                }
                this.fPreview.setEnabled(preview);
            }

            private void addUpdateReferenceComponent(Composite result) {
                this.fReferenceCheckbox = new Button(result, 32);
                this.fReferenceCheckbox.setText(ReorgMessages.getString("JdtMoveAction.update_references"));
                this.fReferenceCheckbox.setSelection(this.fRefactoring.getUpdateReferences());
                this.fReferenceCheckbox.setEnabled(this.canUpdateReferences());
                this.fReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    private final /* synthetic */ UpdateDialog this$2;
                    {
                        this.this$2 = updateDialog;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        UpdateDialog.access$0(this.this$2).setUpdateReferences(((Button)e.widget).getSelection());
                        UpdateDialog.access$1(this.this$2);
                    }
                });
            }

            private boolean canUpdateReferences() {
                try {
                    return this.fRefactoring.canUpdateReferences();
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }

            private void addUpdateQualifiedNameComponent(Composite parent, int marginWidth) {
                if (!this.fRefactoring.canUpdateQualifiedNames()) {
                    return;
                }
                this.fQualifiedNameCheckbox = new Button(parent, 32);
                int indent = marginWidth + this.fQualifiedNameCheckbox.computeSize((int)-1, (int)-1).x;
                this.fQualifiedNameCheckbox.setText(RefactoringMessages.getString("RenameInputWizardPage.update_qualified_names"));
                this.fQualifiedNameCheckbox.setLayoutData((Object)new GridData(768));
                this.fQualifiedNameCheckbox.setSelection(this.fRefactoring.getUpdateQualifiedNames());
                this.fQualifiedNameComponent = new QualifiedNameComponent(parent, 0, this.fRefactoring, this.getRefactoringSettings());
                this.fQualifiedNameComponent.setLayoutData(new GridData(768));
                GridData gd = (GridData)this.fQualifiedNameComponent.getLayoutData();
                gd.horizontalAlignment = 4;
                gd.horizontalIndent = indent;
                this.fQualifiedNameComponent.setEnabled(false);
                this.fQualifiedNameCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    private final /* synthetic */ UpdateDialog this$2;
                    {
                        this.this$2 = updateDialog;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        boolean enabled = ((Button)e.widget).getSelection();
                        UpdateDialog.access$2(this.this$2).setEnabled(enabled);
                        UpdateDialog.access$0(this.this$2).setUpdateQualifiedNames(enabled);
                        UpdateDialog.access$1(this.this$2);
                    }
                });
            }

            protected IDialogSettings getRefactoringSettings() {
                IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
                if (settings == null) {
                    return null;
                }
                IDialogSettings result = settings.getSection("org.eclipse.jdt.ui.refactoring");
                if (result == null) {
                    result = new DialogSettings("org.eclipse.jdt.ui.refactoring");
                    settings.addSection(result);
                }
                return result;
            }

            public boolean close() {
                if (this.getReturnCode() != 1 && this.fQualifiedNameComponent != null) {
                    this.fQualifiedNameComponent.savePatterns(this.getRefactoringSettings());
                }
                return super.close();
            }

            static /* synthetic */ MoveRefactoring access$0(UpdateDialog updateDialog) {
                return updateDialog.fRefactoring;
            }

            static /* synthetic */ void access$1(UpdateDialog updateDialog) {
                updateDialog.updateButtons();
            }

            static /* synthetic */ QualifiedNameComponent access$2(UpdateDialog updateDialog) {
                return updateDialog.fQualifiedNameComponent;
            }
        }
    }
}

