/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PackageFragmentProvider
implements IPropertyChangeListener,
ITreeContentProvider,
IElementChangedListener {
    private TreeViewer fViewer;
    private boolean fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();

    public PackageFragmentProvider() {
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Object[] getChildren(Object parentElement) {
        block16: {
            try {
                if (!(parentElement instanceof IJavaElement)) break block16;
                IJavaElement iJavaElement = (IJavaElement)parentElement;
                int type = iJavaElement.getElementType();
                switch (type) {
                    case 2: {
                        IJavaProject project = (IJavaProject)iJavaElement;
                        IProject proj = project.getProject();
                        List children = new ArrayList();
                        IPackageFragmentRoot defaultroot = project.getPackageFragmentRoot((IResource)proj);
                        if (defaultroot.exists()) {
                            IJavaElement[] els = defaultroot.getChildren();
                            children = this.getTopLevelChildrenByElementName(els);
                        }
                        return this.filter(children.toArray());
                    }
                    case 3: {
                        IPackageFragmentRoot root = (IPackageFragmentRoot)parentElement;
                        if (root.exists()) {
                            IResource resource = root.getUnderlyingResource();
                            if (root.isArchive()) {
                                IJavaElement[] els = root.getChildren();
                                return this.filter(this.getTopLevelChildrenByElementName(els).toArray());
                            }
                            if (resource instanceof IFolder) {
                                IFolder folder = (IFolder)resource;
                                IResource[] reses = folder.members();
                                List children = this.getFolders(reses);
                                IPackageFragment defaultPackage = root.getPackageFragment("");
                                if (defaultPackage.exists()) {
                                    children.add(defaultPackage);
                                }
                                return this.filter(children.toArray());
                            }
                        }
                        break;
                    }
                    case 4: {
                        IPackageFragment packageFragment = (IPackageFragment)parentElement;
                        if (!packageFragment.isDefaultPackage()) {
                            IResource resource = packageFragment.getUnderlyingResource();
                            if (resource != null && resource instanceof IFolder) {
                                IFolder folder = (IFolder)resource;
                                IResource[] reses = folder.members();
                                Object[] children = this.getFolders(reses).toArray();
                                return this.filter(children);
                            }
                            IJavaElement parent = packageFragment.getParent();
                            if (parent instanceof IPackageFragmentRoot) {
                                IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                                Object[] children = this.findNextLevelChildrenByElementName(root, packageFragment);
                                return this.filter(children);
                            }
                        }
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return new Object[0];
    }

    private Object[] filter(Object[] children) {
        if (this.fFoldPackages) {
            int i = 0;
            while (i < children.length) {
                IPackageFragment fragment;
                if (children[i] instanceof IPackageFragment && !(fragment = (IPackageFragment)children[i]).isDefaultPackage()) {
                    children[i] = this.getBottomPackage(fragment);
                }
                ++i;
            }
        }
        return children;
    }

    private Object getBottomPackage(IPackageFragment iPackageFragment) {
        try {
            if (this.isEmpty(iPackageFragment)) {
                return this.findChildrenToBeCompounded(iPackageFragment);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return iPackageFragment;
    }

    private IPackageFragment findChildrenToBeCompounded(IPackageFragment fragment) throws JavaModelException {
        Object[] children = this.getChildren(fragment);
        if (children.length == 1 && children[0] instanceof IPackageFragment) {
            if (this.isEmpty((IPackageFragment)children[0])) {
                return this.findChildrenToBeCompounded((IPackageFragment)children[0]);
            }
            return (IPackageFragment)children[0];
        }
        return fragment;
    }

    private boolean isEmpty(IPackageFragment fragment) throws JavaModelException {
        return !fragment.containsJavaResources() && fragment.getNonJavaResources().length == 0;
    }

    private Object[] findNextLevelChildrenByElementName(IPackageFragmentRoot parent, IPackageFragment fragment) {
        ArrayList<IPackageFragment> list = new ArrayList<IPackageFragment>();
        try {
            IJavaElement[] children = parent.getChildren();
            String fragmentname = fragment.getElementName();
            int i = 0;
            while (i < children.length) {
                IJavaElement element = children[i];
                if (element instanceof IPackageFragment) {
                    String tail;
                    IPackageFragment frag = (IPackageFragment)element;
                    String name = element.getElementName();
                    if (!"".equals(fragmentname) && name.startsWith(fragmentname) && !name.equals(fragmentname) && !"".equals(tail = name.substring(fragmentname.length() + 1)) && tail.indexOf(".") == -1) {
                        list.add(frag);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return list.toArray();
    }

    private List getTopLevelChildrenByElementName(IJavaElement[] elements) {
        ArrayList<IJavaElement> topLevelElements = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < elements.length) {
            IJavaElement iJavaElement = elements[i];
            if (iJavaElement.getElementName().indexOf(".") == -1 && iJavaElement instanceof IPackageFragment) {
                topLevelElements.add(iJavaElement);
            }
            ++i;
        }
        return topLevelElements;
    }

    private List getFolders(IResource[] resources) throws JavaModelException {
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < resources.length) {
            IFolder folder;
            IJavaElement element;
            IResource resource = resources[i];
            if (resource instanceof IFolder && (element = JavaCore.create((IFolder)(folder = (IFolder)resource))) instanceof IPackageFragment) {
                list.add(element);
            }
            ++i;
        }
        return list;
    }

    public Object getParent(Object element) {
        if (element instanceof IPackageFragment) {
            IPackageFragment frag = (IPackageFragment)element;
            return this.filterParent(this.getActualParent(frag));
        }
        return null;
    }

    public Object getActualParent(IPackageFragment fragment) {
        try {
            IJavaElement parent;
            if (fragment.exists() && (parent = fragment.getParent()) instanceof IPackageFragmentRoot && parent.exists()) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                if (root.isArchive()) {
                    return this.findNextLevelChildrenByElementName((IJavaElement)fragment, (IJavaElement)root);
                }
                IResource resource = fragment.getUnderlyingResource();
                if (resource != null && resource instanceof IFolder) {
                    IFolder folder = (IFolder)resource;
                    IContainer res = folder.getParent();
                    IJavaElement el = JavaCore.create((IResource)res);
                    return el;
                }
                return parent;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private Object filterParent(Object parent) {
        if (this.fFoldPackages && parent != null) {
            try {
                IPackageFragment fragment;
                if (parent instanceof IPackageFragment && this.isEmpty(fragment = (IPackageFragment)parent) && this.hasSingleChild(fragment)) {
                    return this.filterParent(this.getActualParent(fragment));
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return parent;
    }

    private boolean hasSingleChild(IPackageFragment fragment) {
        return this.getChildren(fragment).length == 1;
    }

    private Object findNextLevelChildrenByElementName(IJavaElement child, IJavaElement parent) {
        String name = child.getElementName();
        if (name.indexOf(".") == -1) {
            return parent;
        }
        try {
            String realParentName = child.getElementName().substring(0, name.lastIndexOf("."));
            IJavaElement[] children = new IJavaElement[]{};
            if (parent instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                children = root.getChildren();
            } else if (parent instanceof IJavaProject) {
                IJavaProject project = (IJavaProject)parent;
                children = project.getPackageFragments();
            }
            int i = 0;
            while (i < children.length) {
                IJavaElement element = children[i];
                if (element.getElementName().equals(realParentName)) {
                    return element;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        IPackageFragment fragment;
        if (element instanceof IPackageFragment && (fragment = (IPackageFragment)element).isDefaultPackage()) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
    }

    public void elementChanged(ElementChangedEvent event) {
        this.processDelta(event.getDelta());
    }

    public void processDelta(IJavaElementDelta delta) {
        int kind = delta.getKind();
        final IJavaElement element = delta.getElement();
        if (element instanceof IPackageFragment) {
            if (kind == 2) {
                this.postRunnable(new Runnable(){

                    public void run() {
                        Control ctrl = PackageFragmentProvider.this.fViewer.getControl();
                        if (ctrl != null && !ctrl.isDisposed()) {
                            if (!PackageFragmentProvider.this.fFoldPackages) {
                                PackageFragmentProvider.this.fViewer.remove((Object)element);
                            } else {
                                PackageFragmentProvider.this.refreshGrandParent(element);
                            }
                        }
                    }
                });
                return;
            }
            if (kind == 1) {
                final Object parent = this.getParent(element);
                if (parent != null) {
                    this.postRunnable(new Runnable(){

                        public void run() {
                            Control ctrl = PackageFragmentProvider.this.fViewer.getControl();
                            if (ctrl != null && !ctrl.isDisposed()) {
                                if (!PackageFragmentProvider.this.fFoldPackages) {
                                    PackageFragmentProvider.this.fViewer.add(parent, (Object)element);
                                } else {
                                    PackageFragmentProvider.this.refreshGrandParent(element);
                                }
                            }
                        }
                    });
                }
                return;
            }
        }
    }

    private void refreshGrandParent(IJavaElement element) {
        IJavaElement el;
        Object gp;
        if (element instanceof IPackageFragment && (gp = this.getGrandParent((IPackageFragment)element)) instanceof IJavaElement && (el = (IJavaElement)gp).exists()) {
            this.fViewer.refresh(gp);
        }
    }

    private Object getGrandParent(IPackageFragment element) {
        Object parent = this.findNextLevelChildrenByElementName((IJavaElement)element, element.getParent());
        if (parent instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
            if (this.isRootProject(root)) {
                return root.getJavaProject();
            }
            return root;
        }
        Object grandParent = this.getParent(parent);
        if (grandParent == null) {
            return parent;
        }
        return grandParent;
    }

    private boolean isRootProject(IPackageFragmentRoot root) {
        return "".equals(root.getElementName());
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay != null && currentDisplay.equals(ctrl.getDisplay())) {
                ctrl.getDisplay().syncExec(r);
            } else {
                ctrl.getDisplay().asyncExec(r);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.arePackagesFoldedInHierarchicalLayout() != this.fFoldPackages) {
            this.fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
            this.fViewer.getControl().setRedraw(false);
            Object[] expandedObjects = this.fViewer.getExpandedElements();
            this.fViewer.refresh();
            this.fViewer.setExpandedElements(expandedObjects);
            this.fViewer.getControl().setRedraw(true);
        }
    }

    private boolean arePackagesFoldedInHierarchicalLayout() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.flatPackagesInPackageExplorer");
    }
}

