/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.jdt.internal.ui.dnd.LocalSelectionTransfer;
import org.eclipse.jdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.jdt.internal.ui.dnd.TransferDragSourceListener;
import org.eclipse.jdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jdt.internal.ui.packageview.FileTransferDragAdapter;
import org.eclipse.jdt.internal.ui.packageview.FileTransferDropAdapter;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerActionGroup;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerElementComparer;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.jdt.internal.ui.packageview.SelectionTransferDropAdapter;
import org.eclipse.jdt.internal.ui.util.JavaUIHelp;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.FilterUpdater;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class PackageExplorerPart
extends ViewPart
implements ISetSelectionTarget,
IMenuListener,
IShowInTarget,
IPackagesViewPart,
IPropertyChangeListener,
IViewPartInputProvider {
    private boolean fIsCurrentLayoutFlat;
    private static final int HIERARCHICAL_LAYOUT = 1;
    private static final int FLAT_LAYOUT = 2;
    public static final String VIEW_ID = "org.eclipse.jdt.ui.PackageExplorer";
    static final String TAG_SELECTION = "selection";
    static final String TAG_EXPANDED = "expanded";
    static final String TAG_ELEMENT = "element";
    static final String TAG_PATH = "path";
    static final String TAG_VERTICAL_POSITION = "verticalPosition";
    static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    static final String TAG_FILTERS = "filters";
    static final String TAG_FILTER = "filter";
    static final String TAG_LAYOUT = "layout";
    private PackageExplorerContentProvider fContentProvider;
    private FilterUpdater fFilterUpdater;
    private PackageExplorerActionGroup fActionSet;
    private ProblemTreeViewer fViewer;
    private Menu fContextMenu;
    private IMemento fMemento;
    private ISelectionChangedListener fSelectionListener;
    private String fWorkingSetName;
    private IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                PackageExplorerPart.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private ITreeViewerListener fExpansionListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Object element = event.getElement();
            if (element instanceof ICompilationUnit || element instanceof IClassFile) {
                PackageExplorerPart.this.expandMainType(element);
            }
        }
    };
    private PackageExplorerLabelProvider fLabelProvider;
    private boolean fLinkingEnabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
        this.restoreLayoutState(memento);
    }

    private void restoreLayoutState(IMemento memento) {
        Integer state = null;
        if (memento != null) {
            state = memento.getInteger(TAG_LAYOUT);
        }
        if (state == null) {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            state = new Integer(store.getInt(TAG_LAYOUT));
        }
        this.fIsCurrentLayoutFlat = state == 2 ? true : state != 1;
    }

    public static PackageExplorerPart getFromActivePerspective() {
        IWorkbenchPage activePage = JavaPlugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart view = activePage.findView(VIEW_ID);
        if (view instanceof PackageExplorerPart) {
            return (PackageExplorerPart)view;
        }
        return null;
    }

    public static PackageExplorerPart openInActivePerspective() {
        try {
            return (PackageExplorerPart)JavaPlugin.getActivePage().showView(VIEW_ID);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void dispose() {
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        this.getSite().getPage().removePartListener(this.fPartListener);
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fViewer != null) {
            this.fViewer.removeTreeListener(this.fExpansionListener);
        }
        if (this.fActionSet != null) {
            this.fActionSet.dispose();
        }
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.fViewer = this.createViewer(parent);
        this.fViewer.setUseHashlookup(true);
        this.fViewer.setComparer(new PackageExplorerElementComparer());
        this.setProviders();
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
        site.getPage().addPartListener(this.fPartListener);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.makeActions();
        this.restoreFilterAndSorter();
        this.fViewer.setInput(this.findInputElement());
        this.initFrameActions();
        this.initDragAndDrop();
        this.initKeyListener();
        this.fSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PackageExplorerPart.this.handleSelectionChanged(event);
            }
        };
        this.fViewer.addSelectionChangedListener(this.fSelectionListener);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PackageExplorerPart.this.fActionSet.handleDoubleClick(event);
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                PackageExplorerPart.this.fActionSet.handleOpen(event);
            }
        });
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.fViewer.addTreeListener(this.fExpansionListener);
        if (this.fMemento != null) {
            this.restoreUIState(this.fMemento);
        }
        this.fMemento = null;
        JavaUIHelp.setHelp((StructuredViewer)this.fViewer, "org.eclipse.jdt.ui.package_view_context");
        this.fillActionBars();
        this.updateTitle();
        this.fFilterUpdater = new FilterUpdater((StructuredViewer)this.fViewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
    }

    private void initFrameActions() {
        this.fActionSet.getUpAction().update();
        this.fActionSet.getBackAction().update();
        this.fActionSet.getForwardAction().update();
    }

    private ProblemTreeViewer createViewer(Composite parent) {
        return new ProblemTreeViewer(parent, 770){

            protected Object[] getFilteredChildren(Object parent) {
                ArrayList<Object> list = new ArrayList<Object>();
                ViewerFilter[] filters = PackageExplorerPart.this.fViewer.getFilters();
                Object[] children = ((ITreeContentProvider)PackageExplorerPart.this.fViewer.getContentProvider()).getChildren(parent);
                int i = 0;
                while (i < children.length) {
                    Object object = children[i];
                    if (!this.isEssential(object)) {
                        if ((object = this.filter(object, parent, filters)) != null) {
                            list.add(object);
                        }
                    } else {
                        list.add(object);
                    }
                    ++i;
                }
                return list.toArray();
            }

            private Object filter(Object object, Object parent, ViewerFilter[] filters) {
                int i = 0;
                while (i < filters.length) {
                    ViewerFilter filter = filters[i];
                    if (!filter.select((Viewer)PackageExplorerPart.this.fViewer, parent, object)) {
                        return null;
                    }
                    ++i;
                }
                return object;
            }

            private boolean isEssential(Object object) {
                try {
                    if (!PackageExplorerPart.this.isFlatLayout() && object instanceof IPackageFragment) {
                        IPackageFragment fragment = (IPackageFragment)object;
                        return !fragment.isDefaultPackage() && fragment.hasSubpackages();
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
                return false;
            }

            protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
                IStructuredSelection is = (IStructuredSelection)invalidSelection;
                ArrayList<Object> ns = null;
                ns = newSelection instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)newSelection).toList()) : new ArrayList<Object>();
                boolean changed = false;
                Iterator iter = is.iterator();
                while (iter.hasNext()) {
                    IProject project;
                    Object element = iter.next();
                    if (element instanceof IJavaProject) {
                        project = ((IJavaProject)element).getProject();
                        if (project.isOpen()) continue;
                        ns.add(project);
                        changed = true;
                        continue;
                    }
                    if (!(element instanceof IProject) || !(project = (IProject)element).isOpen()) continue;
                    IJavaProject jProject = JavaCore.create((IProject)project);
                    if (jProject != null && jProject.exists()) {
                        ns.add(jProject);
                    }
                    changed = true;
                }
                if (changed) {
                    newSelection = new StructuredSelection(ns);
                    this.setSelection(newSelection);
                }
                super.handleInvalidSelection(invalidSelection, newSelection);
            }
        };
    }

    boolean isFlatLayout() {
        return this.fIsCurrentLayoutFlat;
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        this.fContentProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = this.createLabelProvider();
        this.fLabelProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(this.fLabelProvider, false, false));
    }

    void toggleLayout() {
        this.fIsCurrentLayoutFlat = !this.fIsCurrentLayoutFlat;
        this.saveLayoutState(null);
        this.fContentProvider.setIsFlatLayout(this.isFlatLayout());
        this.fLabelProvider.setIsFlatLayout(this.isFlatLayout());
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.refresh();
        this.fViewer.getControl().setRedraw(true);
    }

    public PackageExplorerContentProvider createContentProvider() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("org.eclipse.jdt.ui.packages.cuchildren");
        boolean reconcile = "JavaUI.update.whileEditing".equals(store.getString("JavaUI.update"));
        return new PackageExplorerContentProvider(this, showCUChildren, reconcile);
    }

    private PackageExplorerLabelProvider createLabelProvider() {
        return new PackageExplorerLabelProvider(1627389961, 3, this.fContentProvider);
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fActionSet.fillActionBars(actionBars);
    }

    private Object findInputElement() {
        IAdaptable input = this.getSite().getPage().getInput();
        if (input instanceof IWorkspace) {
            return JavaCore.create((IWorkspaceRoot)((IWorkspace)input).getRoot());
        }
        if (input instanceof IContainer) {
            IJavaElement element = JavaCore.create((IResource)((IContainer)input));
            if (element != null && element.exists()) {
                return element;
            }
            return input;
        }
        return JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot());
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this.fViewer;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz2) {
            return this.getShowInSource();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz3) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof IJavaModel ? PackagesMessages.getString("PackageExplorerPart.workspace") : JavaElementLabels.getTextLabel(element, 1090519049)) : ((path = ((IResource)element).getFullPath()).isRoot() ? PackagesMessages.getString("PackageExplorer.title") : path.makeRelative().toString());
        if (this.fWorkingSetName == null) {
            return result;
        }
        String wsstr = PackagesMessages.getFormattedString("PackageExplorer.toolTip", new String[]{this.fWorkingSetName});
        if (result.length() == 0) {
            return wsstr;
        }
        return PackagesMessages.getFormattedString("PackageExplorer.toolTip2", new String[]{result, this.fWorkingSetName});
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    private ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    public void menuAboutToShow(IMenuManager menu) {
        JavaPlugin.createStandardGroups(menu);
        this.fActionSet.setContext(new ActionContext(this.getSelection()));
        this.fActionSet.fillContextMenu(menu);
        this.fActionSet.setContext(null);
    }

    private void makeActions() {
        this.fActionSet = new PackageExplorerActionGroup(this);
    }

    private void initDragAndDrop() {
        this.initDrag();
        this.initDrop();
    }

    private void initDrag() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)this.fViewer), new ResourceTransferDragAdapter((ISelectionProvider)this.fViewer), new FileTransferDragAdapter((ISelectionProvider)this.fViewer)};
        this.fViewer.addDragSupport(ops, transfers, new JdtViewerDragAdapter((StructuredViewer)this.fViewer, dragListeners));
    }

    private void initDrop() {
        int ops = 23;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDropTargetListener[] dropListeners = new TransferDropTargetListener[]{new SelectionTransferDropAdapter((StructuredViewer)this.fViewer), new FileTransferDropAdapter((AbstractTreeViewer)this.fViewer)};
        this.fViewer.addDropSupport(ops, transfers, new DelegatingDropAdapter(dropListeners));
    }

    private void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.fActionSet.handleSelectionChanged(event);
        if (this.isLinkingEnabled()) {
            this.linkToEditor(selection);
        }
    }

    public void selectReveal(ISelection selection) {
        this.selectReveal(selection, 0);
    }

    private void selectReveal(final ISelection selection, final int count) {
        Control ctrl = this.getViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        ISelection javaSelection = this.convertSelection(selection);
        this.fViewer.setSelection(javaSelection, true);
        PackageExplorerContentProvider provider = (PackageExplorerContentProvider)this.getViewer().getContentProvider();
        ISelection cs = this.fViewer.getSelection();
        if (count == 0 && provider.hasPendingChanges() && !javaSelection.equals(cs)) {
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PackageExplorerPart.this.selectReveal(selection, count + 1);
                }
            });
        }
    }

    private ISelection convertSelection(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return s;
        }
        Object[] elements = ((StructuredSelection)s).toArray();
        if (!this.containsResources(elements)) {
            return s;
        }
        int i = 0;
        while (i < elements.length) {
            Object o = elements[i];
            if (!(o instanceof IJavaElement)) {
                if (o instanceof IResource) {
                    IJavaElement jElement = JavaCore.create((IResource)((IResource)o));
                    if (jElement != null && jElement.exists()) {
                        elements[i] = jElement;
                    }
                } else if (o instanceof IAdaptable) {
                    IResource r;
                    IAdaptable iAdaptable = (IAdaptable)o;
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((r = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                        IJavaElement jElement = JavaCore.create((IResource)r);
                        elements[i] = jElement != null && jElement.exists() ? jElement : r;
                    }
                }
            }
            ++i;
        }
        return new StructuredSelection(elements);
    }

    private boolean containsResources(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            Object o = elements[i];
            if (!(o instanceof IJavaElement)) {
                if (o instanceof IResource) {
                    return true;
                }
                if (o instanceof IAdaptable) {
                    IAdaptable iAdaptable = (IAdaptable)o;
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (iAdaptable.getAdapter((Class)clazz) != null) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public void selectAndReveal(Object element) {
        this.selectReveal((ISelection)new StructuredSelection(element));
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void initLinkingEnabled() {
        this.fLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.packages.linktoeditor");
    }

    private void linkToEditor(IStructuredSelection selection) {
        IEditorPart part;
        if (!this.isActivePart()) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (selection.size() == 1 && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof IJavaElement) {
                EditorUtility.revealInEditor(part, (IJavaElement)obj);
            }
        }
    }

    private boolean isActivePart() {
        return this == this.getSite().getPage().getActivePart();
    }

    public void saveState(IMemento memento) {
        if (this.fViewer == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        this.saveExpansionState(memento);
        this.saveSelectionState(memento);
        this.saveLayoutState(memento);
        this.saveLinkingEnabled(memento);
        this.fActionSet.saveFilterAndSorterState(memento);
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger("org.eclipse.jdt.ui.packages.linktoeditor", this.fLinkingEnabled ? 1 : 0);
    }

    private void saveLayoutState(IMemento memento) {
        if (memento != null) {
            memento.putInteger(TAG_LAYOUT, this.getLayoutAsInt());
        } else {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            store.setValue(TAG_LAYOUT, this.getLayoutAsInt());
        }
    }

    private int getLayoutAsInt() {
        if (this.fIsCurrentLayoutFlat) {
            return 2;
        }
        return 1;
    }

    protected void saveScrollState(IMemento memento, Tree tree) {
        ScrollBar bar = tree.getVerticalBar();
        int position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_VERTICAL_POSITION, String.valueOf(position));
        bar = tree.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_HORIZONTAL_POSITION, String.valueOf(position));
    }

    protected void saveSelectionState(IMemento memento) {
        Object[] elements = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        if (elements.length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTION);
            int i = 0;
            while (i < elements.length) {
                IMemento elementMem = selectionMem.createChild(TAG_ELEMENT);
                Object o = elements[i];
                if (o instanceof IJavaElement) {
                    elementMem.putString(TAG_PATH, ((IJavaElement)elements[i]).getHandleIdentifier());
                }
                ++i;
            }
        }
    }

    protected void saveExpansionState(IMemento memento) {
        Object[] expandedElements = this.fViewer.getVisibleExpandedElements();
        if (expandedElements.length > 0) {
            IMemento expandedMem = memento.createChild(TAG_EXPANDED);
            int i = 0;
            while (i < expandedElements.length) {
                IMemento elementMem = expandedMem.createChild(TAG_ELEMENT);
                Object o = expandedElements[i];
                if (o instanceof IJavaElement) {
                    elementMem.putString(TAG_PATH, ((IJavaElement)expandedElements[i]).getHandleIdentifier());
                }
                ++i;
            }
        }
    }

    private void restoreFilterAndSorter() {
        this.fViewer.setSorter(new JavaElementSorter());
        if (this.fMemento != null) {
            this.fActionSet.restoreFilterAndSorterState(this.fMemento);
        }
    }

    private void restoreUIState(IMemento memento) {
        this.restoreExpansionState(memento);
        this.restoreSelectionState(memento);
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger("org.eclipse.jdt.ui.packages.linktoeditor");
        if (val != null) {
            this.fLinkingEnabled = val != 0;
        }
    }

    protected void restoreScrollState(IMemento memento, Tree tree) {
        int position;
        String posStr;
        ScrollBar bar = tree.getVerticalBar();
        if (bar != null) {
            try {
                posStr = memento.getString(TAG_VERTICAL_POSITION);
                position = new Integer(posStr);
                bar.setSelection(position);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((bar = tree.getHorizontalBar()) != null) {
            try {
                posStr = memento.getString(TAG_HORIZONTAL_POSITION);
                position = new Integer(posStr);
                bar.setSelection(position);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected void restoreSelectionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_SELECTION);
        if (childMem != null) {
            ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
            IMemento[] elementMem = childMem.getChildren(TAG_ELEMENT);
            int i = 0;
            while (i < elementMem.length) {
                IJavaElement element = JavaCore.create((String)elementMem[i].getString(TAG_PATH));
                if (element != null) {
                    list.add(element);
                }
                ++i;
            }
            this.fViewer.setSelection((ISelection)new StructuredSelection(list));
        }
    }

    protected void restoreExpansionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_EXPANDED);
        if (childMem != null) {
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            IMemento[] elementMem = childMem.getChildren(TAG_ELEMENT);
            int i = 0;
            while (i < elementMem.length) {
                IJavaElement element = JavaCore.create((String)elementMem[i].getString(TAG_PATH));
                if (element != null) {
                    elements.add(element);
                }
                ++i;
            }
            this.fViewer.setExpandedElements(elements.toArray());
        }
    }

    private void initKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                PackageExplorerPart.this.fActionSet.handleKeyEvent(event);
            }
        });
    }

    void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        this.showInput(this.getElementOfInput(editor.getEditorInput()));
    }

    boolean showInput(Object input) {
        Object element = null;
        if (input instanceof IFile && this.isOnClassPath((IFile)input)) {
            element = JavaCore.create((IFile)((IFile)input));
        }
        if (element == null) {
            element = input;
        }
        if (element != null) {
            StructuredSelection newSelection = new StructuredSelection(element);
            if (!this.fViewer.getSelection().equals(newSelection)) {
                try {
                    this.fViewer.removeSelectionChangedListener(this.fSelectionListener);
                    this.fViewer.setSelection((ISelection)newSelection);
                    while (element != null && this.fViewer.getSelection().isEmpty()) {
                        if ((element = this.getParent(element)) == null) continue;
                        newSelection = new StructuredSelection(element);
                        this.fViewer.setSelection((ISelection)newSelection);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.fViewer.addSelectionChangedListener(this.fSelectionListener);
                    throw throwable;
                }
                Object var4_6 = null;
                this.fViewer.addSelectionChangedListener(this.fSelectionListener);
            }
            return true;
        }
        return false;
    }

    private boolean isOnClassPath(IFile file) {
        IJavaProject jproject = JavaCore.create((IProject)file.getProject());
        return jproject.isOnClasspath((IResource)file);
    }

    private Object getParent(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getParent();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    void expandMainType(Object element) {
        try {
            IType type = null;
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)element;
                IType[] types = cu.getTypes();
                if (types.length > 0) {
                    type = types[0];
                }
            } else if (element instanceof IClassFile) {
                IClassFile cf = (IClassFile)element;
                type = cf.getType();
            }
            if (type != null) {
                final IType type2 = type;
                Control ctrl = this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            Control ctrl = PackageExplorerPart.this.fViewer.getControl();
                            if (ctrl != null && !ctrl.isDisposed()) {
                                PackageExplorerPart.this.fViewer.expandToLevel(type2, 1);
                            }
                        }
                    });
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    Object getElementOfInput(IEditorInput input) {
        if (input instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)input).getClassFile();
        }
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        if (input instanceof JarEntryEditorInput) {
            return ((JarEntryEditorInput)input).getStorage();
        }
        return null;
    }

    TreeViewer getViewer() {
        return this.fViewer;
    }

    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    boolean isExpandable(Object element) {
        if (this.fViewer == null) {
            return false;
        }
        return this.fViewer.isExpandable(element);
    }

    void setWorkingSetName(String workingSetName) {
        this.fWorkingSetName = workingSetName;
    }

    void updateTitle() {
        Object input = this.fViewer.getInput();
        String viewName = this.getConfigurationElement().getAttribute("name");
        if (input == null || input instanceof IJavaModel) {
            this.setTitle(viewName);
            this.setTitleToolTip("");
        } else {
            String inputText = JavaElementLabels.getTextLabel(input, 1090519049);
            String title = PackagesMessages.getFormattedString("PackageExplorer.argTitle", new String[]{viewName, inputText});
            this.setTitle(title);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    public void setLabelDecorator(ILabelDecorator decorator) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fViewer == null) {
            return;
        }
        boolean refreshViewer = false;
        if ("org.eclipse.jdt.ui.packages.cuchildren".equals(event.getProperty())) {
            this.fActionSet.updateActionBars(this.getViewSite().getActionBars());
            boolean showCUChildren = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.packages.cuchildren");
            ((StandardJavaElementContentProvider)this.fViewer.getContentProvider()).setProvideMembers(showCUChildren);
            refreshViewer = true;
        } else if ("outlinesortoption".equals(event.getProperty())) {
            refreshViewer = true;
        }
        if (refreshViewer) {
            this.fViewer.refresh();
        }
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    public void collapseAll() {
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        this.fViewer.getControl().setRedraw(true);
    }

    public PackageExplorerPart() {
        this.initLinkingEnabled();
    }

    public boolean show(ShowInContext context) {
        Object input = context.getInput();
        if (input instanceof IEditorInput) {
            Object elementOfInput = this.getElementOfInput((IEditorInput)context.getInput());
            if (elementOfInput == null) {
                return false;
            }
            return this.showInput(elementOfInput);
        }
        ISelection selection = context.getSelection();
        if (selection != null) {
            this.selectReveal(selection);
            return true;
        }
        return false;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(PackageExplorerPart.this.getViewer().getInput(), PackageExplorerPart.this.getViewer().getSelection());
            }
        };
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.fLinkingEnabled = enabled;
        PreferenceConstants.getPreferenceStore().setValue("org.eclipse.jdt.ui.packages.linktoeditor", enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(editor);
        }
    }

    String getFrameName(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getElementName();
        }
        return ((ILabelProvider)this.getTreeViewer().getLabelProvider()).getText(element);
    }

    void projectStateChanged(Object root) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            this.fViewer.refresh(root, true);
            this.fViewer.setSelection(this.fViewer.getSelection());
        }
    }
}

