/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.actions.NewWizardsActionGroup;
import org.eclipse.jdt.internal.ui.packageview.CollapseAllAction;
import org.eclipse.jdt.internal.ui.packageview.GotoPackageAction;
import org.eclipse.jdt.internal.ui.packageview.GotoResourceAction;
import org.eclipse.jdt.internal.ui.packageview.GotoTypeAction;
import org.eclipse.jdt.internal.ui.packageview.LayoutActionGroup;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.packageview.PackagesFrameSource;
import org.eclipse.jdt.internal.ui.packageview.ToggleLinkingAction;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.BuildActionGroup;
import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.ImportActionGroup;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.jdt.ui.actions.NavigateActionGroup;
import org.eclipse.jdt.ui.actions.ProjectActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.UpAction;

class PackageExplorerActionGroup
extends CompositeActionGroup
implements ISelectionChangedListener {
    private PackageExplorerPart fPart;
    private GoIntoAction fZoomInAction;
    private BackAction fBackAction;
    private ForwardAction fForwardAction;
    private UpAction fUpAction;
    private GotoTypeAction fGotoTypeAction;
    private GotoPackageAction fGotoPackageAction;
    private GotoResourceAction fGotoResourceAction;
    private CollapseAllAction fCollapseAllAction;
    private RenameResourceAction fRenameResourceAction;
    private MoveResourceAction fMoveResourceAction;
    private ToggleLinkingAction fToggleLinkingAction;
    private NavigateActionGroup fNavigateActionGroup;
    private BuildActionGroup fBuildActionGroup;
    private CCPActionGroup fCCPActionGroup;
    private WorkingSetFilterActionGroup fWorkingSetFilterActionGroup;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private int fLastElement;
    private static final int INIT = 0;
    private static final int RESOURCE = 1;
    private static final int REST = 2;

    public PackageExplorerActionGroup(PackageExplorerPart part) {
        this.fPart = part;
        IWorkbenchPartSite site = this.fPart.getSite();
        Shell shell = site.getShell();
        ISelectionProvider provider = site.getSelectionProvider();
        IStructuredSelection selection = (IStructuredSelection)provider.getSelection();
        ActionGroup[] actionGroupArray = new ActionGroup[12];
        actionGroupArray[0] = new NewWizardsActionGroup((IWorkbenchSite)site);
        this.fNavigateActionGroup = new NavigateActionGroup(this.fPart);
        actionGroupArray[1] = this.fNavigateActionGroup;
        this.fCCPActionGroup = new CCPActionGroup(this.fPart);
        actionGroupArray[2] = this.fCCPActionGroup;
        actionGroupArray[3] = new GenerateActionGroup(this.fPart);
        actionGroupArray[4] = new RefactorActionGroup(this.fPart);
        actionGroupArray[5] = new ImportActionGroup(this.fPart);
        this.fBuildActionGroup = new BuildActionGroup(this.fPart);
        actionGroupArray[6] = this.fBuildActionGroup;
        actionGroupArray[7] = new JavaSearchActionGroup(this.fPart);
        actionGroupArray[8] = new ProjectActionGroup(this.fPart);
        this.fWorkingSetFilterActionGroup = new WorkingSetFilterActionGroup((StructuredViewer)part.getViewer(), "org.eclipse.jdt.ui.PackageExplorer", shell, this.createTitleUpdater());
        actionGroupArray[9] = this.fWorkingSetFilterActionGroup;
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup(this.fPart, (StructuredViewer)this.fPart.getViewer());
        actionGroupArray[10] = this.fCustomFiltersActionGroup;
        actionGroupArray[11] = new LayoutActionGroup(part);
        this.setGroups(actionGroupArray);
        PackagesFrameSource frameSource = new PackagesFrameSource(this.fPart);
        FrameList frameList = new FrameList((IFrameSource)frameSource);
        frameSource.connectTo(frameList);
        this.fZoomInAction = new GoIntoAction(frameList);
        this.fBackAction = new BackAction(frameList);
        this.fForwardAction = new ForwardAction(frameList);
        this.fUpAction = new UpAction(frameList);
        this.fRenameResourceAction = new RenameResourceAction(shell);
        this.fMoveResourceAction = new MoveResourceAction(shell);
        this.fGotoTypeAction = new GotoTypeAction(this.fPart);
        this.fGotoPackageAction = new GotoPackageAction(this.fPart);
        this.fGotoResourceAction = new GotoResourceAction(this.fPart);
        this.fCollapseAllAction = new CollapseAllAction(this.fPart);
        this.fToggleLinkingAction = new ToggleLinkingAction(this.fPart);
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.fPart.getViewer(), "PackageView", true);
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.update(selection);
        this.fLastElement = 0;
    }

    public void dispose() {
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this);
        super.dispose();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fRenameResourceAction.selectionChanged(event);
        this.fMoveResourceAction.selectionChanged(event);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.update(selection);
    }

    private void update(IStructuredSelection selection) {
        int size = selection.size();
        Object element = selection.getFirstElement();
        IActionBars actionBars = this.fPart.getViewSite().getActionBars();
        if (size == 1 && element instanceof IResource) {
            if (this.fLastElement != 1) {
                actionBars.setGlobalActionHandler("rename", (IAction)this.fRenameResourceAction);
                actionBars.setGlobalActionHandler("move", (IAction)this.fMoveResourceAction);
                actionBars.updateActionBars();
                this.fLastElement = 1;
            }
        } else if (this.fLastElement != 2) {
            actionBars.setGlobalActionHandler("rename", null);
            actionBars.setGlobalActionHandler("move", null);
            actionBars.updateActionBars();
            this.fLastElement = 2;
        }
    }

    void restoreFilterAndSorterState(IMemento memento) {
        this.fMemberFilterActionGroup.restoreState(memento);
        this.fWorkingSetFilterActionGroup.restoreState(memento);
        this.fCustomFiltersActionGroup.restoreState(memento);
    }

    void saveFilterAndSorterState(IMemento memento) {
        this.fMemberFilterActionGroup.saveState(memento);
        this.fWorkingSetFilterActionGroup.saveState(memento);
        this.fCustomFiltersActionGroup.saveState(memento);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.setGlobalActionHandlers(actionBars);
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    void updateActionBars(IActionBars actionBars) {
        actionBars.getToolBarManager().removeAll();
        actionBars.getMenuManager().removeAll();
        this.fillActionBars(actionBars);
        actionBars.updateActionBars();
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("goInto", (IAction)this.fZoomInAction);
        actionBars.setGlobalActionHandler("back", (IAction)this.fBackAction);
        actionBars.setGlobalActionHandler("forward", (IAction)this.fForwardAction);
        actionBars.setGlobalActionHandler("up", (IAction)this.fUpAction);
        actionBars.setGlobalActionHandler("goToResource", (IAction)this.fGotoResourceAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.GoToType", (IAction)this.fGotoTypeAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.GoToPackage", (IAction)this.fGotoPackageAction);
    }

    void fillToolBar(IToolBarManager toolBar) {
        toolBar.add((IAction)this.fBackAction);
        toolBar.add((IAction)this.fForwardAction);
        toolBar.add((IAction)this.fUpAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.fCollapseAllAction);
        toolBar.add((IAction)this.fToggleLinkingAction);
    }

    void fillViewMenu(IMenuManager menu) {
        if (this.showCompilationUnitChildren()) {
            this.fMemberFilterActionGroup.contributeToViewMenu(menu);
        }
        menu.add((IAction)this.fToggleLinkingAction);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
    }

    void handleSelectionChanged(SelectionChangedEvent event) {
        this.fZoomInAction.update();
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        int size = selection.size();
        Object element = selection.getFirstElement();
        this.addGotoMenu(menu, element, size);
        this.addOpenNewWindowAction(menu, element);
        super.fillContextMenu(menu);
    }

    private void addGotoMenu(IMenuManager menu, Object element, int size) {
        if (size == 1 && this.fPart.getViewer().isExpandable(element) && (this.isGoIntoTarget(element) || element instanceof IContainer)) {
            menu.appendToGroup("group.goto", (IAction)this.fZoomInAction);
        }
    }

    private boolean isGoIntoTarget(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IJavaElement) {
            int type = ((IJavaElement)element).getElementType();
            return type == 2 || type == 3 || type == 4;
        }
        return false;
    }

    private void addOpenNewWindowAction(IMenuManager menu, Object element) {
        if (element instanceof IJavaElement) {
            element = ((IJavaElement)element).getResource();
        }
        if (!(element instanceof IContainer)) {
            return;
        }
        menu.appendToGroup("group.open", (IAction)new OpenInNewWindowAction(this.fPart.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)element)));
    }

    void handleDoubleClick(DoubleClickEvent event) {
        Object element;
        TreeViewer viewer = this.fPart.getViewer();
        if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
            if (this.doubleClickGoesInto()) {
                if (element instanceof IOpenable && !(element instanceof ICompilationUnit) && !(element instanceof IClassFile)) {
                    this.fZoomInAction.run();
                }
            } else {
                IAction openAction = this.fNavigateActionGroup.getOpenAction();
                if (openAction != null && openAction.isEnabled() && OpenStrategy.getOpenMethod() == 0) {
                    return;
                }
                viewer.setExpandedState(element, !viewer.getExpandedState(element));
            }
        }
    }

    void handleOpen(OpenEvent event) {
        IAction openAction = this.fNavigateActionGroup.getOpenAction();
        if (openAction != null && openAction.isEnabled()) {
            openAction.run();
            return;
        }
    }

    void handleKeyEvent(KeyEvent event) {
        if (event.stateMask != 0) {
            return;
        }
        if (event.keyCode == 0x100000E) {
            IAction refreshAction = this.fBuildActionGroup.getRefreshAction();
            if (refreshAction != null && refreshAction.isEnabled()) {
                refreshAction.run();
            }
        } else if (event.character == '\u007f') {
            IAction delete = this.fCCPActionGroup.getDeleteAction();
            if (delete != null && delete.isEnabled()) {
                delete.run();
            }
        } else if (event.keyCode == 8 && this.fUpAction != null && this.fUpAction.isEnabled()) {
            this.fUpAction.run();
        }
    }

    private IPropertyChangeListener createTitleUpdater() {
        return new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("workingSetNameChange".equals(property)) {
                    IWorkingSet workingSet = (IWorkingSet)event.getNewValue();
                    String workingSetName = null;
                    if (workingSet != null) {
                        workingSetName = workingSet.getName();
                    }
                    PackageExplorerActionGroup.this.fPart.setWorkingSetName(workingSetName);
                    PackageExplorerActionGroup.this.fPart.updateTitle();
                }
            }
        };
    }

    private boolean showCompilationUnitChildren() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.packages.cuchildren");
    }

    private boolean doubleClickGoesInto() {
        return "packageview.gointo".equals(PreferenceConstants.getPreferenceStore().getString("packageview.doubleclick"));
    }

    public FrameAction getUpAction() {
        return this.fUpAction;
    }

    public FrameAction getBackAction() {
        return this.fBackAction;
    }

    public FrameAction getForwardAction() {
        return this.fForwardAction;
    }
}

