/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

class GotoTypeAction
extends Action {
    private PackageExplorerPart fPackageExplorer;

    GotoTypeAction(PackageExplorerPart part) {
        this.setText(PackagesMessages.getString("GotoType.action.label"));
        this.setDescription(PackagesMessages.getString("GotoType.action.description"));
        this.fPackageExplorer = part;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.goto_type_action");
    }

    public void run() {
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog(shell, (IRunnableContext)new ProgressMonitorDialog(shell), SearchEngine.createWorkspaceScope(), 6, false);
        }
        catch (JavaModelException e) {
            String title = this.getDialogTitle();
            String message = PackagesMessages.getString("GotoType.error.message");
            ExceptionHandler.handle((CoreException)((Object)e), title, message);
            return;
        }
        dialog.setTitle(this.getDialogTitle());
        dialog.setMessage(PackagesMessages.getString("GotoType.dialog.message"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            this.gotoType((IType)types[0]);
        }
    }

    private void gotoType(IType type) {
        PackageExplorerPart view;
        ICompilationUnit cu = (ICompilationUnit)type.getAncestor(5);
        Object element = null;
        element = cu != null ? (cu.isWorkingCopy() ? cu.getOriginalElement() : cu) : type.getAncestor(6);
        if (element != null && (view = PackageExplorerPart.openInActivePerspective()) != null) {
            view.selectReveal((ISelection)new StructuredSelection(element));
            if (!element.equals(this.getSelectedElement(view))) {
                MessageDialog.openInformation((Shell)this.fPackageExplorer.getSite().getShell(), (String)this.getDialogTitle(), (String)PackagesMessages.getFormattedString("PackageExplorer.element_not_present", element.getElementName()));
            }
        }
    }

    private Object getSelectedElement(PackageExplorerPart view) {
        return ((IStructuredSelection)view.getSite().getSelectionProvider().getSelection()).getFirstElement();
    }

    private String getDialogTitle() {
        return PackagesMessages.getString("GotoType.dialog.title");
    }
}

