/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDropAdapter;
import org.eclipse.jdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;

class FileTransferDropAdapter
extends JdtViewerDropAdapter
implements IOverwriteQuery,
TransferDropTargetListener {
    FileTransferDropAdapter(AbstractTreeViewer viewer) {
        super((StructuredViewer)viewer, 24);
    }

    public String queryOverwrite(String file) {
        String[] returnCodes = new String[]{"YES", "ALL", "NO", "CANCEL"};
        int returnVal = this.openDialog(this.getViewer().getControl(), file);
        return returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
    }

    private int openDialog(final Control control, final String file) {
        final int[] result = new int[]{1};
        control.getDisplay().syncExec(new Runnable(){

            public void run() {
                String title = PackagesMessages.getString("DropAdapter.question");
                String msg = PackagesMessages.getFormattedString("DropAdapter.alreadyExists", file);
                String[] options = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                MessageDialog dialog = new MessageDialog(control.getShell(), title, null, msg, 3, options, 0);
                result[0] = dialog.open();
            }
        });
        return result[0];
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        boolean isPackageFragment = target instanceof IPackageFragment;
        boolean isJavaProject = target instanceof IJavaProject;
        boolean isPackageFragmentRoot = target instanceof IPackageFragmentRoot;
        boolean isContainer = target instanceof IContainer;
        if (!(isPackageFragment || isJavaProject || isPackageFragmentRoot || isContainer)) {
            return;
        }
        if (isContainer) {
            IContainer container = (IContainer)target;
            if (container.isAccessible() && !container.isReadOnly()) {
                event.detail = 1;
            }
        } else {
            IJavaElement element = (IJavaElement)target;
            if (!element.isReadOnly()) {
                event.detail = 1;
            }
        }
    }

    public void drop(Object dropTarget, DropTargetEvent event) {
        int operation = event.detail;
        event.detail = 0;
        Object data = event.data;
        if (data == null || operation != 1) {
            return;
        }
        IContainer target = null;
        if (dropTarget instanceof IContainer) {
            target = (IContainer)dropTarget;
        } else {
            try {
                target = (IContainer)((IJavaElement)dropTarget).getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {}
        }
        if (target == null) {
            return;
        }
        new CopyFilesAndFoldersOperation(JavaPlugin.getActiveWorkbenchShell()).copyFiles((String[])data, target);
        event.detail = 1;
    }
}

