/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.selectionactions;

import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class StructureSelectPreviousAction
extends StructureSelectionAction {
    public StructureSelectPreviousAction(JavaEditor editor, SelectionHistory history) {
        super(JavaEditorMessages.getString("StructureSelectPrevious.label"), editor, history);
        this.setToolTipText(JavaEditorMessages.getString("StructureSelectPrevious.tooltip"));
        this.setDescription(JavaEditorMessages.getString("StructureSelectPrevious.description"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.structured_select_previous_action");
    }

    public StructureSelectPreviousAction() {
    }

    ISourceRange internalGetNewSelectionRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws JavaModelException {
        ASTNode first = selAnalyzer.getFirstSelectedNode();
        if (first == null) {
            return StructureSelectionAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode parent = first.getParent();
        if (parent == null) {
            return StructureSelectionAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode previousNode = StructureSelectPreviousAction.getPreviousNode(parent, selAnalyzer.getSelectedNodes()[0]);
        if (previousNode == parent) {
            return StructureSelectionAction.getSelectedNodeSourceRange(sr, parent);
        }
        int offset = previousNode.getStartPosition();
        int end = oldSourceRange.getOffset() + oldSourceRange.getLength() - 1;
        return StructureSelectionAction.createSourceRange(offset, end);
    }

    private static ASTNode getPreviousNode(ASTNode parent, ASTNode node) {
        Object[] siblingNodes = StructureSelectionAction.getChildNodes(parent);
        if (siblingNodes == null || siblingNodes.length == 0) {
            return parent;
        }
        if (node == siblingNodes[0]) {
            return parent;
        }
        return siblingNodes[StructureSelectionAction.findIndex(siblingNodes, node) - 1];
    }
}

