/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.selectionactions;

import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class StructureSelectNextAction
extends StructureSelectionAction {
    public StructureSelectNextAction(JavaEditor editor, SelectionHistory history) {
        super(JavaEditorMessages.getString("StructureSelectNext.label"), editor, history);
        this.setToolTipText(JavaEditorMessages.getString("StructureSelectNext.tooltip"));
        this.setDescription(JavaEditorMessages.getString("StructureSelectNext.description"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.structured_select_next_action");
    }

    public StructureSelectNextAction() {
    }

    ISourceRange internalGetNewSelectionRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws JavaModelException {
        ASTNode first = selAnalyzer.getFirstSelectedNode();
        if (first == null) {
            return StructureSelectionAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode parent = first.getParent();
        if (parent == null) {
            return StructureSelectionAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode lastSelectedNode = selAnalyzer.getSelectedNodes()[selAnalyzer.getSelectedNodes().length - 1];
        ASTNode nextNode = StructureSelectNextAction.getNextNode(parent, lastSelectedNode);
        if (nextNode == parent) {
            return StructureSelectionAction.getSelectedNodeSourceRange(sr, first.getParent());
        }
        int offset = oldSourceRange.getOffset();
        int end = Math.min(sr.getSourceRange().getLength(), nextNode.getStartPosition() + nextNode.getLength() - 1);
        return StructureSelectionAction.createSourceRange(offset, end);
    }

    private static ASTNode getNextNode(ASTNode parent, ASTNode node) {
        Object[] siblingNodes = StructureSelectionAction.getChildNodes(parent);
        if (siblingNodes == null || siblingNodes.length == 0) {
            return parent;
        }
        if (node == siblingNodes[siblingNodes.length - 1]) {
            return parent;
        }
        return siblingNodes[StructureSelectionAction.findIndex(siblingNodes, node) + 1];
    }
}

