/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;

public class JavaSelectMarkerRulerAction
extends SelectMarkerRulerAction {
    private ITextEditor fMyTextEditor;
    private Position fPosition;
    static /* synthetic */ Class class$0;

    public JavaSelectMarkerRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix, editor, ruler);
        this.fMyTextEditor = editor;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.java_select_marker_ruler_action");
    }

    public void run() {
        if (this.fPosition != null) {
            ITextOperationTarget operation;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((operation = (ITextOperationTarget)this.fMyTextEditor.getAdapter((Class)clazz)) != null && operation.canDoOperation(50)) {
                this.fMyTextEditor.selectAndReveal(this.fPosition.getOffset(), 0);
                operation.doOperation(50);
                return;
            }
        }
        super.run();
    }

    public void update() {
        if (!(this.fMyTextEditor instanceof ITextEditorExtension) || ((ITextEditorExtension)this.fMyTextEditor).isEditorInputReadOnly()) {
            this.fPosition = null;
            super.update();
            return;
        }
        this.fPosition = this.getJavaAnnotationPosition();
        if (this.fPosition != null) {
            this.setEnabled(true);
        } else {
            super.update();
        }
    }

    private Position getJavaAnnotationPosition() {
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        IDocument document = this.getDocument();
        if (model == null) {
            return null;
        }
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position position;
            IJavaAnnotation javaAnnotation;
            Annotation annotation = (Annotation)iter.next();
            if (!(annotation instanceof IJavaAnnotation) || !(javaAnnotation = (IJavaAnnotation)annotation).isRelevant() || !this.includesRulerLine(position = model.getPosition(annotation), document) || !JavaCorrectionProcessor.hasCorrections(javaAnnotation)) continue;
            return position;
        }
        return null;
    }
}

