/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.AnnotationType;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class JavaMarkerAnnotation
extends MarkerAnnotation
implements IJavaAnnotation {
    private static final int NO_IMAGE = 0;
    private static final int ORIGINAL_MARKER_IMAGE = 1;
    private static final int QUICKFIX_IMAGE = 2;
    private static final int QUICKFIX_ERROR_IMAGE = 3;
    private static final int OVERLAY_IMAGE = 4;
    private static final int GRAY_IMAGE = 5;
    private static final int BREAKPOINT_IMAGE = 6;
    private static Image fgQuickFixImage;
    private static Image fgQuickFixErrorImage;
    private static ImageRegistry fgGrayMarkersImageRegistry;
    private IDebugModelPresentation fPresentation;
    private IJavaAnnotation fOverlay;
    private boolean fNotRelevant = false;
    private AnnotationType fType;
    private int fImageType;
    private boolean fQuickFixIconEnabled;

    public JavaMarkerAnnotation(IMarker marker) {
        super(marker);
    }

    protected String getUnknownImageName(IMarker marker) {
        return "org.eclipse.jdt.ui.ghost.gif";
    }

    protected void initialize() {
        this.fQuickFixIconEnabled = PreferenceConstants.getPreferenceStore().getBoolean("JavaEditor.ShowTemporaryProblem");
        this.fImageType = 0;
        IMarker marker = this.getMarker();
        if (MarkerUtilities.isMarkerType((IMarker)marker, (String)IBreakpoint.BREAKPOINT_MARKER)) {
            if (this.fPresentation == null) {
                this.fPresentation = DebugUITools.newDebugModelPresentation();
            }
            this.setImage(null);
            this.setLayer(4);
            this.fImageType = 6;
            this.fType = AnnotationType.UNKNOWN;
        } else {
            this.fType = AnnotationType.UNKNOWN;
            if (marker.exists()) {
                try {
                    if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                        int severity = marker.getAttribute("severity", -1);
                        switch (severity) {
                            case 2: {
                                this.fType = AnnotationType.ERROR;
                                break;
                            }
                            case 1: {
                                this.fType = AnnotationType.WARNING;
                            }
                        }
                    } else if (marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
                        this.fType = AnnotationType.TASK;
                    } else if (marker.isSubtypeOf("org.eclipse.search.searchmarker")) {
                        this.fType = AnnotationType.SEARCH;
                    } else if (marker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
                        this.fType = AnnotationType.BOOKMARK;
                    }
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            }
            super.initialize();
        }
    }

    private boolean mustShowQuickFixIcon() {
        return this.fQuickFixIconEnabled && JavaCorrectionProcessor.hasCorrections(this.getMarker());
    }

    private Image getQuickFixImage() {
        if (fgQuickFixImage == null) {
            fgQuickFixImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_warning_obj.gif");
        }
        return fgQuickFixImage;
    }

    private Image getQuickFixErrorImage() {
        if (fgQuickFixErrorImage == null) {
            fgQuickFixErrorImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_error_obj.gif");
        }
        return fgQuickFixErrorImage;
    }

    public String getMessage() {
        IMarker marker = this.getMarker();
        if (marker == null || !marker.exists()) {
            return "";
        }
        return marker.getAttribute("message", "");
    }

    public boolean isTemporary() {
        return false;
    }

    public String[] getArguments() {
        IMarker marker = this.getMarker();
        if (marker != null && marker.exists() && this.isProblem()) {
            return Util.getProblemArgumentsFromMarker((String)marker.getAttribute("arguments", ""));
        }
        return null;
    }

    public int getId() {
        IMarker marker = this.getMarker();
        if (marker != null && marker.exists() && this.isProblem()) {
            return marker.getAttribute("id", -1);
        }
        return -1;
    }

    public boolean isProblem() {
        return this.fType == AnnotationType.WARNING || this.fType == AnnotationType.ERROR;
    }

    public boolean isRelevant() {
        return !this.fNotRelevant;
    }

    public void setOverlay(IJavaAnnotation javaAnnotation) {
        if (this.fOverlay != null) {
            this.fOverlay.removeOverlaid(this);
        }
        this.fOverlay = javaAnnotation;
        boolean bl = this.fNotRelevant = this.fNotRelevant || this.fOverlay != null;
        if (javaAnnotation != null) {
            javaAnnotation.addOverlaid(this);
        }
    }

    public boolean hasOverlay() {
        return this.fOverlay != null;
    }

    public Image getImage(Display display) {
        if (this.fImageType == 6) {
            IMarker marker;
            Image result = super.getImage(display);
            if (result == null && (marker = this.getMarker()) != null && marker.exists()) {
                result = this.fPresentation.getImage((Object)this.getMarker());
                this.setImage(result);
            }
            return result;
        }
        int newImageType = 0;
        newImageType = this.hasOverlay() ? 4 : (this.isRelevant() ? (this.mustShowQuickFixIcon() ? (this.fType == AnnotationType.ERROR ? 3 : 2) : 1) : 5);
        if (this.fImageType == newImageType && newImageType != 4) {
            return super.getImage(display);
        }
        Image newImage = null;
        switch (newImageType) {
            case 1: {
                newImage = null;
                break;
            }
            case 4: {
                newImage = this.fOverlay.getImage(display);
                break;
            }
            case 2: {
                newImage = this.getQuickFixImage();
                break;
            }
            case 3: {
                newImage = this.getQuickFixErrorImage();
                break;
            }
            case 5: {
                ImageRegistry imageRegistry;
                Image originalImage;
                if (this.fImageType != 1) {
                    this.setImage(null);
                }
                if ((originalImage = super.getImage(display)) == null || (imageRegistry = this.getGrayMarkerImageRegistry(display)) == null) break;
                String key = Integer.toString(originalImage.hashCode());
                Image grayImage = imageRegistry.get(key);
                if (grayImage == null) {
                    grayImage = new Image((Device)display, originalImage, 2);
                    imageRegistry.put(key, grayImage);
                }
                newImage = grayImage;
                break;
            }
            default: {
                Assert.isLegal((boolean)false);
            }
        }
        this.fImageType = newImageType;
        this.setImage(newImage);
        return super.getImage(display);
    }

    private ImageRegistry getGrayMarkerImageRegistry(Display display) {
        if (fgGrayMarkersImageRegistry == null) {
            fgGrayMarkersImageRegistry = new ImageRegistry(display);
        }
        return fgGrayMarkersImageRegistry;
    }

    public void addOverlaid(IJavaAnnotation annotation) {
    }

    public void removeOverlaid(IJavaAnnotation annotation) {
    }

    public Iterator getOverlaidIterator() {
        return null;
    }

    public AnnotationType getAnnotationType() {
        return this.fType;
    }
}

