/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.AnnotationType;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.GotoMatchingBracketAction;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.JavaAnnotationIterator;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaOutlinePage;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.GoToNextPreviousMemberAction;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectEnclosingAction;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectHistoryAction;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectNextAction;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectPreviousAction;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.internal.ui.text.JavaPairMatcher;
import org.eclipse.jdt.internal.ui.util.JavaUIHelp;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.OpenEditorActionGroup;
import org.eclipse.jdt.ui.actions.OpenViewActionGroup;
import org.eclipse.jdt.ui.actions.ShowActionGroup;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.AddTaskAction;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.tasklist.TaskList;

public abstract class JavaEditor
extends StatusTextEditor
implements IViewPartInputProvider {
    protected static final String LINE_NUMBER_RULER = "lineNumberRuler";
    protected static final String LINE_NUMBER_COLOR = "lineNumberColor";
    protected static final String LINK_COLOR = "linkColor";
    protected static final String MATCHING_BRACKETS = "matchingBrackets";
    protected static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    protected static final String CURRENT_LINE = "currentLine";
    protected static final String CURRENT_LINE_COLOR = "currentLineColor";
    protected static final String PRINT_MARGIN = "printMargin";
    protected static final String PRINT_MARGIN_COLOR = "printMarginColor";
    protected static final String PRINT_MARGIN_COLUMN = "printMarginColumn";
    protected static final String ERROR_INDICATION = "problemIndication";
    protected static final String ERROR_INDICATION_COLOR = "problemIndicationColor";
    protected static final String WARNING_INDICATION = "warningIndication";
    protected static final String WARNING_INDICATION_COLOR = "warningIndicationColor";
    protected static final String TASK_INDICATION = "taskIndication";
    protected static final String TASK_INDICATION_COLOR = "taskIndicationColor";
    protected static final String BOOKMARK_INDICATION = "bookmarkIndication";
    protected static final String BOOKMARK_INDICATION_COLOR = "bookmarkIndicationColor";
    protected static final String SEARCH_RESULT_INDICATION = "searchResultIndication";
    protected static final String SEARCH_RESULT_INDICATION_COLOR = "searchResultIndicationColor";
    protected static final String UNKNOWN_INDICATION = "othersIndication";
    protected static final String UNKNOWN_INDICATION_COLOR = "othersIndicationColor";
    protected static final String OVERVIEW_RULER = "overviewRuler";
    protected static final String ERROR_INDICATION_IN_OVERVIEW_RULER = "errorIndicationInOverviewRuler";
    protected static final String WARNING_INDICATION_IN_OVERVIEW_RULER = "warningIndicationInOverviewRuler";
    protected static final String TASK_INDICATION_IN_OVERVIEW_RULER = "taskIndicationInOverviewRuler";
    protected static final String BOOKMARK_INDICATION_IN_OVERVIEW_RULER = "bookmarkIndicationInOverviewRuler";
    protected static final String SEARCH_RESULT_INDICATION_IN_OVERVIEW_RULER = "searchResultIndicationInOverviewRuler";
    protected static final String UNKNOWN_INDICATION_IN_OVERVIEW_RULER = "othersIndicationInOverviewRuler";
    private static final String COMPILER_TASK_TAGS = "org.eclipse.jdt.core.compiler.taskTags";
    private static final String BROWSER_LIKE_LINKS = "browserLikeLinks";
    private static final String BROWSER_LIKE_LINKS_KEY_MODIFIER = "browserLikeLinksKeyModifier";
    private static final String BROWSER_LIKE_LINKS_KEY_MODIFIER_MASK = "browserLikeLinksKeyModifierMask";
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    protected JavaOutlinePage fOutlinePage;
    protected String fOutlinerContextMenuId;
    protected ISelectionChangedListener fSelectionChangedListener = new SelectionChangedListener();
    protected JavaPairMatcher fBracketMatcher = new JavaPairMatcher(BRACKETS);
    private OutlinePageSelectionUpdater fUpdater;
    private int fIgnoreOutlinePageSelection;
    private LineNumberRulerColumn fLineNumberRulerColumn;
    private DefaultEncodingSupport fEncodingSupport;
    private MouseClickListener fMouseListener;
    private InformationPresenter fInformationPresenter;
    protected IAnnotationAccess fAnnotationAccess = new AnnotationAccess();
    protected OverviewRuler isOverviewRulerVisible;
    protected SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    protected OverviewRuler fOverviewRuler;
    private SelectionHistory fSelectionHistory;
    private Preferences.IPropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    protected CompositeActionGroup fActionGroups;
    private CompositeActionGroup fContextMenuGroup;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected abstract IJavaElement getElementAt(int var1);

    protected abstract IJavaElement getCorrespondingElement(IJavaElement var1);

    protected abstract void setOutlinePageInput(JavaOutlinePage var1, IEditorInput var2);

    public JavaEditor() {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        this.setSourceViewerConfiguration(new JavaSourceViewerConfiguration(textTools, (ITextEditor)this));
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.setKeyBindingScopes(new String[]{"org.eclipse.jdt.ui.javaEditorScope"});
        if (PreferenceConstants.getPreferenceStore().getBoolean("JavaEditor.SyncOutlineOnCursorMove")) {
            this.fUpdater = new OutlinePageSelectionUpdater();
        }
    }

    protected final ISourceViewer createSourceViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        IColorManager sharedColors = JavaPlugin.getDefault().getJavaTextTools().getColorManager();
        this.fOverviewRuler = new OverviewRuler(this.fAnnotationAccess, 12, (ISharedTextColors)sharedColors);
        this.fOverviewRuler.addHeaderAnnotationType((Object)AnnotationType.WARNING);
        this.fOverviewRuler.addHeaderAnnotationType((Object)AnnotationType.ERROR);
        ISourceViewer viewer = this.createJavaSourceViewer(parent, verticalRuler, (IOverviewRuler)this.fOverviewRuler, this.isOverviewRulerVisible(), styles);
        StyledText text = viewer.getTextWidget();
        text.addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent event) {
                event.segments = JavaEditor.this.getBidiLineSegments(event.lineOffset, event.lineText);
            }
        });
        JavaUIHelp.setHelp(this, text, "org.eclipse.jdt.ui.java_editor_context");
        this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(viewer, (IOverviewRuler)this.fOverviewRuler, this.fAnnotationAccess, (ISharedTextColors)sharedColors);
        this.configureSourceViewerDecorationSupport();
        return viewer;
    }

    protected ISourceViewer createJavaSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles) {
        return new JavaSourceViewer(parent, verticalRuler, (IOverviewRuler)this.fOverviewRuler, this.isOverviewRulerVisible(), styles);
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return textTools.affectsBehavior(event);
    }

    protected void setOutlinerContextMenuId(String menuId) {
        this.fOutlinerContextMenuId = menuId;
    }

    protected ActionGroup getActionGroup() {
        return this.fActionGroups;
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.appendToGroup("group.undo", (IContributionItem)new Separator("group.open"));
        menu.insertAfter("group.open", (IContributionItem)new GroupMarker("group.show"));
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fContextMenuGroup.setContext(context);
        this.fContextMenuGroup.fillContextMenu(menu);
        this.fContextMenuGroup.setContext(null);
    }

    protected JavaOutlinePage createOutlinePage() {
        JavaOutlinePage page = new JavaOutlinePage(this.fOutlinerContextMenuId, this);
        page.addSelectionChangedListener(this.fSelectionChangedListener);
        this.setOutlinePageInput(page, this.getEditorInput());
        return page;
    }

    public void outlinePageClosed() {
        if (this.fOutlinePage != null) {
            this.fOutlinePage.removeSelectionChangedListener(this.fSelectionChangedListener);
            this.fOutlinePage = null;
            this.resetHighlightRange();
        }
    }

    public void synchronizeOutlinePageSelection() {
        if (this.isEditingScriptRunning()) {
            return;
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null || this.fOutlinePage == null) {
            return;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        IJavaElement element = this.getElementAt(caret);
        if (element instanceof ISourceReference) {
            this.fOutlinePage.removeSelectionChangedListener(this.fSelectionChangedListener);
            this.fOutlinePage.select((ISourceReference)element);
            this.fOutlinePage.addSelectionChangedListener(this.fSelectionChangedListener);
        }
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = this.createOutlinePage();
            }
            return this.fOutlinePage;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.editors.text.IEncodingSupport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            return this.fEncodingSupport;
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (required == clazz3) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ContentOutline", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(required);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setSelection(ISourceReference reference, boolean moveCursor) {
        TextSelection textSelection;
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof TextSelection && ((textSelection = (TextSelection)selection).getOffset() != 0 || textSelection.getLength() != 0)) {
            this.markInNavigationHistory();
        }
        if (reference != null) {
            StyledText textWidget;
            block28: {
                block27: {
                    block26: {
                        block25: {
                            textWidget = null;
                            ISourceViewer sourceViewer = this.getSourceViewer();
                            if (sourceViewer != null) {
                                textWidget = sourceViewer.getTextWidget();
                            }
                            if (textWidget == null) {
                                return;
                            }
                            try {
                                try {
                                    String content;
                                    String name;
                                    ISourceRange range = reference.getSourceRange();
                                    if (range == null) {
                                        Object var11_7 = null;
                                        if (textWidget == null) return;
                                        break block25;
                                    }
                                    int offset = range.getOffset();
                                    int length = range.getLength();
                                    if (offset < 0) break block26;
                                    if (length < 0) {
                                        break block26;
                                    }
                                    textWidget.setRedraw(false);
                                    this.setHighlightRange(offset, length, moveCursor);
                                    if (!moveCursor) {
                                        break block27;
                                    }
                                    offset = -1;
                                    length = -1;
                                    if (reference instanceof IMember) {
                                        range = ((IMember)reference).getNameRange();
                                        if (range != null) {
                                            offset = range.getOffset();
                                            length = range.getLength();
                                        }
                                    } else if (reference instanceof IImportDeclaration) {
                                        String content2;
                                        String name2 = ((IImportDeclaration)reference).getElementName();
                                        if (name2 != null && name2.length() > 0 && (content2 = reference.getSource()) != null) {
                                            offset = range.getOffset() + content2.indexOf(name2);
                                            length = name2.length();
                                        }
                                    } else if (reference instanceof IPackageDeclaration && (name = ((IPackageDeclaration)reference).getElementName()) != null && name.length() > 0 && (content = reference.getSource()) != null) {
                                        offset = range.getOffset() + content.indexOf(name);
                                        length = name.length();
                                    }
                                    if (offset > -1 && length > 0) {
                                        sourceViewer.revealRange(offset, length);
                                        sourceViewer.setSelectedRange(offset, length);
                                    }
                                    break block28;
                                }
                                catch (JavaModelException javaModelException) {
                                }
                                catch (IllegalArgumentException illegalArgumentException) {}
                                break block28;
                            }
                            catch (Throwable throwable) {
                                Object var11_10 = null;
                                if (textWidget != null) {
                                    textWidget.setRedraw(true);
                                }
                                throw throwable;
                            }
                        }
                        textWidget.setRedraw(true);
                        return;
                    }
                    Object var11_8 = null;
                    if (textWidget != null) {
                        textWidget.setRedraw(true);
                    }
                    return;
                }
                Object var11_9 = null;
                if (textWidget == null) return;
                textWidget.setRedraw(true);
                return;
            }
            Object var11_11 = null;
            if (textWidget != null) {
                textWidget.setRedraw(true);
            }
        } else if (moveCursor) {
            this.resetHighlightRange();
        }
        this.markInNavigationHistory();
    }

    public void setSelection(IJavaElement element) {
        if (element == null || element instanceof ICompilationUnit || element instanceof IClassFile) {
            return;
        }
        IJavaElement corresponding = this.getCorrespondingElement(element);
        if (corresponding instanceof ISourceReference) {
            ISourceReference reference = (ISourceReference)corresponding;
            this.setSelection(reference, true);
            if (this.fOutlinePage != null) {
                this.fOutlinePage.removeSelectionChangedListener(this.fSelectionChangedListener);
                this.fOutlinePage.select(reference);
                this.fOutlinePage.addSelectionChangedListener(this.fSelectionChangedListener);
            }
        }
    }

    public synchronized void editingScriptStarted() {
        ++this.fIgnoreOutlinePageSelection;
    }

    public synchronized void editingScriptEnded() {
        --this.fIgnoreOutlinePageSelection;
    }

    public synchronized boolean isEditingScriptRunning() {
        return this.fIgnoreOutlinePageSelection > 0;
    }

    protected void doSelectionChanged(SelectionChangedEvent event) {
        Object var5_5;
        ISourceReference reference = null;
        ISelection selection = event.getSelection();
        Iterator iter = ((IStructuredSelection)selection).iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof ISourceReference)) continue;
            reference = (ISourceReference)o;
            break;
        }
        if (!this.isActivePart() && JavaPlugin.getActivePage() != null) {
            JavaPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        try {
            this.editingScriptStarted();
            this.setSelection(reference, !this.isActivePart());
        }
        catch (Throwable throwable) {
            var5_5 = null;
            this.editingScriptEnded();
            throw throwable;
        }
        var5_5 = null;
        this.editingScriptEnded();
    }

    protected void adjustHighlightRange(int offset, int length) {
        try {
            IJavaElement element = this.getElementAt(offset);
            while (element instanceof ISourceReference) {
                ISourceRange range = ((ISourceReference)element).getSourceRange();
                if (offset < range.getOffset() + range.getLength() && range.getOffset() < offset + length) {
                    this.setHighlightRange(range.getOffset(), range.getLength(), true);
                    if (this.fOutlinePage != null) {
                        this.fOutlinePage.removeSelectionChangedListener(this.fSelectionChangedListener);
                        this.fOutlinePage.select((ISourceReference)element);
                        this.fOutlinePage.addSelectionChangedListener(this.fSelectionChangedListener);
                    }
                    return;
                }
                element = element.getParent();
            }
        }
        catch (JavaModelException x) {
            JavaPlugin.log(x.getStatus());
        }
        this.resetHighlightRange();
    }

    protected boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part != null && part.equals(this);
    }

    protected String getStatusHeader(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusHeader(status)) != null) {
            return message;
        }
        return super.getStatusHeader(status);
    }

    protected String getStatusBanner(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusBanner(status)) != null) {
            return message;
        }
        return super.getStatusBanner(status);
    }

    protected String getStatusMessage(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusMessage(status)) != null) {
            return message;
        }
        return super.getStatusMessage(status);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
        this.setOutlinePageInput(this.fOutlinePage, input);
    }

    public void dispose() {
        if (this.isBrowserLikeLinks()) {
            this.disableBrowserLikeLinks();
        }
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.dispose();
            this.fEncodingSupport = null;
        }
        if (this.fPropertyChangeListener != null) {
            Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
            preferences.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.dispose();
            this.fSourceViewerDecorationSupport = null;
        }
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        if (this.fSelectionHistory != null) {
            this.fSelectionHistory.dispose();
            this.fSelectionHistory = null;
        }
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        Object resAction = new AddTaskAction(JavaEditorMessages.getResourceBundle(), "AddTask.", (ITextEditor)this);
        resAction.setHelpContextId("org.eclipse.ui.addTask_action_context");
        resAction.setActionDefinitionId("org.eclipse.ui.edit.addTask");
        this.setAction("addTask", (IAction)resAction);
        ActionGroup[] actionGroupArray = new ActionGroup[4];
        OpenEditorActionGroup oeg = new OpenEditorActionGroup(this);
        actionGroupArray[0] = oeg;
        ShowActionGroup sg = new ShowActionGroup(this);
        actionGroupArray[1] = sg;
        OpenViewActionGroup ovg = new OpenViewActionGroup(this);
        actionGroupArray[2] = ovg;
        JavaSearchActionGroup jsg = new JavaSearchActionGroup(this);
        actionGroupArray[3] = jsg;
        this.fActionGroups = new CompositeActionGroup(actionGroupArray);
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{oeg, ovg, sg, jsg});
        resAction = new TextOperationAction(JavaEditorMessages.getResourceBundle(), "ShowJavaDoc.", (ITextEditor)this, 16, true);
        resAction = new InformationDispatchAction(JavaEditorMessages.getResourceBundle(), "ShowJavaDoc.", (TextOperationAction)resAction);
        resAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.javadoc");
        this.setAction("ShowJavaDoc", (IAction)resAction);
        WorkbenchHelp.setHelp((IAction)resAction, (String)"org.eclipse.jdt.ui.show_javadoc_action");
        Action action = new GotoMatchingBracketAction(this);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.matching.bracket");
        this.setAction("GotoMatchingBracket", (IAction)action);
        action = new TextOperationAction(JavaEditorMessages.getResourceBundle(), "ShowOutline.", (ITextEditor)this, 51, true);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.outline");
        this.setAction("org.eclipse.jdt.ui.edit.text.java.show.outline", (IAction)action);
        WorkbenchHelp.setHelp((IAction)action, (String)"org.eclipse.jdt.ui.show_outline_action");
        action = new TextOperationAction(JavaEditorMessages.getResourceBundle(), "OpenStructure.", (ITextEditor)this, 52, true);
        action.setActionDefinitionId("org.eclipse.jdt.ui.navigate.java.open.structure");
        this.setAction("org.eclipse.jdt.ui.navigate.java.open.structure", (IAction)action);
        WorkbenchHelp.setHelp((IAction)action, (String)"org.eclipse.jdt.ui.open_structure_action");
        this.fEncodingSupport = new DefaultEncodingSupport();
        this.fEncodingSupport.initialize((StatusTextEditor)this);
        this.fSelectionHistory = new SelectionHistory(this);
        action = new StructureSelectEnclosingAction(this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.enclosing");
        this.setAction("SelectEnclosingElement", (IAction)action);
        action = new StructureSelectNextAction(this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.next");
        this.setAction("SelectNextElement", (IAction)action);
        action = new StructureSelectPreviousAction(this, this.fSelectionHistory);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.previous");
        this.setAction("SelectPreviousElement", (IAction)action);
        StructureSelectHistoryAction historyAction = new StructureSelectHistoryAction(this, this.fSelectionHistory);
        historyAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.last");
        this.setAction("RestoreLastSelection", (IAction)historyAction);
        this.fSelectionHistory.setHistoryAction(historyAction);
        action = GoToNextPreviousMemberAction.newGoToNextMemberAction(this);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.next.member");
        this.setAction("GoToNextMember", (IAction)action);
        action = GoToNextPreviousMemberAction.newGoToPreviousMemberAction(this);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.previous.member");
        this.setAction("GoToPreviousMember", (IAction)action);
        if (this.isBrowserLikeLinks()) {
            this.enableBrowserLikeLinks();
        }
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        block20: {
            block21: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                try {
                                    ISourceViewer sourceViewer = this.getSourceViewer();
                                    if (sourceViewer == null) {
                                        Object var5_3 = null;
                                        break block16;
                                    }
                                    String property = event.getProperty();
                                    if ("org.eclipse.jdt.ui.editor.tab.width".equals(property)) {
                                        Object value = event.getNewValue();
                                        if (value instanceof Integer) {
                                            sourceViewer.getTextWidget().setTabs(((Integer)value).intValue());
                                            break block17;
                                        }
                                        if (value instanceof String) {
                                            sourceViewer.getTextWidget().setTabs(Integer.parseInt((String)value));
                                        }
                                        break block17;
                                    }
                                    if (OVERVIEW_RULER.equals(property)) {
                                        if (this.isOverviewRulerVisible()) {
                                            this.showOverviewRuler();
                                            break block18;
                                        } else {
                                            this.hideOverviewRuler();
                                        }
                                        break block18;
                                    }
                                    if (LINE_NUMBER_RULER.equals(property)) {
                                        if (this.isLineNumberRulerVisible()) {
                                            this.showLineNumberRuler();
                                            break block19;
                                        } else {
                                            this.hideLineNumberRuler();
                                        }
                                        break block19;
                                    }
                                    if (this.fLineNumberRulerColumn != null && (LINE_NUMBER_COLOR.equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property))) {
                                        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
                                    }
                                    if (this.isJavaEditorHoverProperty(property)) {
                                        this.updateHoverBehavior();
                                    }
                                    if (!BROWSER_LIKE_LINKS.equals(property)) break block20;
                                    if (this.isBrowserLikeLinks()) {
                                        this.enableBrowserLikeLinks();
                                        break block21;
                                    } else {
                                        this.disableBrowserLikeLinks();
                                    }
                                    break block21;
                                }
                                catch (Throwable throwable) {
                                    Object var5_8 = null;
                                    super.handlePreferenceStoreChanged(event);
                                    throw throwable;
                                }
                            }
                            super.handlePreferenceStoreChanged(event);
                            return;
                        }
                        Object var5_4 = null;
                        super.handlePreferenceStoreChanged(event);
                        return;
                    }
                    Object var5_5 = null;
                    super.handlePreferenceStoreChanged(event);
                    return;
                }
                Object var5_6 = null;
                super.handlePreferenceStoreChanged(event);
                return;
            }
            Object var5_7 = null;
            super.handlePreferenceStoreChanged(event);
            return;
        }
        Object var5_9 = null;
        super.handlePreferenceStoreChanged(event);
    }

    private boolean isJavaEditorHoverProperty(String property) {
        return "hoverModifiers".equals(property);
    }

    private boolean isBrowserLikeLinks() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(BROWSER_LIKE_LINKS);
    }

    private void enableBrowserLikeLinks() {
        if (this.fMouseListener == null) {
            this.fMouseListener = new MouseClickListener();
            this.fMouseListener.install();
        }
    }

    private void disableBrowserLikeLinks() {
        if (this.fMouseListener != null) {
            this.fMouseListener.uninstall();
            this.fMouseListener = null;
        }
    }

    protected void handlePreferencePropertyChanged(Preferences.PropertyChangeEvent event) {
        ISourceViewer sourceViewer;
        if (COMPILER_TASK_TAGS.equals(event.getProperty()) && (sourceViewer = this.getSourceViewer()) != null && this.affectsTextPresentation(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()))) {
            sourceViewer.invalidateTextPresentation();
        }
    }

    private void showLineNumberRuler() {
        IVerticalRuler v = this.getVerticalRuler();
        if (v instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            c.addDecorator(1, this.createLineNumberRulerColumn());
        }
    }

    private void hideLineNumberRuler() {
        IVerticalRuler v = this.getVerticalRuler();
        if (v instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            c.removeDecorator(1);
        }
    }

    private boolean isLineNumberRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(LINE_NUMBER_RULER);
    }

    public static int[] getBidiLineSegments(IDocument document, int lineOffset) throws BadLocationException {
        IRegion line = document.getLineInformationOfOffset(lineOffset);
        ITypedRegion[] linePartitioning = document.computePartitioning(lineOffset, line.getLength());
        ArrayList<ITypedRegion> segmentation = new ArrayList<ITypedRegion>();
        int i = 0;
        while (i < linePartitioning.length) {
            if ("__java_string".equals(linePartitioning[i].getType())) {
                segmentation.add(linePartitioning[i]);
            }
            ++i;
        }
        if (segmentation.size() == 0) {
            return null;
        }
        int size = segmentation.size();
        int[] segments = new int[size * 2 + 1];
        int j = 0;
        int i2 = 0;
        while (i2 < size) {
            int offset;
            ITypedRegion segment = (ITypedRegion)segmentation.get(i2);
            if (i2 == 0) {
                segments[j++] = 0;
            }
            if ((offset = segment.getOffset() - lineOffset) > segments[j - 1]) {
                segments[j++] = offset;
            }
            if (offset + segment.getLength() >= line.getLength()) break;
            segments[j++] = offset + segment.getLength();
            ++i2;
        }
        if (j < segments.length) {
            int[] result = new int[j];
            System.arraycopy(segments, 0, result, 0, j);
            segments = result;
        }
        return segments;
    }

    protected int[] getBidiLineSegments(int widgetLineOffset, String line) {
        IDocument document;
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null && line != null && line.length() > 0 && (document = provider.getDocument((Object)this.getEditorInput())) != null) {
            try {
                int lineOffset;
                ISourceViewer sourceViewer = this.getSourceViewer();
                if (sourceViewer instanceof ITextViewerExtension3) {
                    ITextViewerExtension3 extension = (ITextViewerExtension3)sourceViewer;
                    lineOffset = extension.widgetOffset2ModelOffset(widgetLineOffset);
                } else {
                    IRegion visible = sourceViewer.getVisibleRegion();
                    lineOffset = visible.getOffset() + widgetLineOffset;
                }
                return JavaEditor.getBidiLineSegments(document, lineOffset);
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        if (!this.isEditingScriptRunning() && this.fUpdater != null) {
            this.fUpdater.post();
        }
    }

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        IColorManager manager = textTools.getColorManager();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            RGB rgb = null;
            if (store.contains(LINE_NUMBER_COLOR)) {
                rgb = store.isDefault(LINE_NUMBER_COLOR) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)LINE_NUMBER_COLOR) : PreferenceConverter.getColor((IPreferenceStore)store, (String)LINE_NUMBER_COLOR);
            }
            rulerColumn.setForeground(manager.getColor(rgb));
            rgb = null;
            if (!store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") && store.contains("AbstractTextEditor.Color.Background")) {
                rgb = store.isDefault("AbstractTextEditor.Color.Background") ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background") : PreferenceConverter.getColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background");
            }
            rulerColumn.setBackground(manager.getColor(rgb));
            rulerColumn.redraw();
        }
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        this.fLineNumberRulerColumn = new LineNumberRulerColumn();
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fLineNumberRulerColumn;
    }

    protected IVerticalRuler createVerticalRuler() {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(12));
        if (this.isLineNumberRulerVisible()) {
            ruler.addDecorator(1, this.createLineNumberRulerColumn());
        }
        return ruler;
    }

    protected void updatePropertyDependentActions() {
        super.updatePropertyDependentActions();
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    private void updateHoverBehavior() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        String[] types = configuration.getConfiguredContentTypes(this.getSourceViewer());
        int i = 0;
        while (i < types.length) {
            String t = types[i];
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)sourceViewer).removeTextHovers(t);
                int[] stateMasks = configuration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), t);
                if (stateMasks != null) {
                    int j = 0;
                    while (j < stateMasks.length) {
                        int stateMask = stateMasks[j];
                        ITextHover textHover = configuration.getTextHover(sourceViewer, t, stateMask);
                        ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, stateMask);
                        ++j;
                    }
                } else {
                    ITextHover textHover = configuration.getTextHover(sourceViewer, t);
                    ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, 255);
                }
            } else {
                sourceViewer.setTextHover(configuration.getTextHover(sourceViewer, t), t);
            }
            ++i;
        }
    }

    public Object getViewPartInput() {
        IEditorInput iEditorInput = this.getEditorInput();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return iEditorInput.getAdapter((Class)clazz);
    }

    protected void doSetSelection(ISelection selection) {
        super.doSetSelection(selection);
        this.synchronizeOutlinePageSelection();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fSourceViewerDecorationSupport.install(this.getPreferenceStore());
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        preferences.addPropertyChangeListener(this.fPropertyChangeListener);
        IInformationControlCreator informationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                boolean cutDown = false;
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(parent, 16, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
        this.fInformationPresenter = new InformationPresenter(informationControlCreator);
        this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
        this.fInformationPresenter.install((ITextViewer)this.getSourceViewer());
    }

    protected void showOverviewRuler() {
        if (this.fOverviewRuler != null && this.getSourceViewer() instanceof ISourceViewerExtension) {
            ((ISourceViewerExtension)this.getSourceViewer()).showAnnotationsOverview(true);
            this.fSourceViewerDecorationSupport.updateOverviewDecorations();
        }
    }

    protected void hideOverviewRuler() {
        if (this.getSourceViewer() instanceof ISourceViewerExtension) {
            this.fSourceViewerDecorationSupport.hideAnnotationOverview();
            ((ISourceViewerExtension)this.getSourceViewer()).showAnnotationsOverview(false);
        }
    }

    protected boolean isOverviewRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(OVERVIEW_RULER);
    }

    protected void configureSourceViewerDecorationSupport() {
        this.fSourceViewerDecorationSupport.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.UNKNOWN, UNKNOWN_INDICATION_COLOR, UNKNOWN_INDICATION, UNKNOWN_INDICATION_IN_OVERVIEW_RULER, 0);
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.BOOKMARK, BOOKMARK_INDICATION_COLOR, BOOKMARK_INDICATION, BOOKMARK_INDICATION_IN_OVERVIEW_RULER, 1);
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.TASK, TASK_INDICATION_COLOR, TASK_INDICATION, TASK_INDICATION_IN_OVERVIEW_RULER, 2);
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.SEARCH, SEARCH_RESULT_INDICATION_COLOR, SEARCH_RESULT_INDICATION, SEARCH_RESULT_INDICATION_IN_OVERVIEW_RULER, 3);
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.WARNING, WARNING_INDICATION_COLOR, WARNING_INDICATION, WARNING_INDICATION_IN_OVERVIEW_RULER, 4);
        this.fSourceViewerDecorationSupport.setAnnotationPainterPreferenceKeys((Object)AnnotationType.ERROR, ERROR_INDICATION_COLOR, ERROR_INDICATION, ERROR_INDICATION_IN_OVERVIEW_RULER, 5);
        this.fSourceViewerDecorationSupport.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        this.fSourceViewerDecorationSupport.setMarginPainterPreferenceKeys(PRINT_MARGIN, PRINT_MARGIN_COLOR, PRINT_MARGIN_COLUMN);
        this.fSourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        this.fSourceViewerDecorationSupport.setSymbolicFontName(this.getFontPropertyPreferenceKey());
    }

    public void gotoMatchingBracket() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = JavaEditor.getSignedSelection((ITextViewer)sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage(JavaEditorMessages.getString("GotoMatchingBracket.error.invalidSelection"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (JavaEditor.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.fBracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage(JavaEditorMessages.getString("GotoMatchingBracket.error.noMatchingBracket"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.fBracketMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage(JavaEditorMessages.getString("GotoMatchingBracket.error.bracketOutsideSelectedElement"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    protected void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            statusLine.setMessage(true, msg, null);
        }
    }

    private static IRegion getSignedSelection(ITextViewer viewer) {
        int length;
        int offset;
        StyledText text = viewer.getTextWidget();
        int caretOffset = text.getCaretOffset();
        Point selection = text.getSelection();
        if (caretOffset == selection.x) {
            offset = selection.y;
            length = selection.x - selection.y;
        } else {
            offset = selection.x;
            length = selection.y - selection.x;
        }
        return new Region(offset, length);
    }

    private static boolean isBracket(char character) {
        int i = 0;
        while (i != BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return JavaEditor.isBracket(document.getChar(offset - 1)) && JavaEditor.isBracket(document.getChar(offset));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public void gotoError(boolean forward) {
        ISelectionProvider provider = this.getSelectionProvider();
        ITextSelection s = (ITextSelection)provider.getSelection();
        Position errorPosition = new Position(0, 0);
        IJavaAnnotation nextError = this.getNextError(s.getOffset(), forward, errorPosition);
        if (nextError != null) {
            IMarker marker = null;
            if (nextError instanceof MarkerAnnotation) {
                marker = ((MarkerAnnotation)nextError).getMarker();
            } else {
                Iterator e = nextError.getOverlaidIterator();
                if (e != null) {
                    while (e.hasNext()) {
                        Object o = e.next();
                        if (!(o instanceof MarkerAnnotation)) continue;
                        marker = ((MarkerAnnotation)o).getMarker();
                        break;
                    }
                }
            }
            if (marker != null) {
                IWorkbenchPage page = this.getSite().getPage();
                IViewPart view = page.findView("org.eclipse.ui.views.TaskList");
                if (view instanceof TaskList) {
                    StructuredSelection ss = new StructuredSelection((Object)marker);
                    ((TaskList)view).setSelection((ISelection)ss, true);
                }
            }
            this.selectAndReveal(errorPosition.getOffset(), errorPosition.getLength());
            this.setStatusLineErrorMessage(nextError.getMessage());
        } else {
            this.setStatusLineErrorMessage(null);
        }
    }

    private IJavaAnnotation getNextError(int offset, boolean forward, Position errorPosition) {
        IJavaAnnotation nextError = null;
        Position nextErrorPosition = null;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int endOfDocument = document.getLength();
        int distance = 0;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        JavaAnnotationIterator e = new JavaAnnotationIterator(model, false);
        while (e.hasNext()) {
            Position p;
            IJavaAnnotation a = (IJavaAnnotation)e.next();
            if (a.hasOverlay() || !a.isProblem() || (p = model.getPosition((Annotation)a)).includes(offset)) continue;
            int currentDistance = 0;
            if (forward) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument - offset + p.getOffset();
                }
            } else {
                currentDistance = offset - p.getOffset();
                if (currentDistance < 0) {
                    currentDistance = offset + endOfDocument - p.getOffset();
                }
            }
            if (nextError != null && currentDistance >= distance) continue;
            distance = currentDistance;
            nextError = a;
            nextErrorPosition = p;
        }
        if (nextErrorPosition != null) {
            errorPosition.setOffset(nextErrorPosition.getOffset());
            errorPosition.setLength(nextErrorPosition.getLength());
        }
        return nextError;
    }

    class OutlinePageSelectionUpdater
    implements Runnable {
        private boolean fPosted = false;

        public void run() {
            JavaEditor.this.synchronizeOutlinePageSelection();
            this.fPosted = false;
        }

        public void post() {
            if (this.fPosted) {
                return;
            }
            Shell shell = JavaEditor.this.getSite().getShell();
            if (shell != null & !shell.isDisposed()) {
                this.fPosted = true;
                shell.getDisplay().asyncExec((Runnable)this);
            }
        }
    }

    class SelectionChangedListener
    implements ISelectionChangedListener {
        SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            JavaEditor.this.doSelectionChanged(event);
        }
    }

    class MouseClickListener
    implements KeyListener,
    MouseListener,
    MouseMoveListener,
    FocusListener,
    PaintListener,
    IPropertyChangeListener,
    IDocumentListener,
    ITextInputListener {
        private boolean fActive;
        private IRegion fActiveRegion;
        private Position fRememberedPosition;
        private Cursor fCursor;
        private Color fColor;
        private int fKeyModifierMask;

        MouseClickListener() {
        }

        public void deactivate() {
            this.deactivate(false);
        }

        public void deactivate(boolean redrawAll) {
            if (!this.fActive) {
                return;
            }
            this.repairRepresentation(redrawAll);
            this.fActive = false;
        }

        public void install() {
            ISourceViewer sourceViewer = JavaEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            this.updateColor(sourceViewer);
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
            text.addKeyListener((KeyListener)this);
            text.addMouseListener((MouseListener)this);
            text.addMouseMoveListener((MouseMoveListener)this);
            text.addFocusListener((FocusListener)this);
            text.addPaintListener((PaintListener)this);
            this.updateKeyModifierMask();
            IPreferenceStore preferenceStore = JavaEditor.this.getPreferenceStore();
            preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }

        private void updateKeyModifierMask() {
            String modifiers = JavaEditor.this.getPreferenceStore().getString(JavaEditor.BROWSER_LIKE_LINKS_KEY_MODIFIER);
            this.fKeyModifierMask = this.computeStateMask(modifiers);
            if (this.fKeyModifierMask == -1) {
                this.fKeyModifierMask = JavaEditor.this.getPreferenceStore().getInt(JavaEditor.BROWSER_LIKE_LINKS_KEY_MODIFIER_MASK);
            }
        }

        private int computeStateMask(String modifiers) {
            if (modifiers == null) {
                return -1;
            }
            if (modifiers.length() == 0) {
                return 0;
            }
            int stateMask = 0;
            StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
            while (modifierTokenizer.hasMoreTokens()) {
                int modifier = EditorUtility.findLocalizedModifier(modifierTokenizer.nextToken());
                if (modifier == 0 || (stateMask & modifier) == modifier) {
                    return -1;
                }
                stateMask |= modifier;
            }
            return stateMask;
        }

        public void uninstall() {
            StyledText text;
            IPreferenceStore preferenceStore;
            ISourceViewer sourceViewer;
            if (this.fColor != null) {
                this.fColor.dispose();
                this.fColor = null;
            }
            if (this.fCursor != null) {
                this.fCursor.dispose();
                this.fCursor = null;
            }
            if ((sourceViewer = JavaEditor.this.getSourceViewer()) == null) {
                return;
            }
            sourceViewer.removeTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
            if ((preferenceStore = JavaEditor.this.getPreferenceStore()) != null) {
                preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            }
            if ((text = sourceViewer.getTextWidget()) == null || text.isDisposed()) {
                return;
            }
            text.removeKeyListener((KeyListener)this);
            text.removeMouseListener((MouseListener)this);
            text.removeMouseMoveListener((MouseMoveListener)this);
            text.removeFocusListener((FocusListener)this);
            text.removePaintListener((PaintListener)this);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(JavaEditor.LINK_COLOR)) {
                ISourceViewer viewer = JavaEditor.this.getSourceViewer();
                if (viewer != null) {
                    this.updateColor(viewer);
                }
            } else if (event.getProperty().equals(JavaEditor.BROWSER_LIKE_LINKS_KEY_MODIFIER)) {
                this.updateKeyModifierMask();
            }
        }

        private void updateColor(ISourceViewer viewer) {
            StyledText text;
            if (this.fColor != null) {
                this.fColor.dispose();
            }
            if ((text = viewer.getTextWidget()) == null || text.isDisposed()) {
                return;
            }
            Display display = text.getDisplay();
            this.fColor = this.createColor(JavaEditor.this.getPreferenceStore(), JavaEditor.LINK_COLOR, display);
        }

        private Color createColor(IPreferenceStore store, String key, Display display) {
            RGB rgb = null;
            if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
                return new Color((Device)display, rgb);
            }
            return null;
        }

        private void repairRepresentation() {
            this.repairRepresentation(false);
        }

        private void repairRepresentation(boolean redrawAll) {
            if (this.fActiveRegion == null) {
                return;
            }
            ISourceViewer viewer = JavaEditor.this.getSourceViewer();
            if (viewer != null) {
                this.resetCursor(viewer);
                int offset = this.fActiveRegion.getOffset();
                int length = this.fActiveRegion.getLength();
                if (!redrawAll && viewer instanceof ITextViewerExtension2) {
                    ((ITextViewerExtension2)viewer).invalidateTextPresentation(offset, length);
                } else {
                    viewer.invalidateTextPresentation();
                }
                if (viewer instanceof ITextViewerExtension3) {
                    ITextViewerExtension3 extension = (ITextViewerExtension3)viewer;
                    offset = extension.modelOffset2WidgetOffset(offset);
                } else {
                    offset -= viewer.getVisibleRegion().getOffset();
                }
                StyledText text = viewer.getTextWidget();
                try {
                    text.redrawRange(offset, length, true);
                }
                catch (IllegalArgumentException x) {
                    JavaPlugin.log(x);
                }
            }
            this.fActiveRegion = null;
        }

        private IRegion selectWord(IDocument document, int anchor) {
            try {
                char c;
                int offset = anchor;
                while (offset >= 0) {
                    c = document.getChar(offset);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    --offset;
                }
                int start = offset;
                offset = anchor;
                int length = document.getLength();
                while (offset < length) {
                    c = document.getChar(offset);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    ++offset;
                }
                int end = offset;
                if (start == end) {
                    return new Region(start, 0);
                }
                return new Region(start + 1, end - start - 1);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        IRegion getCurrentTextRegion(ISourceViewer viewer) {
            int offset = this.getCurrentTextOffset(viewer);
            if (offset == -1) {
                return null;
            }
            IJavaElement input = SelectionConverter.getInput(JavaEditor.this);
            if (input == null) {
                return null;
            }
            try {
                IJavaElement[] elements = null;
                IJavaElement iJavaElement = input;
                synchronized (iJavaElement) {
                    elements = ((ICodeAssist)input).codeSelect(offset, 0);
                }
                if (elements == null || elements.length == 0) {
                    return null;
                }
                return this.selectWord(viewer.getDocument(), offset);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }

        private int getCurrentTextOffset(ISourceViewer viewer) {
            try {
                StyledText text = viewer.getTextWidget();
                if (text == null || text.isDisposed()) {
                    return -1;
                }
                Display display = text.getDisplay();
                Point absolutePosition = display.getCursorLocation();
                Point relativePosition = text.toControl(absolutePosition);
                int widgetOffset = text.getOffsetAtLocation(relativePosition);
                if (viewer instanceof ITextViewerExtension3) {
                    ITextViewerExtension3 extension = (ITextViewerExtension3)viewer;
                    return extension.widgetOffset2ModelOffset(widgetOffset);
                }
                return widgetOffset + viewer.getVisibleRegion().getOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }

        private void highlightRegion(ISourceViewer viewer, IRegion region) {
            if (region.equals(this.fActiveRegion)) {
                return;
            }
            this.repairRepresentation();
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            int offset = 0;
            int length = 0;
            if (viewer instanceof ITextViewerExtension3) {
                ITextViewerExtension3 extension = (ITextViewerExtension3)viewer;
                IRegion widgetRange = extension.modelRange2WidgetRange(region);
                if (widgetRange == null) {
                    return;
                }
                offset = widgetRange.getOffset();
                length = widgetRange.getLength();
            } else {
                offset = region.getOffset() - viewer.getVisibleRegion().getOffset();
                length = region.getLength();
            }
            StyleRange oldStyleRange = text.getStyleRangeAtOffset(offset);
            Color foregroundColor = this.fColor;
            Color backgroundColor = oldStyleRange == null ? text.getBackground() : oldStyleRange.background;
            StyleRange styleRange = new StyleRange(offset, length, foregroundColor, backgroundColor);
            text.setStyleRange(styleRange);
            text.redrawRange(offset, length, true);
            this.fActiveRegion = region;
        }

        private void activateCursor(ISourceViewer viewer) {
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            Display display = text.getDisplay();
            if (this.fCursor == null) {
                this.fCursor = new Cursor((Device)display, 21);
            }
            text.setCursor(this.fCursor);
        }

        private void resetCursor(ISourceViewer viewer) {
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                text.setCursor(null);
            }
            if (this.fCursor != null) {
                this.fCursor.dispose();
                this.fCursor = null;
            }
        }

        public void keyPressed(KeyEvent event) {
            if (this.fActive) {
                this.deactivate();
                return;
            }
            if (event.keyCode != this.fKeyModifierMask) {
                this.deactivate();
                return;
            }
            this.fActive = true;
        }

        public void keyReleased(KeyEvent event) {
            if (!this.fActive) {
                return;
            }
            this.deactivate();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent event) {
            if (!this.fActive) {
                return;
            }
            if (event.stateMask != this.fKeyModifierMask) {
                this.deactivate();
                return;
            }
            if (event.button != 1) {
                this.deactivate();
                return;
            }
        }

        public void mouseUp(MouseEvent e) {
            IAction action;
            if (!this.fActive) {
                return;
            }
            if (e.button != 1) {
                this.deactivate();
                return;
            }
            boolean wasActive = this.fCursor != null;
            this.deactivate();
            if (wasActive && (action = JavaEditor.this.getAction("OpenEditor")) != null) {
                action.run();
            }
        }

        public void mouseMove(MouseEvent event) {
            ISourceViewer viewer;
            if (event.widget instanceof Control && !((Control)event.widget).isFocusControl()) {
                this.deactivate();
                return;
            }
            if (!this.fActive) {
                if (event.stateMask != this.fKeyModifierMask) {
                    return;
                }
                this.fActive = true;
            }
            if ((viewer = JavaEditor.this.getSourceViewer()) == null) {
                this.deactivate();
                return;
            }
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                this.deactivate();
                return;
            }
            if ((event.stateMask & 0x80000) != 0 && text.getSelectionCount() != 0) {
                this.deactivate();
                return;
            }
            IRegion region = this.getCurrentTextRegion(viewer);
            if (region == null || region.getLength() == 0) {
                this.repairRepresentation();
                return;
            }
            this.highlightRegion(viewer, region);
            this.activateCursor(viewer);
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            this.deactivate();
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (this.fActive && this.fActiveRegion != null) {
                this.fRememberedPosition = new Position(this.fActiveRegion.getOffset(), this.fActiveRegion.getLength());
                try {
                    event.getDocument().addPosition(this.fRememberedPosition);
                }
                catch (BadLocationException badLocationException) {
                    this.fRememberedPosition = null;
                }
            }
        }

        public void documentChanged(DocumentEvent event) {
            StyledText widget;
            if (this.fRememberedPosition != null && !this.fRememberedPosition.isDeleted()) {
                event.getDocument().removePosition(this.fRememberedPosition);
                this.fActiveRegion = new Region(this.fRememberedPosition.getOffset(), this.fRememberedPosition.getLength());
            }
            this.fRememberedPosition = null;
            ISourceViewer viewer = JavaEditor.this.getSourceViewer();
            if (viewer != null && (widget = viewer.getTextWidget()) != null && !widget.isDisposed()) {
                widget.getDisplay().asyncExec(new Runnable(this){
                    private final /* synthetic */ MouseClickListener this$1;
                    {
                        this.this$1 = mouseClickListener;
                    }

                    public void run() {
                        this.this$1.deactivate();
                    }
                });
            }
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            this.deactivate();
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }

        public void paintControl(PaintEvent event) {
            if (this.fActiveRegion == null) {
                return;
            }
            ISourceViewer viewer = JavaEditor.this.getSourceViewer();
            if (viewer == null) {
                return;
            }
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            int offset = 0;
            int length = 0;
            if (viewer instanceof ITextViewerExtension3) {
                ITextViewerExtension3 extension = (ITextViewerExtension3)viewer;
                IRegion widgetRange = extension.modelRange2WidgetRange((IRegion)new Region(offset, length));
                if (widgetRange == null) {
                    return;
                }
                offset = widgetRange.getOffset();
                length = widgetRange.getLength();
            } else {
                IRegion region = viewer.getVisibleRegion();
                if (!this.includes(region, this.fActiveRegion)) {
                    return;
                }
                offset = this.fActiveRegion.getOffset() - region.getOffset();
                length = this.fActiveRegion.getLength();
            }
            Point minLocation = this.getMinimumLocation(text, offset, length);
            Point maxLocation = this.getMaximumLocation(text, offset, length);
            int x1 = minLocation.x;
            int x2 = minLocation.x + maxLocation.x - minLocation.x - 1;
            int y = minLocation.y + text.getLineHeight() - 1;
            GC gc = event.gc;
            if (this.fColor != null && !this.fColor.isDisposed()) {
                gc.setForeground(this.fColor);
            }
            gc.drawLine(x1, y, x2, y);
        }

        private boolean includes(IRegion region, IRegion position) {
            return position.getOffset() >= region.getOffset() && position.getOffset() + position.getLength() <= region.getOffset() + region.getLength();
        }

        private Point getMinimumLocation(StyledText text, int offset, int length) {
            Point minLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
            int i = 0;
            while (i <= length) {
                Point location = text.getLocationAtOffset(offset + i);
                if (location.x < minLocation.x) {
                    minLocation.x = location.x;
                }
                if (location.y < minLocation.y) {
                    minLocation.y = location.y;
                }
                ++i;
            }
            return minLocation;
        }

        private Point getMaximumLocation(StyledText text, int offset, int length) {
            Point maxLocation = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
            int i = 0;
            while (i <= length) {
                Point location = text.getLocationAtOffset(offset + i);
                if (location.x > maxLocation.x) {
                    maxLocation.x = location.x;
                }
                if (location.y > maxLocation.y) {
                    maxLocation.y = location.y;
                }
                ++i;
            }
            return maxLocation;
        }
    }

    class InformationDispatchAction
    extends TextEditorAction {
        private final TextOperationAction fTextOperationAction;

        public InformationDispatchAction(ResourceBundle resourceBundle, String prefix, TextOperationAction textOperationAction) {
            super(resourceBundle, prefix, (ITextEditor)JavaEditor.this);
            if (textOperationAction == null) {
                throw new IllegalArgumentException();
            }
            this.fTextOperationAction = textOperationAction;
        }

        public void run() {
            ISourceViewer sourceViewer = JavaEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                this.fTextOperationAction.run();
                return;
            }
            if (!(sourceViewer instanceof ITextViewerExtension2)) {
                this.fTextOperationAction.run();
                return;
            }
            ITextViewerExtension2 textViewerExtension2 = (ITextViewerExtension2)sourceViewer;
            ITextHover textHover = textViewerExtension2.getCurrentTextHover();
            if (textHover == null) {
                this.fTextOperationAction.run();
                return;
            }
            Point hoverEventLocation = textViewerExtension2.getHoverEventLocation();
            int offset = this.computeOffsetAtLocation((ITextViewer)sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
            if (offset == -1) {
                this.fTextOperationAction.run();
                return;
            }
            try {
                IDocument document = sourceViewer.getDocument();
                String contentType = document.getContentType(offset);
                IRegion hoverRegion = textHover.getHoverRegion((ITextViewer)sourceViewer, offset);
                if (hoverRegion == null) {
                    return;
                }
                String hoverInfo = textHover.getHoverInfo((ITextViewer)sourceViewer, hoverRegion);
                IInformationProvider informationProvider = new IInformationProvider(hoverRegion, hoverInfo){
                    private final /* synthetic */ IRegion val$hoverRegion;
                    private final /* synthetic */ String val$hoverInfo;
                    {
                        this.val$hoverRegion = iRegion;
                        this.val$hoverInfo = string;
                    }

                    public IRegion getSubject(ITextViewer textViewer, int offset) {
                        return this.val$hoverRegion;
                    }

                    public String getInformation(ITextViewer textViewer, IRegion subject) {
                        return this.val$hoverInfo;
                    }
                };
                JavaEditor.this.fInformationPresenter.setOffset(offset);
                JavaEditor.this.fInformationPresenter.setInformationProvider(informationProvider, contentType);
                JavaEditor.this.fInformationPresenter.showInformation();
            }
            catch (BadLocationException badLocationException) {}
        }

        private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y) {
            StyledText styledText = textViewer.getTextWidget();
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return -1;
            }
            try {
                int widgetLocation = styledText.getOffsetAtLocation(new Point(x, y));
                if (textViewer instanceof ITextViewerExtension3) {
                    ITextViewerExtension3 extension = (ITextViewerExtension3)textViewer;
                    return extension.widgetOffset2ModelOffset(widgetLocation);
                }
                IRegion visibleRegion = textViewer.getVisibleRegion();
                return widgetLocation + visibleRegion.getOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }
    }

    protected static class AnnotationAccess
    implements IAnnotationAccess {
        protected AnnotationAccess() {
        }

        public Object getType(Annotation annotation) {
            IJavaAnnotation javaAnnotation;
            if (annotation instanceof IJavaAnnotation && (javaAnnotation = (IJavaAnnotation)annotation).isRelevant()) {
                return javaAnnotation.getAnnotationType();
            }
            return null;
        }

        public boolean isMultiLine(Annotation annotation) {
            return true;
        }

        public boolean isTemporary(Annotation annotation) {
            IJavaAnnotation javaAnnotation;
            if (annotation instanceof IJavaAnnotation && (javaAnnotation = (IJavaAnnotation)annotation).isRelevant()) {
                return javaAnnotation.isTemporary();
            }
            return false;
        }
    }

    private class PropertyChangeListener
    implements Preferences.IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            JavaEditor.this.handlePreferencePropertyChanged(event);
        }
    }
}

