/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorPresentation;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.WorkbenchPage;

public class EditorWorkbookLinkManager {
    private IEditorPart fSourceEditor;

    public EditorWorkbookLinkManager(IEditorPart editor) {
        this.fSourceEditor = editor;
    }

    public void openInLinkedEditor(IJavaElement element) {
        if (this.fSourceEditor != null) {
            IWorkbenchPartSite site = this.fSourceEditor.getSite();
            WorkbenchPage page = (WorkbenchPage)site.getPage();
            if (!this.isEditorActive((IWorkbenchSite)site)) {
                return;
            }
            IEditorInput input = null;
            try {
                input = EditorUtility.getEditorInput((Object)element);
            }
            catch (JavaModelException javaModelException) {}
            EditorPresentation presentation = page.getEditorPresentation();
            EditorArea area = (EditorArea)presentation.getLayoutPart();
            EditorWorkbook linkedWorkbook = this.findLinkedWorkbook(area);
            if (input == null || linkedWorkbook == null) {
                return;
            }
            JavaEditor editor = this.findOpenEditor(this.fSourceEditor, input, linkedWorkbook);
            if (editor == null) {
                editor = this.findReusableEditor(this.fSourceEditor, input, linkedWorkbook);
            }
            if (editor != null) {
                this.openTargetEditor(element, input, editor);
                return;
            }
            this.openNewTargetEditor(linkedWorkbook, element, input);
        }
    }

    private void openNewTargetEditor(EditorWorkbook workbook, IJavaElement element, IEditorInput input) {
        IWorkbenchPartSite site = this.fSourceEditor.getSite();
        WorkbenchPage page = (WorkbenchPage)site.getPage();
        EditorPresentation presentation = page.getEditorPresentation();
        EditorArea area = (EditorArea)presentation.getLayoutPart();
        IEditorPart editor = null;
        try {
            area.setActiveWorkbook(workbook, false);
            editor = EditorUtility.openInEditor(element, true);
        }
        catch (PartInitException partInitException) {
        }
        catch (JavaModelException javaModelException) {}
        if (editor != null) {
            this.revealElement(element, (IWorkbenchPage)page, editor);
        }
    }

    void revealElement(IJavaElement element, IWorkbenchPage page, IEditorPart editor) {
        EditorUtility.revealInEditor(editor, element);
        page.bringToTop((IWorkbenchPart)editor);
        page.activate((IWorkbenchPart)this.fSourceEditor);
    }

    private boolean isEditorActive(IWorkbenchSite site) {
        IWorkbenchWindow window = site.getWorkbenchWindow();
        IPartService service = window.getPartService();
        return service.getActivePart() == this.fSourceEditor;
    }

    private EditorWorkbook findLinkedWorkbook(EditorArea area) {
        ArrayList list = area.getEditorWorkbooks();
        EditorWorkbook activeWorkbook = area.getActiveWorkbook();
        Iterator iter = ((AbstractList)list).iterator();
        while (iter.hasNext()) {
            EditorWorkbook workbook = (EditorWorkbook)iter.next();
            if (workbook == activeWorkbook) continue;
            return workbook;
        }
        return null;
    }

    private JavaEditor findReusableEditor(IEditorPart activeEditor, IEditorInput input, EditorWorkbook linkedWorkbook) {
        LayoutPart[] panes = linkedWorkbook.getChildren();
        int i = 0;
        while (i < panes.length) {
            EditorPane pane = (EditorPane)panes[i];
            IEditorReference reference = pane.getEditorReference();
            IEditorPart part = (IEditorPart)reference.getPart(false);
            if (part == null) {
                this.activateEditorPart(reference);
                part = (IEditorPart)reference.getPart(false);
            }
            if (part != activeEditor && (!part.isDirty() || activeEditor.getEditorInput().equals(part.getEditorInput()))) {
                if (input instanceof IClassFileEditorInput && part instanceof ClassFileEditor) {
                    return (JavaEditor)part;
                }
                if (input instanceof IFileEditorInput && part instanceof CompilationUnitEditor) {
                    return (JavaEditor)part;
                }
            }
            ++i;
        }
        return null;
    }

    private JavaEditor findOpenEditor(IEditorPart activeEditor, IEditorInput input, EditorWorkbook linkedWorkbook) {
        LayoutPart[] panes = linkedWorkbook.getChildren();
        int i = 0;
        while (i < panes.length) {
            EditorPane pane = (EditorPane)panes[i];
            IEditorReference reference = pane.getEditorReference();
            IEditorPart part = (IEditorPart)reference.getPart(false);
            if (part == null) {
                this.activateEditorPart(reference);
                part = (IEditorPart)reference.getPart(false);
            }
            if (part != activeEditor && part instanceof JavaEditor && part.getEditorInput().equals(input)) {
                return (JavaEditor)part;
            }
            ++i;
        }
        return null;
    }

    private void activateEditorPart(IEditorReference reference) {
        reference.getPart(true);
    }

    private void openTargetEditor(IJavaElement curr, IEditorInput input, JavaEditor javaEditor) {
        IWorkbenchPartSite site = this.fSourceEditor.getSite();
        IWorkbenchPage page = site.getPage();
        if (!javaEditor.getEditorInput().equals(input)) {
            javaEditor.setInput(input);
        }
        this.revealElement(curr, page, (IEditorPart)javaEditor);
    }
}

