/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.compare.LocalHistoryActionGroup;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.ISavePolicy;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorErrorTickUpdater;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaOutlinePage;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.text.ContentAssistPreference;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionAssistant;
import org.eclipse.jdt.internal.ui.text.java.IReconcilingParticipant;
import org.eclipse.jdt.internal.ui.text.java.SmartBracesAutoEditStrategy;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionManager;
import org.eclipse.jdt.internal.ui.text.link.LinkedPositionUI;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class CompilationUnitEditor
extends JavaEditor
implements IReconcilingParticipant {
    public static final int CORRECTIONASSIST_PROPOSALS = 50;
    private static final String CODE_FORMATTER_TAB_SIZE = "org.eclipse.jdt.core.formatter.tabulation.size";
    private static final String SPACES_FOR_TABS = "spacesForTabs";
    private static final String CLOSE_STRINGS = "closeStrings";
    private static final String CLOSE_BRACKETS = "closeBrackets";
    protected ISavePolicy fSavePolicy;
    private JavaEditorErrorTickUpdater fJavaEditorErrorTickUpdater;
    private TabConverter fTabConverter;
    private IJavaElement fRememberedElement;
    private ITextSelection fRememberedSelection;
    private int fRememberedElementOffset;
    private BracketInserter fBracketInserter = new BracketInserter();
    private GenerateActionGroup fGenerateActionGroup;
    private CompositeActionGroup fContextMenuGroup;

    public CompilationUnitEditor() {
        this.setDocumentProvider((IDocumentProvider)JavaPlugin.getDefault().getCompilationUnitDocumentProvider());
        this.setEditorContextMenuId("#CompilationUnitEditorContext");
        this.setRulerContextMenuId("#CompilationUnitRulerContext");
        this.setOutlinerContextMenuId("#CompilationUnitOutlinerContext");
        this.fSavePolicy = null;
        this.fJavaEditorErrorTickUpdater = new JavaEditorErrorTickUpdater(this);
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction action = new TextOperationAction(JavaEditorMessages.getResourceBundle(), "CorrectionAssistProposal.", (ITextEditor)this, 50);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        this.setAction("CorrectionAssistProposal", (IAction)action);
        this.markAsStateDependentAction("CorrectionAssistProposal", true);
        WorkbenchHelp.setHelp((IAction)action, (String)"org.eclipse.jdt.ui.quick_fix_action");
        action = new ContentAssistAction(JavaEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        WorkbenchHelp.setHelp((IAction)action, (String)"org.eclipse.jdt.ui.content_assist_action");
        action = new TextOperationAction(JavaEditorMessages.getResourceBundle(), "ContentAssistContextInformation.", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistContextInformation", (IAction)action);
        this.markAsStateDependentAction("ContentAssistContextInformation", true);
        WorkbenchHelp.setHelp((IAction)action, (String)"org.eclipse.jdt.ui.parameter_hints_action");
        action = new TextOperationAction(JavaEditorMessages.getResourceBundle(), "Comment.", (ITextEditor)this, 11);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.comment");
        this.setAction("Comment", (IAction)action);
        this.markAsStateDependentAction("Comment", true);
        WorkbenchHelp.setHelp((IAction)action, (String)"org.eclipse.jdt.ui.comment_action");
        action = new TextOperationAction(JavaEditorMessages.getResourceBundle(), "Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.uncomment");
        this.setAction("Uncomment", (IAction)action);
        this.markAsStateDependentAction("Uncomment", true);
        WorkbenchHelp.setHelp((IAction)action, (String)"org.eclipse.jdt.ui.uncomment_action");
        action = new TextOperationAction(JavaEditorMessages.getResourceBundle(), "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.format");
        this.setAction("Format", (IAction)action);
        this.markAsStateDependentAction("Format", true);
        this.markAsSelectionDependentAction("Format", true);
        WorkbenchHelp.setHelp((IAction)action, (String)"org.eclipse.jdt.ui.format_action");
        this.fGenerateActionGroup = new GenerateActionGroup(this, "group.edit");
        RefactorActionGroup rg = new RefactorActionGroup(this, "group.edit");
        this.fActionGroups.addGroup(rg);
        this.fActionGroups.addGroup(this.fGenerateActionGroup);
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{this.fGenerateActionGroup, rg, new LocalHistoryActionGroup(this, "group.edit")});
    }

    protected IJavaElement getElementAt(int offset) {
        return this.getElementAt(offset, true);
    }

    protected IJavaElement getElementAt(int offset, boolean reconcile) {
        IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit unit = manager.getWorkingCopy(this.getEditorInput());
        if (unit != null) {
            try {
                if (reconcile) {
                    ICompilationUnit iCompilationUnit = unit;
                    synchronized (iCompilationUnit) {
                        unit.reconcile();
                    }
                    return unit.getElementAt(offset);
                }
                if (unit.isConsistent()) {
                    return unit.getElementAt(offset);
                }
            }
            catch (JavaModelException x) {
                JavaPlugin.log(x.getStatus());
            }
        }
        return null;
    }

    protected IJavaElement getCorrespondingElement(IJavaElement element) {
        try {
            return EditorUtility.getWorkingCopy(element, true);
        }
        catch (JavaModelException x) {
            JavaPlugin.log(x.getStatus());
            return null;
        }
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fContextMenuGroup.setContext(context);
        this.fContextMenuGroup.fillContextMenu(menu);
        this.fContextMenuGroup.setContext(null);
    }

    protected void setOutlinePageInput(JavaOutlinePage page, IEditorInput input) {
        if (page != null) {
            IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            page.setInput((IJavaElement)manager.getWorkingCopy(input));
        }
    }

    protected void performSaveOperation(WorkspaceModifyOperation operation, IProgressMonitor progressMonitor) {
        block4: {
            Object var4_4;
            IDocumentProvider p = this.getDocumentProvider();
            if (p instanceof CompilationUnitDocumentProvider) {
                CompilationUnitDocumentProvider cp = (CompilationUnitDocumentProvider)p;
                cp.setSavePolicy(this.fSavePolicy);
            }
            try {
                super.performSaveOperation(operation, progressMonitor);
            }
            catch (Throwable throwable) {
                var4_4 = null;
                if (p instanceof CompilationUnitDocumentProvider) {
                    CompilationUnitDocumentProvider cp = (CompilationUnitDocumentProvider)p;
                    cp.setSavePolicy(null);
                }
                throw throwable;
            }
            var4_4 = null;
            if (!(p instanceof CompilationUnitDocumentProvider)) break block4;
            CompilationUnitDocumentProvider cp = (CompilationUnitDocumentProvider)p;
            cp.setSavePolicy(null);
        }
    }

    public void doSaveAs() {
        if (this.askIfNonWorkbenchEncodingIsOk()) {
            super.doSaveAs();
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (!this.askIfNonWorkbenchEncodingIsOk()) {
            progressMonitor.setCanceled(true);
            return;
        }
        if (p.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                MessageDialog.openError((Shell)shell, (String)JavaEditorMessages.getString("CompilationUnitEditor.error.saving.title1"), (String)JavaEditorMessages.getString("CompilationUnitEditor.error.saving.message1"));
            }
        } else {
            this.setStatusLineErrorMessage(null);
            IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            ICompilationUnit unit = manager.getWorkingCopy(this.getEditorInput());
            if (unit != null) {
                ICompilationUnit iCompilationUnit = unit;
                synchronized (iCompilationUnit) {
                    this.performSaveOperation(this.createSaveOperation(false), progressMonitor);
                }
            } else {
                this.performSaveOperation(this.createSaveOperation(false), progressMonitor);
            }
        }
    }

    private boolean askIfNonWorkbenchEncodingIsOk() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IStorageDocumentProvider) {
            IEditorInput input = this.getEditorInput();
            IStorageDocumentProvider storageProvider = (IStorageDocumentProvider)provider;
            String encoding = storageProvider.getEncoding((Object)input);
            String defaultEncoding = storageProvider.getDefaultEncoding();
            if (encoding != null && !encoding.equals(defaultEncoding)) {
                Shell shell = this.getSite().getShell();
                String title = JavaEditorMessages.getString("CompilationUnitEditor.warning.save.nonWorkbenchEncoding.title");
                String msg = input != null ? MessageFormat.format(JavaEditorMessages.getString("CompilationUnitEditor.warning.save.nonWorkbenchEncoding.message1"), input.getName(), encoding) : MessageFormat.format(JavaEditorMessages.getString("CompilationUnitEditor.warning.save.nonWorkbenchEncoding.message2"), encoding);
                return MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg);
            }
        }
        return true;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        FileEditorInput newInput;
        IDocumentProvider provider;
        block16: {
            IFile original;
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
            if (original != null) {
                dialog.setOriginalFile(original);
            }
            dialog.create();
            provider = this.getDocumentProvider();
            if (provider == null) {
                return;
            }
            if (provider.isDeleted((Object)input) && original != null) {
                String message = JavaEditorMessages.getFormattedString("CompilationUnitEditor.warning.save.delete", new Object[]{original.getName()});
                dialog.setErrorMessage(null);
                dialog.setMessage(message, 2);
            }
            if (dialog.open() == 1) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(filePath);
            newInput = new FileEditorInput(file);
            WorkspaceModifyOperation op = new WorkspaceModifyOperation((IEditorInput)newInput){
                private final /* synthetic */ IEditorInput val$newInput;
                {
                    this.val$newInput = iEditorInput;
                }

                public void execute(IProgressMonitor monitor) throws CoreException {
                    CompilationUnitEditor.this.getDocumentProvider().saveDocument(monitor, (Object)this.val$newInput, CompilationUnitEditor.this.getDocumentProvider().getDocument((Object)CompilationUnitEditor.this.getEditorInput()), true);
                }
            };
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
                    success = true;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException x) {
                    Throwable t = x.getTargetException();
                    if (t instanceof CoreException) {
                        CoreException cx = (CoreException)t;
                        ErrorDialog.openError((Shell)shell, (String)JavaEditorMessages.getString("CompilationUnitEditor.error.saving.title2"), (String)JavaEditorMessages.getString("CompilationUnitEditor.error.saving.message2"), (IStatus)cx.getStatus());
                        break block16;
                    }
                    MessageDialog.openError((Shell)shell, (String)JavaEditorMessages.getString("CompilationUnitEditor.error.saving.title3"), (String)(String.valueOf(JavaEditorMessages.getString("CompilationUnitEditor.error.saving.message3")) + t.getMessage()));
                }
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                provider.changed((Object)newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
                throw throwable;
            }
        }
        Object var16_18 = null;
        provider.changed((Object)newInput);
        if (success) {
            this.setInput((IEditorInput)newInput);
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.configureTabConverter();
    }

    private void configureTabConverter() {
        IDocumentProvider provider;
        if (this.fTabConverter != null && (provider = this.getDocumentProvider()) instanceof CompilationUnitDocumentProvider) {
            CompilationUnitDocumentProvider cup = (CompilationUnitDocumentProvider)provider;
            this.fTabConverter.setLineTracker(cup.createLineTracker(this.getEditorInput()));
        }
    }

    private int getTabSize() {
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        return preferences.getInt(CODE_FORMATTER_TAB_SIZE);
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.configureTabConverter();
            this.fTabConverter.setNumberOfSpacesPerTab(this.getTabSize());
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            asv.addTextConverter(this.fTabConverter);
            asv.updateIndentationPrefixes();
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            asv.removeTextConverter(this.fTabConverter);
            asv.updateIndentationPrefixes();
            this.fTabConverter = null;
        }
    }

    private boolean isTabConversionEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(SPACES_FOR_TABS);
    }

    public void dispose() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        if (this.fJavaEditorErrorTickUpdater != null) {
            this.fJavaEditorErrorTickUpdater.dispose();
            this.fJavaEditorErrorTickUpdater = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
            this.fActionGroups = null;
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        boolean closeBrackets = preferenceStore.getBoolean(CLOSE_BRACKETS);
        boolean closeStrings = preferenceStore.getBoolean(CLOSE_STRINGS);
        this.fBracketInserter.setCloseBracketsEnabled(closeBrackets);
        this.fBracketInserter.setCloseStringsEnabled(closeStrings);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        block8: {
            block10: {
                block9: {
                    try {
                        AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
                        if (asv == null) break block8;
                        String p = event.getProperty();
                        if (CLOSE_BRACKETS.equals(p)) {
                            this.fBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(p));
                            Object var5_4 = null;
                            super.handlePreferenceStoreChanged(event);
                            return;
                        }
                        if (CLOSE_STRINGS.equals(p)) {
                            this.fBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(p));
                            break block9;
                        }
                        if (SPACES_FOR_TABS.equals(p)) {
                            if (this.isTabConversionEnabled()) {
                                this.startTabConversion();
                                break block10;
                            } else {
                                this.stopTabConversion();
                            }
                            break block10;
                        }
                        IContentAssistant c = asv.getContentAssistant();
                        if (c instanceof ContentAssistant) {
                            ContentAssistPreference.changeConfiguration((ContentAssistant)c, this.getPreferenceStore(), event);
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        super.handlePreferenceStoreChanged(event);
                        throw throwable;
                    }
                }
                Object var5_5 = null;
                super.handlePreferenceStoreChanged(event);
                return;
            }
            Object var5_6 = null;
            super.handlePreferenceStoreChanged(event);
            return;
        }
        Object var5_8 = null;
        super.handlePreferenceStoreChanged(event);
    }

    protected void handlePreferencePropertyChanged(Preferences.PropertyChangeEvent event) {
        String p;
        AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
        if (asv != null && CODE_FORMATTER_TAB_SIZE.equals(p = event.getProperty())) {
            asv.updateIndentationPrefixes();
            if (this.fTabConverter != null) {
                this.fTabConverter.setNumberOfSpacesPerTab(this.getTabSize());
            }
        }
        super.handlePreferencePropertyChanged(event);
    }

    protected ISourceViewer createJavaSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles) {
        return new AdaptedSourceViewer(parent, verticalRuler, overviewRuler, isOverviewRulerVisible, styles);
    }

    public void synchronizeOutlinePageSelection() {
        if (this.isEditingScriptRunning()) {
            return;
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null || this.fOutlinePage == null) {
            return;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        int modelCaret = 0;
        if (sourceViewer instanceof ITextViewerExtension3) {
            ITextViewerExtension3 extension = (ITextViewerExtension3)sourceViewer;
            modelCaret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            modelCaret = offset + styledText.getCaretOffset();
        }
        IJavaElement element = this.getElementAt(modelCaret, false);
        ISourceReference reference = this.getSourceReference(element, modelCaret);
        if (reference != null) {
            this.fOutlinePage.removeSelectionChangedListener(this.fSelectionChangedListener);
            this.fOutlinePage.select(reference);
            this.fOutlinePage.addSelectionChangedListener(this.fSelectionChangedListener);
        }
    }

    private ISourceReference getSourceReference(IJavaElement element, int offset) {
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        if (element.getElementType() == 13) {
            IImportDeclaration declaration = (IImportDeclaration)element;
            IImportContainer container = (IImportContainer)declaration.getParent();
            ISourceRange srcRange = null;
            try {
                srcRange = container.getSourceRange();
            }
            catch (JavaModelException javaModelException) {}
            if (srcRange != null && srcRange.getOffset() == offset) {
                return container;
            }
        }
        return (ISourceReference)element;
    }

    public void reconciled() {
        Shell shell;
        if (this.synchronizeOutlineOnCursorMove() && (shell = this.getSite().getShell()) != null && !shell.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CompilationUnitEditor.this.synchronizeOutlinePageSelection();
                }
            });
        }
    }

    private boolean synchronizeOutlineOnCursorMove() {
        return PreferenceConstants.getPreferenceStore().getBoolean("JavaEditor.SyncOutlineOnCursorMove");
    }

    protected void updateStateDependentActions() {
        super.updateStateDependentActions();
        this.fGenerateActionGroup.editorStateChanged();
    }

    private IJavaElement findElement(IJavaElement element) {
        if (element == null) {
            return null;
        }
        IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit unit = manager.getWorkingCopy(this.getEditorInput());
        if (unit != null) {
            try {
                ICompilationUnit iCompilationUnit = unit;
                synchronized (iCompilationUnit) {
                    unit.reconcile();
                }
                IJavaElement[] findings = unit.findElements(element);
                if (findings != null && findings.length > 0) {
                    return findings[0];
                }
            }
            catch (JavaModelException x) {
                JavaPlugin.log(x.getStatus());
            }
        }
        return null;
    }

    private int getOffset(IJavaElement element) {
        if (element instanceof ISourceReference) {
            ISourceReference sr = (ISourceReference)element;
            try {
                ISourceRange srcRange = sr.getSourceRange();
                if (srcRange != null) {
                    return srcRange.getOffset();
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return -1;
    }

    protected void rememberSelection() {
        ISelectionProvider sp = this.getSelectionProvider();
        ITextSelection iTextSelection = this.fRememberedSelection = sp == null ? null : (ITextSelection)sp.getSelection();
        if (this.fRememberedSelection != null) {
            this.fRememberedElement = this.getElementAt(this.fRememberedSelection.getOffset(), true);
            this.fRememberedElementOffset = this.getOffset(this.fRememberedElement);
        }
    }

    protected void restoreSelection() {
        try {
            int delta;
            block8: {
                block7: {
                    if (this.getSourceViewer() == null) break block7;
                    if (this.fRememberedSelection != null) break block8;
                }
                Object var4_1 = null;
                this.fRememberedSelection = null;
                this.fRememberedElement = null;
                this.fRememberedElementOffset = -1;
                return;
            }
            IJavaElement newElement = this.findElement(this.fRememberedElement);
            int newOffset = this.getOffset(newElement);
            int n = delta = newOffset > -1 && this.fRememberedElementOffset > -1 ? newOffset - this.fRememberedElementOffset : 0;
            if (this.isValidSelection(delta + this.fRememberedSelection.getOffset(), this.fRememberedSelection.getLength())) {
                this.selectAndReveal(delta + this.fRememberedSelection.getOffset(), this.fRememberedSelection.getLength());
            }
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.fRememberedSelection = null;
            this.fRememberedElement = null;
            this.fRememberedElementOffset = -1;
            throw throwable;
        }
        Object var4_3 = null;
        this.fRememberedSelection = null;
        this.fRememberedElement = null;
        this.fRememberedElementOffset = -1;
    }

    private boolean isValidSelection(int offset, int length) {
        IDocument document;
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null && (document = provider.getDocument((Object)this.getEditorInput())) != null) {
            int end = offset + length;
            int documentLength = document.getLength();
            return offset >= 0 && offset <= documentLength && end >= 0 && end <= documentLength;
        }
        return false;
    }

    protected boolean canHandleMove(IEditorInput originalElement, IEditorInput movedElement) {
        IFile file;
        String ext;
        IFile file2;
        String oldExtension = "";
        if (originalElement instanceof IFileEditorInput && (file2 = ((IFileEditorInput)originalElement).getFile()) != null && (ext = file2.getFileExtension()) != null) {
            oldExtension = ext;
        }
        String newExtension = "";
        if (movedElement instanceof IFileEditorInput && (file = ((IFileEditorInput)movedElement).getFile()) != null) {
            newExtension = file.getFileExtension();
        }
        return oldExtension.equals(newExtension);
    }

    interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    class AdaptedSourceViewer
    extends JavaSourceViewer {
        private List fTextConverters;
        private boolean fIgnoreTextConverters = false;
        private JavaCorrectionAssistant fCorrectionAssistant;

        public AdaptedSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        }

        public IContentAssistant getContentAssistant() {
            return this.fContentAssistant;
        }

        public void doOperation(int operation) {
            if (this.getTextWidget() == null) {
                return;
            }
            switch (operation) {
                case 13: {
                    String msg = this.fContentAssistant.showPossibleCompletions();
                    CompilationUnitEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 50: {
                    this.fCorrectionAssistant.showPossibleCompletions();
                    return;
                }
                case 1: {
                    this.fIgnoreTextConverters = true;
                    break;
                }
                case 2: {
                    this.fIgnoreTextConverters = true;
                }
            }
            super.doOperation(operation);
        }

        public boolean canDoOperation(int operation) {
            if (operation == 50) {
                return this.isEditable();
            }
            return super.canDoOperation(operation);
        }

        protected void handleDispose() {
            if (this.fCorrectionAssistant != null) {
                this.fCorrectionAssistant.uninstall();
                this.fCorrectionAssistant = null;
            }
            super.handleDispose();
        }

        public void insertTextConverter(ITextConverter textConverter, int index) {
            throw new UnsupportedOperationException();
        }

        public void addTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters == null) {
                this.fTextConverters = new ArrayList(1);
                this.fTextConverters.add(textConverter);
            } else if (!this.fTextConverters.contains(textConverter)) {
                this.fTextConverters.add(textConverter);
            }
        }

        public void removeTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters != null) {
                this.fTextConverters.remove(textConverter);
                if (this.fTextConverters.size() == 0) {
                    this.fTextConverters = null;
                }
            }
        }

        protected void customizeDocumentCommand(DocumentCommand command) {
            super.customizeDocumentCommand(command);
            if (!this.fIgnoreTextConverters && this.fTextConverters != null) {
                Iterator e = this.fTextConverters.iterator();
                while (e.hasNext()) {
                    ((ITextConverter)e.next()).customizeDocumentCommand(this.getDocument(), command);
                }
            }
            this.fIgnoreTextConverters = false;
        }

        public void updateIndentationPrefixes() {
            SourceViewerConfiguration configuration = CompilationUnitEditor.this.getSourceViewerConfiguration();
            String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
            int i = 0;
            while (i < types.length) {
                String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)this, types[i]);
                if (prefixes != null && prefixes.length > 0) {
                    this.setIndentPrefixes(prefixes, types[i]);
                }
                ++i;
            }
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
            if (WorkbenchHelp.isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester);
        }

        public void configure(SourceViewerConfiguration configuration) {
            super.configure(configuration);
            this.fCorrectionAssistant = new JavaCorrectionAssistant((IEditorPart)CompilationUnitEditor.this);
            this.fCorrectionAssistant.install((ITextViewer)this);
            this.prependAutoEditStrategy(new SmartBracesAutoEditStrategy((ITextViewer)this), "__dftl_partition_content_type");
        }
    }

    static class TabConverter
    implements ITextConverter {
        private int fTabRatio;
        private ILineTracker fLineTracker;

        public void setNumberOfSpacesPerTab(int ratio) {
            this.fTabRatio = ratio;
        }

        public void setLineTracker(ILineTracker lineTracker) {
            this.fLineTracker = lineTracker;
        }

        private int insertTabString(StringBuffer buffer, int offsetInLine) {
            if (this.fTabRatio == 0) {
                return 0;
            }
            int remainder = offsetInLine % this.fTabRatio;
            remainder = this.fTabRatio - remainder;
            int i = 0;
            while (i < remainder) {
                buffer.append(' ');
                ++i;
            }
            return remainder;
        }

        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            String text = command.text;
            if (text == null) {
                return;
            }
            int index = text.indexOf(9);
            if (index > -1) {
                StringBuffer buffer = new StringBuffer();
                this.fLineTracker.set(command.text);
                int lines = this.fLineTracker.getNumberOfLines();
                try {
                    int i = 0;
                    while (i < lines) {
                        int offset = this.fLineTracker.getLineOffset(i);
                        int endOffset = offset + this.fLineTracker.getLineLength(i);
                        String line = text.substring(offset, endOffset);
                        int position = 0;
                        if (i == 0) {
                            IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                            position = command.offset - firstLine.getOffset();
                        }
                        int length = line.length();
                        int j = 0;
                        while (j < length) {
                            char c = line.charAt(j);
                            if (c == '\t') {
                                position += this.insertTabString(buffer, position);
                            } else {
                                buffer.append(c);
                                ++position;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    command.text = buffer.toString();
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    private class ExitPolicy
    implements LinkedPositionUI.ExitPolicy {
        final char fExitCharacter;
        final char fEscapeCharacter;
        final Stack fStack;
        final int fSize;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Stack stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedPositionUI.ExitFlags doExit(LinkedPositionManager manager, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter && this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                if (manager.anyPositionIncludes(offset, length)) {
                    return new LinkedPositionUI.ExitFlags(10, false);
                }
                return new LinkedPositionUI.ExitFlags(2, true);
            }
            switch (event.character) {
                case '\b': {
                    Position p = manager.getFirstPosition();
                    if (p.offset == offset && p.length == length) {
                        return new LinkedPositionUI.ExitFlags(0, false);
                    }
                    return null;
                }
                case '\n': 
                case '\r': {
                    return new LinkedPositionUI.ExitFlags(2, true);
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = CompilationUnitEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    private static class BracketLevel {
        int fOffset;
        int fLength;
        LinkedPositionManager fManager;
        LinkedPositionUI fEditor;

        BracketLevel() {
        }
    }

    private class BracketInserter
    implements VerifyKeyListener,
    LinkedPositionUI.ExitListener {
        private boolean fCloseBrackets = true;
        private boolean fCloseStrings = true;
        private Stack fBracketLevelStack = new Stack();

        BracketInserter() {
        }

        public void setCloseBracketsEnabled(boolean enabled) {
            this.fCloseBrackets = enabled;
        }

        public void setCloseStringsEnabled(boolean enabled) {
            this.fCloseStrings = enabled;
        }

        private boolean hasIdentifierToTheRight(IDocument document, int offset) {
            try {
                int end = offset;
                IRegion endLine = document.getLineInformationOfOffset(end);
                int maxEnd = endLine.getOffset() + endLine.getLength();
                while (end != maxEnd && Character.isWhitespace(document.getChar(end))) {
                    ++end;
                }
                return end != maxEnd && Character.isJavaIdentifierPart(document.getChar(end));
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        private boolean hasIdentifierToTheLeft(IDocument document, int offset) {
            try {
                int start = offset;
                IRegion startLine = document.getLineInformationOfOffset(start);
                int minStart = startLine.getOffset();
                while (start != minStart && Character.isWhitespace(document.getChar(start - 1))) {
                    --start;
                }
                return start != minStart && Character.isJavaIdentifierPart(document.getChar(start - 1));
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        private boolean hasCharacterToTheRight(IDocument document, int offset, char character) {
            try {
                int end = offset;
                IRegion endLine = document.getLineInformationOfOffset(end);
                int maxEnd = endLine.getOffset() + endLine.getLength();
                while (end != maxEnd && Character.isWhitespace(document.getChar(end))) {
                    ++end;
                }
                return end != maxEnd && document.getChar(end) == character;
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit) {
                return;
            }
            ISourceViewer sourceViewer = CompilationUnitEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            switch (event.character) {
                case '(': {
                    if (this.hasCharacterToTheRight(document, offset + length, '(')) {
                        return;
                    }
                }
                case '[': {
                    if (!this.fCloseBrackets) {
                        return;
                    }
                    if (this.hasIdentifierToTheRight(document, offset + length)) {
                        return;
                    }
                }
                case '\'': {
                    if (event.character == '\'') {
                        if (!this.fCloseStrings) {
                            return;
                        }
                        if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                            return;
                        }
                    }
                }
                case '\"': {
                    if (event.character == '\"') {
                        if (!this.fCloseStrings) {
                            return;
                        }
                        if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                            return;
                        }
                    }
                    try {
                        ITypedRegion partition = document.getPartition(offset);
                        if (!"__dftl_partition_content_type".equals(partition.getType()) && partition.getOffset() != offset) {
                            return;
                        }
                        if (!CompilationUnitEditor.this.validateEditorInputState()) {
                            return;
                        }
                        char character = event.character;
                        char closingCharacter = CompilationUnitEditor.getPeerCharacter(character);
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(character);
                        buffer.append(closingCharacter);
                        document.replace(offset, length, buffer.toString());
                        BracketLevel level = new BracketLevel();
                        this.fBracketLevelStack.push(level);
                        level.fManager = new LinkedPositionManager(document, this.fBracketLevelStack.size() > 1);
                        level.fManager.addPosition(offset + 1, 0);
                        level.fOffset = offset;
                        level.fLength = 2;
                        level.fEditor = new LinkedPositionUI((ITextViewer)sourceViewer, level.fManager);
                        level.fEditor.setCancelListener(this);
                        level.fEditor.setExitPolicy(new ExitPolicy(closingCharacter, CompilationUnitEditor.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
                        level.fEditor.setFinalCaretOffset(offset + 2);
                        level.fEditor.enter();
                        IRegion newSelection = level.fEditor.getSelectedRegion();
                        sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
                        event.doit = false;
                        break;
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
        }

        public void exit(boolean accept) {
            BracketLevel level = (BracketLevel)this.fBracketLevelStack.pop();
            if (accept) {
                return;
            }
            try {
                ISourceViewer sourceViewer = CompilationUnitEditor.this.getSourceViewer();
                IDocument document = sourceViewer.getDocument();
                document.replace(level.fOffset, level.fLength, null);
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

