/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.javaeditor.AnnotationType;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitAnnotationModelEvent;
import org.eclipse.jdt.internal.ui.javaeditor.DocumentAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.javaeditor.ISavePolicy;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.java.IProblemRequestorExtension;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class CompilationUnitDocumentProvider
extends FileDocumentProvider {
    private static final String HANDLE_TEMPORARY_PROBLEMS = "handleTemporaryProblems";
    private IBufferFactory fBufferFactory = new BufferFactory();
    private boolean fIsAboutToSave = false;
    private ISavePolicy fSavePolicy;
    private IPropertyChangeListener fPropertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (CompilationUnitDocumentProvider.HANDLE_TEMPORARY_PROBLEMS.equals(event.getProperty())) {
                CompilationUnitDocumentProvider.this.enableHandlingTemporaryProblems();
            }
        }
    };
    private GlobalAnnotationModelListener fGlobalAnnotationModelListener = new GlobalAnnotationModelListener();

    public CompilationUnitDocumentProvider() {
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
    }

    public void setSavePolicy(ISavePolicy savePolicy) {
        this.fSavePolicy = savePolicy;
    }

    protected ICompilationUnit createCompilationUnit(IFile file) {
        IJavaElement element = JavaCore.create((IFile)file);
        if (element instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    public ILineTracker createLineTracker(Object element) {
        return new DefaultLineTracker();
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (!(element instanceof IFileEditorInput)) {
            return super.createElementInfo(element);
        }
        IFileEditorInput input = (IFileEditorInput)element;
        ICompilationUnit original = this.createCompilationUnit(input.getFile());
        if (original != null) {
            try {
                try {
                    this.refreshFile(input.getFile());
                }
                catch (CoreException x) {
                    this.handleCoreException(x, JavaEditorMessages.getString("CompilationUnitDocumentProvider.error.createElementInfo"));
                }
                IAnnotationModel m = this.createCompilationUnitAnnotationModel(input);
                IProblemRequestor r = m instanceof IProblemRequestor ? (IProblemRequestor)m : null;
                ICompilationUnit c = (ICompilationUnit)original.getSharedWorkingCopy(this.getProgressMonitor(), this.fBufferFactory, r);
                DocumentAdapter a = null;
                try {
                    a = (DocumentAdapter)c.getBuffer();
                }
                catch (ClassCastException x) {
                    Status status = new Status(4, "org.eclipse.jdt.ui", 10002, "Shared working copy has wrong buffer", (Throwable)x);
                    throw new CoreException((IStatus)status);
                }
                _FileSynchronizer f = new _FileSynchronizer(input);
                f.install();
                CompilationUnitInfo info = new CompilationUnitInfo(a.getDocument(), m, f, c);
                info.setModificationStamp(this.computeModificationStamp((IResource)input.getFile()));
                ((AbstractDocumentProvider.ElementInfo)info).fStatus = a.getStatus();
                ((StorageDocumentProvider.StorageInfo)info).fEncoding = this.getPersistedEncoding(input);
                if (r instanceof IProblemRequestorExtension) {
                    IProblemRequestorExtension extension = (IProblemRequestorExtension)r;
                    extension.setIsActive(this.isHandlingTemporaryProblems());
                }
                m.addAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
                return info;
            }
            catch (JavaModelException x) {
                throw new CoreException(x.getStatus());
            }
        }
        return super.createElementInfo(element);
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info instanceof CompilationUnitInfo) {
            CompilationUnitInfo cuInfo = (CompilationUnitInfo)info;
            cuInfo.fCopy.destroy();
            ((AbstractDocumentProvider.ElementInfo)cuInfo).fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
        }
        super.disposeElementInfo(element, info);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof CompilationUnitInfo) {
            IResource r;
            IMarker[] markers;
            ICompilationUnit unit;
            CompilationUnitInfo info = (CompilationUnitInfo)elementInfo;
            info.fCopy.reconcile();
            ICompilationUnit original = (ICompilationUnit)info.fCopy.getOriginalElement();
            IResource resource = original.getResource();
            if (resource == null) {
                super.doSaveDocument(monitor, element, document, overwrite);
                return;
            }
            if (resource != null && !overwrite) {
                this.checkSynchronizationState(info.fModificationStamp, resource);
            }
            if (this.fSavePolicy != null) {
                this.fSavePolicy.preSave(info.fCopy);
            }
            this.fireElementStateChanging(element);
            try {
                try {
                    this.fIsAboutToSave = true;
                    info.fCopy.commit(overwrite, monitor);
                }
                catch (CoreException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
                catch (RuntimeException x) {
                    this.fireElementStateChangeFailed(element);
                    throw x;
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                this.fIsAboutToSave = false;
                throw throwable;
            }
            Object var10_15 = null;
            this.fIsAboutToSave = false;
            AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)((AbstractDocumentProvider.ElementInfo)info).fModel;
            model.updateMarkers(((AbstractDocumentProvider.ElementInfo)info).fDocument);
            if (resource != null) {
                info.setModificationStamp(this.computeModificationStamp(resource));
            }
            if (this.fSavePolicy != null && (unit = this.fSavePolicy.postSave(original)) != null && (markers = (r = unit.getResource()).findMarkers("org.eclipse.core.resources.marker", true, 0)) != null && markers.length > 0) {
                int i = 0;
                while (i < markers.length) {
                    model.updateMarker(markers[i], ((AbstractDocumentProvider.ElementInfo)info).fDocument, null);
                    ++i;
                }
            }
        } else {
            super.doSaveDocument(monitor, element, document, overwrite);
        }
    }

    protected IAnnotationModel createCompilationUnitAnnotationModel(Object element) throws CoreException {
        if (!(element instanceof IFileEditorInput)) {
            throw new CoreException(JavaUIStatus.createError(996, "", null));
        }
        IFileEditorInput input = (IFileEditorInput)element;
        return new CompilationUnitAnnotationModel(input);
    }

    protected void initializeDocument(IDocument document) {
        if (document != null) {
            JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
            IDocumentPartitioner partitioner = tools.createDocumentPartitioner();
            document.setDocumentPartitioner(partitioner);
            partitioner.connect(document);
        }
    }

    protected IDocument createDocument(Object element) throws CoreException {
        PartiallySynchronizedDocument document;
        if (element instanceof IEditorInput && this.setDocumentContent((IDocument)(document = new PartiallySynchronizedDocument()), (IEditorInput)element, this.getEncoding(element))) {
            this.initializeDocument((IDocument)document);
            return document;
        }
        return null;
    }

    public void resetDocument(Object element) throws CoreException {
        if (element == null) {
            return;
        }
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof CompilationUnitInfo) {
            Document document;
            IStatus status;
            CompilationUnitInfo info;
            block8: {
                info = (CompilationUnitInfo)elementInfo;
                status = null;
                try {
                    ICompilationUnit original = (ICompilationUnit)info.fCopy.getOriginalElement();
                    IResource resource = original.getResource();
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        try {
                            this.refreshFile(file);
                        }
                        catch (CoreException x) {
                            this.handleCoreException(x, JavaEditorMessages.getString("CompilationUnitDocumentProvider.error.resetDocument"));
                        }
                        FileEditorInput input = new FileEditorInput(file);
                        document = super.createDocument((Object)input);
                        break block8;
                    }
                    document = new Document();
                }
                catch (CoreException x) {
                    document = new Document();
                    status = x.getStatus();
                }
            }
            this.fireElementContentAboutToBeReplaced(element);
            this.removeUnchangedElementListeners(element, (AbstractDocumentProvider.ElementInfo)info);
            ((AbstractDocumentProvider.ElementInfo)info).fDocument.set(document.get());
            ((AbstractDocumentProvider.ElementInfo)info).fCanBeSaved = false;
            ((AbstractDocumentProvider.ElementInfo)info).fStatus = status;
            this.addUnchangedElementListeners(element, (AbstractDocumentProvider.ElementInfo)info);
            this.fireElementContentReplaced(element);
            this.fireElementDirtyStateChanged(element, false);
        } else {
            super.resetDocument(element);
        }
    }

    public void saveDocumentContent(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (!this.fIsAboutToSave) {
            return;
        }
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            try {
                String encoding = this.getEncoding(element);
                if (encoding == null) {
                    encoding = ResourcesPlugin.getEncoding();
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(document.get().getBytes(encoding));
                IFile file = input.getFile();
                file.setContents((InputStream)stream, overwrite, true, monitor);
            }
            catch (IOException x) {
                Status s = new Status(4, "org.eclipse.jdt.ui", 0, x.getMessage(), (Throwable)x);
                throw new CoreException((IStatus)s);
            }
        }
    }

    public IResource getUnderlyingResource(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return input.getFile();
        }
        return null;
    }

    ICompilationUnit getWorkingCopy(IEditorInput element) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(element);
        if (elementInfo instanceof CompilationUnitInfo) {
            CompilationUnitInfo info = (CompilationUnitInfo)elementInfo;
            return info.fCopy;
        }
        return null;
    }

    public IBufferFactory getBufferFactory() {
        return this.fBufferFactory;
    }

    public void shutdown() {
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
        Iterator e = this.getConnectedElements();
        while (e.hasNext()) {
            this.disconnect(e.next());
        }
    }

    protected boolean isHandlingTemporaryProblems() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(HANDLE_TEMPORARY_PROBLEMS);
    }

    protected void enableHandlingTemporaryProblems() {
        boolean enable = this.isHandlingTemporaryProblems();
        Iterator iter = this.getConnectedElements();
        while (iter.hasNext()) {
            AbstractDocumentProvider.ElementInfo element = this.getElementInfo(iter.next());
            if (!(element instanceof CompilationUnitInfo)) continue;
            CompilationUnitInfo info = (CompilationUnitInfo)element;
            if (!(((AbstractDocumentProvider.ElementInfo)info).fModel instanceof IProblemRequestorExtension)) continue;
            IProblemRequestorExtension extension = (IProblemRequestorExtension)((AbstractDocumentProvider.ElementInfo)info).fModel;
            extension.setIsActive(enable);
        }
    }

    public void addGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.addListener(listener);
    }

    public void removeGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.removeListener(listener);
    }

    boolean isConnected(Object element) {
        return this.getElementInfo(element) != null;
    }

    protected class _FileSynchronizer
    extends FileDocumentProvider.FileSynchronizer {
        public _FileSynchronizer(IFileEditorInput fileEditorInput) {
            super((FileDocumentProvider)CompilationUnitDocumentProvider.this, fileEditorInput);
        }
    }

    protected class CompilationUnitInfo
    extends FileDocumentProvider.FileInfo {
        ICompilationUnit fCopy;

        public CompilationUnitInfo(IDocument document, IAnnotationModel model, _FileSynchronizer fileSynchronizer, ICompilationUnit copy) {
            super((FileDocumentProvider)CompilationUnitDocumentProvider.this, document, model, (FileDocumentProvider.FileSynchronizer)fileSynchronizer);
            this.fCopy = copy;
        }

        public void setModificationStamp(long timeStamp) {
            this.fModificationStamp = timeStamp;
        }
    }

    protected static class ProblemAnnotation
    extends Annotation
    implements IJavaAnnotation {
        private static Image fgQuickFixImage;
        private static Image fgQuickFixErrorImage;
        private static boolean fgQuickFixImagesInitialized;
        private List fOverlaids;
        private IProblem fProblem;
        private Image fImage;
        private boolean fQuickFixImagesInitialized = false;
        private AnnotationType fType;

        static {
            fgQuickFixImagesInitialized = false;
        }

        public ProblemAnnotation(IProblem problem) {
            this.fProblem = problem;
            this.setLayer(6);
            this.fType = 536871362 == this.fProblem.getID() ? AnnotationType.TASK : (this.fProblem.isWarning() ? AnnotationType.WARNING : AnnotationType.ERROR);
        }

        private void initializeImages() {
            if (!this.fQuickFixImagesInitialized) {
                if (this.indicateQuixFixableProblems() && JavaCorrectionProcessor.hasCorrections(this.fProblem.getID())) {
                    if (!fgQuickFixImagesInitialized) {
                        fgQuickFixImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_warning_obj.gif");
                        fgQuickFixErrorImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_error_obj.gif");
                        fgQuickFixImagesInitialized = true;
                    }
                    this.fImage = this.fType == AnnotationType.ERROR ? fgQuickFixErrorImage : fgQuickFixImage;
                }
                this.fQuickFixImagesInitialized = true;
            }
        }

        private boolean indicateQuixFixableProblems() {
            return PreferenceConstants.getPreferenceStore().getBoolean("JavaEditor.ShowTemporaryProblem");
        }

        public void paint(GC gc, Canvas canvas, Rectangle r) {
            this.initializeImages();
            if (this.fImage != null) {
                Annotation.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
            }
        }

        public Image getImage(Display display) {
            this.initializeImages();
            return this.fImage;
        }

        public String getMessage() {
            return this.fProblem.getMessage();
        }

        public boolean isTemporary() {
            return true;
        }

        public String[] getArguments() {
            return this.isProblem() ? this.fProblem.getArguments() : null;
        }

        public int getId() {
            return this.isProblem() ? this.fProblem.getID() : -1;
        }

        public boolean isProblem() {
            return this.fType == AnnotationType.WARNING || this.fType == AnnotationType.ERROR;
        }

        public boolean isRelevant() {
            return true;
        }

        public boolean hasOverlay() {
            return false;
        }

        public void addOverlaid(IJavaAnnotation annotation) {
            if (this.fOverlaids == null) {
                this.fOverlaids = new ArrayList(1);
            }
            this.fOverlaids.add(annotation);
        }

        public void removeOverlaid(IJavaAnnotation annotation) {
            if (this.fOverlaids != null) {
                this.fOverlaids.remove(annotation);
                if (this.fOverlaids.size() == 0) {
                    this.fOverlaids = null;
                }
            }
        }

        public Iterator getOverlaidIterator() {
            if (this.fOverlaids != null) {
                return this.fOverlaids.iterator();
            }
            return null;
        }

        public AnnotationType getAnnotationType() {
            return this.fType;
        }
    }

    protected static class ReverseMap {
        private List fList = new ArrayList(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }

    protected class CompilationUnitAnnotationModel
    extends ResourceMarkerAnnotationModel
    implements IProblemRequestor,
    IProblemRequestorExtension {
        private IFileEditorInput fInput;
        private List fCollectedProblems;
        private List fGeneratedAnnotations;
        private IProgressMonitor fProgressMonitor;
        private boolean fIsActive = false;
        private ReverseMap fReverseMap = new ReverseMap();
        private List fPreviouslyOverlaid = null;
        private List fCurrentlyOverlaid = new ArrayList();
        private CompilationUnitAnnotationModelEvent fCurrentEvent;

        public CompilationUnitAnnotationModel(IFileEditorInput input) {
            super((IResource)input.getFile());
            this.fInput = input;
            this.fCurrentEvent = new CompilationUnitAnnotationModelEvent((IAnnotationModel)this, this.getResource());
        }

        protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
            return new JavaMarkerAnnotation(marker);
        }

        protected Position createPositionFromProblem(IProblem problem) {
            int start = problem.getSourceStart();
            if (start < 0) {
                return null;
            }
            int length = problem.getSourceEnd() - problem.getSourceStart() + 1;
            if (length < 0) {
                return null;
            }
            return new Position(start, length);
        }

        protected void update(IMarkerDelta[] markerDeltas) {
            super.update(markerDeltas);
            if (markerDeltas != null && markerDeltas.length > 0) {
                try {
                    ICompilationUnit workingCopy = CompilationUnitDocumentProvider.this.getWorkingCopy((IEditorInput)this.fInput);
                    if (workingCopy != null) {
                        workingCopy.reconcile(true, null);
                    }
                }
                catch (JavaModelException ex) {
                    this.handleCoreException((CoreException)((Object)ex), ex.getMessage());
                }
            }
        }

        public void beginReporting() {
            ICompilationUnit unit = CompilationUnitDocumentProvider.this.getWorkingCopy((IEditorInput)this.fInput);
            this.fCollectedProblems = unit != null && unit.getJavaProject().isOnClasspath((IJavaElement)unit) ? new ArrayList() : null;
        }

        public void acceptProblem(IProblem problem) {
            if (this.isActive()) {
                this.fCollectedProblems.add(problem);
            }
        }

        public void endReporting() {
            if (!this.isActive()) {
                return;
            }
            if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                return;
            }
            boolean isCanceled = false;
            boolean temporaryProblemsChanged = false;
            this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
            this.fCurrentlyOverlaid = new ArrayList();
            Map map = ((AnnotationModel)this).fAnnotations;
            synchronized (map) {
                if (this.fGeneratedAnnotations.size() > 0) {
                    temporaryProblemsChanged = true;
                    this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                    this.fGeneratedAnnotations.clear();
                }
                if (this.fCollectedProblems != null && this.fCollectedProblems.size() > 0) {
                    Iterator e = this.fCollectedProblems.iterator();
                    while (e.hasNext()) {
                        IProblem problem = (IProblem)e.next();
                        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                            isCanceled = true;
                            break;
                        }
                        Position position = this.createPositionFromProblem(problem);
                        if (position == null) continue;
                        ProblemAnnotation annotation = new ProblemAnnotation(problem);
                        this.overlayMarkers(position, annotation);
                        this.fGeneratedAnnotations.add(annotation);
                        this.addAnnotation(annotation, position, false);
                        temporaryProblemsChanged = true;
                    }
                    this.fCollectedProblems.clear();
                }
                this.removeMarkerOverlays(isCanceled);
                this.fPreviouslyOverlaid.clear();
                this.fPreviouslyOverlaid = null;
            }
            if (temporaryProblemsChanged) {
                this.fireModelChanged();
            }
        }

        private void removeMarkerOverlays(boolean isCanceled) {
            if (isCanceled) {
                this.fCurrentlyOverlaid.addAll(this.fPreviouslyOverlaid);
            } else if (this.fPreviouslyOverlaid != null) {
                Iterator e = this.fPreviouslyOverlaid.iterator();
                while (e.hasNext()) {
                    JavaMarkerAnnotation annotation = (JavaMarkerAnnotation)e.next();
                    annotation.setOverlay(null);
                }
            }
        }

        private void setOverlay(Object value, ProblemAnnotation problemAnnotation) {
            JavaMarkerAnnotation annotation;
            if (value instanceof JavaMarkerAnnotation && (annotation = (JavaMarkerAnnotation)value).isProblem()) {
                annotation.setOverlay(problemAnnotation);
                this.fPreviouslyOverlaid.remove(annotation);
                this.fCurrentlyOverlaid.add(annotation);
            }
        }

        private void overlayMarkers(Position position, ProblemAnnotation problemAnnotation) {
            Object value = this.getAnnotations(position);
            if (value instanceof List) {
                List list = (List)value;
                Iterator e = list.iterator();
                while (e.hasNext()) {
                    this.setOverlay(e.next(), problemAnnotation);
                }
            } else {
                this.setOverlay(value, problemAnnotation);
            }
        }

        private void startCollectingProblems() {
            this.fCollectedProblems = new ArrayList();
            this.fGeneratedAnnotations = new ArrayList();
        }

        private void stopCollectingProblems() {
            if (this.fGeneratedAnnotations != null) {
                this.removeAnnotations(this.fGeneratedAnnotations, true, true);
                this.fGeneratedAnnotations.clear();
            }
            this.fCollectedProblems = null;
            this.fGeneratedAnnotations = null;
        }

        protected void fireModelChanged() {
            this.fireModelChanged(this.fCurrentEvent);
            this.fCurrentEvent = new CompilationUnitAnnotationModelEvent((IAnnotationModel)this, this.getResource());
        }

        public boolean isActive() {
            return this.fIsActive && this.fCollectedProblems != null;
        }

        public void setProgressMonitor(IProgressMonitor monitor) {
            this.fProgressMonitor = monitor;
        }

        public void setIsActive(boolean isActive) {
            if (this.fIsActive != isActive) {
                this.fIsActive = isActive;
                if (this.fIsActive) {
                    this.startCollectingProblems();
                } else {
                    this.stopCollectingProblems();
                }
            }
        }

        private Object getAnnotations(Position position) {
            return this.fReverseMap.get(position);
        }

        protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) {
            super.addAnnotation(annotation, position, fireModelChanged);
            this.fCurrentEvent.annotationAdded(annotation);
            Object cached = this.fReverseMap.get(position);
            if (cached == null) {
                this.fReverseMap.put(position, annotation);
            } else if (cached instanceof List) {
                List list = (List)cached;
                list.add(annotation);
            } else if (cached instanceof Annotation) {
                ArrayList<Object> list = new ArrayList<Object>(2);
                list.add(cached);
                list.add(annotation);
                this.fReverseMap.put(position, list);
            }
        }

        protected void removeAllAnnotations(boolean fireModelChanged) {
            Iterator iter = this.getAnnotationIterator();
            while (iter.hasNext()) {
                this.fCurrentEvent.annotationRemoved((Annotation)iter.next());
            }
            super.removeAllAnnotations(fireModelChanged);
            this.fReverseMap.clear();
        }

        protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
            this.fCurrentEvent.annotationRemoved(annotation);
            Position position = this.getPosition(annotation);
            Object cached = this.fReverseMap.get(position);
            if (cached instanceof List) {
                List list = (List)cached;
                list.remove(annotation);
                if (list.size() == 1) {
                    this.fReverseMap.put(position, list.get(0));
                    list.clear();
                }
            } else if (cached instanceof Annotation) {
                this.fReverseMap.remove(position);
            }
            super.removeAnnotation(annotation, fireModelChanged);
        }
    }

    protected class BufferFactory
    implements IBufferFactory {
        protected BufferFactory() {
        }

        private IDocument internalGetDocument(IFileEditorInput input) throws CoreException {
            IDocument document = CompilationUnitDocumentProvider.this.getDocument(input);
            if (document != null) {
                return document;
            }
            return CompilationUnitDocumentProvider.this.createDocument(input);
        }

        public IBuffer createBuffer(IOpenable owner) {
            ICompilationUnit unit;
            ICompilationUnit original;
            IResource resource;
            if (owner instanceof ICompilationUnit && (resource = (original = (ICompilationUnit)(unit = (ICompilationUnit)owner).getOriginalElement()).getResource()) instanceof IFile) {
                FileEditorInput providerKey = new FileEditorInput((IFile)resource);
                IDocument document = null;
                IStatus status = null;
                try {
                    document = this.internalGetDocument((IFileEditorInput)providerKey);
                }
                catch (CoreException x) {
                    status = x.getStatus();
                    document = new Document();
                    CompilationUnitDocumentProvider.this.initializeDocument(document);
                }
                DocumentAdapter adapter = new DocumentAdapter((IOpenable)unit, document, (ILineTracker)new DefaultLineTracker(), CompilationUnitDocumentProvider.this, providerKey);
                adapter.setStatus(status);
                return adapter;
            }
            return DocumentAdapter.NULL;
        }
    }

    protected static class GlobalAnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private ListenerList fListenerList = new ListenerList();

        public void modelChanged(IAnnotationModel model) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IAnnotationModelListener)listeners[i]).modelChanged(model);
                ++i;
            }
        }

        public void modelChanged(AnnotationModelEvent event) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                Object curr = listeners[i];
                if (curr instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)curr).modelChanged(event);
                }
                ++i;
            }
        }

        public void addListener(IAnnotationModelListener listener) {
            this.fListenerList.add((Object)listener);
        }

        public void removeListener(IAnnotationModelListener listener) {
            this.fListenerList.remove((Object)listener);
        }
    }

    protected static class PartiallySynchronizedDocument
    extends Document {
        protected PartiallySynchronizedDocument() {
        }

        public synchronized void startSequentialRewrite(boolean normalized) {
            super.startSequentialRewrite(normalized);
        }

        public synchronized void stopSequentialRewrite() {
            super.stopSequentialRewrite();
        }

        public synchronized String get() {
            return super.get();
        }

        public synchronized String get(int offset, int length) throws BadLocationException {
            return super.get(offset, length);
        }

        public synchronized char getChar(int offset) throws BadLocationException {
            return super.getChar(offset);
        }

        public synchronized void replace(int offset, int length, String text) throws BadLocationException {
            super.replace(offset, length, text);
        }

        public synchronized void set(String text) {
            super.set(text);
        }
    }
}

