/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileDisassembler;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.ExternalClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaOutlinePage;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceAttachmentDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ClassFileEditor
extends JavaEditor
implements ClassFileDocumentProvider.InputChangeListener {
    private static final int HORIZONTAL_SCROLL_INCREMENT = 10;
    private static final int VERTICAL_SCROLL_INCREMENT = 10;
    private StackLayout fStackLayout;
    private Composite fParent;
    private Composite fViewerComposite;
    private Control fSourceAttachmentForm;
    private InputUpdater fInputUpdater = new InputUpdater();

    public ClassFileEditor() {
        this.setDocumentProvider((IDocumentProvider)JavaPlugin.getDefault().getClassFileDocumentProvider());
        this.setEditorContextMenuId("#ClassFileEditorContext");
        this.setRulerContextMenuId("#ClassFileRulerContext");
        this.setOutlinerContextMenuId("#ClassFileOutlinerContext");
    }

    protected void createActions() {
        super.createActions();
        this.setAction("save", null);
        this.setAction("revert", null);
        this.setAction("bookmark", null);
        this.setAction("addTask", null);
    }

    protected IJavaElement getElementAt(int offset) {
        if (this.getEditorInput() instanceof IClassFileEditorInput) {
            try {
                IClassFileEditorInput input = (IClassFileEditorInput)this.getEditorInput();
                return input.getClassFile().getElementAt(offset);
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    protected IJavaElement getCorrespondingElement(IJavaElement element) {
        if (this.getEditorInput() instanceof IClassFileEditorInput) {
            IClassFileEditorInput input = (IClassFileEditorInput)this.getEditorInput();
            IJavaElement parent = element.getAncestor(6);
            if (input.getClassFile().equals(parent)) {
                return element;
            }
        }
        return null;
    }

    public void saveState(IMemento memento) {
    }

    protected void setOutlinePageInput(JavaOutlinePage page, IEditorInput input) {
        if (page != null && input instanceof IClassFileEditorInput) {
            IClassFileEditorInput cfi = (IClassFileEditorInput)input;
            page.setInput((IJavaElement)cfi.getClassFile());
        }
    }

    public boolean isEditable() {
        return false;
    }

    protected IEditorInput transformEditorInput(IEditorInput input) {
        IFile file;
        ExternalClassFileEditorInput classFileInput;
        if (input instanceof IFileEditorInput && (classFileInput = new ExternalClassFileEditorInput(file = ((IFileEditorInput)input).getFile())).getClassFile() != null) {
            input = classFileInput;
        }
        return input;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (!((input = this.transformEditorInput(input)) instanceof IClassFileEditorInput)) {
            throw new CoreException(JavaUIStatus.createError(996, JavaEditorMessages.getString("ClassFileEditor.error.invalid_input_message"), null));
        }
        JavaModelException e = this.probeInputForSource(input);
        if (e != null) {
            IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)input;
            IClassFile file = classFileEditorInput.getClassFile();
            if (!file.getJavaProject().exists() || !file.getJavaProject().isOnClasspath((IJavaElement)file)) {
                throw new CoreException(JavaUIStatus.createError(995, JavaEditorMessages.getString("ClassFileEditor.error.classfile_not_on_classpath"), null));
            }
            throw e;
        }
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ClassFileDocumentProvider) {
            ((ClassFileDocumentProvider)documentProvider).removeInputChangeListener(this);
        }
        super.doSetInput(input);
        documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ClassFileDocumentProvider) {
            ((ClassFileDocumentProvider)documentProvider).addInputChangeListener(this);
        }
        this.verifyInput(this.getEditorInput());
    }

    public void createPartControl(Composite parent) {
        this.fParent = new Composite(parent, 0);
        this.fStackLayout = new StackLayout();
        this.fParent.setLayout((Layout)this.fStackLayout);
        this.fViewerComposite = new Composite(this.fParent, 0);
        this.fViewerComposite.setLayout((Layout)new FillLayout());
        super.createPartControl(this.fViewerComposite);
        this.fStackLayout.topControl = this.fViewerComposite;
        this.fParent.layout();
        try {
            this.verifyInput(this.getEditorInput());
        }
        catch (CoreException e) {
            String title = JavaEditorMessages.getString("ClassFileEditor.error.title");
            String message = JavaEditorMessages.getString("ClassFileEditor.error.message");
            ExceptionHandler.handle(e, this.fParent.getShell(), title, message);
        }
    }

    private JavaModelException probeInputForSource(IEditorInput input) {
        if (input == null) {
            return null;
        }
        IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)input;
        IClassFile file = classFileEditorInput.getClassFile();
        try {
            file.getSourceRange();
        }
        catch (JavaModelException e) {
            return e;
        }
        return null;
    }

    private void verifyInput(IEditorInput input) throws CoreException {
        if (this.fParent == null || input == null) {
            return;
        }
        IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)input;
        IClassFile file = classFileEditorInput.getClassFile();
        if (file.getSourceRange() == null) {
            if (this.fSourceAttachmentForm != null) {
                this.fSourceAttachmentForm.dispose();
            }
            SourceAttachmentForm form = new SourceAttachmentForm(file);
            this.fStackLayout.topControl = this.fSourceAttachmentForm = form.createControl(this.fParent);
            this.fParent.layout();
        } else if (this.fSourceAttachmentForm != null) {
            this.fSourceAttachmentForm.dispose();
            this.fSourceAttachmentForm = null;
            this.fStackLayout.topControl = this.fViewerComposite;
            this.fParent.layout();
        }
    }

    public void inputChanged(IClassFileEditorInput input) {
        this.fInputUpdater.post(input);
    }

    protected ISourceViewer createJavaSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return new SourceViewer(parent, ruler, styles){

            public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
                if (WorkbenchHelp.isContextHelpDisplayed()) {
                    return false;
                }
                return super.requestWidgetToken(requester);
            }
        };
    }

    public void dispose() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ClassFileDocumentProvider) {
            ((ClassFileDocumentProvider)documentProvider).removeInputChangeListener(this);
        }
        super.dispose();
    }

    public void setFocus() {
        super.setFocus();
        if (this.fSourceAttachmentForm != null && !this.fSourceAttachmentForm.isDisposed()) {
            this.fSourceAttachmentForm.setFocus();
        }
    }

    static /* synthetic */ void access$0(ClassFileEditor classFileEditor, IEditorInput iEditorInput) {
        classFileEditor.verifyInput(iEditorInput);
    }

    private class SourceAttachmentForm
    implements IPropertyChangeListener {
        private final IClassFile fFile;
        private ScrolledComposite fScrolledComposite;
        private Color fBackgroundColor;
        private Color fForegroundColor;
        private Color fSeparatorColor;
        private List fBannerLabels = new ArrayList();
        private List fHeaderLabels = new ArrayList();
        private Font fFont;

        public SourceAttachmentForm(IClassFile file) {
            this.fFile = file;
        }

        private IPackageFragmentRoot getPackageFragmentRoot(IClassFile file) {
            IJavaElement element = file.getParent();
            while (element != null && element.getElementType() != 3) {
                element = element.getParent();
            }
            return (IPackageFragmentRoot)element;
        }

        public Control createControl(Composite parent) {
            Display display = parent.getDisplay();
            this.fBackgroundColor = display.getSystemColor(25);
            this.fForegroundColor = display.getSystemColor(24);
            this.fSeparatorColor = new Color((Device)display, 152, 170, 203);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
            this.fScrolledComposite = new ScrolledComposite(parent, 768);
            this.fScrolledComposite.setAlwaysShowScrollBars(false);
            this.fScrolledComposite.setExpandHorizontal(true);
            this.fScrolledComposite.setExpandVertical(true);
            this.fScrolledComposite.addDisposeListener(new DisposeListener(this){
                private final /* synthetic */ SourceAttachmentForm this$1;
                {
                    this.this$1 = sourceAttachmentForm;
                }

                public void widgetDisposed(DisposeEvent e) {
                    JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.this$1);
                    SourceAttachmentForm.access$0(this.this$1, null);
                    SourceAttachmentForm.access$1(this.this$1).dispose();
                    SourceAttachmentForm.access$2(this.this$1, null);
                    SourceAttachmentForm.access$3(this.this$1).clear();
                    SourceAttachmentForm.access$4(this.this$1).clear();
                    if (SourceAttachmentForm.access$5(this.this$1) != null) {
                        SourceAttachmentForm.access$5(this.this$1).dispose();
                        SourceAttachmentForm.access$6(this.this$1, null);
                    }
                }
            });
            this.fScrolledComposite.addControlListener(new ControlListener(this){
                private final /* synthetic */ SourceAttachmentForm this$1;
                {
                    this.this$1 = sourceAttachmentForm;
                }

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    Rectangle clientArea = SourceAttachmentForm.access$7(this.this$1).getClientArea();
                    ScrollBar verticalBar = SourceAttachmentForm.access$7(this.this$1).getVerticalBar();
                    verticalBar.setIncrement(10);
                    verticalBar.setPageIncrement(clientArea.height - verticalBar.getIncrement());
                    ScrollBar horizontalBar = SourceAttachmentForm.access$7(this.this$1).getHorizontalBar();
                    horizontalBar.setIncrement(10);
                    horizontalBar.setPageIncrement(clientArea.width - horizontalBar.getIncrement());
                }
            });
            Composite composite = this.createComposite((Composite)this.fScrolledComposite);
            composite.setLayout((Layout)new GridLayout());
            this.createTitleLabel(composite, JavaEditorMessages.getString("SourceAttachmentForm.title"));
            this.createLabel(composite, null);
            this.createLabel(composite, null);
            this.createHeadingLabel(composite, JavaEditorMessages.getString("SourceAttachmentForm.heading"));
            Composite separator = this.createCompositeSeparator(composite);
            GridData data = new GridData(768);
            data.heightHint = 2;
            separator.setLayoutData((Object)data);
            try {
                IPackageFragmentRoot root = this.getPackageFragmentRoot(this.fFile);
                if (root != null) {
                    this.createSourceAttachmentControls(composite, root);
                }
            }
            catch (JavaModelException e) {
                String title = JavaEditorMessages.getString("SourceAttachmentForm.error.title");
                String message = JavaEditorMessages.getString("SourceAttachmentForm.error.message");
                ExceptionHandler.handle((CoreException)((Object)e), this.fScrolledComposite.getShell(), title, message);
            }
            separator = this.createCompositeSeparator(composite);
            data = new GridData(768);
            data.heightHint = 2;
            separator.setLayoutData((Object)data);
            StyledText styledText = this.createCodeView(composite);
            data = new GridData(1808);
            styledText.setLayoutData((Object)data);
            this.updateCodeView(styledText, this.fFile);
            this.fScrolledComposite.setContent((Control)composite);
            this.fScrolledComposite.setMinSize(composite.computeSize(-1, -1));
            return this.fScrolledComposite;
        }

        private void createSourceAttachmentControls(Composite composite, IPackageFragmentRoot root) throws JavaModelException {
            Button button;
            IPath path;
            IClasspathEntry entry = root.getRawClasspathEntry();
            IPath containerPath = null;
            IJavaProject jproject = root.getJavaProject();
            if (entry == null || !root.isArchive()) {
                this.createLabel(composite, JavaEditorMessages.getFormattedString("SourceAttachmentForm.message.noSource", this.fFile.getElementName()));
                return;
            }
            if (entry.getEntryKind() == 5) {
                containerPath = entry.getPath();
                IClasspathEntry entry2 = SourceAttachmentDialog.getClasspathEntryToEdit(jproject, containerPath, root.getPath());
                if (entry2 == null) {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)root.getJavaProject());
                    String containerName = container == null ? entry.getPath().toString() : container.getDescription();
                    this.createLabel(composite, JavaEditorMessages.getFormattedString("SourceAttachmentForm.message.containerEntry", containerName));
                    return;
                }
                entry = entry2;
            }
            if ((path = entry.getSourceAttachmentPath()) == null || path.isEmpty()) {
                this.createLabel(composite, JavaEditorMessages.getFormattedString("SourceAttachmentForm.message.noSourceAttachment", root.getElementName()));
                this.createLabel(composite, JavaEditorMessages.getString("SourceAttachmentForm.message.pressButtonToAttach"));
                this.createLabel(composite, null);
                button = this.createButton(composite, JavaEditorMessages.getString("SourceAttachmentForm.button.attachSource"));
            } else {
                this.createLabel(composite, JavaEditorMessages.getFormattedString("SourceAttachmentForm.message.noSourceInAttachment", this.fFile.getElementName()));
                this.createLabel(composite, JavaEditorMessages.getString("SourceAttachmentForm.message.pressButtonToChange"));
                this.createLabel(composite, null);
                button = this.createButton(composite, JavaEditorMessages.getString("SourceAttachmentForm.button.changeAttachedSource"));
            }
            button.addSelectionListener(this.getButtonListener(entry, containerPath, jproject));
        }

        private SelectionListener getButtonListener(IClasspathEntry entry, IPath containerPath, IJavaProject jproject) {
            return new SelectionListener(this, entry, containerPath, jproject){
                private final /* synthetic */ SourceAttachmentForm this$1;
                private final /* synthetic */ IClasspathEntry val$entry;
                private final /* synthetic */ IPath val$containerPath;
                private final /* synthetic */ IJavaProject val$jproject;
                {
                    this.this$1 = sourceAttachmentForm;
                    this.val$entry = iClasspathEntry;
                    this.val$containerPath = iPath;
                    this.val$jproject = iJavaProject;
                }

                public void widgetSelected(SelectionEvent event) {
                    try {
                        SourceAttachmentDialog dialog = new SourceAttachmentDialog(SourceAttachmentForm.access$7(this.this$1).getShell(), this.val$entry, this.val$containerPath, this.val$jproject, true);
                        if (dialog.open() == 0) {
                            ClassFileEditor.access$0(SourceAttachmentForm.access$8(this.this$1), SourceAttachmentForm.access$8(this.this$1).getEditorInput());
                        }
                    }
                    catch (CoreException e) {
                        String title = JavaEditorMessages.getString("SourceAttachmentForm.error.title");
                        String message = JavaEditorMessages.getString("SourceAttachmentForm.error.message");
                        ExceptionHandler.handle(e, SourceAttachmentForm.access$7(this.this$1).getShell(), title, message);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
        }

        public void propertyChange(PropertyChangeEvent event) {
            Label label;
            Iterator iterator = this.fBannerLabels.iterator();
            while (iterator.hasNext()) {
                label = (Label)iterator.next();
                label.setFont(JFaceResources.getBannerFont());
            }
            iterator = this.fHeaderLabels.iterator();
            while (iterator.hasNext()) {
                label = (Label)iterator.next();
                label.setFont(JFaceResources.getHeaderFont());
            }
            Control control = this.fScrolledComposite.getContent();
            this.fScrolledComposite.setMinSize(control.computeSize(-1, -1));
            this.fScrolledComposite.setContent(control);
            this.fScrolledComposite.layout(true);
            this.fScrolledComposite.redraw();
        }

        private Composite createComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(this.fBackgroundColor);
            return composite;
        }

        private Composite createCompositeSeparator(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(this.fSeparatorColor);
            return composite;
        }

        private StyledText createCodeView(Composite parent) {
            int styles = 65538;
            StyledText styledText = new StyledText(parent, styles);
            styledText.setBackground(this.fBackgroundColor);
            styledText.setForeground(this.fForegroundColor);
            styledText.setEditable(false);
            return styledText;
        }

        private Label createLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            return label;
        }

        private Label createTitleLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            label.setFont(JFaceResources.getHeaderFont());
            this.fHeaderLabels.add(label);
            return label;
        }

        private Label createHeadingLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            label.setFont(JFaceResources.getBannerFont());
            this.fBannerLabels.add(label);
            return label;
        }

        private Button createButton(Composite parent, String text) {
            Button button = new Button(parent, 0x800000);
            button.setBackground(this.fBackgroundColor);
            button.setForeground(this.fForegroundColor);
            if (text != null) {
                button.setText(text);
            }
            return button;
        }

        private void updateCodeView(StyledText styledText, IClassFile classFile) {
            String content = null;
            int flags = 15;
            IClassFileReader classFileReader = ToolFactory.createDefaultClassFileReader((IClassFile)classFile, (int)flags);
            if (classFileReader != null) {
                IClassFileDisassembler disassembler = ToolFactory.createDefaultClassFileDisassembler();
                content = disassembler.disassemble(classFileReader, "\n");
            }
            styledText.setText(content == null ? "" : content);
        }

        static /* synthetic */ void access$0(SourceAttachmentForm sourceAttachmentForm, ScrolledComposite scrolledComposite) {
            sourceAttachmentForm.fScrolledComposite = scrolledComposite;
        }

        static /* synthetic */ Color access$1(SourceAttachmentForm sourceAttachmentForm) {
            return sourceAttachmentForm.fSeparatorColor;
        }

        static /* synthetic */ void access$2(SourceAttachmentForm sourceAttachmentForm, Color color) {
            sourceAttachmentForm.fSeparatorColor = color;
        }

        static /* synthetic */ List access$3(SourceAttachmentForm sourceAttachmentForm) {
            return sourceAttachmentForm.fBannerLabels;
        }

        static /* synthetic */ List access$4(SourceAttachmentForm sourceAttachmentForm) {
            return sourceAttachmentForm.fHeaderLabels;
        }

        static /* synthetic */ Font access$5(SourceAttachmentForm sourceAttachmentForm) {
            return sourceAttachmentForm.fFont;
        }

        static /* synthetic */ void access$6(SourceAttachmentForm sourceAttachmentForm, Font font) {
            sourceAttachmentForm.fFont = font;
        }

        static /* synthetic */ ScrolledComposite access$7(SourceAttachmentForm sourceAttachmentForm) {
            return sourceAttachmentForm.fScrolledComposite;
        }

        static /* synthetic */ ClassFileEditor access$8(SourceAttachmentForm sourceAttachmentForm) {
            return sourceAttachmentForm.ClassFileEditor.this;
        }
    }

    private class InputUpdater
    implements Runnable {
        private boolean fPosted = false;
        private IClassFileEditorInput fClassFileEditorInput;

        public void run() {
            IClassFileEditorInput input;
            InputUpdater inputUpdater = this;
            synchronized (inputUpdater) {
                input = this.fClassFileEditorInput;
            }
            try {
                if (ClassFileEditor.this.getSourceViewer() != null) {
                    ClassFileEditor.this.setInput(input);
                }
            }
            catch (Throwable throwable) {
                inputUpdater = null;
                InputUpdater inputUpdater2 = this;
                synchronized (inputUpdater2) {
                    this.fPosted = false;
                }
                throw throwable;
            }
            inputUpdater = null;
            InputUpdater inputUpdater3 = this;
            synchronized (inputUpdater3) {
                this.fPosted = false;
            }
        }

        public void post(IClassFileEditorInput input) {
            StyledText textWidget;
            ISourceViewer viewer;
            InputUpdater inputUpdater = this;
            synchronized (inputUpdater) {
                if (this.fPosted) {
                    if (input != null && input.equals(this.fClassFileEditorInput)) {
                        this.fClassFileEditorInput = input;
                    }
                    return;
                }
            }
            if (input != null && input.equals(ClassFileEditor.this.getEditorInput()) && (viewer = ClassFileEditor.this.getSourceViewer()) != null && (textWidget = viewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                InputUpdater inputUpdater2 = this;
                synchronized (inputUpdater2) {
                    this.fPosted = true;
                    this.fClassFileEditorInput = input;
                }
                textWidget.getDisplay().asyncExec((Runnable)this);
            }
        }
    }
}

