/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.GotoErrorAction;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.TogglePresentationAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class BasicJavaEditorActionContributor
extends BasicTextEditorActionContributor {
    private List fRetargetToolbarActions = new ArrayList();
    private List fPartListeners = new ArrayList();
    private TogglePresentationAction fTogglePresentation;
    private GotoErrorAction fPreviousError;
    private GotoErrorAction fNextError;
    private RetargetTextEditorAction fGotoMatchingBracket;
    private RetargetTextEditorAction fShowOutline;
    private RetargetTextEditorAction fOpenStructure;
    private RetargetAction fRetargetShowJavaDoc;
    private RetargetTextEditorAction fShowJavaDoc;
    private RetargetTextEditorAction fStructureSelectEnclosingAction;
    private RetargetTextEditorAction fStructureSelectNextAction;
    private RetargetTextEditorAction fStructureSelectPreviousAction;
    private RetargetTextEditorAction fStructureSelectHistoryAction;
    private RetargetTextEditorAction fGotoNextMemberAction;
    private RetargetTextEditorAction fGotoPreviousMemberAction;

    public BasicJavaEditorActionContributor() {
        ResourceBundle b = JavaEditorMessages.getResourceBundle();
        RetargetToolbarAction a = new RetargetToolbarAction(b, "TogglePresentation.", "togglePresentation", true);
        a.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.toggle.presentation");
        JavaPluginImages.setToolImageDescriptors((IAction)a, "segment_edit.gif");
        this.fRetargetToolbarActions.add(a);
        this.markAsPartListener(a);
        a = new RetargetToolbarAction(b, "NextError.", "gotoNextError", false);
        a.setActionDefinitionId("org.eclipse.ui.navigate.next");
        a.setImageDescriptor(JavaPluginImages.DESC_TOOL_GOTO_NEXT_ERROR);
        this.fRetargetToolbarActions.add(a);
        this.markAsPartListener(a);
        a = new RetargetToolbarAction(b, "PreviousError.", "gotoPreviousError", false);
        a.setActionDefinitionId("org.eclipse.ui.navigate.previous");
        a.setImageDescriptor(JavaPluginImages.DESC_TOOL_GOTO_PREV_ERROR);
        this.fRetargetToolbarActions.add(a);
        this.markAsPartListener(a);
        this.fRetargetShowJavaDoc = new RetargetAction("org.eclipse.jdt.ui.actions.ShowJavaDoc", JavaEditorMessages.getString("ShowJavaDoc.label"));
        this.fRetargetShowJavaDoc.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.javadoc");
        this.markAsPartListener(this.fRetargetShowJavaDoc);
        this.fTogglePresentation = new TogglePresentationAction();
        this.fPreviousError = new GotoErrorAction("PreviousError.", false);
        this.fPreviousError.setActionDefinitionId("org.eclipse.ui.navigate.previous");
        this.fPreviousError.setImageDescriptor(JavaPluginImages.DESC_TOOL_GOTO_PREV_ERROR);
        this.fNextError = new GotoErrorAction("NextError.", true);
        this.fNextError.setActionDefinitionId("org.eclipse.ui.navigate.next");
        this.fNextError.setImageDescriptor(JavaPluginImages.DESC_TOOL_GOTO_NEXT_ERROR);
        this.fGotoMatchingBracket = new RetargetTextEditorAction(b, "GotoMatchingBracket.");
        this.fGotoMatchingBracket.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.matching.bracket");
        this.fShowJavaDoc = new RetargetTextEditorAction(b, "ShowJavaDoc.");
        this.fShowJavaDoc.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.javadoc");
        this.fShowOutline = new RetargetTextEditorAction(JavaEditorMessages.getResourceBundle(), "ShowOutline.");
        this.fShowOutline.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.show.outline");
        this.fOpenStructure = new RetargetTextEditorAction(JavaEditorMessages.getResourceBundle(), "OpenStructure.");
        this.fOpenStructure.setActionDefinitionId("org.eclipse.jdt.ui.navigate.java.open.structure");
        this.fStructureSelectEnclosingAction = new RetargetTextEditorAction(b, "StructureSelectEnclosing.");
        this.fStructureSelectEnclosingAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.enclosing");
        this.fStructureSelectNextAction = new RetargetTextEditorAction(b, "StructureSelectNext.");
        this.fStructureSelectNextAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.next");
        this.fStructureSelectPreviousAction = new RetargetTextEditorAction(b, "StructureSelectPrevious.");
        this.fStructureSelectPreviousAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.previous");
        this.fStructureSelectHistoryAction = new RetargetTextEditorAction(b, "StructureSelectHistory.");
        this.fStructureSelectHistoryAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.select.last");
        this.fGotoNextMemberAction = new RetargetTextEditorAction(b, "GotoNextMember.");
        this.fGotoNextMemberAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.next.member");
        this.fGotoPreviousMemberAction = new RetargetTextEditorAction(b, "GotoPreviousMember.");
        this.fGotoPreviousMemberAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.goto.previous.member");
    }

    protected final void markAsPartListener(RetargetAction action) {
        this.fPartListeners.add(action);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        Iterator e = this.fPartListeners.iterator();
        while (e.hasNext()) {
            page.addPartListener((IPartListener)((RetargetAction)e.next()));
        }
        super.init(bars, page);
        bars.setGlobalActionHandler("next", (IAction)this.fNextError);
        bars.setGlobalActionHandler("previous", (IAction)this.fPreviousError);
        bars.setGlobalActionHandler("togglePresentation", (IAction)this.fTogglePresentation);
        bars.setGlobalActionHandler("gotoNextError", (IAction)this.fNextError);
        bars.setGlobalActionHandler("gotoPreviousError", (IAction)this.fPreviousError);
        bars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ShowJavaDoc", (IAction)this.fShowJavaDoc);
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager gotoMenu;
        IMenuManager navigateMenu;
        super.contributeToMenu(menu);
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IContributionItem)new Separator("group.open"));
            editMenu.add((IContributionItem)new Separator("group.generate"));
            editMenu.add((IContributionItem)new Separator("additions"));
            MenuManager structureSelection = new MenuManager(JavaEditorMessages.getString("ExpandSelectionMenu.label"), "expandSelection");
            structureSelection.add((IAction)this.fStructureSelectEnclosingAction);
            structureSelection.add((IAction)this.fStructureSelectNextAction);
            structureSelection.add((IAction)this.fStructureSelectPreviousAction);
            structureSelection.add((IAction)this.fStructureSelectHistoryAction);
            editMenu.appendToGroup("group.open", (IContributionItem)structureSelection);
            editMenu.appendToGroup("group.generate", (IAction)this.fRetargetShowJavaDoc);
        }
        if ((navigateMenu = menu.findMenuUsingPath("navigate")) != null) {
            navigateMenu.appendToGroup("show.ext", (IAction)this.fShowOutline);
        }
        if ((gotoMenu = menu.findMenuUsingPath("navigate/goTo")) != null) {
            gotoMenu.add((IContributionItem)new Separator("additions2"));
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoPreviousMemberAction);
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoNextMemberAction);
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoMatchingBracket);
        }
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator());
        Iterator e = this.fRetargetToolbarActions.iterator();
        while (e.hasNext()) {
            tbm.add((IAction)e.next());
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        IActionBars actionBars = this.getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        manager.setMessage(null);
        manager.setErrorMessage(null);
        ITextEditor textEditor = null;
        if (part instanceof ITextEditor) {
            textEditor = (ITextEditor)part;
        }
        this.fTogglePresentation.setEditor(textEditor);
        this.fPreviousError.setEditor(textEditor);
        this.fNextError.setEditor(textEditor);
        this.fGotoMatchingBracket.setAction(this.getAction(textEditor, "GotoMatchingBracket"));
        this.fShowJavaDoc.setAction(this.getAction(textEditor, "ShowJavaDoc"));
        this.fShowOutline.setAction(this.getAction(textEditor, "org.eclipse.jdt.ui.edit.text.java.show.outline"));
        this.fOpenStructure.setAction(this.getAction(textEditor, "org.eclipse.jdt.ui.navigate.java.open.structure"));
        this.fStructureSelectEnclosingAction.setAction(this.getAction(textEditor, "SelectEnclosingElement"));
        this.fStructureSelectNextAction.setAction(this.getAction(textEditor, "SelectNextElement"));
        this.fStructureSelectPreviousAction.setAction(this.getAction(textEditor, "SelectPreviousElement"));
        this.fStructureSelectHistoryAction.setAction(this.getAction(textEditor, "RestoreLastSelection"));
        this.fGotoNextMemberAction.setAction(this.getAction(textEditor, "GoToNextMember"));
        this.fGotoPreviousMemberAction.setAction(this.getAction(textEditor, "GoToPreviousMember"));
        if (part instanceof JavaEditor) {
            JavaEditor javaEditor = (JavaEditor)part;
            javaEditor.getActionGroup().fillActionBars(this.getActionBars());
        }
    }

    public void dispose() {
        Iterator e = this.fPartListeners.iterator();
        while (e.hasNext()) {
            this.getPage().removePartListener((IPartListener)((RetargetAction)e.next()));
        }
        this.fPartListeners.clear();
        this.setActiveEditor(null);
        super.dispose();
    }

    protected static class RetargetToolbarAction
    extends RetargetAction {
        private String fDefaultLabel = this.getText();

        public RetargetToolbarAction(ResourceBundle bundle, String prefix, String actionId, boolean checkStyle) {
            super(actionId, RetargetToolbarAction.getLabel(bundle, prefix));
            if (checkStyle) {
                this.setChecked(true);
            }
        }

        private static String getLabel(ResourceBundle bundle, String prefix) {
            try {
                return bundle.getString(String.valueOf(prefix) + "label");
            }
            catch (MissingResourceException missingResourceException) {
                return "label";
            }
        }

        protected void propagateChange(PropertyChangeEvent event) {
            if ("enabled".equals(event.getProperty())) {
                Boolean bool = (Boolean)event.getNewValue();
                this.setEnabled(bool);
            } else if ("text".equals(event.getProperty())) {
                this.setText((String)event.getNewValue());
            } else if ("toolTipText".equals(event.getProperty())) {
                this.setToolTipText((String)event.getNewValue());
            } else if ("checked".equals(event.getProperty())) {
                Boolean bool = (Boolean)event.getNewValue();
                this.setChecked(bool);
            }
        }

        protected void setActionHandler(IAction newHandler) {
            super.setActionHandler(newHandler);
            if (newHandler != null) {
                this.setText(newHandler.getText());
                this.setToolTipText(newHandler.getToolTipText());
                this.setDescription(newHandler.getDescription());
                this.setImageDescriptor(newHandler.getImageDescriptor());
                this.setHoverImageDescriptor(newHandler.getHoverImageDescriptor());
                this.setDisabledImageDescriptor(newHandler.getDisabledImageDescriptor());
                this.setMenuCreator(newHandler.getMenuCreator());
                if (newHandler.getStyle() == 2) {
                    this.setChecked(newHandler.isChecked());
                }
            } else {
                this.setText(this.fDefaultLabel);
                this.setToolTipText(this.fDefaultLabel);
                this.setDescription(this.fDefaultLabel);
                this.setChecked(false);
            }
        }
    }
}

