/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.jface.util.Assert;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavadocWriter {
    private OutputStream fOutputStream;
    private IJavaProject fJavaProject;
    private IPath fBasePath;

    public JavadocWriter(OutputStream outputStream, IPath basePath, IJavaProject project) {
        Assert.isNotNull((Object)outputStream);
        this.fOutputStream = new BufferedOutputStream(outputStream);
        this.fBasePath = basePath;
        this.fJavaProject = project;
    }

    public void writeXML(JavadocOptionsManager store) throws IOException, CoreException {
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException();
        }
        Document document = docBuilder.newDocument();
        Element project = document.createElement("project");
        document.appendChild(project);
        project.setAttribute("name", this.fJavaProject.getElementName());
        project.setAttribute("default", "javadoc");
        Element javadocTarget = document.createElement("target");
        project.appendChild(javadocTarget);
        javadocTarget.setAttribute("name", "javadoc");
        Element xmlJavadocDesc = document.createElement("javadoc");
        javadocTarget.appendChild(xmlJavadocDesc);
        if (!store.fromStandard()) {
            this.xmlWriteDoclet(store, document, xmlJavadocDesc);
        } else {
            this.xmlWriteJavadocStandardParams(store, document, xmlJavadocDesc);
        }
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        SerializerFactory serializerFactory = SerializerFactory.getSerializerFactory((String)"xml");
        Serializer serializer = serializerFactory.makeSerializer(this.fOutputStream, format);
        serializer.asDOMSerializer().serialize(document);
    }

    private void xmlWriteJavadocStandardParams(JavadocOptionsManager store, Document document, Element xmlJavadocDesc) throws DOMException, CoreException {
        String destination = this.getPathString((IPath)new Path(store.getDestination()));
        xmlJavadocDesc.setAttribute("destdir", destination);
        xmlJavadocDesc.setAttribute("access", store.getAccess());
        if (store.isJDK14Mode()) {
            xmlJavadocDesc.setAttribute("source", "1.4");
        }
        xmlJavadocDesc.setAttribute("use", this.booleanToString(store.getBoolean("use")));
        xmlJavadocDesc.setAttribute("notree", this.booleanToString(store.getBoolean("notree")));
        xmlJavadocDesc.setAttribute("nonavbar", this.booleanToString(store.getBoolean("nonavbar")));
        xmlJavadocDesc.setAttribute("noindex", this.booleanToString(store.getBoolean("noindex")));
        xmlJavadocDesc.setAttribute("splitindex", this.booleanToString(store.getBoolean("splitindex")));
        xmlJavadocDesc.setAttribute("author", this.booleanToString(store.getBoolean("author")));
        xmlJavadocDesc.setAttribute("version", this.booleanToString(store.getBoolean("version")));
        xmlJavadocDesc.setAttribute("nodeprecatedlist", this.booleanToString(store.getBoolean("nodeprecatedlist")));
        xmlJavadocDesc.setAttribute("nodeprecated", this.booleanToString(store.getBoolean("nodeprecated")));
        ArrayList packages = new ArrayList();
        ArrayList sourcefiles = new ArrayList();
        this.sortSourceElement(store.getSourceElements(), sourcefiles, packages);
        if (!packages.isEmpty()) {
            xmlJavadocDesc.setAttribute("packagenames", this.toSeparatedList(packages));
        }
        if (!sourcefiles.isEmpty()) {
            xmlJavadocDesc.setAttribute("sourcefiles", this.toSeparatedList(sourcefiles));
        }
        xmlJavadocDesc.setAttribute("sourcepath", this.getPathString(store.getSourcepath()));
        xmlJavadocDesc.setAttribute("classpath", this.getPathString(store.getClasspath()));
        String str = store.getOverview();
        if (str.length() > 0) {
            xmlJavadocDesc.setAttribute("overview", str);
        }
        if ((str = store.getStyleSheet()).length() > 0) {
            xmlJavadocDesc.setAttribute("stylesheetfile", str);
        }
        if ((str = store.getTitle()).length() > 0) {
            xmlJavadocDesc.setAttribute("doctitle", str);
        }
        if ((str = store.getAdditionalParams()).length() > 0) {
            xmlJavadocDesc.setAttribute("additionalparam", str);
        }
        String hrefs = store.getDependencies();
        StringTokenizer tokenizer = new StringTokenizer(hrefs, ";");
        while (tokenizer.hasMoreElements()) {
            String href = (String)tokenizer.nextElement();
            Element links = document.createElement("link");
            xmlJavadocDesc.appendChild(links);
            links.setAttribute("href", href);
        }
    }

    private void sortSourceElement(IJavaElement[] iJavaElements, List sourcefiles, List packages) {
        int i = 0;
        while (i < iJavaElements.length) {
            IJavaElement element = iJavaElements[i];
            IPath p = element.getResource().getLocation();
            if (p != null) {
                if (element instanceof ICompilationUnit) {
                    String relative = this.getPathString(p);
                    sourcefiles.add(relative);
                } else if (element instanceof IPackageFragment) {
                    packages.add(element.getElementName());
                }
            }
            ++i;
        }
    }

    private String getPathString(IPath[] paths) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            if (buf.length() != 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(this.getPathString(paths[i]));
            ++i;
        }
        if (buf.length() == 0) {
            buf.append('.');
        }
        return buf.toString();
    }

    private boolean hasSameDevice(IPath p1, IPath p2) {
        String dev = p1.getDevice();
        if (dev == null) {
            return p2.getDevice() == null;
        }
        return dev.equals(p2.getDevice());
    }

    private String getPathString(IPath fullPath) {
        if (this.fBasePath == null || !this.hasSameDevice(fullPath, this.fBasePath)) {
            return fullPath.toOSString();
        }
        int matchingSegments = this.fBasePath.matchingFirstSegments(fullPath);
        if (this.fBasePath.segmentCount() == matchingSegments) {
            return this.getRelativePath(fullPath, matchingSegments);
        }
        IProject proj = this.fJavaProject.getProject();
        IPath projLoc = proj.getLocation();
        if (projLoc.segmentCount() <= matchingSegments && projLoc.isPrefixOf(fullPath)) {
            return this.getRelativePath(fullPath, matchingSegments);
        }
        IPath workspaceLoc = proj.getWorkspace().getRoot().getLocation();
        if (workspaceLoc.segmentCount() <= matchingSegments && workspaceLoc.isPrefixOf(fullPath)) {
            return this.getRelativePath(fullPath, matchingSegments);
        }
        return fullPath.toOSString();
    }

    private String getRelativePath(IPath fullPath, int matchingSegments) {
        StringBuffer res = new StringBuffer();
        int backSegments = this.fBasePath.segmentCount() - matchingSegments;
        while (backSegments > 0) {
            res.append("..");
            res.append(File.separatorChar);
            --backSegments;
        }
        int segCount = fullPath.segmentCount();
        int i = matchingSegments;
        while (i < segCount) {
            if (i > matchingSegments) {
                res.append(File.separatorChar);
            }
            res.append(fullPath.segment(i));
            ++i;
        }
        return res.toString();
    }

    private void xmlWriteDoclet(JavadocOptionsManager store, Document document, Element xmlJavadocDesc) throws DOMException, CoreException {
        ArrayList packages = new ArrayList();
        ArrayList sourcefiles = new ArrayList();
        this.sortSourceElement(store.getSourceElements(), sourcefiles, packages);
        if (!packages.isEmpty()) {
            xmlJavadocDesc.setAttribute("packagenames", this.toSeparatedList(packages));
        }
        if (!sourcefiles.isEmpty()) {
            xmlJavadocDesc.setAttribute("sourcefiles", this.toSeparatedList(sourcefiles));
        }
        xmlJavadocDesc.setAttribute("sourcepath", this.getPathString(store.getSourcepath()));
        xmlJavadocDesc.setAttribute("classpath", this.getPathString(store.getClasspath()));
        xmlJavadocDesc.setAttribute("access", store.getAccess());
        Element doclet = document.createElement("doclet");
        xmlJavadocDesc.appendChild(doclet);
        doclet.setAttribute("name", store.getDocletName());
        doclet.setAttribute("path", store.getDocletPath());
        String str = store.getOverview();
        if (str.length() > 0) {
            xmlJavadocDesc.setAttribute("overview", str);
        }
        if ((str = store.getAdditionalParams()).length() > 0) {
            xmlJavadocDesc.setAttribute("additionalparam", str);
        }
    }

    private String toSeparatedList(List packages) throws JavaModelException {
        StringBuffer buf = new StringBuffer();
        Iterator iter = packages.iterator();
        int nAdded = 0;
        while (iter.hasNext()) {
            if (nAdded > 0) {
                buf.append(",");
            }
            ++nAdded;
            String curr = (String)iter.next();
            buf.append(curr);
        }
        return buf.toString();
    }

    private String booleanToString(boolean bool) {
        if (bool) {
            return "true";
        }
        return "false";
    }

    public void close() throws IOException {
        if (this.fOutputStream != null) {
            this.fOutputStream.close();
        }
    }
}

