/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.jarpackager.ConfirmSaveModifiedResourcesDialog;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocSpecificsWizardPage;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocStandardWizardPage;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocTreeWizardPage;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;

public class JavadocWizard
extends Wizard
implements IExportWizard {
    private JavadocTreeWizardPage fJTWPage;
    private JavadocSpecificsWizardPage fJSWPage;
    private JavadocStandardWizardPage fJSpWPage;
    private IPath fDestination;
    private boolean fWriteCustom;
    private boolean fOpenInBrowser;
    protected final String TreePageDesc = "JavadocTreePage";
    protected final String SpecificsPageDesc = "JavadocSpecificsPage";
    protected final String StandardPageDesc = "JavadocStandardPage";
    private final int YES = 0;
    private final int YES_TO_ALL = 1;
    private final int NO = 2;
    private final int NO_TO_ALL = 3;
    private final String JAVADOC_ANT_INFORMATION_DIALOG = "javadocAntInformationDialog";
    private JavadocOptionsManager fStore;
    private IWorkspaceRoot fRoot;
    private Set fSelectedProjects;
    private IFile fXmlJavadocFile;

    public JavadocWizard() {
        this(null);
    }

    public JavadocWizard(IFile xmlJavadocFile) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_EXPORT_JAVADOC);
        this.setWindowTitle(JavadocExportMessages.getString("JavadocWizard.javadocwizard.title"));
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fXmlJavadocFile = xmlJavadocFile;
        this.fWriteCustom = false;
        this.fSelectedProjects = null;
    }

    public boolean performFinish() {
        IJavaProject[] projects = this.fSelectedProjects.toArray(new IJavaProject[this.fSelectedProjects.size()]);
        this.fJTWPage.finish();
        if (!this.fJTWPage.getCustom()) {
            this.fJSpWPage.finish();
        }
        this.fJSWPage.finish();
        if (!this.checkPreconditions(this.fStore.getSourceElements())) {
            return false;
        }
        this.fDestination = new Path(this.fStore.getDestination());
        this.fDestination.toFile().mkdirs();
        this.fOpenInBrowser = this.fStore.doOpenInBrowser();
        if (this.fStore.fromStandard()) {
            try {
                URL newURL = this.fDestination.toFile().toURL();
                ArrayList<IJavaProject> projs = new ArrayList<IJavaProject>();
                int i = 0;
                while (i < projects.length) {
                    IJavaProject iJavaProject = projects[i];
                    URL currURL = JavaUI.getProjectJavadocLocation(iJavaProject);
                    if (!newURL.equals(currURL)) {
                        projs.add(iJavaProject);
                    }
                    ++i;
                }
                if (!projs.isEmpty()) {
                    this.setAllJavadocLocations(projs.toArray(new IJavaProject[projs.size()]), newURL);
                }
            }
            catch (MalformedURLException e) {
                JavaPlugin.log(e);
            }
        }
        if (this.fJSWPage.generateAnt()) {
            OptionalMessageDialog.open("javadocAntInformationDialog", this.getShell(), JavadocExportMessages.getString("JavadocWizard.antInformationDialog.title"), Window.getDefaultImage(), JavadocExportMessages.getString("JavadocWizard.antInformationDialog.message"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.fStore.createXML();
        }
        if (this.fXmlJavadocFile == null) {
            this.getDialogSettings().addSection(this.fStore.createDialogSettings());
        }
        try {
            if (!this.executeJavadocGeneration(this.fStore.createArgumentArray())) {
                return false;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return false;
        }
        return true;
    }

    public void setAllJavadocLocations(IJavaProject[] projects, URL newURL) {
        int j = 0;
        while (j < projects.length) {
            IJavaProject iJavaProject = projects[j];
            String message = JavadocExportMessages.getFormattedString("JavadocWizard.updatejavadoclocation.message", new String[]{iJavaProject.getElementName(), this.fDestination.toOSString()});
            String[] buttonlabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL};
            MessageDialog dialog = new MessageDialog(this.getShell(), JavadocExportMessages.getString("JavadocWizard.updatejavadocdialog.label"), Dialog.getImage((String)"dialog_question_image"), message, 4, buttonlabels, 1);
            switch (dialog.open()) {
                case 0: {
                    JavaUI.setProjectJavadocLocation(iJavaProject, newURL);
                    break;
                }
                case 1: {
                    int i = j;
                    while (i < projects.length) {
                        iJavaProject = projects[i];
                        JavaUI.setProjectJavadocLocation(iJavaProject, newURL);
                        ++j;
                        ++i;
                    }
                    break;
                }
                case 3: {
                    j = projects.length;
                    break;
                }
            }
            ++j;
        }
    }

    private boolean executeJavadocGeneration(String[] args) {
        block5: {
            Process process = null;
            try {
                process = Runtime.getRuntime().exec(args);
                if (process == null) break block5;
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < args.length) {
                    buf.append(args[i]);
                    buf.append(' ');
                    ++i;
                }
                JavadocDebugEventListener listener = new JavadocDebugEventListener();
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)listener);
                ILaunchConfigurationWorkingCopy wc = null;
                try {
                    ILaunchConfigurationType lcType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
                    String name = JavadocExportMessages.getString("JavadocWizard.launchconfig.name");
                    wc = lcType.newInstance(null, name);
                    wc.setAttribute(IDebugUIConstants.ATTR_TARGET_RUN_PERSPECTIVE, null);
                    wc.setAttribute(IDebugUIConstants.ATTR_PRIVATE, true);
                    Launch newLaunch = new Launch((ILaunchConfiguration)wc, "run", null);
                    IProcess iprocess = DebugPlugin.newProcess((ILaunch)newLaunch, (Process)process, (String)JavadocExportMessages.getString("JavadocWizard.javadocprocess.label"));
                    iprocess.setAttribute(IProcess.ATTR_CMDLINE, buf.toString());
                    DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)newLaunch);
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
                return true;
            }
            catch (IOException e) {
                JavaPlugin.log(e);
                return false;
            }
        }
        return false;
    }

    private boolean checkPreconditions(IJavaElement[] elements) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof ICompilationUnit) {
                resources.add(elements[i].getResource());
            }
            ++i;
        }
        IFile[] unSavedFiles = this.getUnsavedFiles(resources);
        return this.saveModifiedResourcesIfUserConfirms(unSavedFiles);
    }

    private IFile[] getUnsavedFiles(List resources) {
        IEditorPart[] dirtyEditors = JavaPlugin.getDirtyEditors();
        HashSet<IFile> unsavedFiles = new HashSet<IFile>(dirtyEditors.length);
        if (dirtyEditors.length > 0) {
            int i = 0;
            while (i < dirtyEditors.length) {
                IFile dirtyFile;
                if (dirtyEditors[i].getEditorInput() instanceof IFileEditorInput && resources.contains(dirtyFile = ((IFileEditorInput)dirtyEditors[i].getEditorInput()).getFile())) {
                    unsavedFiles.add(dirtyFile);
                }
                ++i;
            }
        }
        return unsavedFiles.toArray(new IFile[unsavedFiles.size()]);
    }

    private boolean saveModifiedResourcesIfUserConfirms(IFile[] dirtyFiles) {
        if (this.confirmSaveModifiedResources(dirtyFiles)) {
            try {
                if (this.saveModifiedResources(dirtyFiles)) {
                    return true;
                }
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, this.getShell(), JavadocExportMessages.getString("JavadocWizard.saveresourcedialogCE.title"), JavadocExportMessages.getString("JavadocWizard.saveresourcedialogCE.message"));
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), JavadocExportMessages.getString("JavadocWizard.saveresourcedialogITE.title"), JavadocExportMessages.getString("JavadocWizard.saveresourcedialogITE.message"));
            }
        }
        return false;
    }

    private boolean confirmSaveModifiedResources(IFile[] dirtyFiles) {
        if (dirtyFiles == null || dirtyFiles.length == 0) {
            return true;
        }
        Display display = this.getShell().getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        final ConfirmSaveModifiedResourcesDialog dlg = new ConfirmSaveModifiedResourcesDialog(this.getShell(), dirtyFiles);
        final int[] intResult = new int[1];
        Runnable runnable = new Runnable(){

            public void run() {
                intResult[0] = dlg.open();
            }
        };
        display.syncExec(runnable);
        return intResult[0] == 0;
    }

    private boolean saveModifiedResources(IFile[] dirtyFiles) throws CoreException, InvocationTargetException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        boolean autoBuild = description.isAutoBuilding();
        description.setAutoBuilding(false);
        try {
            workspace.setDescription(description);
            try {
                new ProgressMonitorDialog(this.getShell()).run(false, false, this.createSaveModifiedResourcesRunnable(dirtyFiles));
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
                throw throwable;
            }
            Object var5_7 = null;
            description.setAutoBuilding(autoBuild);
            workspace.setDescription(description);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private IRunnableWithProgress createSaveModifiedResourcesRunnable(final IFile[] dirtyFiles) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                IEditorPart[] editorsToSave = JavaPlugin.getDirtyEditors();
                String name = JavadocExportMessages.getString("JavadocWizard.savetask.name");
                pm.beginTask(name, editorsToSave.length);
                try {
                    List<IFile> dirtyFilesList = Arrays.asList(dirtyFiles);
                    int i = 0;
                    while (i < editorsToSave.length) {
                        IFile dirtyFile;
                        if (editorsToSave[i].getEditorInput() instanceof IFileEditorInput && dirtyFilesList.contains(dirtyFile = ((IFileEditorInput)editorsToSave[i].getEditorInput()).getFile())) {
                            editorsToSave[i].doSave((IProgressMonitor)new SubProgressMonitor(pm, 1));
                        }
                        pm.worked(1);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    pm.done();
                    throw throwable;
                }
                Object var7_9 = null;
                pm.done();
            }
        };
    }

    public void addPages() {
        this.fJTWPage = new JavadocTreeWizardPage("JavadocTreePage", this.fStore);
        this.fJSWPage = new JavadocSpecificsWizardPage("JavadocSpecificsPage", this.fStore);
        this.fJSpWPage = new JavadocStandardWizardPage("JavadocStandardPage", this.fStore);
        super.addPage((IWizardPage)this.fJTWPage);
        super.addPage((IWizardPage)this.fJSpWPage);
        super.addPage((IWizardPage)this.fJSWPage);
        this.fJTWPage.init();
        this.fJSpWPage.init();
        this.fJSWPage.init();
    }

    public void init(IWorkbench workbench, IStructuredSelection structuredSelection) {
        IDialogSettings settings = this.getDialogSettings().getSection("javadoc");
        this.fStore = new JavadocOptionsManager(this.fXmlJavadocFile, settings, (ISelection)structuredSelection);
        this.fSelectedProjects = new HashSet(this.fStore.getJavaProjects());
    }

    private void refresh(IPath path) {
        if (this.fRoot.findContainersForLocation(path).length > 0) {
            try {
                this.fRoot.refreshLocal(2, null);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private void spawnInBrowser() {
        if (this.fOpenInBrowser) {
            try {
                IPath indexFile = this.fDestination.append("index.html");
                URL url = indexFile.toFile().toURL();
                OpenBrowserUtil.open(url, this.getShell(), this.getWindowTitle());
            }
            catch (MalformedURLException e) {
                JavaPlugin.log(e);
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof JavadocTreeWizardPage) {
            if (!this.fJTWPage.getCustom()) {
                return this.fJSpWPage;
            }
            return this.fJSWPage;
        }
        if (page instanceof JavadocSpecificsWizardPage) {
            return null;
        }
        if (page instanceof JavadocStandardWizardPage) {
            return this.fJSWPage;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page instanceof JavadocSpecificsWizardPage) {
            if (!this.fJTWPage.getCustom()) {
                return this.fJSpWPage;
            }
            return this.fJSWPage;
        }
        if (page instanceof JavadocTreeWizardPage) {
            return null;
        }
        if (page instanceof JavadocStandardWizardPage) {
            return this.fJTWPage;
        }
        return null;
    }

    protected void setSelectedProjects(Set projects) {
        this.fSelectedProjects = projects;
    }

    protected Set getSelectedProjects() {
        return this.fSelectedProjects;
    }

    protected void addSelectedProject(IJavaProject project) {
        this.fSelectedProjects.add(project);
    }

    protected void removeSelectedProject(IJavaProject project) {
        if (this.fSelectedProjects.contains(project)) {
            this.fSelectedProjects.remove(project);
        }
    }

    void removeAllProjects() {
        this.fSelectedProjects.clear();
    }

    private class JavadocDebugEventListener
    implements IDebugEventSetListener {
        JavadocDebugEventListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                if (events[i].getKind() == 8) {
                    try {
                        if (!JavadocWizard.this.fWriteCustom) {
                            JavadocWizard.this.refresh(JavadocWizard.this.fDestination);
                            JavadocWizard.this.spawnInBrowser();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        throw throwable;
                    }
                    Object var3_5 = null;
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    return;
                }
                ++i;
            }
        }
    }
}

