/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocLinkDialogLabelProvider;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocWizard;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocWizardPage;
import org.eclipse.jdt.internal.ui.preferences.JavadocConfigurationBlock;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavadocStandardWizardPage
extends JavadocWizardPage {
    private JavadocOptionsManager fStore;
    private JavadocWizard fWizard;
    private Composite fUpperComposite;
    private Group fBasicOptionsGroup;
    private Group fTagsGroup;
    private Button fTitleButton;
    private Text fTitleText;
    protected Text fStyleSheetText;
    protected FlaggedButton fDeprecatedList;
    protected FlaggedButton fAuthorCheck;
    protected FlaggedButton fVersionCheck;
    protected FlaggedButton fDeprecatedCheck;
    protected FlaggedButton fHierarchyCheck;
    protected FlaggedButton fNavigatorCheck;
    protected FlaggedButton fIndexCheck;
    protected FlaggedButton fSeperatedIndexCheck;
    protected FlaggedButton fUse;
    protected Button fStyleSheetBrowseButton;
    protected Button fStyleSheetButton;
    private CheckedListDialogField fListDialogField;
    private final int STYLESHEETSTATUS = 0;
    private StatusInfo fStyleSheetStatus;
    protected ArrayList fButtonsList;
    private Map fTempLinks;

    public JavadocStandardWizardPage(String pageName, JavadocOptionsManager store) {
        super(pageName);
        this.setDescription(JavadocExportMessages.getString("JavadcoStandardWizardPage.description"));
        this.fStore = store;
        this.fButtonsList = new ArrayList();
        this.fStyleSheetStatus = new StatusInfo();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fWizard = (JavadocWizard)this.getWizard();
        this.fUpperComposite = new Composite(parent, 0);
        this.fUpperComposite.setLayoutData((Object)this.createGridData(1808, 1, 0));
        GridLayout layout = this.createGridLayout(4);
        layout.marginHeight = 0;
        this.fUpperComposite.setLayout((Layout)layout);
        this.createBasicOptionsGroup(this.fUpperComposite);
        this.createTagOptionsGroup(this.fUpperComposite);
        this.createListDialogField(this.fUpperComposite);
        this.createStyleSheetGroup(this.fUpperComposite);
        this.setControl((Control)this.fUpperComposite);
        Dialog.applyDialogFont((Control)this.fUpperComposite);
        WorkbenchHelp.setHelp((Control)this.fUpperComposite, (String)"org.eclipse.jdt.ui.javadoc_standard_page_context");
    }

    private void createBasicOptionsGroup(Composite composite) {
        this.fTitleButton = this.createButton(composite, 32, JavadocExportMessages.getString("JavadcoStandardWizardPage.titlebutton.label"), this.createGridData(1));
        this.fTitleText = this.createText(composite, 2052, null, this.createGridData(768, 3, 0));
        String text = this.fStore.getTitle();
        if (!text.equals("")) {
            this.fTitleText.setText(text);
            this.fTitleButton.setSelection(true);
        } else {
            this.fTitleText.setEnabled(false);
        }
        this.fBasicOptionsGroup = new Group(composite, 16);
        this.fBasicOptionsGroup.setLayout((Layout)this.createGridLayout(1));
        this.fBasicOptionsGroup.setLayoutData((Object)this.createGridData(1808, 2, 0));
        this.fBasicOptionsGroup.setText(JavadocExportMessages.getString("JavadcoStandardWizardPage.basicgroup.label"));
        this.fUse = new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.getString("JavadcoStandardWizardPage.usebutton.label"), new GridData(768), "use", true);
        this.fHierarchyCheck = new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.getString("JavadcoStandardWizardPage.hierarchybutton.label"), new GridData(768), "notree", false);
        this.fNavigatorCheck = new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.getString("JavadcoStandardWizardPage.navigartorbutton.label"), new GridData(768), "nonavbar", false);
        this.fIndexCheck = new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.getString("JavadcoStandardWizardPage.indexbutton.label"), new GridData(768), "noindex", false);
        this.fSeperatedIndexCheck = new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.getString("JavadcoStandardWizardPage.seperateindexbutton.label"), this.createGridData(512, 1, this.convertWidthInCharsToPixels(3)), "splitindex", true);
        this.fSeperatedIndexCheck.getButton().setEnabled(this.fIndexCheck.getButton().getSelection());
        this.fIndexCheck.getButton().addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fSeperatedIndexCheck.getButton()}){

            public void validate() {
            }
        });
        this.fTitleButton.addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fTitleText}){

            public void validate() {
            }
        });
    }

    private void createTagOptionsGroup(Composite composite) {
        this.fTagsGroup = new Group(composite, 16);
        this.fTagsGroup.setLayout((Layout)this.createGridLayout(1));
        this.fTagsGroup.setLayoutData((Object)this.createGridData(1808, 2, 0));
        this.fTagsGroup.setText(JavadocExportMessages.getString("JavadcoStandardWizardPage.tagsgroup.label"));
        this.fAuthorCheck = new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.getString("JavadcoStandardWizardPage.authorbutton.label"), new GridData(768), "author", true);
        this.fVersionCheck = new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.getString("JavadcoStandardWizardPage.versionbutton.label"), new GridData(768), "version", true);
        this.fDeprecatedCheck = new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.getString("JavadcoStandardWizardPage.deprecatedbutton.label"), new GridData(768), "nodeprecated", false);
        this.fDeprecatedList = new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.getString("JavadcoStandardWizardPage.deprecatedlistbutton.label"), this.createGridData(768, 1, this.convertWidthInCharsToPixels(3)), "nodeprecatedlist", false);
        this.fDeprecatedList.getButton().setEnabled(this.fDeprecatedCheck.getButton().getSelection());
        this.fDeprecatedCheck.getButton().addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fDeprecatedList.getButton()}){

            public void validate() {
            }
        });
    }

    private void createStyleSheetGroup(Composite composite) {
        Composite c = new Composite(composite, 0);
        c.setLayout((Layout)this.createGridLayout(3));
        c.setLayoutData((Object)this.createGridData(768, 4, 0));
        ((GridLayout)c.getLayout()).marginWidth = 0;
        this.fStyleSheetButton = this.createButton(c, 32, JavadocExportMessages.getString("JavadcoStandardWizardPage.stylesheettext.label"), this.createGridData(1));
        this.fStyleSheetText = this.createText(c, 2052, null, this.createGridData(768, 1, 0));
        ((GridData)this.fStyleSheetText.getLayoutData()).widthHint = 200;
        this.fStyleSheetBrowseButton = this.createButton(c, 8, JavadocExportMessages.getString("JavadocStandardWizardPage.stylesheetbrowsebutton.label"), this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fStyleSheetBrowseButton);
        String str = this.fStore.getStyleSheet();
        if (str.equals("")) {
            this.fStyleSheetText.setEnabled(false);
            this.fStyleSheetBrowseButton.setEnabled(false);
        } else {
            this.fStyleSheetButton.setSelection(true);
            this.fStyleSheetText.setText(str);
        }
        this.fStyleSheetButton.addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fStyleSheetText, this.fStyleSheetBrowseButton}){

            public void validate() {
                JavadocStandardWizardPage.this.doValidation(0);
            }
        });
        this.fStyleSheetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocStandardWizardPage.this.doValidation(0);
            }
        });
        this.fStyleSheetBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavadocStandardWizardPage.this.handleFileBrowseButtonPressed(JavadocStandardWizardPage.this.fStyleSheetText, new String[]{"*.css"}, JavadocExportMessages.getString("JavadocSpecificsWizardPage.stylesheetbrowsedialog.title"));
            }
        });
    }

    private void createListDialogField(Composite composite) {
        Composite c = new Composite(composite, 0);
        c.setLayout((Layout)this.createGridLayout(3));
        c.setLayoutData((Object)this.createGridData(1808, 4, 0));
        ((GridLayout)c.getLayout()).marginWidth = 0;
        String[] buttonlabels = new String[]{JavadocExportMessages.getString("JavadcoStandardWizardPage.selectallbutton.label"), JavadocExportMessages.getString("JavadcoStandardWizardPage.clearallbutton.label"), JavadocExportMessages.getString("JavadocStandardWizardPage.configurebutton.label")};
        JavadocLinkDialogLabelProvider labelProvider = new JavadocLinkDialogLabelProvider();
        this.fListDialogField = new CheckedListDialogField(new ListAdapter(), buttonlabels, (ILabelProvider)labelProvider);
        this.fListDialogField.setCheckAllButtonIndex(0);
        this.fListDialogField.setUncheckAllButtonIndex(1);
        this.createLabel(c, 0, JavadocExportMessages.getString("JavadcoStandardWizardPage.referencedclasses.label"), this.createGridData(32, 4, 0));
        this.fListDialogField.doFillIntoGrid(c, 3);
        LayoutUtil.setHorizontalGrabbing(this.fListDialogField.getListControl(null));
        this.fListDialogField.enableButton(2, false);
        this.fTempLinks = this.createTempLinksStore();
        this.updateCheckedListGroup();
    }

    private Map createTempLinksStore() {
        HashMap<IJavaProject, String> temp = new HashMap<IJavaProject, String>();
        IProject[] projects = this.fStore.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject iProject = projects[i];
            IJavaProject javaProject = JavaCore.create((IProject)iProject);
            if (javaProject != null) {
                String links = this.fStore.getLinks(javaProject);
                temp.put(javaProject, links);
            }
            ++i;
        }
        return temp;
    }

    private void checkListDialogFieldElements(List referencedClasses, IJavaProject[] projects) {
        ArrayList<IJavaElement> checkedElements = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < projects.length) {
            IJavaProject iJavaProject = projects[i];
            String hrefs = (String)this.fTempLinks.get(iJavaProject);
            URL url = null;
            if (!hrefs.equals("")) {
                Iterator iterator = referencedClasses.iterator();
                block3: while (iterator.hasNext()) {
                    IJavaElement element = (IJavaElement)iterator.next();
                    try {
                        url = JavaUI.getJavadocBaseLocation(element);
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                        continue;
                    }
                    StringTokenizer tokenizer = new StringTokenizer(hrefs, ";");
                    while (tokenizer.hasMoreElements()) {
                        String href = (String)tokenizer.nextElement();
                        if (url == null || !href.equals(url.toExternalForm())) continue;
                        if (checkedElements.contains(element)) continue block3;
                        checkedElements.add(element);
                        continue block3;
                    }
                }
            }
            ++i;
        }
        this.fListDialogField.setCheckedElements(checkedElements);
    }

    private void findRE(List referencedClasses, IJavaProject[] jprojects, List visisted) throws JavaModelException {
        int j = 0;
        while (j < jprojects.length) {
            IJavaProject iJavaProject = jprojects[j];
            this.findReferencedElements(referencedClasses, iJavaProject, new ArrayList());
            ++j;
        }
    }

    private void findReferencedElements(List referencedClasses, IJavaProject jproject, List visited) throws JavaModelException {
        if (visited.contains(jproject)) {
            return;
        }
        visited.add(jproject);
        IClasspathEntry[] entries = jproject.getResolvedClasspath(true);
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry curr = entries[i];
            switch (curr.getEntryKind()) {
                case 1: {
                    IPackageFragmentRoot el = jproject.getPackageFragmentRoot(curr.getPath().toOSString());
                    if (el == null || referencedClasses.contains(el)) break;
                    referencedClasses.add(el);
                    break;
                }
                case 2: {
                    IProject reqProject = (IProject)this.fStore.getRoot().findMember(curr.getPath());
                    IJavaProject javaProject = JavaCore.create((IProject)reqProject);
                    if (reqProject == null || !reqProject.isOpen() || referencedClasses.contains(javaProject)) break;
                    if (!this.fWizard.getSelectedProjects().contains(javaProject)) {
                        referencedClasses.add(javaProject);
                    }
                    this.findReferencedElements(referencedClasses, javaProject, visited);
                }
            }
            ++i;
        }
    }

    private void doValidation(int VALIDATE) {
        File file = null;
        String ext = null;
        Path path = null;
        switch (VALIDATE) {
            case 0: {
                this.fStyleSheetStatus = new StatusInfo();
                if (!this.fStyleSheetButton.getSelection()) break;
                path = new Path(this.fStyleSheetText.getText());
                file = new File(this.fStyleSheetText.getText());
                ext = path.getFileExtension();
                if (file == null || !file.exists()) {
                    this.fStyleSheetStatus.setError(JavadocExportMessages.getString("JavadcoStandardWizardPage.stylesheetnopath.error"));
                    break;
                }
                if (ext != null && ext.equalsIgnoreCase("css")) break;
                this.fStyleSheetStatus.setError(JavadocExportMessages.getString("JavadcoStandardWizardPage.stylesheetnotcss.error"));
            }
        }
        this.updateStatus(this.findMostSevereStatus());
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fStyleSheetStatus});
    }

    protected void finish() {
        if (this.fTitleButton.getSelection()) {
            this.fStore.setTitle(this.fTitleText.getText());
        } else {
            this.fStore.setTitle("");
        }
        Object[] buttons = this.fButtonsList.toArray();
        int i = 0;
        while (i < buttons.length) {
            FlaggedButton button = (FlaggedButton)buttons[i];
            if (button.getButton().getEnabled()) {
                this.fStore.setBoolean(button.getFlag(), !(button.getButton().getSelection() ^ button.show()));
            } else {
                this.fStore.setBoolean(button.getFlag(), !button.show());
            }
            ++i;
        }
        if (this.fStyleSheetText.getEnabled()) {
            this.fStore.setStyleSheet(this.fStyleSheetText.getText());
        } else {
            this.fStore.setStyleSheet("");
        }
        String hrefs = this.makeHrefString();
        this.fStore.setDependencies(hrefs);
        if (this.fWizard.getSelectedProjects().size() == 1) {
            this.fStore.setLinks((IJavaProject)this.fWizard.getSelectedProjects().iterator().next(), hrefs);
        }
    }

    protected String makeHrefString() {
        boolean firstTime = true;
        StringBuffer buf = new StringBuffer();
        List els = this.fListDialogField.getCheckedElements();
        URL url = null;
        Iterator iterator = els.iterator();
        while (iterator.hasNext()) {
            try {
                IJavaElement element = (IJavaElement)iterator.next();
                url = JavaUI.getJavadocBaseLocation(element);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                continue;
            }
            if (url == null) continue;
            if (firstTime) {
                firstTime = false;
            } else {
                buf.append(";");
            }
            buf.append(url.toExternalForm());
        }
        return buf.toString();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.doValidation(0);
            this.updateCheckedListGroup();
        } else {
            String hrefs = this.makeHrefString();
            IJavaProject[] projects = this.fWizard.getSelectedProjects().toArray(new IJavaProject[this.fWizard.getSelectedProjects().size()]);
            int i = 0;
            while (i < projects.length) {
                this.fTempLinks.put(projects[i], hrefs);
                ++i;
            }
        }
    }

    public void updateCheckedListGroup() {
        ArrayList referencedClasses = new ArrayList();
        ArrayList visited = new ArrayList();
        try {
            IJavaProject[] currProjects = this.fWizard.getSelectedProjects().toArray(new IJavaProject[this.fWizard.getSelectedProjects().size()]);
            this.findRE(referencedClasses, currProjects, visited);
            this.fListDialogField.setElements(referencedClasses);
            this.checkListDialogFieldElements(referencedClasses, currProjects);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    public void init() {
        this.updateStatus(new StatusInfo());
    }

    private void doEditButtonPressed() {
        List selected = this.fListDialogField.getSelectedElements();
        if (selected.isEmpty()) {
            return;
        }
        Object obj = selected.get(0);
        if (obj instanceof IJavaElement) {
            JavadocPropertyDialog jdialog = new JavadocPropertyDialog(this.getShell(), (IJavaElement)obj);
            jdialog.open();
        }
    }

    protected class FlaggedButton {
        private Button fButton;
        private String fFlag;
        private boolean fShowFlag;

        public FlaggedButton(Composite composite, String message, GridData gridData, String flag, boolean show) {
            this.fFlag = flag;
            this.fShowFlag = show;
            this.fButton = JavadocStandardWizardPage.this.createButton(composite, 32, message, gridData);
            JavadocStandardWizardPage.this.fButtonsList.add(this);
            this.setButtonSettings();
        }

        public Button getButton() {
            return this.fButton;
        }

        public String getFlag() {
            return this.fFlag;
        }

        public boolean show() {
            return this.fShowFlag;
        }

        private void setButtonSettings() {
            this.fButton.setSelection(!(JavadocStandardWizardPage.this.fStore.getBoolean(this.fFlag) ^ this.fShowFlag));
        }
    }

    private class ListAdapter
    implements IListAdapter {
        ListAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            if (index == 2) {
                JavadocStandardWizardPage.this.doEditButtonPressed();
            }
        }

        public void selectionChanged(ListDialogField field) {
            List selection = JavadocStandardWizardPage.this.fListDialogField.getSelectedElements();
            if (selection.size() != 1) {
                JavadocStandardWizardPage.this.fListDialogField.enableButton(2, false);
            } else {
                JavadocStandardWizardPage.this.fListDialogField.enableButton(2, true);
            }
        }

        public void doubleClicked(ListDialogField field) {
        }
    }

    private class JavadocPropertyDialog
    extends StatusDialog
    implements IStatusChangeListener {
        private JavadocConfigurationBlock fJavadocConfigurationBlock;
        private IJavaElement fElement;

        public JavadocPropertyDialog(Shell parent, IJavaElement selection) {
            super(parent);
            this.setTitle(JavadocExportMessages.getString("JavadocStandardWizardPage.javadocpropertydialog.title"));
            this.fElement = selection;
            URL initialLocation = null;
            try {
                initialLocation = JavaUI.getJavadocBaseLocation(selection);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            this.fJavadocConfigurationBlock = new JavadocConfigurationBlock(parent, this, initialLocation);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Control inner = this.fJavadocConfigurationBlock.createContents(composite);
            inner.setLayoutData((Object)new GridData(1808));
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void statusChanged(IStatus status) {
            this.updateStatus(status);
        }

        protected void okPressed() {
            URL javadocLocation = this.fJavadocConfigurationBlock.getJavadocLocation();
            if (this.fElement instanceof IJavaProject) {
                JavaUI.setProjectJavadocLocation((IJavaProject)this.fElement, javadocLocation);
            } else {
                JavaUI.setLibraryJavadocLocation(this.fElement.getPath(), javadocLocation);
            }
            JavadocStandardWizardPage.this.fListDialogField.refresh();
            super.okPressed();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.javadoc_property_dialog_context");
        }
    }
}

