/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavadocReader {
    protected InputStream fInputStream;
    protected IJavaProject fProject;

    public JavadocReader(InputStream inputStream) {
        Assert.isNotNull((Object)inputStream);
        this.fInputStream = new BufferedInputStream(inputStream);
    }

    public void close() throws IOException {
        if (this.fInputStream != null) {
            this.fInputStream.close();
        }
    }

    public Element readXML() throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder parser = null;
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex.getMessage());
        }
        Element xmlJavadocDesc = parser.parse(new InputSource(this.fInputStream)).getDocumentElement();
        String projectName = xmlJavadocDesc.getAttribute("name");
        IResource res = null;
        if (projectName != null) {
            res = JavaPlugin.getWorkspace().getRoot().findMember(projectName);
        }
        if (res instanceof IProject) {
            this.fProject = JavaCore.create((IProject)((IProject)res));
        }
        NodeList targets = xmlJavadocDesc.getChildNodes();
        int i = 0;
        while (i < targets.getLength()) {
            Node target = targets.item(i);
            if (target.getNodeName().equals("target")) {
                NodeList children = target.getChildNodes();
                int j = 0;
                while (j < children.getLength()) {
                    Node child = children.item(j);
                    if (child.getNodeName().equals("javadoc") && child.getNodeType() == 1) {
                        return (Element)child;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    protected boolean getBooleanAttribute(Element element, String name, boolean defaultValue) throws IOException {
        if (element.hasAttribute(name)) {
            return this.getBooleanAttribute(element, name);
        }
        return defaultValue;
    }

    protected boolean getBooleanAttribute(Element element, String name) throws IOException {
        String value = element.getAttribute(name);
        if (value != null && value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value != null && value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IOException("Illegal value for boolean attribute");
    }

    IJavaProject getProject() {
        return this.fProject;
    }
}

