/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.dialogs.ProblemDialog;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageActionDelegate;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageWizard;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionReader;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

public class OpenJarPackageWizardActionDelegate
extends JarPackageActionDelegate {
    private IJarDescriptionReader fReader;

    public void run(IAction action) {
        Shell parent = this.getShell();
        JarPackageData jarPackage = null;
        String errorDetail = null;
        try {
            jarPackage = this.readJarPackage(this.getDescriptionFile(this.getSelection()));
        }
        catch (IOException ex) {
            errorDetail = ex.getLocalizedMessage();
            MessageDialog.openError((Shell)parent, (String)JarPackagerMessages.getString("OpenJarPackageWizardDelegate.error.openJarPackager.title"), (String)(String.valueOf(JarPackagerMessages.getString("OpenJarPackageWizardDelegate.error.openJarPackager.message")) + errorDetail));
            return;
        }
        catch (CoreException ex) {
            errorDetail = ex.getLocalizedMessage();
            MessageDialog.openError((Shell)parent, (String)JarPackagerMessages.getString("OpenJarPackageWizardDelegate.error.openJarPackager.title"), (String)(String.valueOf(JarPackagerMessages.getString("OpenJarPackageWizardDelegate.error.openJarPackager.message")) + errorDetail));
            return;
        }
        catch (SAXException ex) {
            errorDetail = String.valueOf(JarPackagerMessages.getString("OpenJarPackageWizardDelegate.badXmlFormat")) + ex.getLocalizedMessage();
            MessageDialog.openError((Shell)parent, (String)JarPackagerMessages.getString("OpenJarPackageWizardDelegate.error.openJarPackager.title"), (String)(String.valueOf(JarPackagerMessages.getString("OpenJarPackageWizardDelegate.error.openJarPackager.message")) + errorDetail));
            return;
        }
        if (this.fReader != null && !this.fReader.getStatus().isOK()) {
            ProblemDialog.open(parent, JarPackagerMessages.getString("OpenJarPackageWizardDelegate.jarDescriptionReaderWarnings.title"), null, this.fReader.getStatus());
        }
        JarPackageWizard wizard = new JarPackageWizard();
        wizard.init(this.getWorkbench(), jarPackage);
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private JarPackageData readJarPackage(IFile description) throws CoreException, IOException, SAXException {
        JarPackageData jarPackage;
        block3: {
            Assert.isLegal((boolean)description.isAccessible());
            Assert.isNotNull((Object)description.getFileExtension());
            Assert.isLegal((boolean)description.getFileExtension().equals("jardesc"));
            jarPackage = new JarPackageData();
            try {
                this.fReader = jarPackage.createJarDescriptionReader(description.getContents());
                this.fReader.read(jarPackage);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (this.fReader != null) {
                    this.fReader.close();
                }
                throw throwable;
            }
            Object var3_5 = null;
            if (this.fReader == null) break block3;
            this.fReader.close();
        }
        return jarPackage;
    }
}

