/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.ui.jarpackager.IJarDescriptionWriter;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.util.Assert;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JarPackageWriter
implements IJarDescriptionWriter {
    protected OutputStream fOutputStream;

    public JarPackageWriter(OutputStream outputStream) {
        Assert.isNotNull((Object)outputStream);
        this.fOutputStream = new BufferedOutputStream(outputStream);
    }

    public void write(JarPackageData jarPackage) throws CoreException {
        try {
            this.writeXML(jarPackage);
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    public void writeXML(JarPackageData jarPackage) throws IOException {
        Assert.isNotNull((Object)jarPackage);
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(JarPackagerMessages.getString("JarWriter.error.couldNotGetXmlBuilder"));
        }
        Document document = docBuilder.newDocument();
        Element xmlJarDesc = document.createElement("jardesc");
        document.appendChild(xmlJarDesc);
        this.xmlWriteJarLocation(jarPackage, document, xmlJarDesc);
        this.xmlWriteOptions(jarPackage, document, xmlJarDesc);
        if (jarPackage.areClassFilesExported()) {
            this.xmlWriteManifest(jarPackage, document, xmlJarDesc);
        }
        this.xmlWriteSelectedElements(jarPackage, document, xmlJarDesc);
        OutputFormat format = new OutputFormat();
        format.setIndenting(true);
        SerializerFactory serializerFactory = SerializerFactory.getSerializerFactory((String)"xml");
        Serializer serializer = serializerFactory.makeSerializer(this.fOutputStream, format);
        serializer.asDOMSerializer().serialize(document);
    }

    private void xmlWriteJarLocation(JarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element jar = document.createElement("jar");
        xmlJarDesc.appendChild(jar);
        jar.setAttribute("path", jarPackage.getJarLocation().toString());
    }

    private void xmlWriteOptions(JarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element options = document.createElement("options");
        xmlJarDesc.appendChild(options);
        options.setAttribute("overwrite", "" + jarPackage.allowOverwrite());
        options.setAttribute("compress", "" + jarPackage.isCompressed());
        options.setAttribute("exportErrors", "" + jarPackage.areErrorsExported());
        options.setAttribute("exportWarnings", "" + jarPackage.exportWarnings());
        options.setAttribute("saveDescription", "" + jarPackage.isDescriptionSaved());
        options.setAttribute("descriptionLocation", jarPackage.getDescriptionLocation().toString());
        options.setAttribute("useSourceFolders", "" + jarPackage.useSourceFolderHierarchy());
        options.setAttribute("buildIfNeeded", "" + jarPackage.isBuildingIfNeeded());
    }

    private void xmlWriteManifest(JarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element manifest = document.createElement("manifest");
        xmlJarDesc.appendChild(manifest);
        manifest.setAttribute("manifestVersion", jarPackage.getManifestVersion());
        manifest.setAttribute("usesManifest", "" + jarPackage.usesManifest());
        manifest.setAttribute("reuseManifest", "" + jarPackage.isManifestReused());
        manifest.setAttribute("saveManifest", "" + jarPackage.isManifestSaved());
        manifest.setAttribute("generateManifest", "" + jarPackage.isManifestGenerated());
        manifest.setAttribute("manifestLocation", jarPackage.getManifestLocation().toString());
        if (jarPackage.getManifestMainClass() != null) {
            manifest.setAttribute("mainClassHandleIdentifier", jarPackage.getManifestMainClass().getHandleIdentifier());
        }
        this.xmlWriteSealingInfo(jarPackage, document, manifest);
    }

    private void xmlWriteSealingInfo(JarPackageData jarPackage, Document document, Element manifest) throws DOMException {
        Element sealing = document.createElement("sealing");
        manifest.appendChild(sealing);
        sealing.setAttribute("sealJar", "" + jarPackage.isJarSealed());
        Element packagesToSeal = document.createElement("packagesToSeal");
        sealing.appendChild(packagesToSeal);
        this.add(jarPackage.getPackagesToSeal(), packagesToSeal, document);
        Element packagesToUnSeal = document.createElement("packagesToUnSeal");
        sealing.appendChild(packagesToUnSeal);
        this.add(jarPackage.getPackagesToUnseal(), packagesToUnSeal, document);
    }

    private void xmlWriteSelectedElements(JarPackageData jarPackage, Document document, Element xmlJarDesc) throws DOMException {
        Element selectedElements = document.createElement("selectedElements");
        xmlJarDesc.appendChild(selectedElements);
        selectedElements.setAttribute("exportClassFiles", "" + jarPackage.areClassFilesExported());
        selectedElements.setAttribute("exportJavaFiles", "" + jarPackage.areJavaFilesExported());
        Object[] elements = jarPackage.getElements();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IResource) {
                this.add((IResource)element, selectedElements, document);
            } else if (element instanceof IJavaElement) {
                this.add((IJavaElement)element, selectedElements, document);
            }
            ++i;
        }
    }

    public void writeString(JarPackageData jarPackage) throws IOException {
        Assert.isNotNull((Object)jarPackage);
        OutputStreamWriter streamWriter = new OutputStreamWriter(this.fOutputStream);
        BufferedWriter writer = new BufferedWriter(streamWriter);
        writer.write(JarPackagerMessages.getString("JarWriter.output.title"));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.exportBin", jarPackage.areClassFilesExported()));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.exportJava", jarPackage.areJavaFilesExported()));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.jarFileName", jarPackage.getJarLocation().toOSString()));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.compressed", jarPackage.isCompressed()));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.overwrite", jarPackage.allowOverwrite()));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.saveDescription", jarPackage.isDescriptionSaved()));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.descriptionFile", jarPackage.getDescriptionLocation()));
        writer.newLine();
        writer.write(JarPackagerMessages.getString("JarWriter.output.lineSeparator"));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.generateManifest", jarPackage.isManifestGenerated()));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.saveManifest", jarPackage.isManifestSaved()));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.reuseManifest", jarPackage.isManifestReused()));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.manifestName", jarPackage.getManifestLocation()));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.jarSealed", jarPackage.isJarSealed()));
        writer.newLine();
        writer.write(JarPackagerMessages.getFormattedString("JarWriter.output.mainClass", JarPackagerUtil.getMainClassName(jarPackage)));
        writer.flush();
    }

    public void close() throws CoreException {
        if (this.fOutputStream != null) {
            try {
                this.fOutputStream.close();
            }
            catch (IOException ex) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, ex.getLocalizedMessage(), (Throwable)ex));
            }
        }
    }

    private void add(IResource resource, Element parent, Document document) {
        Element element = null;
        if (resource.getType() == 4) {
            element = document.createElement("project");
            parent.appendChild(element);
            element.setAttribute("name", resource.getName());
            return;
        }
        if (resource.getType() == 1) {
            element = document.createElement("file");
        } else if (resource.getType() == 2) {
            element = document.createElement("folder");
        }
        parent.appendChild(element);
        element.setAttribute("path", resource.getFullPath().toString());
    }

    private void add(IJavaElement javaElement, Element parent, Document document) {
        Element element = document.createElement("javaElement");
        parent.appendChild(element);
        element.setAttribute("handleIdentifier", javaElement.getHandleIdentifier());
    }

    private void add(IPackageFragment[] packages, Element parent, Document document) {
        int i = 0;
        while (i < packages.length) {
            Element pkg = document.createElement("package");
            parent.appendChild(pkg);
            pkg.setAttribute("handleIdentifier", packages[i].getHandleIdentifier());
            ++i;
        }
    }

    public IStatus getStatus() {
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }
}

