/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.filters.EmptyInnerPackageFilter;
import org.eclipse.jdt.internal.ui.jarpackager.CheckboxTreeAndListGroup;
import org.eclipse.jdt.internal.ui.jarpackager.ContainerFilter;
import org.eclipse.jdt.internal.ui.jarpackager.IJarPackageWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageWizard;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.LibraryFilter;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;
import org.eclipse.ui.help.WorkbenchHelp;

class JarPackageWizardPage
extends WizardExportResourcesPage
implements IJarPackageWizardPage {
    private JarPackageData fJarPackage;
    private IStructuredSelection fInitialSelection;
    private CheckboxTreeAndListGroup fInputGroup;
    private Text fSourceNameField;
    private Button fExportClassFilesCheckbox;
    private Button fExportJavaFilesCheckbox;
    private Combo fDestinationNamesCombo;
    private Button fDestinationBrowseButton;
    private Button fCompressCheckbox;
    private Button fOverwriteCheckbox;
    private Text fDescriptionFileText;
    private static final String PAGE_NAME = "JarPackageWizardPage";
    private static final String STORE_EXPORT_CLASS_FILES = "JarPackageWizardPage.EXPORT_CLASS_FILES";
    private static final String STORE_EXPORT_JAVA_FILES = "JarPackageWizardPage.EXPORT_JAVA_FILES";
    private static final String STORE_DESTINATION_NAMES = "JarPackageWizardPage.DESTINATION_NAMES_ID";
    private static final String STORE_COMPRESS = "JarPackageWizardPage.COMPRESS";
    private static final String STORE_OVERWRITE = "JarPackageWizardPage.OVERWRITE";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 480;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 150;

    public JarPackageWizardPage(JarPackageData jarPackage, IStructuredSelection selection) {
        super(PAGE_NAME, selection);
        this.setTitle(JarPackagerMessages.getString("JarPackageWizardPage.title"));
        this.setDescription(JarPackagerMessages.getString("JarPackageWizardPage.description"));
        this.fJarPackage = jarPackage;
        this.fInitialSelection = selection;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createPlainLabel(composite, JarPackagerMessages.getString("JarPackageWizardPage.whatToExport.label"));
        this.createInputGroup(composite);
        this.createExportTypeGroup(composite);
        new Label(composite, 0);
        this.createPlainLabel(composite, JarPackagerMessages.getString("JarPackageWizardPage.whereToExport.label"));
        this.createDestinationGroup(composite);
        this.createPlainLabel(composite, JarPackagerMessages.getString("JarPackageWizardPage.options.label"));
        this.createOptionsGroup(composite);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.fInitialSelection != null) {
            BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    JarPackageWizardPage.this.setupBasedOnInitialSelections();
                }
            });
        }
        this.setControl((Control)composite);
        this.update();
        this.giveFocusToDestination();
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.jar_packager_wizard_page_context");
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        this.fCompressCheckbox = new Button(optionsGroup, 16416);
        this.fCompressCheckbox.setText(JarPackagerMessages.getString("JarPackageWizardPage.compress.text"));
        this.fCompressCheckbox.addListener(13, (Listener)this);
        this.fOverwriteCheckbox = new Button(optionsGroup, 16416);
        this.fOverwriteCheckbox.setText(JarPackagerMessages.getString("JarPackageWizardPage.overwrite.text"));
        this.fOverwriteCheckbox.addListener(13, (Listener)this);
    }

    protected String getDestinationValue() {
        String destinationText = this.fDestinationNamesCombo.getText().trim();
        if (destinationText.indexOf(46) < 0) {
            destinationText = String.valueOf(destinationText) + this.getOutputSuffix();
        }
        return destinationText;
    }

    protected String getDestinationLabel() {
        return JarPackagerMessages.getString("JarPackageWizardPage.destination.label");
    }

    protected String getOutputSuffix() {
        return ".jar";
    }

    protected Iterator getSelectedResourcesIterator() {
        return this.fInputGroup.getAllCheckedListItems();
    }

    public final void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES, directoryNames);
            settings.put(STORE_EXPORT_CLASS_FILES, this.fJarPackage.areClassFilesExported());
            settings.put(STORE_EXPORT_JAVA_FILES, this.fJarPackage.areJavaFilesExported());
            settings.put(STORE_COMPRESS, this.fJarPackage.isCompressed());
            settings.put(STORE_OVERWRITE, this.fJarPackage.allowOverwrite());
        }
        this.internalSaveWidgetValues();
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
        if (!((JarPackageWizard)this.getWizard()).isInitializingFromJarPackage()) {
            this.initializeJarPackage();
        }
        this.fExportClassFilesCheckbox.setSelection(this.fJarPackage.areClassFilesExported());
        this.fExportJavaFilesCheckbox.setSelection(this.fJarPackage.areJavaFilesExported());
        if (this.fJarPackage.getJarLocation().isEmpty()) {
            this.fDestinationNamesCombo.setText("");
        } else {
            this.fDestinationNamesCombo.setText(this.fJarPackage.getJarLocation().toOSString());
        }
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES);
            if (directoryNames == null) {
                return;
            }
            if (!this.fDestinationNamesCombo.getText().equals(directoryNames[0])) {
                this.fDestinationNamesCombo.add(this.fDestinationNamesCombo.getText());
            }
            int i = 0;
            while (i < directoryNames.length) {
                this.fDestinationNamesCombo.add(directoryNames[i]);
                ++i;
            }
        }
        this.fCompressCheckbox.setSelection(this.fJarPackage.isCompressed());
        this.fOverwriteCheckbox.setSelection(this.fJarPackage.allowOverwrite());
    }

    protected void initializeJarPackage() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fJarPackage.setElements(this.getSelectedElements());
            this.fJarPackage.setExportClassFiles(settings.getBoolean(STORE_EXPORT_CLASS_FILES));
            this.fJarPackage.setExportJavaFiles(settings.getBoolean(STORE_EXPORT_JAVA_FILES));
            this.fJarPackage.setCompress(settings.getBoolean(STORE_COMPRESS));
            this.fJarPackage.setOverwrite(settings.getBoolean(STORE_OVERWRITE));
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES);
            if (directoryNames == null) {
                return;
            }
            this.fJarPackage.setJarLocation((IPath)new Path(directoryNames[0]));
        }
    }

    protected void updateModel() {
        if (this.getControl() == null) {
            return;
        }
        this.fJarPackage.setElements(this.getSelectedElements());
        this.fJarPackage.setExportClassFiles(this.fExportClassFilesCheckbox.getSelection());
        this.fJarPackage.setExportJavaFiles(this.fExportJavaFilesCheckbox.getSelection());
        String comboText = this.fDestinationNamesCombo.getText();
        Path path = new Path(comboText);
        if (!new File(comboText).isAbsolute()) {
            path = this.getWorkspaceLocation().append((IPath)path);
        }
        if (path.segmentCount() > 0 && this.ensureTargetFileIsValid(path.toFile()) && path.getFileExtension() == null) {
            path = path.addFileExtension("jar");
        }
        this.fJarPackage.setJarLocation((IPath)path);
        this.fJarPackage.setCompress(this.fCompressCheckbox.getSelection());
        this.fJarPackage.setOverwrite(this.fOverwriteCheckbox.getSelection());
    }

    protected boolean ensureTargetFileIsValid(File targetFile) {
        if (targetFile.exists() && targetFile.isDirectory() && this.fDestinationNamesCombo.getText().length() > 0) {
            this.setErrorMessage(JarPackagerMessages.getString("JarPackageWizardPage.error.exportDestinationMustNotBeDirectory"));
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        if (targetFile.exists() && !targetFile.canWrite()) {
            this.setErrorMessage(JarPackagerMessages.getString("JarPackageWizardPage.error.jarFileExistsAndNotWritable"));
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        return true;
    }

    protected void createDestinationGroup(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        new Label(destinationSelectionGroup, 0).setText(this.getDestinationLabel());
        this.fDestinationNamesCombo = new Combo(destinationSelectionGroup, 2052);
        this.fDestinationNamesCombo.addListener(24, (Listener)this);
        this.fDestinationNamesCombo.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.fDestinationNamesCombo.setLayoutData((Object)data);
        this.fDestinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.fDestinationBrowseButton.setText(JarPackagerMessages.getString("JarPackageWizardPage.browseButton.text"));
        this.fDestinationBrowseButton.setLayoutData((Object)new GridData(256));
        SWTUtil.setButtonDimensionHint(this.fDestinationBrowseButton);
        this.fDestinationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JarPackageWizardPage.this.handleDestinationBrowseButtonPressed();
            }
        });
    }

    protected void handleDescriptionFileBrowseButtonPressed() {
        SaveAsDialog dialog = new SaveAsDialog(this.getContainer().getShell());
        dialog.create();
        dialog.getShell().setText(JarPackagerMessages.getString("JarPackageWizardPage.saveAsDialog.title"));
        dialog.setMessage(JarPackagerMessages.getString("JarPackageWizardPage.saveAsDialog.message"));
        dialog.setOriginalFile(this.createFileHandle(this.fJarPackage.getDescriptionLocation()));
        if (dialog.open() == 0) {
            IPath path = dialog.getResult();
            path = path.removeFileExtension().addFileExtension("jardesc");
            this.fDescriptionFileText.setText(path.toString());
        }
    }

    protected void handleDestinationBrowseButtonPressed() {
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.jar", "*.zip"});
        String currentSourceString = this.getDestinationValue();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
            dialog.setFileName(currentSourceString.substring(lastSeparatorIndex + 1, currentSourceString.length()));
        } else {
            dialog.setFileName(currentSourceString);
        }
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.fDestinationNamesCombo.setText(selectedFileName);
        }
    }

    protected IResource findResource(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validatePath(path.toString(), 15);
        if (result.isOK() && workspace.getRoot().exists(path)) {
            return workspace.getRoot().findMember(path);
        }
        return null;
    }

    protected void createInputGroup(Composite parent) {
        int labelFlags = 272;
        StandardJavaElementContentProvider treeContentProvider = new StandardJavaElementContentProvider(){

            public boolean hasChildren(Object element) {
                return !(element instanceof IPackageFragment) && super.hasChildren(element);
            }
        };
        this.fInputGroup = new CheckboxTreeAndListGroup(parent, JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()), treeContentProvider, (ILabelProvider)new JavaElementLabelProvider(labelFlags), (IStructuredContentProvider)new StandardJavaElementContentProvider(), (ILabelProvider)new JavaElementLabelProvider(labelFlags), 0, 480, 150);
        this.fInputGroup.addTreeFilter(new EmptyInnerPackageFilter());
        this.fInputGroup.setTreeSorter(new JavaElementSorter());
        this.fInputGroup.setListSorter(new JavaElementSorter());
        this.fInputGroup.addTreeFilter(new ContainerFilter(ContainerFilter.FILTER_NON_CONTAINERS));
        this.fInputGroup.addTreeFilter(new LibraryFilter());
        this.fInputGroup.addListFilter(new ContainerFilter(ContainerFilter.FILTER_CONTAINERS));
        this.fInputGroup.getTree().addListener(4, (Listener)this);
        this.fInputGroup.getTable().addListener(4, (Listener)this);
    }

    protected void createExportTypeGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout optionsLayout = new GridLayout();
        optionsLayout.marginHeight = 0;
        optionsGroup.setLayout((Layout)optionsLayout);
        this.fExportClassFilesCheckbox = new Button(optionsGroup, 16416);
        this.fExportClassFilesCheckbox.setText(JarPackagerMessages.getString("JarPackageWizardPage.exportClassFiles.text"));
        this.fExportClassFilesCheckbox.addListener(13, (Listener)this);
        this.fExportJavaFilesCheckbox = new Button(optionsGroup, 16416);
        this.fExportJavaFilesCheckbox.setText(JarPackagerMessages.getString("JarPackageWizardPage.exportJavaFiles.text"));
        this.fExportJavaFilesCheckbox.addListener(13, (Listener)this);
    }

    protected void updateWidgetEnablements() {
    }

    public boolean isPageComplete() {
        boolean complete = this.validateSourceGroup();
        complete = this.validateDestinationGroup() && complete;
        boolean bl = complete = this.validateOptionsGroup() && complete;
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    public void handleEvent(Event e) {
        if (this.getControl() == null) {
            return;
        }
        this.update();
    }

    protected void update() {
        this.updateModel();
        this.updateWidgetEnablements();
        this.updatePageCompletion();
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.isPageComplete();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
    }

    protected boolean validateDestinationGroup() {
        if (this.fDestinationNamesCombo.getText().length() == 0) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            if (this.getMessage() != null) {
                this.setMessage(null);
            }
            return false;
        }
        if (this.fJarPackage.getJarLocation().toString().endsWith("/")) {
            this.setErrorMessage(JarPackagerMessages.getString("JarPackageWizardPage.error.exportDestinationMustNotBeDirectory"));
            this.fDestinationNamesCombo.setFocus();
            return false;
        }
        if (this.getWorkspaceLocation() != null && this.getWorkspaceLocation().isPrefixOf(this.fJarPackage.getJarLocation())) {
            int segments = this.getWorkspaceLocation().matchingFirstSegments(this.fJarPackage.getJarLocation());
            IPath path = this.fJarPackage.getJarLocation().removeFirstSegments(segments);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.getType() == 1 && JarPackagerUtil.contains(JarPackagerUtil.asResources(this.fJarPackage.getElements()), (IFile)resource)) {
                this.setErrorMessage(JarPackagerMessages.getString("JarPackageWizardPage.error.cantExportJARIntoItself"));
                return false;
            }
        }
        String currentMessage = this.getMessage();
        if (!new File(this.fDestinationNamesCombo.getText()).isAbsolute()) {
            if (currentMessage == null) {
                this.setMessage(JarPackagerMessages.getString("JarPackageWizardPage.info.relativeExportDestination"), 1);
            }
        } else if (currentMessage != null) {
            this.setMessage(null);
        }
        return this.ensureTargetFileIsValid(this.fJarPackage.getJarLocation().toFile());
    }

    protected boolean validateOptionsGroup() {
        return true;
    }

    protected boolean validateSourceGroup() {
        if (!this.fExportClassFilesCheckbox.getSelection() && !this.fExportJavaFilesCheckbox.getSelection()) {
            this.setErrorMessage(JarPackagerMessages.getString("JarPackageWizardPage.error.noExportTypeChecked"));
            return false;
        }
        if (this.getSelectedResources().size() == 0) {
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            return false;
        }
        if (this.fExportClassFilesCheckbox.getSelection() || !this.fExportJavaFilesCheckbox.getSelection()) {
            return true;
        }
        Iterator iter = this.getSelectedResourcesIterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof IClassFile) continue;
            return true;
        }
        if (this.getErrorMessage() != null) {
            this.setErrorMessage(null);
        }
        return false;
    }

    protected IPath getResourcePath() {
        return this.getPathFromText(this.fSourceNameField);
    }

    protected IFile createFileHandle(IPath filePath) {
        if (filePath.isValidPath(filePath.toString()) && filePath.segmentCount() >= 2) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        }
        return null;
    }

    protected void giveFocusToDestination() {
        this.fDestinationNamesCombo.setFocus();
    }

    protected void setupBasedOnInitialSelections() {
        Iterator iterator = this.fInitialSelection.iterator();
        while (iterator.hasNext()) {
            IJavaElement je;
            Object selectedElement = iterator.next();
            if (selectedElement instanceof ICompilationUnit || selectedElement instanceof IClassFile || selectedElement instanceof IFile) {
                this.fInputGroup.initialCheckListItem(selectedElement);
                continue;
            }
            if (selectedElement instanceof IFolder && (je = JavaCore.create((IResource)((IResource)selectedElement))) != null && je.exists() && je.getJavaProject().isOnClasspath((IResource)selectedElement)) {
                selectedElement = je;
            }
            this.fInputGroup.initialCheckTreeItem(selectedElement);
        }
        TreeItem[] items = this.fInputGroup.getTree().getItems();
        int i = 0;
        while (i < items.length && !items[i].getChecked()) {
            ++i;
        }
        if (i < items.length) {
            this.fInputGroup.getTree().setSelection(new TreeItem[]{items[i]});
            this.fInputGroup.getTree().showSelection();
            this.fInputGroup.populateListViewer(items[i].getData());
        }
    }

    public void finish() {
        this.saveWidgetValues();
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        if (this.getControl() != null) {
            this.updatePageCompletion();
        }
    }

    Object[] getSelectedElementsWithoutContainedChildren() {
        Set closure = this.removeContainedChildren(this.fInputGroup.getWhiteCheckedTreeItems());
        closure.addAll(this.getExportedNonContainers());
        return closure.toArray();
    }

    private Set removeContainedChildren(Set elements) {
        HashSet newList = new HashSet(elements.size());
        Set javaElementResources = this.getCorrespondingContainers(elements);
        Iterator iter = elements.iterator();
        boolean removedOne = false;
        while (iter.hasNext()) {
            IContainer parent;
            Object element = iter.next();
            if (element instanceof IResource) {
                parent = ((IResource)element).getParent();
            } else if (element instanceof IJavaElement) {
                parent = ((IJavaElement)element).getParent();
                if (parent instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)parent;
                    try {
                        if (pkgRoot.getCorrespondingResource() instanceof IProject) {
                            parent = pkgRoot.getJavaProject();
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            } else {
                newList.add(element);
                continue;
            }
            if (element instanceof IJavaModel || !(parent instanceof IJavaModel) && (elements.contains(parent) || javaElementResources.contains(parent))) {
                removedOne = true;
                continue;
            }
            newList.add(element);
        }
        if (removedOne) {
            return this.removeContainedChildren(newList);
        }
        return newList;
    }

    private Set getExportedNonContainers() {
        Set whiteCheckedTreeItems = this.fInputGroup.getWhiteCheckedTreeItems();
        HashSet exportedNonContainers = new HashSet(whiteCheckedTreeItems.size());
        Set javaElementResources = this.getCorrespondingContainers(whiteCheckedTreeItems);
        Iterator iter = this.fInputGroup.getAllCheckedListItems();
        while (iter.hasNext()) {
            Object element = iter.next();
            IContainer parent = null;
            if (element instanceof IResource) {
                parent = ((IResource)element).getParent();
            } else if (element instanceof IJavaElement) {
                parent = ((IJavaElement)element).getParent();
            }
            if (whiteCheckedTreeItems.contains(parent) || javaElementResources.contains(parent)) continue;
            exportedNonContainers.add(element);
        }
        return exportedNonContainers;
    }

    private Set getCorrespondingContainers(Set elements) {
        HashSet<IResource> javaElementResources = new HashSet<IResource>(elements.size());
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IResource resource;
            IJavaElement je;
            int type;
            Object element = iter.next();
            if (!(element instanceof IJavaElement) || (type = (je = (IJavaElement)element).getElementType()) != 2 && type != 4 && type != 3 || type == 4 && ((IPackageFragment)element).isDefaultPackage()) continue;
            try {
                resource = je.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {
                resource = null;
            }
            if (resource == null) continue;
            javaElementResources.add(resource);
        }
        return javaElementResources;
    }

    private Object[] getSelectedElements() {
        return this.getSelectedResources().toArray();
    }

    private IPath getWorkspaceLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }
}

