/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.filters;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.filters.FilterMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;

public class FilterDescriptor
implements Comparable {
    private static String PATTERN_FILTER_ID_PREFIX = "_patternFilterId_";
    private static final String EXTENSION_POINT_NAME = "javaElementFilters";
    private static final String FILTER_TAG = "filter";
    private static final String PATTERN_ATTRIBUTE = "pattern";
    private static final String ID_ATTRIBUTE = "id";
    private static final String VIEW_ID_ATTRIBUTE = "viewId";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String SELECTED_ATTRIBUTE = "selected";
    private static FilterDescriptor[] fgFilterDescriptors;
    private IConfigurationElement fElement;

    public static FilterDescriptor[] getFilterDescriptors() {
        if (fgFilterDescriptors == null) {
            IPluginRegistry registry = Platform.getPluginRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.jdt.ui", EXTENSION_POINT_NAME);
            fgFilterDescriptors = FilterDescriptor.createFilterDescriptors(elements);
        }
        return fgFilterDescriptors;
    }

    public static FilterDescriptor[] getFilterDescriptors(String viewId) {
        FilterDescriptor[] filterDescs = FilterDescriptor.getFilterDescriptors();
        ArrayList<FilterDescriptor> result = new ArrayList<FilterDescriptor>(filterDescs.length);
        int i = 0;
        while (i < filterDescs.length) {
            String vid = filterDescs[i].getViewId();
            if (vid == null || vid.equals(viewId)) {
                result.add(filterDescs[i]);
            }
            ++i;
        }
        return result.toArray(new FilterDescriptor[result.size()]);
    }

    private FilterDescriptor(IConfigurationElement element) {
        this.fElement = element;
        Assert.isTrue((boolean)(this.isPatternFilter() ^ this.isCustomFilter()));
        Assert.isNotNull((Object)this.getId());
        Assert.isNotNull((Object)this.getName());
    }

    public ViewerFilter createViewerFilter() {
        Assert.isTrue((boolean)this.isCustomFilter());
        ViewerFilter result = null;
        try {
            result = (ViewerFilter)this.fElement.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException ex) {
            this.handleError(ex.getStatus());
        }
        catch (ClassCastException ex) {
            this.handleError((IStatus)new Status(4, "org.eclipse.jdt.ui", 10001, ex.getLocalizedMessage(), (Throwable)ex));
            return null;
        }
        return result;
    }

    private void handleError(IStatus status) {
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            String title = FilterMessages.getString("FilterDescriptor.filterCreationError.title");
            String message = FilterMessages.getFormattedString("FilterDescriptor.filterCreationError.message", this.getId());
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        }
        JavaPlugin.log(status);
    }

    public String getId() {
        if (this.isPatternFilter()) {
            String viewId = this.getViewId();
            if (viewId == null) {
                return String.valueOf(PATTERN_FILTER_ID_PREFIX) + this.getPattern();
            }
            return String.valueOf(viewId) + PATTERN_FILTER_ID_PREFIX + this.getPattern();
        }
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getName() {
        String name = this.fElement.getAttribute(NAME_ATTRIBUTE);
        if (name == null && this.isPatternFilter()) {
            name = this.getPattern();
        }
        return name;
    }

    public String getPattern() {
        return this.fElement.getAttribute(PATTERN_ATTRIBUTE);
    }

    public String getViewId() {
        return this.fElement.getAttribute(VIEW_ID_ATTRIBUTE);
    }

    public String getDescription() {
        String description = this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        if (description == null) {
            description = "";
        }
        return description;
    }

    public boolean isPatternFilter() {
        return this.getPattern() != null;
    }

    public boolean isCustomFilter() {
        return this.fElement.getAttribute(CLASS_ATTRIBUTE) != null;
    }

    public boolean isEnabled() {
        String strVal = this.fElement.getAttribute(ENABLED_ATTRIBUTE);
        if (strVal == null) {
            strVal = this.fElement.getAttribute(SELECTED_ATTRIBUTE);
        }
        return strVal == null || Boolean.valueOf(strVal) != false;
    }

    public int compareTo(Object o) {
        if (o instanceof FilterDescriptor) {
            return Collator.getInstance().compare(this.getName(), ((FilterDescriptor)o).getName());
        }
        return Integer.MIN_VALUE;
    }

    private static FilterDescriptor[] createFilterDescriptors(IConfigurationElement[] elements) {
        ArrayList<FilterDescriptor> result = new ArrayList<FilterDescriptor>(5);
        HashSet<String> descIds = new HashSet<String>(5);
        int i = 0;
        while (i < elements.length) {
            FilterDescriptor desc;
            IConfigurationElement element = elements[i];
            if (FILTER_TAG.equals(element.getName()) && !descIds.contains((desc = new FilterDescriptor(element)).getId())) {
                result.add(desc);
                descIds.add(desc.getId());
            }
            ++i;
        }
        Collections.sort(result);
        return result.toArray(new FilterDescriptor[result.size()]);
    }
}

