/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dnd;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class LocalSelectionTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "local-selection-transfer-format" + new Long(System.currentTimeMillis()).toString();
    private static final int TYPEID = Transfer.registerType((String)TYPE_NAME);
    private static final LocalSelectionTransfer INSTANCE = new LocalSelectionTransfer();
    private ISelection fSelection;
    private int fSelectionSetTime;

    private LocalSelectionTransfer() {
    }

    public static LocalSelectionTransfer getInstance() {
        return INSTANCE;
    }

    public void setSelection(ISelection s) {
        this.fSelection = s;
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public void javaToNative(Object object, TransferData transferData) {
        byte[] check = TYPE_NAME.getBytes();
        super.javaToNative((Object)check, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        Object result = super.nativeToJava(transferData);
        if (this.isInvalidNativeType(result)) {
            JavaPlugin.logErrorMessage(JavaUIMessages.getString("LocalSelectionTransfer.errorMessage"));
        }
        return this.fSelection;
    }

    private boolean isInvalidNativeType(Object result) {
        return !(result instanceof byte[]) || !TYPE_NAME.equals(new String((byte[])result));
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public int getSelectionSetTime() {
        return this.fSelectionSetTime;
    }

    public void setSelectionSetTime(int time) {
        this.fSelectionSetTime = time;
    }
}

