/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dnd;

import org.eclipse.jdt.internal.ui.dnd.LocalSelectionTransfer;
import org.eclipse.jdt.internal.ui.dnd.TransferDragSourceListener;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class BasicSelectionTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;

    public BasicSelectionTransferDragAdapter(ISelectionProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fProvider = provider;
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.fProvider.getSelection();
        LocalSelectionTransfer.getInstance().setSelection(selection);
        LocalSelectionTransfer.getInstance().setSelectionSetTime(event.time);
        event.doit = this.isDragable(selection);
    }

    protected boolean isDragable(ISelection selection) {
        return true;
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = LocalSelectionTransfer.getInstance().getSelection();
    }

    public void dragFinished(DragSourceEvent event) {
        Assert.isTrue((event.detail == 0 ? 1 : 0) != 0);
        LocalSelectionTransfer.getInstance().setSelection(null);
        LocalSelectionTransfer.getInstance().setSelectionSetTime(0);
    }
}

