/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaAddElementFromHistory;
import org.eclipse.jdt.internal.ui.compare.JavaCompareWithEditionAction;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryEditorAction;
import org.eclipse.jdt.internal.ui.compare.JavaReplaceWithEditionAction;
import org.eclipse.jdt.internal.ui.compare.JavaReplaceWithPreviousEditionAction;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.help.WorkbenchHelp;

public class LocalHistoryActionGroup
extends ActionGroup {
    private String fGroupName;
    private JavaHistoryEditorAction fCompareWith;
    private JavaHistoryEditorAction fReplaceWithPrevious;
    private JavaHistoryEditorAction fReplaceWith;
    private JavaHistoryEditorAction fAddFrom;

    public LocalHistoryActionGroup(CompilationUnitEditor editor, String groupName) {
        Assert.isNotNull((Object)groupName);
        this.fGroupName = groupName;
        this.fCompareWith = new JavaHistoryEditorAction(editor, new JavaCompareWithEditionAction(), CompareMessages.getString("LocalHistoryActionGroup.action.compare_with"), CompareMessages.getString("LocalHistoryActionGroup.action.compare_with.title"), CompareMessages.getString("LocalHistoryActionGroup.action.compare_with.message"));
        WorkbenchHelp.setHelp((IAction)this.fCompareWith, (String)"org.eclipse.jdt.ui.compare_with_history_action");
        this.fReplaceWithPrevious = new JavaHistoryEditorAction(editor, new JavaReplaceWithPreviousEditionAction(), CompareMessages.getString("LocalHistoryActionGroup.action.replace_with_previous"), CompareMessages.getString("LocalHistoryActionGroup.action.replace_with_previous.title"), CompareMessages.getString("LocalHistoryActionGroup.action.replace_with_previous.message"));
        WorkbenchHelp.setHelp((IAction)this.fReplaceWithPrevious, (String)"org.eclipse.jdt.ui.replace_with_previous_from_history_action");
        this.fReplaceWith = new JavaHistoryEditorAction(editor, new JavaReplaceWithEditionAction(), CompareMessages.getString("LocalHistoryActionGroup.action.replace_with"), CompareMessages.getString("LocalHistoryActionGroup.action.replace_with.title"), CompareMessages.getString("LocalHistoryActionGroup.action.replace_with.message"));
        WorkbenchHelp.setHelp((IAction)this.fReplaceWith, (String)"org.eclipse.jdt.ui.replace_with_history_action");
        this.fAddFrom = new JavaHistoryEditorAction(editor, new JavaAddElementFromHistory(), CompareMessages.getString("LocalHistoryActionGroup.action.add"), CompareMessages.getString("LocalHistoryActionGroup.action.add.title"), CompareMessages.getString("LocalHistoryActionGroup.action.add.message"));
        WorkbenchHelp.setHelp((IAction)this.fAddFrom, (String)"org.eclipse.jdt.ui.add_from_history_action");
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        MenuManager localMenu = new MenuManager(CompareMessages.getString("LocalHistoryActionGroup.menu.local_history"));
        int added = 0;
        added += this.addAction((IMenuManager)localMenu, this.fCompareWith);
        added += this.addAction((IMenuManager)localMenu, this.fReplaceWithPrevious);
        added += this.addAction((IMenuManager)localMenu, this.fReplaceWith);
        if ((added += this.addAction((IMenuManager)localMenu, this.fAddFrom)) > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)localMenu);
        }
    }

    private int addAction(IMenuManager menu, JavaHistoryEditorAction action) {
        action.update();
        if (action.isEnabled()) {
            menu.add((IAction)action);
            return 1;
        }
        return 0;
    }
}

