/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.corext.codemanipulation.MemberEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryAction;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class JavaReplaceWithEditionAction
extends JavaHistoryAction {
    private static final String BUNDLE_NAME = "org.eclipse.jdt.internal.ui.compare.ReplaceWithEditionAction";
    private boolean fPrevious = false;

    public JavaReplaceWithEditionAction() {
        super(true);
    }

    public JavaReplaceWithEditionAction(boolean previous) {
        this();
        this.fPrevious = previous;
    }

    protected ITypedElement[] buildEditions(ITypedElement target, IFile file, IFileState[] states) {
        ITypedElement[] editions = new ITypedElement[states.length + 1];
        editions[0] = new ResourceNode((IResource)file);
        int i = 0;
        while (i < states.length) {
            editions[i + 1] = new HistoryItem(target, states[i]);
            ++i;
        }
        return editions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IAction action) {
        TextBuffer buffer;
        block18: {
            block19: {
                block17: {
                    String errorTitle = CompareMessages.getString("ReplaceFromHistory.title");
                    String errorMessage = CompareMessages.getString("ReplaceFromHistory.internalErrorMessage");
                    Shell shell = JavaPlugin.getActiveWorkbenchShell();
                    ISelection selection = this.getSelection();
                    IMember input = this.getEditionElement(selection);
                    if (input == null) {
                        String invalidSelectionMessage = CompareMessages.getString("ReplaceFromHistory.invalidSelectionMessage");
                        MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)invalidSelectionMessage);
                        return;
                    }
                    IFile file = this.getFile(input);
                    if (file == null) {
                        MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                        return;
                    }
                    boolean inEditor = this.beingEdited(file);
                    if (inEditor) {
                        input = (IMember)this.getWorkingCopy((IJavaElement)input);
                    }
                    buffer = null;
                    try {
                        try {
                            buffer = TextBuffer.acquire(file);
                            ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
                            EditionSelectionDialog d = new EditionSelectionDialog(shell, bundle);
                            d.setHelpContextId("org.eclipse.jdt.ui.replace_element_with_history_dialog_context");
                            JavaHistoryAction.JavaTextBufferNode target = new JavaHistoryAction.JavaTextBufferNode(buffer, inEditor);
                            ITypedElement[] editions = this.buildEditions(target, file);
                            ITypedElement ti = null;
                            if (this.fPrevious) {
                                ti = d.selectPreviousEdition((ITypedElement)target, editions, (Object)input);
                                if (ti == null) {
                                    MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)CompareMessages.getString("ReplaceFromHistory.parsingErrorMessage"));
                                    Object var22_18 = null;
                                    if (buffer == null) return;
                                    break block17;
                                }
                            } else {
                                ti = d.selectEdition((ITypedElement)target, editions, (Object)input);
                            }
                            if (!(ti instanceof IStreamContentAccessor)) break block18;
                            String[] lines = null;
                            try {
                                lines = JavaCompareUtilities.readLines(((IStreamContentAccessor)ti).getContents());
                            }
                            catch (CoreException ex) {
                                JavaPlugin.log(ex);
                            }
                            if (lines == null) {
                                MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                                break block19;
                            }
                            MemberEdit edit = new MemberEdit((IJavaElement)input, 4, lines, JavaCompareUtilities.getTabSize());
                            edit.setAddLineSeparators(false);
                            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
                            TextBufferEditor editor = new TextBufferEditor(buffer);
                            editor.add(edit);
                            editor.performEdits((IProgressMonitor)nullProgressMonitor);
                            final TextBuffer bb = buffer;
                            IRunnableWithProgress r = new IRunnableWithProgress(){

                                public void run(IProgressMonitor pm) throws InvocationTargetException {
                                    try {
                                        TextBuffer.commitChanges(bb, false, pm);
                                    }
                                    catch (CoreException ex) {
                                        throw new InvocationTargetException(ex);
                                    }
                                }
                            };
                            if (inEditor) {
                                JavaEditor je = this.getEditor(file);
                                if (je != null) {
                                    je.setFocus();
                                }
                                r.run((IProgressMonitor)nullProgressMonitor);
                                break block18;
                            }
                            ProgressMonitorDialog pd = new ProgressMonitorDialog(shell);
                            pd.run(true, false, r);
                        }
                        catch (InvocationTargetException ex) {
                            ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (CoreException ex) {
                            ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                        }
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var22_20 = null;
                        if (buffer == null) throw throwable;
                        TextBuffer.release(buffer);
                        throw throwable;
                    }
                }
                TextBuffer.release(buffer);
                return;
            }
            Object var22_19 = null;
            if (buffer == null) return;
            TextBuffer.release(buffer);
            return;
        }
        Object var22_21 = null;
        if (buffer == null) return;
        TextBuffer.release(buffer);
    }

    private JavaEditor getEditor(IFile file) {
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    if (ep instanceof JavaEditor) {
                        return (JavaEditor)ep;
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return null;
    }
}

