/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryAction;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.IUpdate;

public class JavaHistoryEditorAction
extends Action
implements IUpdate {
    private JavaEditor fEditor;
    private JavaHistoryAction fAction;
    private String fTitle;
    private String fMessage;

    public JavaHistoryEditorAction(JavaEditor editor, JavaHistoryAction action, String text, String title, String message) {
        Assert.isNotNull((Object)editor);
        Assert.isNotNull((Object)action);
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)message);
        this.fEditor = editor;
        this.fAction = action;
        this.fTitle = title;
        this.fMessage = message;
        this.setText(text);
        this.setEnabled(this.checkEnabled());
    }

    public void run() {
        this.updateDelegate();
        if (!this.isEnabled()) {
            MessageDialog.openInformation((Shell)this.fEditor.getEditorSite().getShell(), (String)this.fTitle, (String)this.fMessage);
            return;
        }
        this.fAction.run((IAction)this);
    }

    public void update() {
        this.setEnabled(this.checkEnabled());
    }

    private void updateDelegate() {
        IJavaElement element = null;
        try {
            element = SelectionConverter.getElementAtOffset(this.fEditor);
        }
        catch (JavaModelException javaModelException) {}
        StructuredSelection selection = StructuredSelection.EMPTY;
        if (element != null) {
            selection = new StructuredSelection((Object)element);
        }
        this.fAction.selectionChanged((IAction)this, (ISelection)selection);
    }

    private boolean checkEnabled() {
        ICompilationUnit unit = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
        IFile file = this.fAction.getFile(unit);
        return this.fAction.isEnabled(file);
    }
}

