/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaStructureCreator;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.part.FileEditorInput;

public abstract class JavaHistoryAction
implements IActionDelegate {
    private boolean fModifiesFile;
    private ISelection fSelection;

    JavaHistoryAction(boolean modifiesFile) {
        this.fModifiesFile = modifiesFile;
    }

    ISelection getSelection() {
        return this.fSelection;
    }

    protected IFile getFile(Object input) {
        IFile file;
        ICompilationUnit cu = null;
        if (input instanceof ICompilationUnit) {
            cu = (ICompilationUnit)input;
        } else if (input instanceof IMember) {
            cu = ((IMember)input).getCompilationUnit();
        }
        if (cu == null || !cu.exists()) {
            return null;
        }
        if (cu.isWorkingCopy()) {
            cu = (ICompilationUnit)cu.getOriginalElement();
        }
        if ((file = (IFile)cu.getResource()) != null && file.exists()) {
            return file;
        }
        return null;
    }

    protected ITypedElement[] buildEditions(ITypedElement target, IFile file) {
        IFileState[] states = null;
        try {
            states = file.getHistory(null);
        }
        catch (CoreException ex) {
            JavaPlugin.log(ex);
        }
        int count = 1;
        if (states != null) {
            count += states.length;
        }
        ITypedElement[] editions = new ITypedElement[count];
        editions[0] = new ResourceNode((IResource)file);
        if (states != null) {
            int i = 0;
            while (i < states.length) {
                editions[i + 1] = new HistoryItem(target, states[i]);
                ++i;
            }
        }
        return editions;
    }

    protected IJavaElement getWorkingCopy(IJavaElement input) {
        try {
            return EditorUtility.getWorkingCopy(input, true);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    boolean beingEdited(IFile file) {
        FileEditorInput input;
        CompilationUnitDocumentProvider dp = JavaPlugin.getDefault().getCompilationUnitDocumentProvider();
        return dp.getDocument(input = new FileEditorInput(file)) != null;
    }

    IMember getEditionElement(ISelection selection) {
        IMember m;
        Object o;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (o = ss.getFirstElement()) instanceof IMember && (m = (IMember)o).exists() && !m.isBinary() && JavaStructureCreator.hasEdition((IJavaElement)m)) {
            return m;
        }
        return null;
    }

    protected boolean isEnabled(IFile file) {
        if (file == null) {
            return false;
        }
        return !this.fModifiesFile || !file.isReadOnly();
    }

    protected boolean isEnabled(ISelection selection) {
        IMember m = this.getEditionElement(selection);
        if (m == null) {
            return false;
        }
        IFile file = this.getFile(m);
        if (!this.isEnabled(file)) {
            return false;
        }
        if (file != null && this.beingEdited(file)) {
            return this.getWorkingCopy((IJavaElement)m) != null;
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        action.setEnabled(this.isEnabled(selection));
    }

    public abstract void run(IAction var1);

    class JavaTextBufferNode
    implements ITypedElement,
    IStreamContentAccessor {
        private TextBuffer fBuffer;
        private boolean fInEditor;

        JavaTextBufferNode(TextBuffer buffer, boolean inEditor) {
            this.fBuffer = buffer;
            this.fInEditor = inEditor;
        }

        public String getName() {
            if (this.fInEditor) {
                return CompareMessages.getString("Editor_Buffer");
            }
            return CompareMessages.getString("Workspace_File");
        }

        public String getType() {
            return "java";
        }

        public Image getImage() {
            return null;
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(JavaCompareUtilities.getBytes(this.fBuffer.getContent()));
        }
    }
}

