/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryAction;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;

public class JavaCompareWithEditionAction
extends JavaHistoryAction {
    private static final String BUNDLE_NAME = "org.eclipse.jdt.internal.ui.compare.CompareWithEditionAction";

    public JavaCompareWithEditionAction() {
        super(false);
    }

    public void run(IAction action) {
        block8: {
            String errorTitle = CompareMessages.getString("CompareWithHistory.title");
            String errorMessage = CompareMessages.getString("CompareWithHistory.internalErrorMessage");
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            ISelection selection = this.getSelection();
            IMember input = this.getEditionElement(selection);
            if (input == null) {
                String invalidSelectionMessage = CompareMessages.getString("CompareWithHistory.invalidSelectionMessage");
                MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)invalidSelectionMessage);
                return;
            }
            IFile file = this.getFile(input);
            if (file == null) {
                MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                return;
            }
            boolean inEditor = this.beingEdited(file);
            if (inEditor) {
                input = (IMember)this.getWorkingCopy((IJavaElement)input);
            }
            TextBuffer buffer = null;
            try {
                try {
                    buffer = TextBuffer.acquire(file);
                    JavaHistoryAction.JavaTextBufferNode target = new JavaHistoryAction.JavaTextBufferNode(this, buffer, inEditor);
                    ITypedElement[] editions = this.buildEditions(target, file);
                    ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
                    EditionSelectionDialog d = new EditionSelectionDialog(shell, bundle);
                    d.setHelpContextId("org.eclipse.jdt.ui.compare_element_with_history_dialog_context");
                    d.setCompareMode(true);
                    d.setEditionTitleImage(JavaCompareUtilities.getImage(input));
                    d.selectEdition((ITypedElement)target, editions, (Object)input);
                }
                catch (CoreException ex) {
                    ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                if (buffer != null) {
                    TextBuffer.release(buffer);
                }
                throw throwable;
            }
            Object var14_18 = null;
            if (buffer == null) break block8;
            TextBuffer.release(buffer);
        }
    }
}

