/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;

class JavaCompareUtilities {
    JavaCompareUtilities() {
    }

    static int getTabSize() {
        String string = (String)JavaCore.getOptions().get("org.eclipse.jdt.core.formatter.tabulation.size");
        try {
            int i = Integer.parseInt(string);
            if (i >= 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 4;
    }

    static String getString(ResourceBundle bundle, String key, String dfltValue) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }

    static String getString(ResourceBundle bundle, String key) {
        return JavaCompareUtilities.getString(bundle, key, key);
    }

    static int getInteger(ResourceBundle bundle, String key, int dfltValue) {
        if (bundle != null) {
            try {
                String s = bundle.getString(key);
                if (s != null) {
                    return Integer.parseInt(s);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return dfltValue;
    }

    static ImageDescriptor getImageDescriptor(int type) {
        switch (type) {
            case 9: 
            case 10: {
                return JavaCompareUtilities.getImageDescriptor("obj16/compare_method.gif");
            }
            case 8: {
                return JavaCompareUtilities.getImageDescriptor("obj16/compare_field.gif");
            }
            case 11: {
                return JavaPluginImages.DESC_OBJS_PACKDECL;
            }
            case 13: {
                return JavaPluginImages.DESC_OBJS_IMPDECL;
            }
            case 12: {
                return JavaPluginImages.DESC_OBJS_IMPCONT;
            }
            case 5: {
                return JavaPluginImages.DESC_OBJS_CUNIT;
            }
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    static ImageDescriptor getTypeImageDescriptor(boolean isClass) {
        if (isClass) {
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE;
    }

    static ImageDescriptor getImageDescriptor(IMember element) {
        int t = element.getElementType();
        if (t == 7) {
            IType type = (IType)element;
            try {
                return JavaCompareUtilities.getTypeImageDescriptor(type.isClass());
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return JavaPluginImages.DESC_OBJS_GHOST;
            }
        }
        return JavaCompareUtilities.getImageDescriptor(t);
    }

    static String getJavaElementID(IJavaElement je) {
        if (je instanceof IMember && ((IMember)je).isBinary()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        switch (je.getElementType()) {
            case 5: {
                sb.append('{');
                break;
            }
            case 7: {
                sb.append('[');
                sb.append(je.getElementName());
                break;
            }
            case 8: {
                sb.append('^');
                sb.append(je.getElementName());
                break;
            }
            case 9: {
                sb.append('~');
                sb.append(JavaElementLabels.getElementLabel(je, 1));
                break;
            }
            case 10: {
                String id = je.getHandleIdentifier();
                int pos = id.lastIndexOf(124);
                if (pos < 0) break;
                sb.append(id.substring(pos));
                break;
            }
            case 11: {
                sb.append('%');
                break;
            }
            case 12: {
                sb.append('<');
                break;
            }
            case 13: {
                sb.append('#');
                sb.append(je.getElementName());
                break;
            }
            default: {
                return null;
            }
        }
        return sb.toString();
    }

    static String buildID(int type, String name) {
        StringBuffer sb = new StringBuffer();
        switch (type) {
            case 0: {
                sb.append('{');
                break;
            }
            case 4: 
            case 5: {
                sb.append('[');
                sb.append(name);
                break;
            }
            case 6: {
                sb.append('^');
                sb.append(name);
                break;
            }
            case 8: 
            case 9: {
                sb.append('~');
                sb.append(name);
                break;
            }
            case 7: {
                sb.append('|');
                sb.append(name);
                break;
            }
            case 1: {
                sb.append('%');
                break;
            }
            case 3: {
                sb.append('#');
                sb.append(name);
                break;
            }
            case 2: {
                sb.append('<');
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
            }
        }
        return sb.toString();
    }

    static ImageDescriptor getImageDescriptor(String relativePath) {
        JavaPlugin plugin = JavaPlugin.getDefault();
        URL installURL = null;
        if (plugin != null) {
            installURL = plugin.getDescriptor().getInstallURL();
        }
        if (installURL != null) {
            try {
                URL url = new URL(installURL, "icons/full/" + relativePath);
                return ImageDescriptor.createFromURL((URL)url);
            }
            catch (MalformedURLException malformedURLException) {
                Assert.isTrue((boolean)false);
            }
        }
        return null;
    }

    static Image getImage(IMember member) {
        ImageDescriptor id = JavaCompareUtilities.getImageDescriptor(member);
        return id.createImage();
    }

    static JavaTextTools getJavaTextTools() {
        JavaPlugin plugin = JavaPlugin.getDefault();
        if (plugin != null) {
            return plugin.getJavaTextTools();
        }
        return null;
    }

    static IDocumentPartitioner createJavaPartitioner() {
        JavaTextTools tools = JavaCompareUtilities.getJavaTextTools();
        if (tools != null) {
            return tools.createDocumentPartitioner();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readString(InputStream is) {
        block12: {
            if (is == null) {
                return null;
            }
            reader = null;
            try {
                try {
                    buffer = new StringBuffer();
                    part = new char[2048];
                    read = 0;
                    reader = new BufferedReader(new InputStreamReader(is, ResourcesPlugin.getEncoding()));
                    while (true) {
                        if ((read = reader.read(part)) == -1) {
                            var7_5 = buffer.toString();
                            var5_6 = null;
                            if (reader == null) return var7_5;
                            break;
                        }
                        buffer.append(part, 0, read);
                    }
                }
                catch (IOException v0) {
                    break block12;
                }
            }
            catch (Throwable var6_12) {
                var5_7 = null;
                if (reader == null) throw var6_12;
                try {
                    reader.close();
                    throw var6_12;
                }
                catch (IOException ex) {
                    JavaPlugin.log(ex);
                }
                throw var6_12;
            }
            ** try [egrp 2[TRYBLOCK] [2 : 104->111)] { 
lbl34:
            // 1 sources

            reader.close();
            return var7_5;
lbl36:
            // 1 sources

            catch (IOException ex) {
                JavaPlugin.log(ex);
            }
            return var7_5;
        }
        var5_8 = null;
        if (reader == null) return null;
        try {}
        catch (IOException ex) {
            JavaPlugin.log(ex);
            return null;
        }
        reader.close();
        return null;
    }

    static byte[] getBytes(String s) {
        try {
            return s.getBytes(ResourcesPlugin.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s.getBytes();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String[] readLines(InputStream is2) {
        reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(is2, ResourcesPlugin.getEncoding()));
                sb = new StringBuffer();
                list = new ArrayList<String>();
                while ((c = reader.read()) != -1) {
                    sb.append((char)c);
                    if (c == 13) {
                        c = reader.read();
                        if (c == -1) break;
                        sb.append((char)c);
                        if (c != 10) continue;
                        list.add(sb.toString());
                        sb = new StringBuffer();
                        continue;
                    }
                    if (c != 10) continue;
                    list.add(sb.toString());
                    sb = new StringBuffer();
                }
                if (sb.length() > 0) {
                    list.add(sb.toString());
                }
                var7_5 = list.toArray(new String[list.size()]);
                var5_6 = null;
                if (reader == null) return var7_5;
            }
            catch (IOException v0) {
                var5_7 = null;
                if (reader == null) return null;
                try {
                    reader.close();
                    return null;
                }
                catch (IOException ex) {
                    JavaPlugin.log(ex);
                }
                return null;
            }
        }
        catch (Throwable var6_12) {
            var5_8 = null;
            if (reader == null) throw var6_12;
            try {}
            catch (IOException ex) {
                JavaPlugin.log(ex);
                throw var6_12;
            }
            reader.close();
            throw var6_12;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 212->219)] { 
lbl55:
        // 1 sources

        reader.close();
        return var7_5;
lbl57:
        // 1 sources

        catch (IOException ex) {
            JavaPlugin.log(ex);
        }
        return var7_5;
    }
}

