/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.MemberEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryAction;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class JavaAddElementFromHistory
extends JavaHistoryAction {
    private static final String BUNDLE_NAME = "org.eclipse.jdt.internal.ui.compare.AddFromHistoryAction";
    private JavaEditor fEditor;

    public JavaAddElementFromHistory() {
        super(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IAction action) {
        TextBuffer buffer;
        block28: {
            block27: {
                block26: {
                    block25: {
                        IMember input;
                        IParent parent;
                        ICompilationUnit cu;
                        Shell shell;
                        String errorMessage;
                        String errorTitle;
                        block30: {
                            Object o;
                            ISelection selection;
                            block31: {
                                block29: {
                                    errorTitle = CompareMessages.getString("AddFromHistory.title");
                                    errorMessage = CompareMessages.getString("AddFromHistory.internalErrorMessage");
                                    shell = JavaPlugin.getActiveWorkbenchShell();
                                    cu = null;
                                    parent = null;
                                    input = null;
                                    selection = this.getSelection();
                                    if (!selection.isEmpty()) break block29;
                                    if (this.fEditor != null) {
                                        IEditorInput editorInput = this.fEditor.getEditorInput();
                                        IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
                                        if (manager != null) {
                                            cu = manager.getWorkingCopy(editorInput);
                                            parent = cu;
                                        }
                                    }
                                    break block30;
                                }
                                input = this.getEditionElement(selection);
                                if (input == null) break block31;
                                cu = input.getCompilationUnit();
                                if (input instanceof IParent) {
                                    parent = (IParent)input;
                                    input = null;
                                    break block30;
                                } else {
                                    IJavaElement parentElement = input.getParent();
                                    if (parentElement instanceof IParent) {
                                        parent = (IParent)parentElement;
                                    }
                                }
                                break block30;
                            }
                            if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ICompilationUnit) {
                                cu = (ICompilationUnit)o;
                                parent = cu;
                            }
                        }
                        if (parent == null || cu == null) {
                            String invalidSelectionMessage = CompareMessages.getString("AddFromHistory.invalidSelectionMessage");
                            MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)invalidSelectionMessage);
                            return;
                        }
                        IFile file = this.getFile(parent);
                        if (file == null) {
                            MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                            return;
                        }
                        boolean inEditor = this.beingEdited(file);
                        if (inEditor) {
                            parent = (IParent)this.getWorkingCopy((IJavaElement)parent);
                            if (input != null) {
                                input = (IMember)this.getWorkingCopy((IJavaElement)input);
                            }
                        }
                        buffer = null;
                        try {
                            try {
                                IRunnableWithProgress r;
                                buffer = TextBuffer.acquire(file);
                                JavaHistoryAction.JavaTextBufferNode target = new JavaHistoryAction.JavaTextBufferNode(this, buffer, inEditor);
                                ITypedElement[] editions = this.buildEditions(target, file);
                                ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
                                EditionSelectionDialog d = new EditionSelectionDialog(shell, bundle);
                                d.setAddMode(true);
                                d.setHelpContextId("org.eclipse.jdt.ui.add_element_from_history_dialog_context");
                                ITypedElement selected = d.selectEdition((ITypedElement)target, editions, (Object)parent);
                                if (selected == null) {
                                    Object var25_20 = null;
                                    if (buffer == null) return;
                                    break block25;
                                }
                                ITypedElement[] results = d.getSelection();
                                ArrayList<MemberEdit> edits = new ArrayList<MemberEdit>();
                                int i = 0;
                                while (true) {
                                    if (i >= results.length) break;
                                    ITypedElement ti = results[i];
                                    if (ti instanceof IStreamContentAccessor) {
                                        IStreamContentAccessor sca = (IStreamContentAccessor)ti;
                                        String[] lines = null;
                                        try {
                                            lines = JavaCompareUtilities.readLines(sca.getContents());
                                        }
                                        catch (CoreException ex) {
                                            JavaPlugin.log(ex);
                                        }
                                        if (lines == null) {
                                            MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                                            break block26;
                                        }
                                        MemberEdit edit = null;
                                        edit = input != null ? new MemberEdit((IJavaElement)input, 1, lines, JavaCompareUtilities.getTabSize()) : this.createEdit(lines, parent);
                                        if (edit == null) {
                                            MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                                            break block27;
                                        }
                                        edit.setAddLineSeparators(false);
                                        edits.add(edit);
                                    }
                                    ++i;
                                }
                                NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
                                TextBufferEditor editor = new TextBufferEditor(buffer);
                                Iterator iter = ((AbstractList)edits).iterator();
                                while (true) {
                                    if (!iter.hasNext()) {
                                        editor.performEdits((IProgressMonitor)nullProgressMonitor);
                                        final TextBuffer bb = buffer;
                                        r = new IRunnableWithProgress(){

                                            public void run(IProgressMonitor pm) throws InvocationTargetException {
                                                try {
                                                    TextBuffer.commitChanges(bb, false, pm);
                                                }
                                                catch (CoreException ex) {
                                                    throw new InvocationTargetException(ex);
                                                }
                                            }
                                        };
                                        if (!inEditor) break;
                                        r.run((IProgressMonitor)nullProgressMonitor);
                                        break block28;
                                    }
                                    editor.add((TextEdit)iter.next());
                                }
                                ProgressMonitorDialog pd = new ProgressMonitorDialog(shell);
                                pd.run(true, false, r);
                            }
                            catch (InvocationTargetException ex) {
                                ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (CoreException ex) {
                                ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                            }
                            break block28;
                        }
                        catch (Throwable throwable) {
                            Object var25_23 = null;
                            if (buffer == null) throw throwable;
                            TextBuffer.release(buffer);
                            throw throwable;
                        }
                    }
                    TextBuffer.release(buffer);
                    return;
                }
                Object var25_21 = null;
                if (buffer == null) return;
                TextBuffer.release(buffer);
                return;
            }
            Object var25_22 = null;
            if (buffer == null) return;
            TextBuffer.release(buffer);
            return;
        }
        Object var25_24 = null;
        if (buffer == null) return;
        TextBuffer.release(buffer);
    }

    private MemberEdit createEdit(String[] lines, IParent container) {
        IJavaElement[] children = null;
        try {
            children = container.getChildren();
        }
        catch (JavaModelException javaModelException) {}
        if (children != null) {
            IJavaElement candidate = null;
            int i = 0;
            while (i < children.length) {
                IJavaElement chld = children[i];
                switch (chld.getElementType()) {
                    case 11: 
                    case 12: {
                        candidate = chld;
                        break;
                    }
                    default: {
                        return new MemberEdit(chld, 0, lines, JavaCompareUtilities.getTabSize());
                    }
                }
                ++i;
            }
            if (candidate != null) {
                return new MemberEdit(candidate, 1, lines, JavaCompareUtilities.getTabSize());
            }
        }
        if (container instanceof IJavaElement) {
            return new MemberEdit((IJavaElement)container, 3, lines, JavaCompareUtilities.getTabSize());
        }
        return null;
    }

    protected boolean isEnabled(ISelection selection) {
        Object o;
        if (selection.isEmpty()) {
            if (this.fEditor != null) {
                IEditorInput editorInput = this.fEditor.getEditorInput();
                IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
                return manager.getWorkingCopy(editorInput) != null;
            }
            return false;
        }
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ICompilationUnit) {
            return true;
        }
        return super.isEnabled(selection);
    }
}

