/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectAllAction;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.browsing.TopLevelTypeProblemsLabelDecorator;
import org.eclipse.jdt.internal.ui.filters.NonJavaElementFilter;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTargetList;

public class TypesView
extends JavaBrowsingPart {
    private SelectAllAction fSelectAllAction;
    static /* synthetic */ Class class$0;

    protected JavaUILabelProvider createLabelProvider() {
        AppearanceAwareLabelProvider lprovider = new AppearanceAwareLabelProvider(1090519049, 1);
        lprovider.addLabelDecorator(new TopLevelTypeProblemsLabelDecorator(null));
        return lprovider;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    protected void addFilters() {
        super.addFilters();
        this.getViewer().addFilter((ViewerFilter)new NonJavaElementFilter());
    }

    protected boolean isValidInput(Object element) {
        return element instanceof IPackageFragment;
    }

    protected boolean isValidElement(Object element) {
        if (element instanceof ICompilationUnit) {
            return super.isValidElement(((ICompilationUnit)element).getParent());
        }
        if (element instanceof IType) {
            IType type = (IType)element;
            return type.getDeclaringType() == null && this.isValidElement(type.getCompilationUnit());
        }
        return false;
    }

    protected IJavaElement findElementToSelect(IJavaElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                IType type = ((IType)je).getDeclaringType();
                if (type == null) {
                    type = (IType)je;
                }
                return this.getSuitableJavaElement(type);
            }
            case 5: {
                return this.getTypeForCU((ICompilationUnit)je);
            }
            case 6: {
                try {
                    return this.findElementToSelect((IJavaElement)((IClassFile)je).getType());
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
            }
            case 11: 
            case 12: 
            case 13: {
                return this.findElementToSelect(je.getParent());
            }
        }
        if (je instanceof IMember) {
            return this.findElementToSelect((IJavaElement)((IMember)je).getDeclaringType());
        }
        return null;
    }

    protected String getHelpContextId() {
        return "org.eclipse.jdt.ui.types_view_context";
    }

    protected String getLinkToEditorKey() {
        return "org.eclipse.jdt.ui.browsing.typestoeditor";
    }

    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction((TableViewer)this.getViewer());
    }

    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("selectAll", (IAction)this.fSelectAllAction);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part, selection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        Object selectedElement = sel.getFirstElement();
        if (sel.size() == 1 && selectedElement instanceof LogicalPackage) {
            IPackageFragment[] fragments = ((LogicalPackage)((Object)selectedElement)).getFragments();
            List<IPackageFragment> selectedElements = Arrays.asList(fragments);
            if (selectedElements.size() > 1) {
                this.adjustInput(part, selectedElements);
                this.fPreviousSelectedElement = selectedElements;
                this.fPreviousSelectionProvider = part;
            } else if (selectedElements.size() == 1) {
                super.selectionChanged(part, (ISelection)new StructuredSelection((Object)selectedElements.get(0)));
            } else {
                Assert.isLegal((boolean)false);
            }
            return;
        }
        super.selectionChanged(part, selection);
    }

    private void adjustInput(IWorkbenchPart part, List selectedElements) {
        Object currentInput = this.getViewer().getInput();
        if (!selectedElements.equals(currentInput)) {
            this.setInput(selectedElements);
        }
    }
}

