/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingContentProvider;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;

class ProjectAndSourceFolderContentProvider
extends JavaBrowsingContentProvider {
    ProjectAndSourceFolderContentProvider(JavaBrowsingPart browsingPart) {
        super(false, browsingPart);
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return StandardJavaElementContentProvider.NO_CHILDREN;
        }
        try {
            if (element instanceof IStructuredSelection) {
                Assert.isLegal((boolean)false);
                Object[] result = new Object[]{};
                Class<?> clazz = null;
                Iterator iter = ((IStructuredSelection)element).iterator();
                while (iter.hasNext()) {
                    Object item = iter.next();
                    if (clazz == null) {
                        clazz = item.getClass();
                    }
                    if (clazz == item.getClass()) {
                        result = StandardJavaElementContentProvider.concatenate(result, this.getChildren(item));
                        continue;
                    }
                    return StandardJavaElementContentProvider.NO_CHILDREN;
                }
                return result;
            }
            if (element instanceof IStructuredSelection) {
                Assert.isLegal((boolean)false);
                Object[] result = new Object[]{};
                Iterator iter = ((IStructuredSelection)element).iterator();
                while (iter.hasNext()) {
                    result = StandardJavaElementContentProvider.concatenate(result, this.getChildren(iter.next()));
                }
                return result;
            }
            if (element instanceof IJavaProject) {
                return this.getPackageFragmentRoots((IJavaProject)element);
            }
            if (element instanceof IPackageFragmentRoot) {
                return StandardJavaElementContentProvider.NO_CHILDREN;
            }
        }
        catch (JavaModelException javaModelException) {
            return StandardJavaElementContentProvider.NO_CHILDREN;
        }
        return super.getChildren(element);
    }

    protected Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
        if (!project.getProject().isOpen()) {
            return StandardJavaElementContentProvider.NO_CHILDREN;
        }
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> list = new ArrayList<IPackageFragmentRoot>(roots.length);
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (!this.isProjectPackageFragmentRoot(root)) {
                list.add(root);
            }
            ++i;
        }
        return list.toArray();
    }

    public boolean hasChildren(Object element) {
        return element instanceof IJavaProject && super.hasChildren(element);
    }
}

