/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.browsing.IPackagesViewViewer;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class PackagesViewTreeViewer
extends ProblemTreeViewer
implements IPackagesViewViewer {
    public PackagesViewTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void mapElement(Object element, Widget item) {
        if (element instanceof LogicalPackage && item instanceof Item) {
            LogicalPackage cp = (LogicalPackage)((Object)element);
            IPackageFragment[] fragments = cp.getFragments();
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment fragment = fragments[i];
                this.fResourceToItemsMapper.addToMap(fragment, (Item)item);
                ++i;
            }
        }
        super.mapElement(element, item);
    }

    public void unmapElement(Object element, Widget item) {
        if (element instanceof LogicalPackage && item instanceof Item) {
            LogicalPackage cp = (LogicalPackage)((Object)element);
            IPackageFragment[] fragments = cp.getFragments();
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment fragment = fragments[i];
                this.fResourceToItemsMapper.removeFromMap(fragment, (Item)item);
                ++i;
            }
        }
        super.unmapElement(element, item);
    }

    protected Object[] getFilteredChildren(Object parent) {
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] result = this.getRawChildren(parent);
        if (result != null) {
            Object[] toBeFiltered = new Object[1];
            int i = 0;
            while (i < result.length) {
                Object object;
                toBeFiltered[0] = object = result[i];
                if (object instanceof LogicalPackage) {
                    if (this.filterLogicalPackages((LogicalPackage)((Object)object))) {
                        list.add(object);
                    }
                } else if (this.isEssential(object) || this.filter(toBeFiltered).length == 1) {
                    list.add(object);
                }
                ++i;
            }
        }
        return list.toArray();
    }

    private boolean isEssential(Object object) {
        try {
            if (object instanceof IPackageFragment) {
                IPackageFragment fragment = (IPackageFragment)object;
                return !fragment.isDefaultPackage() && fragment.hasSubpackages();
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    private boolean filterLogicalPackages(LogicalPackage logicalPackage) {
        IPackageFragment[] fragments = logicalPackage.getFragments();
        Object[] toBeFiltered = new Object[1];
        int i = 0;
        while (i < fragments.length) {
            IPackageFragment fragment = fragments[i];
            toBeFiltered[0] = fragment;
            if (this.isEssential(fragment) || this.filter(toBeFiltered).length != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Widget doFindItem(Object element) {
        return super.doFindItem(element);
    }

    public Widget doFindInputItem(Object element) {
        return super.doFindInputItem(element);
    }

    public List getSelectionFromWidget() {
        return super.getSelectionFromWidget();
    }

    public void doUpdateItem(Widget item, Object element, boolean fullMap) {
        super.doUpdateItem(item, element, fullMap);
    }

    public void internalRefresh(Object element) {
        super.internalRefresh(element);
    }

    public void setSelectionToWidget(List l, boolean reveal) {
        super.setSelectionToWidget(l, reveal);
    }
}

