/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.corext.codemanipulation.IOverrideMethodQuery;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class OverrideMethodQuery
implements IOverrideMethodQuery {
    private boolean fEmptySelectionAllowed;
    private Shell fShell;

    public OverrideMethodQuery(Shell shell, boolean emptySelectionAllowed) {
        this.fShell = shell;
        this.fEmptySelectionAllowed = emptySelectionAllowed;
    }

    public IMethod[] select(IMethod[] methods, IMethod[] defaultSelected, ITypeHierarchy typeHierarchy) {
        HashSet<IType> types = new HashSet<IType>(methods.length);
        int i = 0;
        while (i < methods.length) {
            types.add(methods[i].getDeclaringType());
            ++i;
        }
        Object[] typesArrays = ((AbstractCollection)types).toArray();
        OverrideMethodSorter sorter = new OverrideMethodSorter(typeHierarchy);
        sorter.sort(null, typesArrays);
        HashSet<Object> expanded = new HashSet<Object>(defaultSelected.length);
        int i2 = 0;
        while (i2 < defaultSelected.length) {
            expanded.add(defaultSelected[i2].getDeclaringType());
            ++i2;
        }
        if (expanded.isEmpty() && typesArrays.length > 0) {
            expanded.add(typesArrays[0]);
        }
        JavaElementLabelProvider lprovider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        OverrideMethodContentProvider contentProvider = new OverrideMethodContentProvider(methods, typesArrays);
        OverrideTreeSelectionDialog dialog = new OverrideTreeSelectionDialog(this.fShell, (ILabelProvider)lprovider, contentProvider);
        dialog.setValidator(new OverrideMethodValidator());
        dialog.setTitle(ActionMessages.getString("OverrideMethodQuery.dialog.title"));
        dialog.setMessage(ActionMessages.getString("OverrideMethodQuery.dialog.description"));
        dialog.setInitialSelections(defaultSelected);
        dialog.setExpandedElements(((AbstractCollection)expanded).toArray());
        dialog.setContainerMode(true);
        dialog.setSorter(sorter);
        dialog.setSize(60, 18);
        dialog.setInput(this);
        if (dialog.open() == 0) {
            Object[] checkedElements = dialog.getResult();
            ArrayList<Object> result = new ArrayList<Object>(checkedElements.length);
            int i3 = 0;
            while (i3 < checkedElements.length) {
                Object curr = checkedElements[i3];
                if (curr instanceof IMethod) {
                    result.add(curr);
                }
                ++i3;
            }
            return result.toArray(new IMethod[result.size()]);
        }
        return null;
    }

    private static class OverrideTreeSelectionDialog
    extends CheckedTreeSelectionDialog {
        private OverrideMethodContentProvider fContentProvider;

        public OverrideTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, OverrideMethodContentProvider contentProvider) {
            super(parent, labelProvider, (ITreeContentProvider)contentProvider);
            this.fContentProvider = contentProvider;
        }

        protected CheckboxTreeViewer createTreeViewer(Composite composite) {
            Composite inner = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 1;
            inner.setLayout((Layout)layout);
            inner.setLayoutData((Object)new GridData(1808));
            CheckboxTreeViewer treeViewer = super.createTreeViewer(inner);
            Button flatListButton = new Button(inner, 32);
            flatListButton.setText(ActionMessages.getString("OverrideMethodQuery.groupMethodsByTypes"));
            flatListButton.setLayoutData((Object)new GridData(256));
            flatListButton.addSelectionListener(new SelectionListener(this){
                private final /* synthetic */ OverrideTreeSelectionDialog this$1;
                {
                    this.this$1 = overrideTreeSelectionDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = ((Button)e.widget).getSelection();
                    OverrideTreeSelectionDialog.access$0(this.this$1).setShowTypes(isSelected);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            flatListButton.setSelection(this.fContentProvider.isShowTypes());
            return treeViewer;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.override_tree_selection_dialog_context");
        }

        static /* synthetic */ OverrideMethodContentProvider access$0(OverrideTreeSelectionDialog overrideTreeSelectionDialog) {
            return overrideTreeSelectionDialog.fContentProvider;
        }
    }

    private static class OverrideMethodContentProvider
    implements ITreeContentProvider {
        private final String SETTINGS_SECTION = "OverrideMethodDialog";
        private final String SETTINGS_SHOWTYPES = "showtypes";
        private Object[] fTypes;
        private IMethod[] fMethods;
        private final Object[] fEmpty = new Object[0];
        private boolean fShowTypes;
        private Viewer fViewer;
        private IDialogSettings fSettings;

        public OverrideMethodContentProvider(IMethod[] methods, Object[] types) {
            this.fMethods = methods;
            this.fTypes = types;
            IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
            this.fSettings = dialogSettings.getSection("OverrideMethodDialog");
            if (this.fSettings == null) {
                this.fSettings = dialogSettings.addNewSection("OverrideMethodDialog");
                this.fSettings.put("showtypes", true);
            }
            this.fShowTypes = this.fSettings.getBoolean("showtypes");
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IType) {
                ArrayList<IMethod> result = new ArrayList<IMethod>(this.fMethods.length);
                int i = 0;
                while (i < this.fMethods.length) {
                    if (this.fMethods[i].getDeclaringType().equals(parentElement)) {
                        result.add(this.fMethods[i]);
                    }
                    ++i;
                }
                return result.toArray();
            }
            return this.fEmpty;
        }

        public Object getParent(Object element) {
            if (element instanceof IMethod) {
                return ((IMethod)element).getDeclaringType();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fShowTypes ? this.fTypes : this.fMethods;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = viewer;
        }

        public boolean isShowTypes() {
            return this.fShowTypes;
        }

        public void setShowTypes(boolean showTypes) {
            if (this.fShowTypes != showTypes) {
                this.fShowTypes = showTypes;
                this.fSettings.put("showtypes", showTypes);
                if (this.fViewer != null) {
                    this.fViewer.refresh();
                }
            }
        }
    }

    private static class OverrideMethodSorter
    extends ViewerSorter {
        private IType[] fAllTypes;

        public OverrideMethodSorter(ITypeHierarchy typeHierarchy) {
            IType curr = typeHierarchy.getType();
            IType[] superTypes = typeHierarchy.getAllSupertypes(curr);
            this.fAllTypes = new IType[superTypes.length + 1];
            this.fAllTypes[0] = curr;
            System.arraycopy(superTypes, 0, this.fAllTypes, 1, superTypes.length);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IType && e2 instanceof IType) {
                if (e1.equals(e2)) {
                    return 0;
                }
                int i = 0;
                while (i < this.fAllTypes.length) {
                    IType curr = this.fAllTypes[i];
                    if (curr.equals(e1)) {
                        return -1;
                    }
                    if (curr.equals(e2)) {
                        return 1;
                    }
                    ++i;
                }
                return 0;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class OverrideMethodValidator
    implements ISelectionStatusValidator {
        OverrideMethodValidator() {
        }

        public IStatus validate(Object[] selection) {
            int count = 0;
            int i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof IMethod) {
                    ++count;
                }
                ++i;
            }
            if (count == 0 && !OverrideMethodQuery.this.fEmptySelectionAllowed) {
                return new StatusInfo(4, "");
            }
            String message = count == 1 ? ActionMessages.getFormattedString("OverrideMethodQuery.selectioninfo.one", String.valueOf(count)) : ActionMessages.getFormattedString("OverrideMethodQuery.selectioninfo.more", String.valueOf(count));
            return new StatusInfo(1, message);
        }
    }
}

