/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.ui.EditorInputAdapterFactory;
import org.eclipse.jdt.internal.ui.JavaElementAdapterFactory;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.LogicalPackageAdapterFactory;
import org.eclipse.jdt.internal.ui.MarkerAdapterFactory;
import org.eclipse.jdt.internal.ui.ResourceAdapterFactory;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemMarkerManager;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class JavaPlugin
extends AbstractUIPlugin {
    private static JavaPlugin fgJavaPlugin;
    private IWorkingCopyManager fWorkingCopyManager;
    private CompilationUnitDocumentProvider fCompilationUnitDocumentProvider;
    private ClassFileDocumentProvider fClassFileDocumentProvider;
    private JavaTextTools fJavaTextTools;
    private ProblemMarkerManager fProblemMarkerManager;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private JavaElementAdapterFactory fJavaElementAdapterFactory;
    private MarkerAdapterFactory fMarkerAdapterFactory;
    private EditorInputAdapterFactory fEditorInputAdapterFactory;
    private ResourceAdapterFactory fResourceAdapterFactory;
    private LogicalPackageAdapterFactory fLogicalPackageAdapterFactory;
    private MembersOrderPreferenceCache fMembersOrderPreferenceCache;
    private IPropertyChangeListener fFontPropertyChangeListener;
    private JavaEditorTextHoverDescriptor[] fJavaEditorTextHoverDescriptors;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public static JavaPlugin getDefault() {
        return fgJavaPlugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchPage getActivePage() {
        return JavaPlugin.getDefault().internalGetActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return JavaPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        return JavaPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static IEditorPart[] getInstanciatedEditors() {
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int windowIndex = 0;
        while (windowIndex < windows.length) {
            IWorkbenchPage[] pages = windows[windowIndex].getPages();
            int pageIndex = 0;
            while (pageIndex < pages.length) {
                IEditorReference[] references = pages[pageIndex].getEditorReferences();
                int refIndex = 0;
                while (refIndex < references.length) {
                    IEditorPart editor = references[refIndex].getEditor(false);
                    if (editor != null) {
                        result.add(editor);
                    }
                    ++refIndex;
                }
                ++pageIndex;
            }
            ++windowIndex;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static String getPluginId() {
        return JavaPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static void log(IStatus status) {
        JavaPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, null));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            JavaPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus(JavaPlugin.getPluginId(), 10001, message, null);
        multi.add(status);
        JavaPlugin.log((IStatus)multi);
    }

    public static void log(Throwable e) {
        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, JavaUIMessages.getString("JavaPlugin.internal_error"), e));
    }

    public static boolean isDebug() {
        return JavaPlugin.getDefault().isDebugging();
    }

    static IPath getInstallLocation() {
        return new Path(JavaPlugin.getDefault().getDescriptor().getInstallURL().getFile());
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return JavaPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    public JavaPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fgJavaPlugin = this;
    }

    public void startup() throws CoreException {
        super.startup();
        this.registerAdapters();
        String fontPropagatedKey = "fontPropagated";
        if (this.getPreferenceStore().contains("org.eclipse.jface.textfont") && !this.getPreferenceStore().isDefault("org.eclipse.jface.textfont") && !this.getPreferenceStore().getBoolean(fontPropagatedKey)) {
            PreferenceConverter.setValue((IPreferenceStore)PlatformUI.getWorkbench().getPreferenceStore(), (String)"org.eclipse.jdt.ui.editors.textfont", (FontData[])PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)"org.eclipse.jface.textfont"));
        }
        this.getPreferenceStore().setValue(fontPropagatedKey, true);
        PreferenceConverter.putValue((IPreferenceStore)this.getPreferenceStore(), (String)"org.eclipse.jface.textfont", (FontData[])JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.editors.textfont"));
        this.fFontPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jdt.ui.editors.textfont".equals(event.getProperty())) {
                    PreferenceConverter.putValue((IPreferenceStore)JavaPlugin.this.getPreferenceStore(), (String)"org.eclipse.jface.textfont", (FontData[])JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.editors.textfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fFontPropertyChangeListener);
    }

    protected ImageRegistry createImageRegistry() {
        return JavaPluginImages.getImageRegistry();
    }

    public void shutdown() throws CoreException {
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
        }
        this.unregisterAdapters();
        super.shutdown();
        if (this.fWorkingCopyManager != null) {
            this.fWorkingCopyManager.shutdown();
            this.fWorkingCopyManager = null;
        }
        if (this.fCompilationUnitDocumentProvider != null) {
            this.fCompilationUnitDocumentProvider.shutdown();
            this.fCompilationUnitDocumentProvider = null;
        }
        if (this.fJavaTextTools != null) {
            this.fJavaTextTools.dispose();
            this.fJavaTextTools = null;
        }
        JavaDocLocations.shutdownJavadocLocations();
        JFaceResources.getFontRegistry().removeListener(this.fFontPropertyChangeListener);
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public synchronized CompilationUnitDocumentProvider getCompilationUnitDocumentProvider() {
        if (this.fCompilationUnitDocumentProvider == null) {
            this.fCompilationUnitDocumentProvider = new CompilationUnitDocumentProvider();
        }
        return this.fCompilationUnitDocumentProvider;
    }

    public synchronized ClassFileDocumentProvider getClassFileDocumentProvider() {
        if (this.fClassFileDocumentProvider == null) {
            this.fClassFileDocumentProvider = new ClassFileDocumentProvider();
        }
        return this.fClassFileDocumentProvider;
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            CompilationUnitDocumentProvider provider = this.getCompilationUnitDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    public synchronized JavaTextTools getJavaTextTools() {
        if (this.fJavaTextTools == null) {
            this.fJavaTextTools = new JavaTextTools(this.getPreferenceStore(), JavaCore.getPlugin().getPluginPreferences());
        }
        return this.fJavaTextTools;
    }

    public synchronized MembersOrderPreferenceCache getMemberOrderPreferenceCache() {
        if (this.fMembersOrderPreferenceCache == null) {
            this.fMembersOrderPreferenceCache = new MembersOrderPreferenceCache();
        }
        return this.fMembersOrderPreferenceCache;
    }

    public JavaEditorTextHoverDescriptor[] getJavaEditorTextHoverDescriptors() {
        if (this.fJavaEditorTextHoverDescriptors == null) {
            this.fJavaEditorTextHoverDescriptors = JavaEditorTextHoverDescriptor.getContributedHovers();
        }
        return this.fJavaEditorTextHoverDescriptors;
    }

    public void resetJavaEditorTextHoverDescriptors() {
        this.fJavaEditorTextHoverDescriptors = null;
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        PreferenceConstants.initializeDefaultValues(store);
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    private void registerAdapters() {
        this.fJavaElementAdapterFactory = new JavaElementAdapterFactory();
        this.fMarkerAdapterFactory = new MarkerAdapterFactory();
        this.fEditorInputAdapterFactory = new EditorInputAdapterFactory();
        this.fResourceAdapterFactory = new ResourceAdapterFactory();
        this.fLogicalPackageAdapterFactory = new LogicalPackageAdapterFactory();
        IAdapterManager manager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fJavaElementAdapterFactory, (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fMarkerAdapterFactory, (Class)clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ui.IEditorInput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fEditorInputAdapterFactory, (Class)clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fResourceAdapterFactory, (Class)clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.jdt.internal.ui.browsing.LogicalPackage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fLogicalPackageAdapterFactory, (Class)clazz5);
    }

    private void unregisterAdapters() {
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters((IAdapterFactory)this.fJavaElementAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fMarkerAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fEditorInputAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fResourceAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fLogicalPackageAdapterFactory);
    }
}

