/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class WorkingCopyUtil {
    private WorkingCopyUtil() {
    }

    public static ICompilationUnit getWorkingCopyIfExists(ICompilationUnit cu) {
        if (cu == null) {
            return null;
        }
        return JavaModelUtil.toWorkingCopy(cu);
    }

    public static IMember getWorkingCopyIfExists(IMember member) throws JavaModelException {
        if (member == null) {
            return null;
        }
        return JavaModelUtil.toWorkingCopy(member);
    }

    public static IJavaElement getOriginal(IMember member) {
        return JavaModelUtil.toOriginal(member);
    }

    public static ICompilationUnit getOriginal(ICompilationUnit cu) {
        return JavaModelUtil.toOriginal(cu);
    }

    public static IMember[] getOriginals(IMember[] members) {
        IMember[] result = new IMember[members.length];
        int i = 0;
        while (i < members.length) {
            result[i] = (IMember)WorkingCopyUtil.getOriginal(members[i]);
            ++i;
        }
        return result;
    }

    public static ICompilationUnit getNewWorkingCopy(ICompilationUnit cu) throws JavaModelException {
        return (ICompilationUnit)WorkingCopyUtil.getOriginal(cu).getWorkingCopy();
    }

    public static ICompilationUnit getNewWorkingCopy(IPackageFragment pack, String cuName) throws JavaModelException {
        return (ICompilationUnit)pack.getCompilationUnit(cuName).getWorkingCopy();
    }
}

