/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;

public class JdtFlags {
    public static final String VISIBILITY_STRING_PRIVATE = "private";
    public static final String VISIBILITY_STRING_PACKAGE = "";
    public static final String VISIBILITY_STRING_PROTECTED = "protected";
    public static final String VISIBILITY_STRING_PUBLIC = "public";
    public static final int VISIBILITY_CODE_INVALID = -1;

    private JdtFlags() {
    }

    public static boolean isAbstract(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceMethod(member)) {
            return true;
        }
        return Flags.isAbstract((int)member.getFlags());
    }

    public static boolean isDeprecated(IMember member) throws JavaModelException {
        return Flags.isDeprecated((int)member.getFlags());
    }

    public static boolean isFinal(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceField(member)) {
            return true;
        }
        if (JdtFlags.isAnonymousType(member)) {
            return true;
        }
        return Flags.isFinal((int)member.getFlags());
    }

    public static boolean isNative(IMember member) throws JavaModelException {
        return Flags.isNative((int)member.getFlags());
    }

    public static boolean isPackageVisible(IMember member) throws JavaModelException {
        return !JdtFlags.isPrivate(member) && !JdtFlags.isProtected(member) && !JdtFlags.isPublic(member);
    }

    public static boolean isPrivate(IMember member) throws JavaModelException {
        return Flags.isPrivate((int)member.getFlags());
    }

    public static boolean isProtected(IMember member) throws JavaModelException {
        return Flags.isProtected((int)member.getFlags());
    }

    public static boolean isPublic(IMember member) throws JavaModelException {
        if (JdtFlags.isInterfaceMember(member)) {
            return true;
        }
        return Flags.isPublic((int)member.getFlags());
    }

    public static boolean isStatic(IMember member) throws JavaModelException {
        if (JdtFlags.isNestedInterface(member)) {
            return true;
        }
        if (member.getElementType() != 9 && JdtFlags.isInterfaceMember(member)) {
            return true;
        }
        return Flags.isStatic((int)member.getFlags());
    }

    public static boolean isStrictfp(IMember member) throws JavaModelException {
        return Flags.isStrictfp((int)member.getFlags());
    }

    public static boolean isSynchronized(IMember member) throws JavaModelException {
        return Flags.isSynchronized((int)member.getFlags());
    }

    public static boolean isSynthetic(IMember member) throws JavaModelException {
        return Flags.isSynthetic((int)member.getFlags());
    }

    public static boolean isTransient(IMember member) throws JavaModelException {
        return Flags.isTransient((int)member.getFlags());
    }

    public static boolean isVolatile(IMember member) throws JavaModelException {
        return Flags.isVolatile((int)member.getFlags());
    }

    private static boolean isInterfaceMethod(IMember member) throws JavaModelException {
        return member.getElementType() == 9 && JdtFlags.isInterfaceMember(member);
    }

    private static boolean isInterfaceField(IMember member) throws JavaModelException {
        return member.getElementType() == 8 && JdtFlags.isInterfaceMember(member);
    }

    private static boolean isInterfaceMember(IMember member) throws JavaModelException {
        return member.getDeclaringType() != null && member.getDeclaringType().isInterface();
    }

    private static boolean isNestedInterface(IMember member) throws JavaModelException {
        return member.getElementType() == 7 && member.getDeclaringType() != null && ((IType)member).isInterface();
    }

    private static boolean isAnonymousType(IMember member) throws JavaModelException {
        return member.getElementType() == 7 && ((IType)member).isAnonymous();
    }

    public static int getVisibilityCode(IMember member) throws JavaModelException {
        if (JdtFlags.isPublic(member)) {
            return 1;
        }
        if (JdtFlags.isProtected(member)) {
            return 4;
        }
        if (JdtFlags.isPackageVisible(member)) {
            return 0;
        }
        if (JdtFlags.isPrivate(member)) {
            return 2;
        }
        Assert.isTrue(false);
        return -1;
    }

    public static String getVisibilityString(int visibilityCode) {
        switch (visibilityCode) {
            case 1: {
                return VISIBILITY_STRING_PUBLIC;
            }
            case 4: {
                return VISIBILITY_STRING_PROTECTED;
            }
            case 0: {
                return VISIBILITY_STRING_PACKAGE;
            }
            case 2: {
                return VISIBILITY_STRING_PRIVATE;
            }
        }
        Assert.isTrue(false);
        return null;
    }

    public static void assertVisibility(int visibility) {
        Assert.isTrue(visibility == 1 || visibility == 4 || visibility == 0 || visibility == 2);
    }

    public static boolean isHigherVisibility(int newVisibility, int oldVisibility) {
        JdtFlags.assertVisibility(oldVisibility);
        JdtFlags.assertVisibility(newVisibility);
        switch (oldVisibility) {
            case 2: {
                return newVisibility == 0 || newVisibility == 1 || newVisibility == 4;
            }
            case 0: {
                return newVisibility == 1 || newVisibility == 4;
            }
            case 4: {
                return newVisibility == 1;
            }
            case 1: {
                return false;
            }
        }
        Assert.isTrue(false);
        return false;
    }
}

