/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;

public class JavaModelUtil {
    public static IType findType(IJavaProject jproject, String fullyQualifiedName) throws JavaModelException {
        IType type = jproject.findType(fullyQualifiedName);
        if (type != null) {
            return type;
        }
        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            type = JavaModelUtil.findType(root, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static boolean isReferenced(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject jarProject = resource.getProject();
            IProject container = root.getJavaProject().getProject();
            return !container.equals((Object)jarProject);
        }
        return false;
    }

    private static IType findType(IPackageFragmentRoot root, String fullyQualifiedName) throws JavaModelException {
        IJavaElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            IType type;
            IPackageFragment pack;
            IJavaElement element = children[i];
            if (element.getElementType() == 4 && fullyQualifiedName.startsWith((pack = (IPackageFragment)element).getElementName()) && (type = JavaModelUtil.findType(pack, fullyQualifiedName)) != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IType findType(IPackageFragment pack, String fullyQualifiedName) throws JavaModelException {
        ICompilationUnit[] cus = pack.getCompilationUnits();
        int i = 0;
        while (i < cus.length) {
            ICompilationUnit unit = cus[i];
            ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(unit);
            IType type = JavaModelUtil.findType(wc, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IType findType(ICompilationUnit cu, String fullyQualifiedName) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            if (JavaModelUtil.getFullyQualifiedName(type).equals(fullyQualifiedName)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public static IType findType(IJavaProject jproject, String pack, String typeQualifiedName) throws JavaModelException {
        return jproject.findType(pack, typeQualifiedName);
    }

    public static IJavaElement findTypeContainer(IJavaProject jproject, String typeContainerName) throws JavaModelException {
        Path path;
        IType result = jproject.findType(typeContainerName);
        if (result == null && !((result = jproject.findElement((IPath)(path = new Path(typeContainerName.replace('.', '/'))))) instanceof IPackageFragment)) {
            result = null;
        }
        return result;
    }

    public static IType findTypeInCompilationUnit(ICompilationUnit cu, String typeQualifiedName) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        int i = 0;
        while (i < types.length) {
            String currName = JavaModelUtil.getTypeQualifiedName(types[i]);
            if (typeQualifiedName.equals(currName)) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    public static IMember findMemberInCompilationUnit(ICompilationUnit cu, IMember member) throws JavaModelException {
        IJavaElement[] elements = cu.findElements((IJavaElement)member);
        if (elements != null && elements.length > 0) {
            return (IMember)elements[0];
        }
        return null;
    }

    public static IJavaElement findInCompilationUnit(ICompilationUnit cu, IJavaElement element) throws JavaModelException {
        IJavaElement[] elements = cu.findElements(element);
        if (elements != null && elements.length > 0) {
            return elements[0];
        }
        return null;
    }

    public static String getTypeQualifiedName(IType type) {
        return type.getTypeQualifiedName('.');
    }

    private static void getTypeQualifiedName(IType type, StringBuffer buf) {
        IType outerType = type.getDeclaringType();
        if (outerType != null) {
            JavaModelUtil.getTypeQualifiedName(outerType, buf);
            buf.append('.');
        }
        buf.append(type.getElementName());
    }

    public static String getFullyQualifiedName(IType type) {
        return type.getFullyQualifiedName('.');
    }

    public static String getTypeContainerName(IType type) {
        IType outerType = type.getDeclaringType();
        if (outerType != null) {
            return outerType.getFullyQualifiedName('.');
        }
        return type.getPackageFragment().getElementName();
    }

    public static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static String concatenateName(char[] name1, char[] name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static boolean isVisible(IMember member, IPackageFragment pack) throws JavaModelException {
        int otherflags = member.getFlags();
        if (Flags.isPublic((int)otherflags)) {
            return true;
        }
        if (Flags.isPrivate((int)otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)JavaModelUtil.findParentOfKind((IJavaElement)member, 4);
        return pack != null && pack.equals(otherpack);
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public static IJavaElement findParentOfKind(IJavaElement element, int kind) {
        if (element != null && element.getParent() != null) {
            return element.getParent().getAncestor(kind);
        }
        return null;
    }

    public static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IType type) throws JavaModelException {
        return JavaModelUtil.findMethod(name, paramTypes, isConstructor, type.getMethods());
    }

    public static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IMethod[] methods) throws JavaModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            if (JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, methods[i])) {
                return methods[i];
            }
            --i;
        }
        return null;
    }

    public static IMethod findMethodDeclarationInHierarchy(ITypeHierarchy hierarchy, IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        IType[] superTypes = hierarchy.getAllSupertypes(type);
        int i = superTypes.length - 1;
        while (i >= 0) {
            IMethod first = JavaModelUtil.findMethod(name, paramTypes, isConstructor, superTypes[i]);
            if (first != null && !Flags.isPrivate((int)first.getFlags())) {
                IMethod res = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, first.getDeclaringType(), name, paramTypes, isConstructor);
                if (res != null) {
                    return res;
                }
                return first;
            }
            --i;
        }
        return null;
    }

    public static IMethod findMethodImplementationInHierarchy(ITypeHierarchy hierarchy, IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        IType[] superTypes = hierarchy.getAllSuperclasses(type);
        int i = 0;
        while (i < superTypes.length) {
            IMethod found = JavaModelUtil.findMethod(name, paramTypes, isConstructor, superTypes[i]);
            if (found != null) {
                if (Flags.isAbstract((int)found.getFlags())) {
                    return null;
                }
                return found;
            }
            ++i;
        }
        return null;
    }

    public static boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, IMethod curr) throws JavaModelException {
        String[] currParamTypes;
        if ((isConstructor || name.equals(curr.getElementName())) && isConstructor == curr.isConstructor() && paramTypes.length == (currParamTypes = curr.getParameterTypes()).length) {
            int i = 0;
            while (i < paramTypes.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)paramTypes[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)currParamTypes[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean hasMainMethod(IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isMainMethod()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isBoolean(IField field) throws JavaModelException {
        return field.getTypeSignature().equals("Z");
    }

    public static boolean isOnBuildPath(IJavaProject jproject, IJavaElement element) throws JavaModelException {
        return jproject.isOnClasspath(element);
    }

    public static boolean isOnClasspath(IJavaElement element) {
        IJavaProject project = element.getJavaProject();
        if (!project.exists()) {
            return false;
        }
        return project.isOnClasspath(element);
    }

    public static String getResolvedTypeName(String refTypeSig, IType declaringType) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (type == 'Q') {
            int semi = refTypeSig.indexOf(59, arrayCount + 1);
            if (semi == -1) {
                throw new IllegalArgumentException();
            }
            String name = refTypeSig.substring(arrayCount + 1, semi);
            String[][] resolvedNames = declaringType.resolveType(name);
            if (resolvedNames != null && resolvedNames.length > 0) {
                return JavaModelUtil.concatenateName(resolvedNames[0][0], resolvedNames[0][1]);
            }
            return null;
        }
        return Signature.toString((String)refTypeSig.substring(arrayCount));
    }

    public static boolean isEditable(ICompilationUnit cu) {
        IResource resource;
        if (cu.isWorkingCopy()) {
            cu = (ICompilationUnit)cu.getOriginalElement();
        }
        return (resource = cu.getResource()).exists() && !resource.isReadOnly();
    }

    public static IImportDeclaration findImport(ICompilationUnit cu, String simpleName) throws JavaModelException {
        IImportDeclaration[] existing = cu.getImports();
        int i = 0;
        while (i < existing.length) {
            int dotPos;
            String curr = existing[i].getElementName();
            if (curr.endsWith(simpleName) && ((dotPos = curr.length() - simpleName.length() - 1) == -1 || dotPos > 0 && curr.charAt(dotPos) == '.')) {
                return existing[i];
            }
            ++i;
        }
        return null;
    }

    public static IMember toOriginal(IMember member) {
        if (member instanceof IMethod) {
            return JavaModelUtil.toOriginalMethod((IMethod)member);
        }
        ICompilationUnit cu = member.getCompilationUnit();
        if (cu != null && cu.isWorkingCopy()) {
            return (IMember)cu.getOriginal((IJavaElement)member);
        }
        return member;
    }

    private static IMethod toOriginalMethod(IMethod method) {
        try {
            ICompilationUnit cu = method.getCompilationUnit();
            if (cu == null || !cu.isWorkingCopy()) {
                return method;
            }
            if (!method.getElementName().equals(method.getDeclaringType().getElementName())) {
                return (IMethod)cu.getOriginal((IJavaElement)method);
            }
            IType originalType = (IType)JavaModelUtil.toOriginal((IMember)method.getDeclaringType());
            IMethod[] methods = originalType.findMethods(method);
            boolean isConstructor = method.isConstructor();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].isConstructor() == isConstructor) {
                    return methods[i];
                }
                ++i;
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static ICompilationUnit toOriginal(ICompilationUnit cu) {
        if (cu != null && cu.isWorkingCopy()) {
            return (ICompilationUnit)cu.getOriginal((IJavaElement)cu);
        }
        return cu;
    }

    public static IMember toWorkingCopy(IMember member) {
        IJavaElement[] members;
        ICompilationUnit workingCopy;
        ICompilationUnit cu = member.getCompilationUnit();
        if (cu != null && !cu.isWorkingCopy() && (workingCopy = EditorUtility.getWorkingCopy(cu)) != null && (members = workingCopy.findElements((IJavaElement)member)) != null && members.length > 0) {
            return (IMember)members[0];
        }
        return member;
    }

    public static ICompilationUnit toWorkingCopy(ICompilationUnit cu) {
        ICompilationUnit workingCopy;
        if (!cu.isWorkingCopy() && (workingCopy = EditorUtility.getWorkingCopy(cu)) != null) {
            return workingCopy;
        }
        return cu;
    }

    public static boolean filterNotPresentException(CoreException exception) {
        if (!(exception instanceof JavaModelException)) {
            return true;
        }
        JavaModelException je = (JavaModelException)((Object)exception);
        if (!je.isDoesNotExist()) {
            return true;
        }
        IJavaElement[] elements = je.getJavaModelStatus().getElements();
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            ICompilationUnit unit = (ICompilationUnit)element.getAncestor(5);
            if (unit == null) {
                return true;
            }
            if (!unit.isWorkingCopy()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IType[] getAllSuperTypes(IType type, IProgressMonitor pm) throws JavaModelException {
        IType[] iTypeArray;
        try {
            pm.beginTask("", 3);
            ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 1));
            SubProgressMonitor subPm = new SubProgressMonitor(pm, 2);
            List<IType> typeList = Arrays.asList(hierarchy.getAllSupertypes(type));
            subPm.beginTask("", typeList.size());
            HashSet<IType> types = new HashSet<IType>(typeList);
            Iterator<IType> iter = typeList.iterator();
            while (iter.hasNext()) {
                IType superType = iter.next();
                IType[] superTypes = JavaModelUtil.getAllSuperTypes(superType, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm, 1));
                types.addAll(Arrays.asList(superTypes));
            }
            types.add(type.getJavaProject().findType("java.lang.Object"));
            subPm.done();
            iTypeArray = types.toArray(new IType[types.size()]);
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iTypeArray;
    }

    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            char[] pattern = exclusionPatterns[i].toString().toCharArray();
            if (CharOperation.pathMatch((char[])pattern, (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        int i = 0;
        int length = exclusionPatterns.length;
        while (i < length) {
            if (CharOperation.pathMatch((char[])exclusionPatterns[i], (char[])path, (boolean)true, (char)'/')) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

