/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.internal.corext.util.Strings;

public class CodeFormatterUtil {
    public static int computeIndent(String line) {
        return Strings.computeIndent(line, CodeFormatterUtil.getTabWidth());
    }

    public static void removeIndentation(String[] lines) {
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth());
    }

    public static String trimIndents(String line) {
        return Strings.trimIndents(line, CodeFormatterUtil.getTabWidth());
    }

    public static String createIndentString(int indent) {
        ICodeFormatter formatter = ToolFactory.createCodeFormatter();
        return formatter.format("", indent, null, "");
    }

    public static String createIndentString(String example) {
        return CodeFormatterUtil.createIndentString(CodeFormatterUtil.computeIndent(example));
    }

    public static int getTabWidth() {
        try {
            return Integer.parseInt((String)JavaCore.getOptions().get("org.eclipse.jdt.core.formatter.tabulation.size"));
        }
        catch (NumberFormatException numberFormatException) {
            return 4;
        }
    }
}

