/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestor;
import org.eclipse.jdt.internal.corext.util.UnresolvableTypeInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class AllTypesCache {
    private static TypeInfo[] fgTypeCache = null;
    private static int fgSizeHint = 2000;
    private static int fgNumberOfCacheFlushes = 0;
    private static Comparator fgTypeNameComparator = new TypeNameComparator();

    public static void getTypes(IJavaSearchScope scope, int kind, IProgressMonitor monitor, Collection typesFound) throws JavaModelException {
        TypeInfo[] allTypes = AllTypesCache.getAllTypes(monitor);
        boolean isWorkspaceScope = scope.equals(SearchEngine.createWorkspaceScope());
        boolean isBoth = kind == 0;
        boolean isInterface = kind == 6;
        int i = 0;
        while (i < allTypes.length) {
            TypeInfo info = fgTypeCache[i];
            if ((isWorkspaceScope || info.isEnclosed(scope)) && (isBoth || isInterface == info.isInterface())) {
                typesFound.add(info);
            }
            ++i;
        }
    }

    public static synchronized TypeInfo[] getAllTypes(IProgressMonitor monitor) throws JavaModelException {
        if (fgTypeCache == null) {
            ArrayList searchResult = new ArrayList(fgSizeHint);
            AllTypesCache.doSearchTypes(SearchEngine.createWorkspaceScope(), 0, monitor, searchResult);
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            monitor = null;
            fgTypeCache = searchResult.toArray(new TypeInfo[searchResult.size()]);
            Arrays.sort(fgTypeCache, AllTypesCache.getTypeNameComperator());
            fgSizeHint = fgTypeCache.length;
            JavaCore.addElementChangedListener((IElementChangedListener)new TypeCacheDeltaListener());
        }
        if (monitor != null) {
            monitor.done();
        }
        return fgTypeCache;
    }

    public static boolean isCacheUpToDate() {
        return fgTypeCache != null;
    }

    public static int getNumberOfAllTypesHint() {
        return fgSizeHint;
    }

    public static Comparator getTypeNameComperator() {
        return fgTypeNameComparator;
    }

    private static void doSearchTypes(IJavaSearchScope scope, int style, IProgressMonitor monitor, Collection typesFound) throws JavaModelException {
        new SearchEngine().searchAllTypeNames(ResourcesPlugin.getWorkspace(), null, null, 2, false, style, scope, (ITypeNameRequestor)new TypeInfoRequestor(typesFound), 3, monitor);
    }

    public static int getNumberOfCacheFlushes() {
        return fgNumberOfCacheFlushes;
    }

    public static TypeInfo[] getTypesForName(String simpleTypeName, IJavaSearchScope searchScope, IProgressMonitor monitor) throws JavaModelException {
        UnresolvableTypeInfo key;
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        HashSet<String> namesFound = new HashSet<String>();
        TypeInfo[] allTypes = AllTypesCache.getAllTypes(monitor);
        int index = Arrays.binarySearch(allTypes, key = new UnresolvableTypeInfo("", simpleTypeName, null, true, null), AllTypesCache.getTypeNameComperator());
        if (index >= 0 && index < allTypes.length) {
            TypeInfo curr;
            int i = index - 1;
            while (i >= 0) {
                curr = allTypes[i];
                if (!simpleTypeName.equals(curr.getTypeName())) break;
                if (!namesFound.contains(curr.getFullyQualifiedName()) && curr.isEnclosed(searchScope)) {
                    result.add(curr);
                    namesFound.add(curr.getFullyQualifiedName());
                }
                --i;
            }
            i = index;
            while (i < allTypes.length) {
                curr = allTypes[i];
                if (!simpleTypeName.equals(curr.getTypeName())) break;
                if (!namesFound.contains(curr.getFullyQualifiedName()) && curr.isEnclosed(searchScope)) {
                    result.add(curr);
                    namesFound.add(curr.getFullyQualifiedName());
                }
                ++i;
            }
        }
        return result.toArray(new TypeInfo[result.size()]);
    }

    public static boolean isIndexUpToDate() {
        class TypeFoundException
        extends Error {
            TypeFoundException() {
            }
        }
        ITypeNameRequestor requestor = new ITypeNameRequestor(){

            public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                throw new TypeFoundException();
            }

            public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                throw new TypeFoundException();
            }
        };
        try {
            new SearchEngine().searchAllTypeNames(ResourcesPlugin.getWorkspace(), null, null, 2, false, 0, SearchEngine.createWorkspaceScope(), requestor, 2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        catch (TypeFoundException typeFoundException) {}
        return true;
    }

    private static class TypeNameComparator
    implements Comparator {
        TypeNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((TypeInfo)o1).getTypeName().compareTo(((TypeInfo)o2).getTypeName());
        }
    }

    private static class TypeCacheDeltaListener
    implements IElementChangedListener {
        TypeCacheDeltaListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            boolean needsFlushing = this.processDelta(event.getDelta());
            if (needsFlushing) {
                fgTypeCache = null;
                fgNumberOfCacheFlushes = fgNumberOfCacheFlushes + 1;
                JavaCore.removeElementChangedListener((IElementChangedListener)this);
            }
        }

        private boolean processDelta(IJavaElementDelta delta) {
            IJavaElement elem = delta.getElement();
            boolean isAddedOrRemoved = delta.getKind() != 4 || (delta.getFlags() & 0xC0) != 0;
            switch (elem.getElementType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    if (isAddedOrRemoved) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 5: {
                    if (((ICompilationUnit)elem).isWorkingCopy()) {
                        return false;
                    }
                    if (isAddedOrRemoved || this.isPossibleStructuralChange(delta.getFlags())) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
            }
            return false;
        }

        private boolean isPossibleStructuralChange(int flags) {
            return (flags & 0x4001) == 1;
        }

        private boolean processChildrenDelta(IJavaElementDelta delta) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.processDelta(children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

