/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.UndoMemento;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;

abstract class Updater
implements IDocumentListener {
    protected TextEdit fActiveEdit;
    protected UndoMemento undo = new UndoMemento();

    Updater() {
    }

    public static Updater createDoUpdater() {
        return new DoUpdater();
    }

    public static Updater createUndoUpdater() {
        return new UndoUpdater();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        int offset = event.getOffset();
        int currentLength = event.getLength();
        String currentText = null;
        try {
            currentText = event.getDocument().get(offset, currentLength);
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue(false, "Can't happen");
        }
        String newText = event.getText();
        int newLength = newText.length();
        if (currentLength > 0 && newLength == 0) {
            this.undo.add(SimpleTextEdit.createInsert(offset, currentText));
        } else if (currentLength == 0 && newLength > 0) {
            this.undo.add(SimpleTextEdit.createDelete(offset, newLength));
        } else {
            this.undo.add(SimpleTextEdit.createReplace(offset, newLength, currentText));
        }
    }

    public void setActiveNode(TextEdit edit) {
        this.fActiveEdit = edit;
    }

    public abstract List getProcessedEdits();

    private static int getDelta(DocumentEvent event) {
        return (event.getText() == null ? 0 : event.getText().length()) - event.getLength();
    }

    public abstract void documentChanged(DocumentEvent var1);

    private static class DoUpdater
    extends Updater {
        private List fProcessedEdits = new ArrayList(10);

        DoUpdater() {
        }

        public void setActiveNode(TextEdit edit) {
            if (this.fActiveEdit != null) {
                this.fProcessedEdits.add(this.fActiveEdit);
            }
            super.setActiveNode(edit);
        }

        public void documentChanged(DocumentEvent event) {
            this.fActiveEdit.checkRange(event);
            int delta = Updater.getDelta(event);
            this.fActiveEdit.updateTextRange(delta, this.fProcessedEdits);
        }

        public List getProcessedEdits() {
            return this.fProcessedEdits;
        }
    }

    private static class UndoUpdater
    extends Updater {
        UndoUpdater() {
        }

        public void documentChanged(DocumentEvent event) {
        }

        public List getProcessedEdits() {
            return null;
        }
    }
}

